/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import sun.io.ByteToCharConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;

public class ByteToCharUnicode
extends ByteToCharConverter {
    static final char BYTE_ORDER_MARK = '\ufeff';
    static final char REVERSED_MARK = '\ufffe';
    static final int AUTO = 0;
    static final int BIG = 1;
    static final int LITTLE = 2;
    int originalByteOrder;
    int byteOrder;
    boolean usesMark;
    boolean started = false;
    int leftOverByte;
    boolean leftOver = false;

    public ByteToCharUnicode() {
        this.byteOrder = 0;
        this.originalByteOrder = 0;
        this.usesMark = true;
    }

    public void reset() {
        this.leftOver = false;
        this.charOff = 0;
        this.byteOff = 0;
        this.started = false;
        this.byteOrder = this.originalByteOrder;
    }

    protected ByteToCharUnicode(int n2, boolean bl2) {
        this.originalByteOrder = this.byteOrder = n2;
        this.usesMark = bl2;
    }

    public int convert(byte[] byArray, int n2, int n3, char[] cArray, int n4, int n5) throws ConversionBufferFullException, MalformedInputException {
        char c2;
        int n6;
        int n7;
        this.byteOff = n2;
        this.charOff = n4;
        if (n2 >= n3) {
            return 0;
        }
        int n8 = 0;
        int n9 = n2;
        int n10 = n4;
        if (this.leftOver) {
            n7 = this.leftOverByte & 0xFF;
            this.leftOver = false;
        } else {
            n7 = byArray[n9++] & 0xFF;
        }
        n8 = 1;
        if (this.usesMark && !this.started && n9 < n3) {
            n6 = byArray[n9++] & 0xFF;
            n8 = 2;
            c2 = (char)(n7 << 8 | n6);
            int n11 = 0;
            if (c2 == '\ufeff') {
                n11 = 1;
            } else if (c2 == '\ufffe') {
                n11 = 2;
            }
            if (this.byteOrder == 0) {
                if (n11 == 0) {
                    this.badInputLength = n8;
                    throw new MalformedInputException("Missing byte-order mark");
                }
                this.byteOrder = n11;
                if (n9 < n3) {
                    n7 = byArray[n9++] & 0xFF;
                    n8 = 1;
                }
            } else if (n11 == 0) {
                --n9;
                n8 = 1;
            } else if (this.byteOrder == n11) {
                if (n9 < n3) {
                    n7 = byArray[n9++] & 0xFF;
                    n8 = 1;
                } else {
                    this.byteOff = n9;
                }
            } else {
                this.badInputLength = n8;
                throw new MalformedInputException("Incorrect byte-order mark");
            }
            this.started = true;
        }
        while (n9 < n3) {
            n6 = byArray[n9++] & 0xFF;
            n8 = 2;
            c2 = this.byteOrder == 1 ? (char)(n7 << 8 | n6) : (char)(n6 << 8 | n7);
            if (c2 == '\ufffe') {
                throw new MalformedInputException("Reversed byte-order mark");
            }
            if (n10 >= n5) {
                throw new ConversionBufferFullException();
            }
            cArray[n10++] = c2;
            this.byteOff = n9;
            this.charOff = n10;
            if (n9 >= n3) continue;
            n7 = byArray[n9++] & 0xFF;
            n8 = 1;
        }
        if (n8 == 1) {
            this.leftOverByte = n7;
            this.byteOff = n9;
            this.leftOver = true;
        }
        return n10 - n4;
    }

    public int flush(char[] cArray, int n2, int n3) throws MalformedInputException {
        if (this.leftOver) {
            this.reset();
            throw new MalformedInputException();
        }
        this.charOff = 0;
        this.byteOff = 0;
        return 0;
    }

    public String getCharacterEncoding() {
        switch (this.originalByteOrder) {
            case 1: {
                return this.usesMark ? "UnicodeBig" : "UnicodeBigUnmarked";
            }
            case 2: {
                return this.usesMark ? "UnicodeLittle" : "UnicodeLittleUnmarked";
            }
        }
        return "Unicode";
    }
}

