/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.peer.WindowPeer;
import java.security.AccessController;
import java.util.Vector;
import sun.awt.DisplayChangedListener;
import sun.awt.SunToolkit;
import sun.awt.im.InputMethodManager;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.MInputMethodControl;
import sun.awt.motif.MMenuBarPeer;
import sun.awt.motif.MPanelPeer;
import sun.awt.motif.MToolkit;
import sun.awt.motif.MWindowAttributes;
import sun.awt.motif.X11InputMethod;
import sun.security.action.GetIntegerAction;

class MWindowPeer
extends MPanelPeer
implements WindowPeer,
DisplayChangedListener {
    Insets insets = new Insets(0, 0, 0, 0);
    MWindowAttributes winAttr;
    static Vector allWindows = new Vector();
    int iconWidth = -1;
    int iconHeight = -1;
    private Vector imList = new Vector();
    private Vector tcList = new Vector();
    private volatile int sysX = 0;
    private volatile int sysY = 0;
    private volatile int sysW = 0;
    private volatile int sysH = 0;

    public native int getState();

    static {
        MWindowPeer.initIDs();
    }

    MWindowPeer() {
        this.insets = new Insets(0, 0, 0, 0);
        this.winAttr = new MWindowAttributes();
    }

    protected void disposeImpl() {
        allWindows.removeElement(this);
        super.disposeImpl();
    }

    public void handleDeiconify() {
        this.postEvent(new WindowEvent((Window)this.target, 204));
    }

    public void handleDestroy() {
        Window window = (Window)this.target;
        SunToolkit.executeOnEventHandlerThread(window, new Runnable(this, window){
            private final Window val$target;
            private final MWindowPeer this$0;

            public void run() {
                this.val$target.dispose();
            }
            {
                this.this$0 = mWindowPeer;
                this.val$target = window;
            }
        });
    }

    public void handleIconify() {
        this.postEvent(new WindowEvent((Window)this.target, 203));
    }

    public void handleQuit() {
        this.postEvent(new WindowEvent((Window)this.target, 201));
    }

    public void handleWindowFocusIn() {
        WindowEvent windowEvent = new WindowEvent((Window)this.target, 207);
        this.postEvent(this.wrapInSequenced(windowEvent));
    }

    private static native void initIDs();

    void notifyIMMOptionChange() {
        InputMethodManager.getInstance().notifyChangeRequest(this.target);
    }

    native void pDispose();

    native void pHide();

    native void pShow();

    native void removeTextComponentNative();

    public native void toBack();

    public void toFront() {
        if (this.target.isVisible()) {
            this.pShow();
        }
    }

    private final boolean hasWarningWindow() {
        return ((Window)this.target).getWarningString() != null;
    }

    boolean isTargetUndecorated() {
        return true;
    }

    public void displayChanged(int n2) {
        this.resetLocalGC(n2);
        this.resetTargetGC(this.target);
        super.displayChanged(n2);
    }

    public void draggedToNewScreen(int n2) {
        int n3 = n2;
        SunToolkit.executeOnEventHandlerThread(this.target, new Runnable(this, n3){
            private final int val$finalScreenNum;
            private final MWindowPeer this$0;

            public void run() {
                this.this$0.displayChanged(this.val$finalScreenNum);
            }
            {
                this.this$0 = mWindowPeer;
                this.val$finalScreenNum = n2;
            }
        });
    }

    public native void setState(int var1);

    boolean hasDecorations(int n2) {
        boolean bl2;
        if (!this.winAttr.nativeDecor) {
            return false;
        }
        int n3 = this.winAttr.decorations;
        boolean bl3 = bl2 = (n3 & n2) == n2;
        if ((n3 & MWindowAttributes.AWT_DECOR_ALL) != 0) {
            return !bl2;
        }
        return bl2;
    }

    public void handleMoved(int n2, int n3) {
        this.sysX = n2;
        this.sysY = n3;
        this.postEvent(new ComponentEvent(this.target, 100));
    }

    public void handleResize(int n2, int n3) {
        this.sysW = n2;
        this.sysH = n3;
        if (!this.tcList.isEmpty() && !this.imList.isEmpty()) {
            for (int i2 = 0; i2 < this.imList.size(); ++i2) {
                ((X11InputMethod)this.imList.elementAt(i2)).configureStatus();
            }
        }
        this.postEvent(new ComponentEvent(this.target, 101));
    }

    public void handleStateChange(int n2, int n3) {
        this.postEvent(new WindowEvent((Window)this.target, 209, n2, n3));
    }

    public boolean checkNativePaintOnSetBounds(int n2, int n3) {
        return n2 > this.oldWidth || n3 > this.oldHeight;
    }

    native void pReshape(int var1, int var2, int var3, int var4);

    public void setBounds(int n2, int n3, int n4, int n5) {
        Rectangle rectangle = this.constrainBounds(n2, n3, n4, n5);
        super.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    native void pShowModal(boolean var1);

    public native void setResizable(boolean var1);

    native void setSaveUnder(boolean var1);

    native void resetTargetGC(Component var1);

    public Insets getInsets() {
        return this.insets;
    }

    public Insets insets() {
        return this.getInsets();
    }

    Rectangle constrainBounds(int n2, int n3, int n4, int n5) {
        if (!this.hasWarningWindow()) {
            return new Rectangle(n2, n3, n4, n5);
        }
        int n6 = n2;
        int n7 = n3;
        int n8 = n4;
        int n9 = n5;
        GraphicsConfiguration graphicsConfiguration = ((Window)this.target).getGraphicsConfiguration();
        Rectangle rectangle = graphicsConfiguration.getBounds();
        Insets insets = ((Window)this.target).getToolkit().getScreenInsets(graphicsConfiguration);
        int n10 = rectangle.width - insets.left - insets.right;
        int n11 = rectangle.height - insets.top - insets.bottom;
        if (!this.target.isVisible() || this.isTargetUndecorated()) {
            int n12 = rectangle.x + insets.left;
            int n13 = rectangle.y + insets.top;
            if (n8 > n10) {
                n8 = n10;
            }
            if (n9 > n11) {
                n9 = n11;
            }
            if (n6 < n12) {
                n6 = n12;
            } else if (n6 + n8 > n12 + n10) {
                n6 = n12 + n10 - n8;
            }
            if (n7 < n13) {
                n7 = n13;
            } else if (n7 + n9 > n13 + n11) {
                n7 = n13 + n11 - n9;
            }
        } else {
            int n14 = Math.max(n10, this.sysW);
            int n15 = Math.max(n11, this.sysH);
            if (n8 > n14) {
                n8 = n14;
            }
            if (n9 > n15) {
                n9 = n15;
            }
        }
        return new Rectangle(n6, n7, n8, n9);
    }

    MWindowPeer(Window window) {
        this();
        this.init(window);
        allWindows.addElement(this);
    }

    public void handleWindowFocusOut(Window window) {
        WindowEvent windowEvent = new WindowEvent((Window)this.target, 208, window);
        this.postEvent(this.wrapInSequenced(windowEvent));
    }

    void init(Window window) {
        Color color;
        if (this.winAttr.nativeDecor) {
            this.insets.top = MWindowPeer.getInset("awt.frame.topInset", -1);
            this.insets.left = MWindowPeer.getInset("awt.frame.leftInset", -1);
            this.insets.bottom = MWindowPeer.getInset("awt.frame.bottomInset", -1);
            this.insets.right = MWindowPeer.getInset("awt.frame.rightInset", -1);
        }
        Rectangle rectangle = window.getBounds();
        this.sysX = rectangle.x;
        this.sysY = rectangle.y;
        this.sysW = rectangle.width;
        this.sysH = rectangle.height;
        super.init(window);
        InputMethodManager inputMethodManager = InputMethodManager.getInstance();
        String string = inputMethodManager.getTriggerMenuString();
        if (string != null) {
            this.pSetIMMOption(string);
        }
        this.pSetTitle(this.winAttr.title);
        this.setResizable(this.winAttr.isResizable);
        this.setSaveUnder(true);
        Font font = window.getFont();
        if (font == null) {
            font = defaultFont;
            window.setFont(font);
            this.setFont(font);
        }
        if ((color = window.getBackground()) == null) {
            window.setBackground(SystemColor.window);
            this.setBackground(SystemColor.window);
        }
        if ((color = window.getForeground()) == null) {
            window.setForeground(SystemColor.windowText);
            this.setForeground(SystemColor.windowText);
        }
    }

    native void pSetIMMOption(String var1);

    native void pSetTitle(String var1);

    private static int getInset(String string, int n2) {
        Integer n3 = (Integer)AccessController.doPrivileged(new GetIntegerAction(string, n2));
        return n3;
    }

    public MComponentPeer getTextComponent() {
        if (!this.tcList.isEmpty()) {
            return (MComponentPeer)this.tcList.firstElement();
        }
        return null;
    }

    public void addTextComponent(MComponentPeer mComponentPeer) {
        if (this.tcList.contains(mComponentPeer)) {
            return;
        }
        if (this.tcList.isEmpty()) {
            this.addTextComponentNative(mComponentPeer);
            if (!this.imList.isEmpty()) {
                for (int i2 = 0; i2 < this.imList.size(); ++i2) {
                    ((X11InputMethod)this.imList.elementAt(i2)).reconfigureXIC((MInputMethodControl)((Object)this));
                }
            }
            MToolkit.executeOnEventHandlerThread(this.target, new Runnable(this){
                private final MWindowPeer this$0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = this.this$0.target.getTreeLock();
                    synchronized (object) {
                        this.this$0.target.doLayout();
                    }
                }
                {
                    this.this$0 = mWindowPeer;
                }
            });
        }
        this.tcList.addElement(mComponentPeer);
    }

    native void addTextComponentNative(MComponentPeer var1);

    void create(MComponentPeer mComponentPeer) {
        this.pCreate(mComponentPeer, this.target.getClass().getName());
    }

    public void removeTextComponent(MComponentPeer mComponentPeer) {
        if (!this.tcList.contains(mComponentPeer)) {
            return;
        }
        this.tcList.removeElement(mComponentPeer);
        if (this.tcList.isEmpty()) {
            this.removeTextComponentNative();
            if (!this.imList.isEmpty()) {
                for (int i2 = 0; i2 < this.imList.size(); ++i2) {
                    ((X11InputMethod)this.imList.elementAt(i2)).reconfigureXIC((MInputMethodControl)((Object)this));
                }
            }
            this.target.doLayout();
        }
    }

    native void pSetMenuBar(MMenuBarPeer var1);

    public void addInputMethod(X11InputMethod x11InputMethod) {
        if (!this.imList.contains(x11InputMethod)) {
            this.imList.addElement(x11InputMethod);
        }
    }

    public void removeInputMethod(X11InputMethod x11InputMethod) {
        if (this.imList.contains(x11InputMethod)) {
            this.imList.removeElement(x11InputMethod);
        }
    }

    private native AWTEvent wrapInSequenced(AWTEvent var1);

    native void pCreate(MComponentPeer var1, String var2);
}

