/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.InternalFrameEvent;
import javax.swing.plaf.ActionMapUIResource;

class SynthInternalFrameTitlePane
extends JComponent
implements SynthUI {
    protected JButton minimizeButton;
    protected JButton maximizeButton;
    protected JButton closeButton;
    protected JPopupMenu systemPopupMenu;
    protected JButton menuButton;
    protected JInternalFrame frame;
    protected Icon maximizeIcon;
    protected Icon restoreIcon;
    protected Icon minimizeIcon;
    protected Icon closeIcon;
    protected PropertyChangeListener propertyChangeListener;
    protected Action closeAction;
    protected Action maximizeAction;
    protected Action iconifyAction;
    protected Action restoreAction;
    protected Action moveAction;
    protected Action sizeAction;
    protected static final String CLOSE_CMD = UIManager.getString("InternalFrameTitlePane.closeButtonText");
    protected static final String ICONIFY_CMD = UIManager.getString("InternalFrameTitlePane.minimizeButtonText");
    protected static final String RESTORE_CMD = UIManager.getString("InternalFrameTitlePane.restoreButtonText");
    protected static final String MAXIMIZE_CMD = UIManager.getString("InternalFrameTitlePane.maximizeButtonText");
    protected static final String MOVE_CMD = UIManager.getString("InternalFrameTitlePane.moveButtonText");
    protected static final String SIZE_CMD = UIManager.getString("InternalFrameTitlePane.sizeButtonText");
    private String closeButtonToolTip;
    private String minimizeButtonToolTip;
    private String restoreButtonToolTip;
    private String maximizeButtonToolTip;
    private SynthStyle style;
    static Class class$com$sun$java$swing$plaf$gtk$SynthContext;
    static Class class$javax$swing$JInternalFrame;

    protected void addSubComponents() {
        this.add(this.menuButton);
        this.add(this.minimizeButton);
        this.add(this.maximizeButton);
        this.add(this.closeButton);
    }

    protected void assembleSystemMenu() {
        this.systemPopupMenu = new JPopupMenu();
        this.addSystemMenuItems(this.systemPopupMenu);
        this.enableActions();
        this.menuButton = this.createNoFocusButton();
        this.menuButton.setIcon(this.frame.getFrameIcon());
        this.menuButton.addMouseListener(new MouseAdapter(this){
            private final SynthInternalFrameTitlePane this$0;
            {
                this.this$0 = synthInternalFrameTitlePane;
            }

            public void mousePressed(MouseEvent mouseEvent) {
                Dimension dimension = new Dimension();
                Border border = this.this$0.frame.getBorder();
                if (border != null) {
                    dimension.width += border.getBorderInsets((Component)this.this$0.frame).left + border.getBorderInsets((Component)this.this$0.frame).right;
                    dimension.height += border.getBorderInsets((Component)this.this$0.frame).bottom + border.getBorderInsets((Component)this.this$0.frame).top;
                }
                if (!this.this$0.frame.isIcon()) {
                    this.this$0.systemPopupMenu.show(mouseEvent.getComponent(), this.this$0.getX() - dimension.width, this.this$0.getY() + this.this$0.getHeight() - dimension.height);
                } else {
                    this.this$0.systemPopupMenu.show(mouseEvent.getComponent(), this.this$0.getX() - dimension.width, this.this$0.getY() - this.this$0.systemPopupMenu.getPreferredSize().height - dimension.height);
                }
            }
        });
    }

    protected void createActions() {
        this.maximizeAction = new MaximizeAction(this);
        this.iconifyAction = new IconifyAction(this);
        this.closeAction = new CloseAction(this);
        this.restoreAction = new RestoreAction(this);
        this.moveAction = new MoveAction(this);
        this.sizeAction = new SizeAction(this);
    }

    protected void createButtons() {
        this.minimizeButton = this.createNoFocusButton();
        this.minimizeButton.addActionListener(this.iconifyAction);
        if (this.minimizeButtonToolTip != null && this.minimizeButtonToolTip.length() != 0) {
            this.minimizeButton.setToolTipText(this.minimizeButtonToolTip);
        }
        this.maximizeButton = this.createNoFocusButton();
        this.maximizeButton.addActionListener(this.maximizeAction);
        this.closeButton = this.createNoFocusButton();
        this.closeButton.addActionListener(this.closeAction);
        if (this.closeButtonToolTip != null && this.closeButtonToolTip.length() != 0) {
            this.closeButton.setToolTipText(this.closeButtonToolTip);
        }
        this.setButtonIcons();
    }

    protected void enableActions() {
        this.restoreAction.setEnabled(this.frame.isMaximum() || this.frame.isIcon());
        this.maximizeAction.setEnabled(this.frame.isMaximizable() && !this.frame.isMaximum());
        this.iconifyAction.setEnabled(this.frame.isIconifiable() && !this.frame.isIcon());
        this.closeAction.setEnabled(this.frame.isClosable());
        this.sizeAction.setEnabled(false);
        this.moveAction.setEnabled(false);
    }

    protected void installDefaults() {
        this.closeButtonToolTip = UIManager.getString("InternalFrame.closeButtonToolTip");
        this.minimizeButtonToolTip = UIManager.getString("InternalFrame.iconButtonToolTip");
        this.restoreButtonToolTip = UIManager.getString("InternalFrame.restoreButtonToolTip");
        this.maximizeButtonToolTip = UIManager.getString("InternalFrame.maxButtonToolTip");
    }

    protected void installListeners() {
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = this.createPropertyChangeListener();
        }
        this.frame.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void installTitlePane() {
        this.installDefaults();
        this.installListeners();
        this.createActions();
        this.enableActions();
        this.createActionMap();
        this.setLayout(this.createLayout());
        this.assembleSystemMenu();
        this.createButtons();
        this.addSubComponents();
    }

    protected void setButtonIcons() {
        if (this.frame.isIcon()) {
            if (this.restoreIcon != null) {
                this.minimizeButton.setIcon(this.restoreIcon);
            }
            if (this.restoreButtonToolTip != null && this.restoreButtonToolTip.length() != 0) {
                this.minimizeButton.setToolTipText(this.restoreButtonToolTip);
            }
            if (this.maximizeIcon != null) {
                this.maximizeButton.setIcon(this.maximizeIcon);
            }
            if (this.maximizeButtonToolTip != null && this.maximizeButtonToolTip.length() != 0) {
                this.maximizeButton.setToolTipText(this.maximizeButtonToolTip);
            }
        } else if (this.frame.isMaximum()) {
            if (this.minimizeIcon != null) {
                this.minimizeButton.setIcon(this.minimizeIcon);
            }
            if (this.minimizeButtonToolTip != null && this.minimizeButtonToolTip.length() != 0) {
                this.minimizeButton.setToolTipText(this.minimizeButtonToolTip);
            }
            if (this.restoreIcon != null) {
                this.maximizeButton.setIcon(this.restoreIcon);
            }
            if (this.restoreButtonToolTip != null && this.restoreButtonToolTip.length() != 0) {
                this.maximizeButton.setToolTipText(this.restoreButtonToolTip);
            }
        } else {
            if (this.minimizeIcon != null) {
                this.minimizeButton.setIcon(this.minimizeIcon);
            }
            if (this.minimizeButtonToolTip != null && this.minimizeButtonToolTip.length() != 0) {
                this.minimizeButton.setToolTipText(this.minimizeButtonToolTip);
            }
            if (this.maximizeIcon != null) {
                this.maximizeButton.setIcon(this.maximizeIcon);
            }
            if (this.maximizeButtonToolTip != null && this.maximizeButtonToolTip.length() != 0) {
                this.maximizeButton.setToolTipText(this.maximizeButtonToolTip);
            }
        }
        if (this.closeIcon != null) {
            this.closeButton.setIcon(this.closeIcon);
        }
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext(this, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    protected void uninstallListeners() {
        this.frame.removePropertyChangeListener(this.propertyChangeListener);
    }

    public void paintComponent(Graphics graphics) {
        SynthContext synthContext = this.getContext(this);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.dispose();
    }

    protected LayoutManager createLayout() {
        SynthContext synthContext = this.getContext(this);
        LayoutManager layoutManager = (LayoutManager)this.style.get(synthContext, "InternalFrameTitlePane.titlePaneLayout");
        synthContext.dispose();
        return layoutManager != null ? layoutManager : new TitlePaneLayout(this);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler(this);
    }

    public String getUIClassID() {
        return "InternalFrameTitlePaneUI";
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("showSystemMenu", new ShowSystemMenuAction(this, true));
        actionMapUIResource.put("hideSystemMenu", new ShowSystemMenuAction(this, false));
        return actionMapUIResource;
    }

    private JButton createNoFocusButton() {
        JButton jButton = new JButton();
        jButton.setFocusable(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        return jButton;
    }

    private int getComponentState(JComponent jComponent) {
        if (this.frame != null && this.frame.isSelected()) {
            return 512;
        }
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    private void fetchStyle(JComponent jComponent) {
        SynthContext synthContext = this.getContext(this, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            this.maximizeIcon = this.style.getIcon(synthContext, "InternalFrameTitlePane.maximizeIcon");
            this.restoreIcon = this.style.getIcon(synthContext, "InternalFrameTitlePane.restoreIcon");
            this.minimizeIcon = this.style.getIcon(synthContext, "InternalFrameTitlePane.iconifyIcon");
            this.closeIcon = this.style.getIcon(synthContext, "InternalFrameTitlePane.closeIcon");
        }
        synthContext.dispose();
    }

    public SynthInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        this.fetchStyle(this);
        this.frame = jInternalFrame;
        this.installTitlePane();
        this.menuButton.setName("InternalFrameTitlePane.menuButton");
        this.minimizeButton.setName("InternalFrameTitlePane.iconifyButton");
        this.maximizeButton.setName("InternalFrameTitlePane.maximizeButton");
        this.closeButton.setName("InternalFrameTitlePane.closeButton");
    }

    protected void postClosingEvent(JInternalFrame jInternalFrame) {
        InternalFrameEvent internalFrameEvent = new InternalFrameEvent(jInternalFrame, 25550);
        if ((class$javax$swing$JInternalFrame == null ? (class$javax$swing$JInternalFrame = SynthInternalFrameTitlePane.class$("javax.swing.JInternalFrame")) : class$javax$swing$JInternalFrame).getClassLoader() == null) {
            try {
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(internalFrameEvent);
                return;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        jInternalFrame.dispatchEvent(internalFrameEvent);
    }

    protected void addSystemMenuItems(JPopupMenu jPopupMenu) {
        JMenuItem jMenuItem = jPopupMenu.add(this.restoreAction);
        jMenuItem.setMnemonic('R');
        jMenuItem = jPopupMenu.add(this.moveAction);
        jMenuItem.setMnemonic('M');
        jMenuItem = jPopupMenu.add(this.sizeAction);
        jMenuItem.setMnemonic('S');
        jMenuItem = jPopupMenu.add(this.iconifyAction);
        jMenuItem.setMnemonic('n');
        jMenuItem = jPopupMenu.add(this.maximizeAction);
        jMenuItem.setMnemonic('x');
        jPopupMenu.add(new JSeparator());
        jMenuItem = jPopupMenu.add(this.closeAction);
        jMenuItem.setMnemonic('C');
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    public SynthContext getContext(JComponent jComponent, int n2) {
        return SynthContext.getContext(class$com$sun$java$swing$plaf$gtk$SynthContext == null ? (class$com$sun$java$swing$plaf$gtk$SynthContext = SynthInternalFrameTitlePane.class$("com.sun.java.swing.plaf.gtk.SynthContext")) : class$com$sun$java$swing$plaf$gtk$SynthContext, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n2);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static void access$000(SynthInternalFrameTitlePane synthInternalFrameTitlePane, JComponent jComponent) {
        synthInternalFrameTitlePane.fetchStyle(jComponent);
    }

    class CloseAction
    extends AbstractAction {
        private final SynthInternalFrameTitlePane this$0;

        public CloseAction(SynthInternalFrameTitlePane synthInternalFrameTitlePane) {
            this.this$0 = synthInternalFrameTitlePane;
            super(CLOSE_CMD);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.this$0.frame.isClosable()) {
                this.this$0.frame.doDefaultCloseAction();
            }
        }
    }

    class IconifyAction
    extends AbstractAction {
        private final SynthInternalFrameTitlePane this$0;

        public IconifyAction(SynthInternalFrameTitlePane synthInternalFrameTitlePane) {
            this.this$0 = synthInternalFrameTitlePane;
            super(ICONIFY_CMD);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.this$0.frame.isIconifiable()) {
                if (!this.this$0.frame.isIcon()) {
                    try {
                        this.this$0.frame.setIcon(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else {
                    try {
                        this.this$0.frame.setIcon(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    class MaximizeAction
    extends AbstractAction {
        private final SynthInternalFrameTitlePane this$0;

        public MaximizeAction(SynthInternalFrameTitlePane synthInternalFrameTitlePane) {
            this.this$0 = synthInternalFrameTitlePane;
            super(MAXIMIZE_CMD);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.this$0.frame.isMaximizable()) {
                if (!this.this$0.frame.isMaximum()) {
                    try {
                        this.this$0.frame.setMaximum(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else {
                    try {
                        this.this$0.frame.setMaximum(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    class MoveAction
    extends AbstractAction {
        private final SynthInternalFrameTitlePane this$0;

        public MoveAction(SynthInternalFrameTitlePane synthInternalFrameTitlePane) {
            this.this$0 = synthInternalFrameTitlePane;
            super(MOVE_CMD);
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    class PropertyChangeHandler
    implements PropertyChangeListener {
        private final SynthInternalFrameTitlePane this$0;

        PropertyChangeHandler(SynthInternalFrameTitlePane synthInternalFrameTitlePane) {
            this.this$0 = synthInternalFrameTitlePane;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
                SynthInternalFrameTitlePane.access$000(this.this$0, this.this$0);
            }
            if ("selected".equals(string)) {
                this.this$0.repaint();
                return;
            }
            if ("icon".equals(string) || "maximum".equals(string)) {
                this.this$0.setButtonIcons();
                this.this$0.enableActions();
                return;
            }
            if (string.equals("closable")) {
                if ((Boolean)propertyChangeEvent.getNewValue() == Boolean.TRUE) {
                    this.this$0.add(this.this$0.closeButton);
                } else {
                    this.this$0.remove(this.this$0.closeButton);
                }
            } else if (string.equals("maximizable")) {
                if ((Boolean)propertyChangeEvent.getNewValue() == Boolean.TRUE) {
                    this.this$0.add(this.this$0.maximizeButton);
                } else {
                    this.this$0.remove(this.this$0.maximizeButton);
                }
            } else if (string.equals("iconable")) {
                if ((Boolean)propertyChangeEvent.getNewValue() == Boolean.TRUE) {
                    this.this$0.add(this.this$0.minimizeButton);
                } else {
                    this.this$0.remove(this.this$0.minimizeButton);
                }
            }
            this.this$0.enableActions();
            this.this$0.revalidate();
            this.this$0.repaint();
        }
    }

    class RestoreAction
    extends AbstractAction {
        private final SynthInternalFrameTitlePane this$0;

        public RestoreAction(SynthInternalFrameTitlePane synthInternalFrameTitlePane) {
            this.this$0 = synthInternalFrameTitlePane;
            super(RESTORE_CMD);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.this$0.frame.isMaximizable() && this.this$0.frame.isMaximum()) {
                try {
                    this.this$0.frame.setMaximum(false);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else if (this.this$0.frame.isIconifiable() && this.this$0.frame.isIcon()) {
                try {
                    this.this$0.frame.setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }

    private class ShowSystemMenuAction
    extends AbstractAction {
        private boolean show;
        private final SynthInternalFrameTitlePane this$0;

        public ShowSystemMenuAction(SynthInternalFrameTitlePane synthInternalFrameTitlePane, boolean bl2) {
            this.this$0 = synthInternalFrameTitlePane;
            this.show = bl2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.show) {
                this.this$0.systemPopupMenu.setVisible(false);
            }
        }
    }

    class SizeAction
    extends AbstractAction {
        private final SynthInternalFrameTitlePane this$0;

        public SizeAction(SynthInternalFrameTitlePane synthInternalFrameTitlePane) {
            this.this$0 = synthInternalFrameTitlePane;
            super(SIZE_CMD);
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    class TitlePaneLayout
    implements LayoutManager {
        private final SynthInternalFrameTitlePane this$0;

        TitlePaneLayout(SynthInternalFrameTitlePane synthInternalFrameTitlePane) {
            this.this$0 = synthInternalFrameTitlePane;
        }

        public void removeLayoutComponent(Component component) {
        }

        public void layoutContainer(Container container) {
            Icon icon;
            int n2;
            boolean bl2 = SynthLookAndFeel.isLeftToRight(this.this$0.frame);
            int n3 = this.this$0.getWidth();
            int n4 = this.this$0.getHeight();
            Icon icon2 = this.this$0.closeButton.getIcon();
            int n5 = n2 = icon2 != null ? icon2.getIconHeight() : 12;
            if (n2 == 0) {
                n2 = 12;
            }
            int n6 = (icon = this.this$0.frame.getFrameIcon()) != null ? icon.getIconHeight() : n2;
            Insets insets = this.this$0.frame.getInsets();
            int n7 = bl2 ? insets.left : n3 - 16 - insets.right;
            this.this$0.menuButton.setBounds(n7, (n4 - n6) / 2, 16, 14);
            int n8 = n7 = bl2 ? n3 - 16 - insets.right : insets.left;
            if (this.this$0.frame.isClosable()) {
                this.this$0.closeButton.setBounds(n7, (n4 - n2) / 2, 16, 14);
                n7 += bl2 ? -18 : 18;
            }
            if (this.this$0.frame.isMaximizable()) {
                this.this$0.maximizeButton.setBounds(n7, (n4 - n2) / 2, 16, 14);
                n7 += bl2 ? -18 : 18;
            }
            if (this.this$0.frame.isIconifiable()) {
                this.this$0.minimizeButton.setBounds(n7, (n4 - n2) / 2, 16, 14);
            }
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public Dimension minimumLayoutSize(Container container) {
            int n2;
            int n3;
            int n4 = 22;
            if (this.this$0.frame.isClosable()) {
                n4 += 19;
            }
            if (this.this$0.frame.isMaximizable()) {
                n4 += 19;
            }
            if (this.this$0.frame.isIconifiable()) {
                n4 += 19;
            }
            FontMetrics fontMetrics = this.this$0.getFontMetrics(this.this$0.getFont());
            String string = this.this$0.frame.getTitle();
            int n5 = string != null ? fontMetrics.stringWidth(string) : 0;
            int n6 = n3 = string != null ? string.length() : 0;
            n4 = n3 > 3 ? (n4 += n5 < (n2 = fontMetrics.stringWidth(string.substring(0, 3) + "...")) ? n5 : n2) : (n4 += n5);
            Icon icon = this.this$0.frame.getFrameIcon();
            int n7 = fontMetrics.getHeight();
            n7 += 2;
            int n8 = 0;
            if (icon != null) {
                n8 = Math.min(icon.getIconHeight(), 16);
            }
            int n9 = Math.max(n7, n8 += 2);
            Dimension dimension = new Dimension(n4, n9);
            if (this.this$0.getBorder() != null) {
                Insets insets = this.this$0.getBorder().getBorderInsets(container);
                dimension.height += insets.top + insets.bottom;
                dimension.width += insets.left + insets.right;
            }
            return dimension;
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }
    }
}

