/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthEventListener;
import com.sun.java.swing.plaf.gtk.SynthInternalFrameTitlePane;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.DesktopIconUI;

class SynthDesktopIconUI
extends DesktopIconUI
implements SynthUI {
    private SynthStyle style;
    protected JInternalFrame.JDesktopIcon desktopIcon;
    protected JInternalFrame frame;
    protected JComponent iconPane;
    static Class class$com$sun$java$swing$plaf$gtk$SynthContext;

    public void deiconize() {
        try {
            this.frame.setIcon(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    protected void installComponents() {
        this.iconPane = new SynthInternalFrameTitlePane(this.frame);
        this.desktopIcon.setLayout(new BorderLayout());
        this.desktopIcon.add((Component)this.iconPane, "Center");
    }

    protected void installDefaults() {
        this.fetchStyle(this.desktopIcon);
    }

    protected void installListeners() {
        EventHandler eventHandler = this.createEventHandler();
        this.desktopIcon.addMouseMotionListener(eventHandler);
        this.desktopIcon.addMouseListener(eventHandler);
        this.desktopIcon.addPropertyChangeListener(eventHandler);
    }

    protected void uninstallComponents() {
        this.desktopIcon.setLayout(null);
        this.desktopIcon.remove(this.iconPane);
        this.iconPane = null;
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext(this.desktopIcon, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    protected void uninstallListeners() {
        EventHandler eventHandler = this.getEventHandler(this.desktopIcon);
        this.desktopIcon.removeMouseMotionListener(eventHandler);
        this.desktopIcon.removeMouseListener(eventHandler);
        this.desktopIcon.removePropertyChangeListener(eventHandler);
    }

    EventHandler createEventHandler() {
        return new EventHandler(this, null);
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    private void fetchStyle(JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent, 1);
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        synthContext.dispose();
    }

    public void installUI(JComponent jComponent) {
        this.desktopIcon = (JInternalFrame.JDesktopIcon)jComponent;
        this.frame = this.desktopIcon.getInternalFrame();
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        JLayeredPane.putLayer(this.desktopIcon, JLayeredPane.getLayer(this.frame));
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallComponents();
        this.uninstallListeners();
        this.frame = null;
        this.desktopIcon = null;
    }

    Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n2) {
        Region region = this.getRegion(jComponent);
        return SynthContext.getContext(class$com$sun$java$swing$plaf$gtk$SynthContext == null ? (class$com$sun$java$swing$plaf$gtk$SynthContext = SynthDesktopIconUI.class$("com.sun.java.swing.plaf.gtk.SynthContext")) : class$com$sun$java$swing$plaf$gtk$SynthContext, jComponent, region, this.style, n2);
    }

    private EventHandler getEventHandler(JComponent jComponent) {
        return (EventHandler)SynthLookAndFeel.getSynthEventListener(jComponent);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.iconPane.getMaximumSize();
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = new Dimension(this.iconPane.getMinimumSize());
        Border border = this.frame.getBorder();
        if (border != null) {
            dimension.height += border.getBorderInsets((Component)this.frame).bottom + border.getBorderInsets((Component)this.frame).top;
        }
        return dimension;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.desktopIcon.getLayout().preferredLayoutSize(this.desktopIcon);
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
    }

    public Insets getInsets(JComponent jComponent) {
        JInternalFrame jInternalFrame = this.desktopIcon.getInternalFrame();
        Border border = jInternalFrame.getBorder();
        if (border != null) {
            return border.getBorderInsets(jInternalFrame);
        }
        return new Insets(0, 0, 0, 0);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static void access$100(SynthDesktopIconUI synthDesktopIconUI, JComponent jComponent) {
        synthDesktopIconUI.fetchStyle(jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthDesktopIconUI();
    }

    static class 1 {
    }

    private class EventHandler
    extends MouseInputAdapter
    implements PropertyChangeListener,
    SynthEventListener {
        int _x;
        int _y;
        int __x;
        int __y;
        Rectangle startingBounds;
        private final SynthDesktopIconUI this$0;

        private EventHandler(SynthDesktopIconUI synthDesktopIconUI) {
            this.this$0 = synthDesktopIconUI;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            JDesktopPane jDesktopPane;
            Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), null);
            Insets insets = this.this$0.desktopIcon.getInsets();
            int n2 = ((JComponent)this.this$0.desktopIcon.getParent()).getWidth();
            int n3 = ((JComponent)this.this$0.desktopIcon.getParent()).getHeight();
            if (this.startingBounds == null) {
                return;
            }
            int n4 = this.startingBounds.x - (this._x - point.x);
            int n5 = this.startingBounds.y - (this._y - point.y);
            if (n4 + insets.left <= -this.__x) {
                n4 = -this.__x - insets.left;
            }
            if (n5 + insets.top <= -this.__y) {
                n5 = -this.__y - insets.top;
            }
            if (n4 + this.__x + insets.right > n2) {
                n4 = n2 - this.__x - insets.right;
            }
            if (n5 + this.__y + insets.bottom > n3) {
                n5 = n3 - this.__y - insets.bottom;
            }
            if ((jDesktopPane = this.this$0.desktopIcon.getDesktopPane()) != null) {
                DesktopManager desktopManager = jDesktopPane.getDesktopManager();
                desktopManager.dragFrame(this.this$0.desktopIcon, n4, n5);
            } else {
                this.moveAndRepaint(this.this$0.desktopIcon, n4, n5, this.this$0.desktopIcon.getWidth(), this.this$0.desktopIcon.getHeight());
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), null);
            this.__x = mouseEvent.getX();
            this.__y = mouseEvent.getY();
            this._x = point.x;
            this._y = point.y;
            this.startingBounds = this.this$0.desktopIcon.getBounds();
            JDesktopPane jDesktopPane = this.this$0.desktopIcon.getDesktopPane();
            if (jDesktopPane != null) {
                DesktopManager desktopManager = jDesktopPane.getDesktopManager();
                desktopManager.beginDraggingFrame(this.this$0.desktopIcon);
            }
            try {
                this.this$0.frame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            if (this.this$0.desktopIcon.getParent() instanceof JLayeredPane) {
                ((JLayeredPane)this.this$0.desktopIcon.getParent()).moveToFront(this.this$0.desktopIcon);
            }
            if (mouseEvent.getClickCount() > 1 && this.this$0.frame.isIconifiable() && this.this$0.frame.isIcon()) {
                this.this$0.deiconize();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this._x = 0;
            this._y = 0;
            this.__x = 0;
            this.__y = 0;
            this.startingBounds = null;
            JDesktopPane jDesktopPane = this.this$0.desktopIcon.getDesktopPane();
            if (jDesktopPane != null) {
                DesktopManager desktopManager = jDesktopPane.getDesktopManager();
                desktopManager.endDraggingFrame(this.this$0.desktopIcon);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
                SynthDesktopIconUI.access$100(this.this$0, (JInternalFrame.JDesktopIcon)propertyChangeEvent.getSource());
            }
        }

        public void moveAndRepaint(JComponent jComponent, int n2, int n3, int n4, int n5) {
            Rectangle rectangle = jComponent.getBounds();
            jComponent.setBounds(n2, n3, n4, n5);
            SwingUtilities.computeUnion(n2, n3, n4, n5, rectangle);
            jComponent.getParent().repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }

        EventHandler(SynthDesktopIconUI synthDesktopIconUI, 1 var2_2) {
            this(synthDesktopIconUI);
        }
    }
}

