/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.nio.ByteOrder;
import sun.misc.Unsafe;

class NativeObject {
    protected static final Unsafe unsafe;
    protected long allocationAddress;
    private final long address;
    private static ByteOrder byteOrder;
    private static int pageSize;
    static final boolean $assertionsDisabled;
    static Class class$sun$nio$ch$NativeObject;

    static int addressSize() {
        return unsafe.addressSize();
    }

    static int pageSize() {
        if (pageSize == -1) {
            pageSize = unsafe.pageSize();
        }
        return pageSize;
    }

    long address() {
        return this.address;
    }

    long allocationAddress() {
        return this.allocationAddress;
    }

    static {
        $assertionsDisabled = !(class$sun$nio$ch$NativeObject == null ? (class$sun$nio$ch$NativeObject = NativeObject.class$("sun.nio.ch.NativeObject")) : class$sun$nio$ch$NativeObject).desiredAssertionStatus();
        unsafe = Unsafe.getUnsafe();
        byteOrder = null;
        pageSize = -1;
    }

    final byte getByte(int n2) {
        return unsafe.getByte((long)n2 + this.address);
    }

    final char getChar(int n2) {
        return unsafe.getChar((long)n2 + this.address);
    }

    final double getDouble(int n2) {
        return unsafe.getDouble((long)n2 + this.address);
    }

    final float getFloat(int n2) {
        return unsafe.getFloat((long)n2 + this.address);
    }

    final int getInt(int n2) {
        return unsafe.getInt((long)n2 + this.address);
    }

    final long getLong(int n2) {
        return unsafe.getLong((long)n2 + this.address);
    }

    final short getShort(int n2) {
        return unsafe.getShort((long)n2 + this.address);
    }

    final void putByte(int n2, byte by) {
        unsafe.putByte((long)n2 + this.address, by);
    }

    final void putChar(int n2, char c2) {
        unsafe.putChar((long)n2 + this.address, c2);
    }

    final void putDouble(int n2, double d2) {
        unsafe.putDouble((long)n2 + this.address, d2);
    }

    final void putFloat(int n2, float f2) {
        unsafe.putFloat((long)n2 + this.address, f2);
    }

    final void putInt(int n2, int n3) {
        unsafe.putInt((long)n2 + this.address, n3);
    }

    final void putLong(int n2, long l2) {
        unsafe.putLong((long)n2 + this.address, l2);
    }

    final void putShort(int n2, short s2) {
        unsafe.putShort((long)n2 + this.address, s2);
    }

    protected NativeObject(int n2, boolean bl2) {
        if (!bl2) {
            this.address = this.allocationAddress = unsafe.allocateMemory(n2);
        } else {
            long l2;
            int n3 = NativeObject.pageSize();
            this.allocationAddress = l2 = unsafe.allocateMemory(n2 + n3);
            this.address = l2 + (long)n3 - (l2 & (long)(n3 - 1));
        }
    }

    NativeObject(long l2) {
        this.allocationAddress = l2;
        this.address = l2;
    }

    NativeObject(long l2, long l3) {
        this.allocationAddress = l2;
        this.address = l2 + l3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ByteOrder byteOrder() {
        if (byteOrder != null) {
            return byteOrder;
        }
        long l2 = unsafe.allocateMemory(8L);
        try {
            unsafe.putLong(l2, 72623859790382856L);
            byte by = unsafe.getByte(l2);
            switch (by) {
                case 1: {
                    byteOrder = ByteOrder.BIG_ENDIAN;
                    return byteOrder;
                }
                case 8: {
                    byteOrder = ByteOrder.LITTLE_ENDIAN;
                    return byteOrder;
                }
                default: {
                    if ($assertionsDisabled) return byteOrder;
                    throw new AssertionError();
                }
            }
        }
        finally {
            unsafe.freeMemory(l2);
        }
    }

    NativeObject getObject(int n2) {
        long l2 = 0L;
        switch (NativeObject.addressSize()) {
            case 8: {
                l2 = unsafe.getLong((long)n2 + this.address);
                break;
            }
            case 4: {
                l2 = unsafe.getInt((long)n2 + this.address) & 0xFFFFFFFF;
                break;
            }
            default: {
                throw new InternalError("Address size not supported");
            }
        }
        return new NativeObject(l2);
    }

    NativeObject subObject(int n2) {
        return new NativeObject((long)n2 + this.address);
    }

    void putObject(int n2, NativeObject nativeObject) {
        switch (NativeObject.addressSize()) {
            case 8: {
                this.putLong(n2, nativeObject.address);
                break;
            }
            case 4: {
                this.putInt(n2, (int)(nativeObject.address & 0xFFFFFFFFFFFFFFFFL));
                break;
            }
            default: {
                throw new InternalError("Address size not supported");
            }
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

