/*
 * Decompiled with CFR 0.152.
 */
package org.xml.sax.helpers;

import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class NamespaceSupport {
    public static final String XMLNS = "http://www.w3.org/XML/1998/namespace";
    private static final Enumeration EMPTY_ENUMERATION = new Vector().elements();
    private Context[] contexts;
    private Context currentContext;
    private int contextPos;

    public NamespaceSupport() {
        this.reset();
    }

    public void popContext() {
        --this.contextPos;
        if (this.contextPos < 0) {
            throw new EmptyStackException();
        }
        this.currentContext = this.contexts[this.contextPos];
    }

    public void pushContext() {
        int n2 = this.contexts.length;
        ++this.contextPos;
        if (this.contextPos >= n2) {
            Context[] contextArray = new Context[n2 * 2];
            System.arraycopy(this.contexts, 0, contextArray, 0, n2);
            n2 *= 2;
            this.contexts = contextArray;
        }
        this.currentContext = this.contexts[this.contextPos];
        if (this.currentContext == null) {
            this.contexts[this.contextPos] = this.currentContext = new Context(this);
        }
        if (this.contextPos > 0) {
            this.currentContext.setParent(this.contexts[this.contextPos - 1]);
        }
    }

    public void reset() {
        this.contexts = new Context[32];
        this.contextPos = 0;
        this.contexts[this.contextPos] = this.currentContext = new Context(this);
        this.currentContext.declarePrefix("xml", XMLNS);
    }

    static Enumeration access$000() {
        return EMPTY_ENUMERATION;
    }

    public Enumeration getDeclaredPrefixes() {
        return this.currentContext.getDeclaredPrefixes();
    }

    public Enumeration getPrefixes() {
        return this.currentContext.getPrefixes();
    }

    public String getPrefix(String string) {
        return this.currentContext.getPrefix(string);
    }

    public String getURI(String string) {
        return this.currentContext.getURI(string);
    }

    public boolean declarePrefix(String string, String string2) {
        if (string.equals("xml") || string.equals("xmlns")) {
            return false;
        }
        this.currentContext.declarePrefix(string, string2);
        return true;
    }

    public Enumeration getPrefixes(String string) {
        Vector vector = new Vector();
        Enumeration enumeration = this.getPrefixes();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string.equals(this.getURI(string2))) continue;
            vector.addElement(string2);
        }
        return vector.elements();
    }

    public String[] processName(String string, String[] stringArray, boolean bl2) {
        String[] stringArray2 = this.currentContext.processName(string, bl2);
        if (stringArray2 == null) {
            return null;
        }
        stringArray[0] = stringArray2[0];
        stringArray[1] = stringArray2[1];
        stringArray[2] = stringArray2[2];
        return stringArray;
    }

    final class Context {
        Hashtable prefixTable;
        Hashtable uriTable;
        Hashtable elementNameTable;
        Hashtable attributeNameTable;
        String defaultNS;
        private Vector declarations;
        private boolean tablesDirty;
        private Context parent;
        private final NamespaceSupport this$0;

        private void copyTables() {
            this.prefixTable = this.prefixTable != null ? (Hashtable)this.prefixTable.clone() : new Hashtable();
            this.uriTable = this.uriTable != null ? (Hashtable)this.uriTable.clone() : new Hashtable();
            this.elementNameTable = new Hashtable();
            this.attributeNameTable = new Hashtable();
            this.tablesDirty = true;
        }

        Enumeration getDeclaredPrefixes() {
            if (this.declarations == null) {
                return NamespaceSupport.access$000();
            }
            return this.declarations.elements();
        }

        Enumeration getPrefixes() {
            if (this.prefixTable == null) {
                return NamespaceSupport.access$000();
            }
            return this.prefixTable.keys();
        }

        Context(NamespaceSupport namespaceSupport) {
            this.this$0 = namespaceSupport;
            this.defaultNS = null;
            this.declarations = null;
            this.tablesDirty = false;
            this.parent = null;
            this.copyTables();
        }

        void setParent(Context context) {
            this.parent = context;
            this.declarations = null;
            this.prefixTable = context.prefixTable;
            this.uriTable = context.uriTable;
            this.elementNameTable = context.elementNameTable;
            this.attributeNameTable = context.attributeNameTable;
            this.defaultNS = context.defaultNS;
            this.tablesDirty = false;
        }

        String getPrefix(String string) {
            if (this.uriTable == null) {
                return null;
            }
            return (String)this.uriTable.get(string);
        }

        String getURI(String string) {
            if ("".equals(string)) {
                return this.defaultNS;
            }
            if (this.prefixTable == null) {
                return null;
            }
            return (String)this.prefixTable.get(string);
        }

        void declarePrefix(String string, String string2) {
            if (!this.tablesDirty) {
                this.copyTables();
            }
            if (this.declarations == null) {
                this.declarations = new Vector();
            }
            string = string.intern();
            string2 = string2.intern();
            if ("".equals(string)) {
                this.defaultNS = "".equals(string2) ? null : string2;
            } else {
                this.prefixTable.put(string, string2);
                this.uriTable.put(string2, string);
            }
            this.declarations.addElement(string);
        }

        String[] processName(String string, boolean bl2) {
            Hashtable hashtable = bl2 ? this.elementNameTable : this.attributeNameTable;
            String[] stringArray = (String[])hashtable.get(string);
            if (stringArray != null) {
                return stringArray;
            }
            stringArray = new String[3];
            int n2 = string.indexOf(58);
            if (n2 == -1) {
                stringArray[0] = bl2 || this.defaultNS == null ? "" : this.defaultNS;
                stringArray[1] = string.intern();
                stringArray[2] = stringArray[1];
            } else {
                String string2 = string.substring(0, n2);
                String string3 = string.substring(n2 + 1);
                String string4 = "".equals(string2) ? this.defaultNS : (String)this.prefixTable.get(string2);
                if (string4 == null) {
                    return null;
                }
                stringArray[0] = string4;
                stringArray[1] = string3.intern();
                stringArray[2] = string.intern();
            }
            hashtable.put(stringArray[2], stringArray);
            this.tablesDirty = true;
            return stringArray;
        }
    }
}

