/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import org.apache.crimson.parser.AttributeDecl;
import org.apache.crimson.parser.AttributesExImpl;
import org.apache.crimson.parser.ContentModel;
import org.apache.crimson.parser.ElementDecl;
import org.apache.crimson.parser.ElementValidator;
import org.apache.crimson.parser.EndOfInputException;
import org.apache.crimson.parser.ExternalEntity;
import org.apache.crimson.parser.InputEntity;
import org.apache.crimson.parser.InternalEntity;
import org.apache.crimson.parser.Resolver;
import org.apache.crimson.parser.SimpleHashtable;
import org.apache.crimson.util.MessageCatalog;
import org.apache.crimson.util.XmlChars;
import org.apache.crimson.util.XmlNames;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class Parser2 {
    private InputEntity in;
    private AttributesExImpl attTmp;
    private StringBuffer strTmp;
    private char[] nameTmp;
    private NameCache nameCache;
    private char[] charTmp = new char[2];
    private String[] namePartsTmp = new String[3];
    private boolean seenNSDecl;
    private NamespaceSupport nsSupport;
    private Vector nsAttTmp;
    private boolean isValidating = false;
    private boolean fastStandalone = false;
    private boolean isInAttribute = false;
    private boolean namespaces;
    private boolean prefixes;
    private boolean inExternalPE;
    private boolean doLexicalPE;
    private boolean donePrologue;
    private boolean isStandalone;
    private String rootElementName;
    private boolean ignoreDeclarations;
    private SimpleHashtable elements = new SimpleHashtable(47);
    private SimpleHashtable params = new SimpleHashtable(7);
    Hashtable notations = new Hashtable(7);
    SimpleHashtable entities = new SimpleHashtable(17);
    private ContentHandler contentHandler;
    private DTDHandler dtdHandler;
    private EntityResolver resolver;
    private ErrorHandler errHandler;
    private Locale locale;
    private Locator locator = new DocLocator(this);
    private DeclHandler declHandler;
    private LexicalHandler lexicalHandler;
    private boolean disallowDoctypeDecl = false;
    private String propertyEntityExpansionLimit = null;
    private String propertyDisallowDoctypeDecl = null;
    private String propertyElementAttributeLimit = null;
    private int entityExpansionCount = 0;
    private int entityExpansionLimit = -1;
    private int elementAttributeLimit = -1;
    private static final int DEFAULT_ENTITY_EXPANSION_LIMIT = 64000;
    private static final int DEFAULT_ELEMENT_ATTRIBUTE_LIMIT = 10000;
    private static final boolean supportValidation = true;
    static final String strANY = "ANY";
    static final String strEMPTY = "EMPTY";
    static final String SYSTEM_PROPERTY_ENTITY_EXPANSION_LIMIT = "entityExpansionLimit";
    static final String SYSTEM_PROPERTY_DISALLOW_DOCTYPE_DECL = "disallowDoctypeDecl";
    static final String SYSTEM_PROPERTY_ELEMENT_ATTRIBUTE_LIMIT = "elementAttributeLimit";
    static final boolean SECURITY_DEBUG = false;
    private static final NullHandler nullHandler = new NullHandler(null);
    private static final String XmlLang = "xml:lang";
    static final Catalog messages = new Catalog();
    static Class class$org$apache$crimson$parser$Parser2;

    private char getc() throws IOException, SAXException {
        if (!this.inExternalPE || !this.doLexicalPE) {
            char c2 = this.in.getc();
            if (c2 == '%' && this.doLexicalPE) {
                this.fatal("P-080");
            }
            return c2;
        }
        while (this.in.isEOF()) {
            if (this.in.isInternal() || this.doLexicalPE && !this.in.isDocument()) {
                this.in = this.in.pop();
                continue;
            }
            this.fatal("P-064", new Object[]{this.in.getName()});
        }
        char c3 = this.in.getc();
        if (c3 == '%' && this.doLexicalPE) {
            String string = this.maybeGetName();
            if (string == null) {
                this.fatal("P-011");
            }
            this.nextChar(';', "F-021", string);
            Object object = this.params.get(string);
            this.pushReader(" ".toCharArray(), null, false);
            if (object instanceof InternalEntity) {
                this.pushReader(((InternalEntity)object).buf, string, false);
            } else if (object instanceof ExternalEntity) {
                this.pushReader((ExternalEntity)object);
            } else if (object == null) {
                this.fatal("V-022");
            } else {
                throw new InternalError();
            }
            this.pushReader(" ".toCharArray(), null, false);
            return this.in.getc();
        }
        return c3;
    }

    private int parseCharNumber() throws SAXException, IOException {
        int n2 = 0;
        if (this.getc() != 'x') {
            this.ungetc();
            while (true) {
                char c2;
                if ((c2 = this.getc()) >= '0' && c2 <= '9') {
                    n2 *= 10;
                    n2 += c2 - 48;
                    continue;
                }
                if (c2 == ';') {
                    return n2;
                }
                this.fatal("P-049");
            }
        }
        while (true) {
            char c3;
            if ((c3 = this.getc()) >= '0' && c3 <= '9') {
                n2 <<= 4;
                n2 += c3 - 48;
                continue;
            }
            if (c3 >= 'a' && c3 <= 'f') {
                n2 <<= 4;
                n2 += 10 + (c3 - 97);
                continue;
            }
            if (c3 >= 'A' && c3 <= 'F') {
                n2 <<= 4;
                n2 += 10 + (c3 - 65);
                continue;
            }
            if (c3 == ';') {
                return n2;
            }
            this.fatal("P-050");
        }
    }

    public Parser2() {
        this.setHandlers();
        this.setSecurityConstraintValues();
    }

    void afterDocument() {
    }

    void afterRoot() throws SAXException {
    }

    private void init() {
        this.in = null;
        this.attTmp = new AttributesExImpl();
        this.strTmp = new StringBuffer();
        this.nameTmp = new char[20];
        this.nameCache = new NameCache();
        if (this.namespaces) {
            this.nsSupport = new NamespaceSupport();
            if (this.isValidating && !this.prefixes) {
                this.nsAttTmp = new Vector();
            }
        }
        this.isStandalone = false;
        this.rootElementName = null;
        this.isInAttribute = false;
        this.inExternalPE = false;
        this.doLexicalPE = false;
        this.donePrologue = false;
        this.entities.clear();
        this.notations.clear();
        this.params.clear();
        this.elements.clear();
        this.ignoreDeclarations = false;
        this.builtin("amp", "&#38;");
        this.builtin("lt", "&#60;");
        this.builtin("gt", ">");
        this.builtin("quot", "\"");
        this.builtin("apos", "'");
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        if (this.resolver == null) {
            this.resolver = new Resolver();
        }
        this.setHandlers();
        this.entityExpansionCount = 0;
        if (this.entityExpansionLimit < 0) {
            this.entityExpansionLimit = 64000;
        }
        if (this.elementAttributeLimit < 0) {
            this.elementAttributeLimit = 10000;
        }
    }

    private void maybeTextDecl() throws IOException, SAXException {
        if (!this.in.isXmlDeclOrTextDeclPrefix()) {
            return;
        }
        this.peek("<?xml");
        this.readVersion(false, "1.0");
        this.readEncoding(true);
        this.maybeWhitespace();
        if (!this.peek("?>")) {
            this.fatal("P-057");
        }
    }

    private void maybeXmlDecl() throws IOException, SAXException {
        if (!this.in.isXmlDeclOrTextDeclPrefix()) {
            return;
        }
        this.peek("<?xml");
        this.readVersion(true, "1.0");
        this.readEncoding(false);
        this.readStandalone();
        this.maybeWhitespace();
        if (!this.peek("?>")) {
            char c2 = this.getc();
            this.fatal("P-023", new Object[]{Integer.toHexString(c2), new Character(c2)});
        }
    }

    private void readStandalone() throws IOException, SAXException {
        String string = this.maybeReadAttribute("standalone", false);
        if (string == null || "no".equals(string)) {
            return;
        }
        if ("yes".equals(string)) {
            this.isStandalone = true;
            return;
        }
        this.fatal("P-029", new Object[]{string});
    }

    private void setHandlers() {
        if (this.contentHandler == null) {
            this.contentHandler = nullHandler;
        }
        if (this.errHandler == null) {
            this.errHandler = nullHandler;
        }
        if (this.dtdHandler == null) {
            this.dtdHandler = nullHandler;
        }
        if (this.lexicalHandler == null) {
            this.lexicalHandler = nullHandler;
        }
        if (this.declHandler == null) {
            this.declHandler = nullHandler;
        }
    }

    void setSecurityConstraintValues() {
        try {
            this.propertyEntityExpansionLimit = (String)AccessController.doPrivileged(new PrivilegedAction(this){
                private final Parser2 this$0;

                public Object run() {
                    return System.getProperty(Parser2.SYSTEM_PROPERTY_ENTITY_EXPANSION_LIMIT);
                }
                {
                    this.this$0 = parser2;
                }
            });
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            this.propertyDisallowDoctypeDecl = (String)AccessController.doPrivileged(new PrivilegedAction(this){
                private final Parser2 this$0;

                public Object run() {
                    return System.getProperty(Parser2.SYSTEM_PROPERTY_DISALLOW_DOCTYPE_DECL);
                }
                {
                    this.this$0 = parser2;
                }
            });
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            this.propertyElementAttributeLimit = (String)AccessController.doPrivileged(new PrivilegedAction(this){
                private final Parser2 this$0;

                public Object run() {
                    return System.getProperty(Parser2.SYSTEM_PROPERTY_ELEMENT_ATTRIBUTE_LIMIT);
                }
                {
                    this.this$0 = parser2;
                }
            });
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (this.propertyEntityExpansionLimit == null || this.propertyDisallowDoctypeDecl == null) {
            try {
                FileInputStream fileInputStream = (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(this){
                    private final Parser2 this$0;

                    public Object run() throws FileNotFoundException {
                        String string = System.getProperty("java.home");
                        String string2 = string + File.separator + "lib" + File.separator + "jaxp.properties";
                        File file = new File(string2);
                        if (file.exists()) {
                            return new FileInputStream(file);
                        }
                        return null;
                    }
                    {
                        this.this$0 = parser2;
                    }
                });
                if (fileInputStream != null) {
                    Properties properties = new Properties();
                    properties.load(fileInputStream);
                    if (this.propertyEntityExpansionLimit == null) {
                        this.propertyEntityExpansionLimit = properties.getProperty(SYSTEM_PROPERTY_ENTITY_EXPANSION_LIMIT);
                    }
                    if (this.propertyDisallowDoctypeDecl == null) {
                        this.propertyDisallowDoctypeDecl = properties.getProperty(SYSTEM_PROPERTY_DISALLOW_DOCTYPE_DECL);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            if (this.propertyEntityExpansionLimit != null) {
                this.entityExpansionLimit = Integer.parseInt(this.propertyEntityExpansionLimit);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.propertyDisallowDoctypeDecl != null && (this.propertyDisallowDoctypeDecl.equals("true") || this.propertyDisallowDoctypeDecl.equals("TRUE"))) {
            this.disallowDoctypeDecl = true;
        }
        try {
            if (this.propertyElementAttributeLimit != null) {
                this.elementAttributeLimit = Integer.parseInt(this.propertyElementAttributeLimit);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void ungetc() {
        this.in.ungetc();
    }

    public boolean isFastStandalone() {
        return this.fastStandalone;
    }

    private boolean maybeAttlistDecl() throws IOException, SAXException {
        InputEntity inputEntity = this.peekDeclaration("!ATTLIST");
        if (inputEntity == null) {
            return false;
        }
        String string = this.getMarkupDeclname("F-016", true);
        ElementDecl elementDecl = (ElementDecl)this.elements.get(string);
        if (elementDecl == null) {
            elementDecl = new ElementDecl(string);
            if (!this.ignoreDeclarations) {
                this.elements.put(string, elementDecl);
            }
        }
        this.maybeWhitespace();
        while (!this.peek(">")) {
            Object object;
            string = this.maybeGetName();
            if (string == null) {
                this.fatal("P-044", new Object[]{new Character(this.getc())});
            }
            this.whitespace("F-001");
            AttributeDecl attributeDecl = new AttributeDecl(string);
            boolean bl2 = attributeDecl.isFromInternalSubset = !this.inExternalPE;
            if (this.peek("CDATA")) {
                attributeDecl.type = "CDATA";
            } else if (this.peek("IDREFS")) {
                attributeDecl.type = "IDREFS";
            } else if (this.peek("IDREF")) {
                attributeDecl.type = "IDREF";
            } else if (this.peek("ID")) {
                attributeDecl.type = "ID";
                if (elementDecl.id != null) {
                    if (this.isValidating) {
                        this.error("V-016", new Object[]{elementDecl.id});
                    }
                } else {
                    elementDecl.id = string;
                }
            } else if (this.peek("ENTITY")) {
                attributeDecl.type = "ENTITY";
            } else if (this.peek("ENTITIES")) {
                attributeDecl.type = "ENTITIES";
            } else if (this.peek("NMTOKENS")) {
                attributeDecl.type = "NMTOKENS";
            } else if (this.peek("NMTOKEN")) {
                attributeDecl.type = "NMTOKEN";
            } else if (this.peek("NOTATION")) {
                attributeDecl.type = "NOTATION";
                this.whitespace("F-002");
                this.nextChar('(', "F-029", null);
                this.maybeWhitespace();
                object = new Vector();
                do {
                    if ((string = this.maybeGetName()) == null) {
                        this.fatal("P-068");
                    }
                    if (this.isValidating && this.notations.get(string) == null) {
                        this.notations.put(string, string);
                    }
                    ((Vector)object).addElement(string);
                    this.maybeWhitespace();
                    if (!this.peek("|")) continue;
                    this.maybeWhitespace();
                } while (!this.peek(")"));
                attributeDecl.values = new String[((Vector)object).size()];
                for (int i2 = 0; i2 < ((Vector)object).size(); ++i2) {
                    attributeDecl.values[i2] = (String)((Vector)object).elementAt(i2);
                }
            } else if (this.peek("(")) {
                attributeDecl.type = "ENUMERATION";
                this.maybeWhitespace();
                object = new Vector();
                do {
                    string = this.getNmtoken();
                    ((Vector)object).addElement(string);
                    this.maybeWhitespace();
                    if (!this.peek("|")) continue;
                    this.maybeWhitespace();
                } while (!this.peek(")"));
                attributeDecl.values = new String[((Vector)object).size()];
                for (int i3 = 0; i3 < ((Vector)object).size(); ++i3) {
                    attributeDecl.values[i3] = (String)((Vector)object).elementAt(i3);
                }
            } else {
                this.fatal("P-045", new Object[]{string, new Character(this.getc())});
            }
            this.whitespace("F-003");
            if (this.peek("#REQUIRED")) {
                attributeDecl.valueDefault = "#REQUIRED";
                attributeDecl.isRequired = true;
            } else if (this.peek("#FIXED")) {
                if (this.isValidating && attributeDecl.type == "ID") {
                    this.error("V-017", new Object[]{attributeDecl.name});
                }
                attributeDecl.valueDefault = "#FIXED";
                attributeDecl.isFixed = true;
                this.whitespace("F-004");
                this.doLexicalPE = false;
                this.parseLiteral(false);
                this.doLexicalPE = true;
                attributeDecl.defaultValue = attributeDecl.type != "CDATA" ? this.normalize(false) : this.strTmp.toString();
                if (attributeDecl.type != "CDATA") {
                    this.validateAttributeSyntax(attributeDecl, attributeDecl.defaultValue);
                }
            } else if (this.peek("#IMPLIED")) {
                attributeDecl.valueDefault = "#IMPLIED";
            } else {
                if (this.isValidating && attributeDecl.type == "ID") {
                    this.error("V-018", new Object[]{attributeDecl.name});
                }
                this.doLexicalPE = false;
                this.parseLiteral(false);
                this.doLexicalPE = true;
                attributeDecl.defaultValue = attributeDecl.type != "CDATA" ? this.normalize(false) : this.strTmp.toString();
                if (attributeDecl.type != "CDATA") {
                    this.validateAttributeSyntax(attributeDecl, attributeDecl.defaultValue);
                }
            }
            if (XmlLang.equals(attributeDecl.name) && attributeDecl.defaultValue != null && !this.isXmlLang(attributeDecl.defaultValue)) {
                this.error("P-033", new Object[]{attributeDecl.defaultValue});
            }
            if (!this.ignoreDeclarations && elementDecl.attributes.get(attributeDecl.name) == null) {
                elementDecl.attributes.put(attributeDecl.name, attributeDecl);
                if (attributeDecl.type == "ENUMERATION" || attributeDecl.type == "NOTATION") {
                    StringBuffer stringBuffer = new StringBuffer();
                    if (attributeDecl.type == "NOTATION") {
                        stringBuffer.append(attributeDecl.type);
                        stringBuffer.append(" ");
                    }
                    if (attributeDecl.values.length > 1) {
                        stringBuffer.append("(");
                    }
                    for (int i4 = 0; i4 < attributeDecl.values.length; ++i4) {
                        stringBuffer.append(attributeDecl.values[i4]);
                        if (i4 + 1 >= attributeDecl.values.length) continue;
                        stringBuffer.append("|");
                    }
                    if (attributeDecl.values.length > 1) {
                        stringBuffer.append(")");
                    }
                    object = stringBuffer.toString();
                } else {
                    object = attributeDecl.type;
                }
                this.declHandler.attributeDecl(elementDecl.name, attributeDecl.name, (String)object, attributeDecl.valueDefault, attributeDecl.defaultValue);
            }
            this.maybeWhitespace();
        }
        if (this.isValidating && inputEntity != this.in) {
            this.error("V-013", null);
        }
        return true;
    }

    private boolean maybeConditionalSect() throws IOException, SAXException {
        if (!this.peek("<![")) {
            return false;
        }
        InputEntity inputEntity = this.in;
        this.maybeWhitespace();
        String string = this.maybeGetName();
        if (string == null) {
            this.fatal("P-046");
        }
        this.maybeWhitespace();
        this.nextChar('[', "F-030", null);
        if ("INCLUDE".equals(string)) {
            while (true) {
                if (this.in.isEOF() && this.in != inputEntity) {
                    this.in = this.in.pop();
                    continue;
                }
                if (this.in.isEOF()) {
                    if (this.isValidating) {
                        this.error("V-020", null);
                    }
                    this.in = this.in.pop();
                }
                if (!this.peek("]]>")) {
                    this.doLexicalPE = false;
                    if (this.maybeWhitespace() || this.maybePEReference()) continue;
                    this.doLexicalPE = true;
                    if (this.maybeMarkupDecl() || this.maybeConditionalSect()) continue;
                    this.fatal("P-047");
                    continue;
                }
                break;
            }
        } else if ("IGNORE".equals(string)) {
            int n2 = 1;
            this.doLexicalPE = false;
            while (n2 > 0) {
                char c2 = this.getc();
                if (c2 == '<') {
                    if (!this.peek("![")) continue;
                    ++n2;
                    continue;
                }
                if (c2 != ']' || !this.peek("]>")) continue;
                --n2;
            }
        } else {
            this.fatal("P-048", new Object[]{string});
        }
        return true;
    }

    private boolean maybeDoctypeDecl() throws IOException, SAXException {
        if (!this.peek("<!DOCTYPE")) {
            return false;
        }
        if (this.disallowDoctypeDecl) {
            this.fatal("P-085", new Object[]{SYSTEM_PROPERTY_DISALLOW_DOCTYPE_DECL});
        }
        ExternalEntity externalEntity = null;
        this.rootElementName = this.getMarkupDeclname("F-014", true);
        if (this.maybeWhitespace() && (externalEntity = this.maybeExternalID()) != null) {
            this.lexicalHandler.startDTD(this.rootElementName, externalEntity.publicId, externalEntity.verbatimSystemId);
            this.maybeWhitespace();
        } else {
            this.lexicalHandler.startDTD(this.rootElementName, null, null);
        }
        if (this.in.peekc('[')) {
            while (true) {
                if (this.in.isEOF() && !this.in.isDocument()) {
                    this.in = this.in.pop();
                    continue;
                }
                if (this.maybeMarkupDecl() || this.maybePEReference() || this.maybeWhitespace()) continue;
                if (!this.peek("<![")) break;
                this.fatal("P-028");
            }
            this.nextChar(']', "F-024", null);
            this.maybeWhitespace();
        }
        this.nextChar('>', "F-025", null);
        if (externalEntity != null) {
            externalEntity.name = "[dtd]";
            externalEntity.isPE = true;
            this.externalParameterEntity(externalEntity);
        }
        this.params.clear();
        this.lexicalHandler.endDTD();
        Vector vector = new Vector();
        Object object = this.notations.keys();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            Object object2 = this.notations.get(string);
            if (object2 == Boolean.TRUE) {
                if (this.isValidating) {
                    this.error("V-003", new Object[]{string});
                }
                vector.addElement(string);
                continue;
            }
            if (!(object2 instanceof String)) continue;
            if (this.isValidating) {
                this.error("V-004", new Object[]{string});
            }
            vector.addElement(string);
        }
        while (!vector.isEmpty()) {
            object = vector.firstElement();
            vector.removeElement(object);
            this.notations.remove(object);
        }
        return true;
    }

    private boolean maybeElementDecl() throws IOException, SAXException {
        InputEntity inputEntity = this.peekDeclaration("!ELEMENT");
        if (inputEntity == null) {
            return false;
        }
        String string = this.getMarkupDeclname("F-015", true);
        ElementDecl elementDecl = (ElementDecl)this.elements.get(string);
        boolean bl2 = false;
        if (elementDecl != null) {
            if (elementDecl.contentType != null) {
                if (this.isValidating && elementDecl.contentType != null) {
                    this.error("V-012", new Object[]{string});
                }
                elementDecl = new ElementDecl(string);
            }
        } else {
            elementDecl = new ElementDecl(string);
            if (!this.ignoreDeclarations) {
                this.elements.put(elementDecl.name, elementDecl);
                bl2 = true;
            }
        }
        elementDecl.isFromInternalSubset = !this.inExternalPE;
        this.whitespace("F-000");
        if (this.peek(strEMPTY)) {
            elementDecl.contentType = strEMPTY;
            elementDecl.ignoreWhitespace = true;
        } else if (this.peek(strANY)) {
            elementDecl.contentType = strANY;
            elementDecl.ignoreWhitespace = false;
        } else {
            elementDecl.contentType = this.getMixedOrChildren(elementDecl);
        }
        this.maybeWhitespace();
        char c2 = this.getc();
        if (c2 != '>') {
            this.fatal("P-036", new Object[]{string, new Character(c2)});
        }
        if (this.isValidating && inputEntity != this.in) {
            this.error("V-013", null);
        }
        if (bl2) {
            this.declHandler.elementDecl(elementDecl.name, elementDecl.contentType);
        }
        return true;
    }

    private boolean maybeEntityDecl() throws IOException, SAXException {
        boolean bl2;
        SimpleHashtable simpleHashtable;
        InputEntity inputEntity = this.peekDeclaration("!ENTITY");
        if (inputEntity == null) {
            return false;
        }
        this.doLexicalPE = false;
        this.whitespace("F-005");
        if (this.in.peekc('%')) {
            this.whitespace("F-006");
            simpleHashtable = this.params;
        } else {
            simpleHashtable = this.entities;
        }
        this.ungetc();
        this.doLexicalPE = true;
        String string = this.getMarkupDeclname("F-017", false);
        this.whitespace("F-007");
        ExternalEntity externalEntity = this.maybeExternalID();
        boolean bl3 = bl2 = simpleHashtable.get(string) == null;
        if (!bl2 && simpleHashtable == this.entities) {
            this.warning("P-054", new Object[]{string});
        }
        bl2 &= !this.ignoreDeclarations;
        if (externalEntity == null) {
            this.doLexicalPE = false;
            this.parseLiteral(true);
            this.doLexicalPE = true;
            if (bl2) {
                char[] cArray = new char[this.strTmp.length()];
                if (cArray.length != 0) {
                    this.strTmp.getChars(0, cArray.length, cArray, 0);
                }
                InternalEntity internalEntity = new InternalEntity(string, cArray);
                internalEntity.isPE = simpleHashtable == this.params;
                internalEntity.isFromInternalSubset = !this.inExternalPE;
                simpleHashtable.put(string, internalEntity);
                if (simpleHashtable == this.params) {
                    string = "%" + string;
                }
                this.declHandler.internalEntityDecl(string, new String(cArray));
            }
        } else {
            if (simpleHashtable == this.entities && this.maybeWhitespace() && this.peek("NDATA")) {
                externalEntity.notation = this.getMarkupDeclname("F-018", false);
                if (this.isValidating && this.notations.get(externalEntity.notation) == null) {
                    this.notations.put(externalEntity.notation, Boolean.TRUE);
                }
            }
            externalEntity.name = string;
            externalEntity.isPE = simpleHashtable == this.params;
            boolean bl4 = externalEntity.isFromInternalSubset = !this.inExternalPE;
            if (bl2) {
                simpleHashtable.put(string, externalEntity);
                if (externalEntity.notation != null) {
                    this.dtdHandler.unparsedEntityDecl(string, externalEntity.publicId, externalEntity.systemId, externalEntity.notation);
                } else {
                    if (simpleHashtable == this.params) {
                        string = "%" + string;
                    }
                    this.declHandler.externalEntityDecl(string, externalEntity.publicId, externalEntity.systemId);
                }
            }
        }
        this.maybeWhitespace();
        this.nextChar('>', "F-031", string);
        if (this.isValidating && inputEntity != this.in) {
            this.error("V-013", null);
        }
        return true;
    }

    private boolean maybeMarkupDecl() throws IOException, SAXException {
        return this.maybeElementDecl() || this.maybeAttlistDecl() || this.maybeEntityDecl() || this.maybeNotationDecl() || this.maybePI(false) || this.maybeComment(false);
    }

    private boolean maybeNotationDecl() throws IOException, SAXException {
        Object object;
        InputEntity inputEntity = this.peekDeclaration("!NOTATION");
        if (inputEntity == null) {
            return false;
        }
        String string = this.getMarkupDeclname("F-019", false);
        ExternalEntity externalEntity = new ExternalEntity(this.in);
        this.whitespace("F-011");
        if (this.peek("PUBLIC")) {
            this.whitespace("F-009");
            externalEntity.publicId = this.parsePublicId();
            if (this.maybeWhitespace()) {
                if (!this.peek(">")) {
                    externalEntity.systemId = this.parseSystemId();
                } else {
                    this.ungetc();
                }
            }
        } else if (this.peek("SYSTEM")) {
            this.whitespace("F-008");
            externalEntity.systemId = this.parseSystemId();
        } else {
            this.fatal("P-062");
        }
        this.maybeWhitespace();
        this.nextChar('>', "F-032", string);
        if (this.isValidating && inputEntity != this.in) {
            this.error("V-013", null);
        }
        if (externalEntity.systemId != null && externalEntity.systemId.indexOf(35) != -1) {
            this.error("P-056", new Object[]{externalEntity.systemId});
        }
        if ((object = this.notations.get(string)) != null && object instanceof ExternalEntity) {
            this.warning("P-063", new Object[]{string});
        } else if (!this.ignoreDeclarations) {
            this.notations.put(string, externalEntity);
            this.dtdHandler.notationDecl(string, externalEntity.publicId, externalEntity.systemId);
        }
        return true;
    }

    private boolean maybePEReference() throws IOException, SAXException {
        if (!this.in.peekc('%')) {
            return false;
        }
        String string = this.maybeGetName();
        if (string == null) {
            this.fatal("P-011");
        }
        this.nextChar(';', "F-021", string);
        Object object = this.params.get(string);
        if (object instanceof InternalEntity) {
            InternalEntity internalEntity = (InternalEntity)object;
            this.pushReader(internalEntity.buf, string, false);
        } else if (object instanceof ExternalEntity) {
            this.externalParameterEntity((ExternalEntity)object);
        } else if (object == null) {
            this.ignoreDeclarations = true;
            if (this.isValidating) {
                this.error("V-022", new Object[]{string});
            } else {
                this.warning("V-022", new Object[]{string});
            }
        }
        return true;
    }

    private boolean maybeWhitespace() throws IOException, SAXException {
        if (!this.inExternalPE || !this.doLexicalPE) {
            return this.in.maybeWhitespace();
        }
        char c2 = this.getc();
        boolean bl2 = false;
        while (c2 == ' ' || c2 == '\t' || c2 == '\n' || c2 == '\r') {
            bl2 = true;
            if (this.in.isEOF() && !this.in.isInternal()) {
                return bl2;
            }
            c2 = this.getc();
        }
        this.ungetc();
        return bl2;
    }

    private int surrogatesToCharTmp(int n2) throws SAXException {
        if (n2 <= 65535) {
            if (XmlChars.isChar(n2)) {
                this.charTmp[0] = (char)n2;
                return 1;
            }
        } else if (n2 <= 0x10FFFF) {
            this.charTmp[0] = (char)(0xD800 | (n2 -= 65536) >> 10 & 0x3FF);
            this.charTmp[1] = (char)(0xDC00 | n2 & 0x3FF);
            return 2;
        }
        this.fatal("P-051", new Object[]{Integer.toHexString(n2)});
        return -1;
    }

    private void maybeMisc(boolean bl2) throws IOException, SAXException {
        while (!(bl2 && this.in.isEOF() || !this.maybeComment(false) && !this.maybePI(false) && !this.maybeWhitespace())) {
        }
    }

    private void parseLiteral(boolean bl2) throws IOException, SAXException {
        boolean bl3 = this.doLexicalPE;
        char c2 = this.getc();
        InputEntity inputEntity = this.in;
        if (c2 != '\'' && c2 != '\"') {
            this.fatal("P-007");
        }
        this.isInAttribute = !bl2;
        this.strTmp = new StringBuffer();
        while (true) {
            String string;
            if (this.in != inputEntity && this.in.isEOF()) {
                this.in = this.in.pop();
                continue;
            }
            char c3 = this.getc();
            if (c3 == c2 && this.in == inputEntity) break;
            if (c3 == '&') {
                string = this.maybeGetName();
                if (string != null) {
                    this.nextChar(';', "F-020", string);
                    if (bl2) {
                        this.strTmp.append('&');
                        this.strTmp.append(string);
                        this.strTmp.append(';');
                        continue;
                    }
                    this.expandEntityInLiteral(string, this.entities, bl2);
                    continue;
                }
                c3 = this.getc();
                if (c3 == '#') {
                    int n2 = this.parseCharNumber();
                    if (n2 > 65535) {
                        n2 = this.surrogatesToCharTmp(n2);
                        this.strTmp.append(this.charTmp[0]);
                        if (n2 != 2) continue;
                        this.strTmp.append(this.charTmp[1]);
                        continue;
                    }
                    this.strTmp.append((char)n2);
                    continue;
                }
                this.fatal("P-009");
                continue;
            }
            if (c3 == '%' && bl2) {
                string = this.maybeGetName();
                if (string != null) {
                    this.nextChar(';', "F-021", string);
                    if (this.inExternalPE) {
                        this.expandEntityInLiteral(string, this.params, bl2);
                        continue;
                    }
                    this.fatal("P-010", new Object[]{string});
                    continue;
                }
                this.fatal("P-011");
            }
            if (!bl2) {
                if (c3 == ' ' || c3 == '\t' || c3 == '\n' || c3 == '\r') {
                    this.strTmp.append(' ');
                    continue;
                }
                if (c3 == '<') {
                    this.fatal("P-012");
                }
            }
            this.strTmp.append(c3);
        }
        this.isInAttribute = false;
    }

    private void readEncoding(boolean bl2) throws IOException, SAXException {
        String string = this.maybeReadAttribute("encoding", bl2);
        if (string == null) {
            return;
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z' || i2 != 0 && (c2 >= '0' && c2 <= '9' || c2 == '-' || c2 == '_' || c2 == '.')) continue;
            this.fatal("P-060", new Object[]{new Character(c2)});
        }
        String string2 = this.in.getEncoding();
        if (string2 != null && !string.equalsIgnoreCase(string2)) {
            this.warning("P-061", new Object[]{string, string2});
        }
    }

    public void setFastStandalone(boolean bl2) {
        this.fastStandalone = bl2 && !this.isValidating;
    }

    void setIsValidating(boolean bl2) {
        this.isValidating = bl2;
        if (bl2) {
            this.fastStandalone = false;
        }
    }

    private boolean maybeComment(boolean bl2) throws IOException, SAXException {
        int n2;
        boolean bl3;
        if (!this.in.peek(bl2 ? "!--" : "<!--", null)) {
            return false;
        }
        boolean bl4 = this.doLexicalPE;
        this.doLexicalPE = false;
        boolean bl5 = bl3 = this.lexicalHandler != nullHandler;
        if (bl3) {
            this.strTmp = new StringBuffer();
        }
        block2: while (true) {
            try {
                while (true) {
                    if ((n2 = this.getc()) == 45) {
                        n2 = this.getc();
                        if (n2 != 45) {
                            if (bl3) {
                                this.strTmp.append('-');
                            }
                            this.ungetc();
                            continue;
                        }
                        this.nextChar('>', "F-022", null);
                        break block2;
                    }
                    if (!bl3) continue;
                    this.strTmp.append((char)n2);
                }
            }
            catch (EndOfInputException endOfInputException) {
                if (this.inExternalPE || !this.donePrologue && this.in.isInternal()) {
                    if (this.isValidating) {
                        this.error("V-021", null);
                    }
                    this.in = this.in.pop();
                    continue;
                }
                this.fatal("P-017");
                continue;
            }
            break;
        }
        this.doLexicalPE = bl4;
        if (bl3) {
            n2 = this.strTmp.length();
            char[] cArray = new char[n2];
            if (n2 != 0) {
                this.strTmp.getChars(0, n2, cArray, 0);
            }
            this.lexicalHandler.comment(cArray, 0, n2);
        }
        return true;
    }

    private boolean maybePI(boolean bl2) throws IOException, SAXException {
        boolean bl3 = this.doLexicalPE;
        if (!this.in.peek(bl2 ? "?" : "<?", null)) {
            return false;
        }
        this.doLexicalPE = false;
        String string = this.maybeGetName();
        if (string == null) {
            this.fatal("P-018");
        }
        if ("xml".equals(string)) {
            this.fatal("P-019");
        }
        if ("xml".equalsIgnoreCase(string)) {
            this.fatal("P-020", new Object[]{string});
        }
        if (this.maybeWhitespace()) {
            this.strTmp = new StringBuffer();
            try {
                char c2;
                while ((c2 = this.in.getc()) != '?' || !this.in.peekc('>')) {
                    this.strTmp.append(c2);
                }
            }
            catch (EndOfInputException endOfInputException) {
                this.fatal("P-021");
            }
            this.contentHandler.processingInstruction(string, this.strTmp.toString());
        } else {
            if (!this.in.peek("?>", null)) {
                this.fatal("P-022");
            }
            this.contentHandler.processingInstruction(string, "");
        }
        this.doLexicalPE = bl3;
        return true;
    }

    void setNamespaceFeatures(boolean bl2, boolean bl3) {
        this.namespaces = bl2;
        this.prefixes = bl3;
    }

    public void pushInputBuffer(char[] cArray, int n2, int n3) throws SAXException {
        if (n3 <= 0) {
            return;
        }
        if (n2 != 0 || n3 != cArray.length) {
            char[] cArray2 = new char[n3];
            System.arraycopy(cArray, n2, cArray2, 0, n3);
            cArray = cArray2;
        }
        this.pushReader(cArray, null, false);
    }

    private String getNmtoken() throws SAXException, IOException {
        char c2 = this.getc();
        if (!XmlChars.isNameChar(c2)) {
            this.fatal("P-006", new Object[]{new Character(c2)});
        }
        return this.nameCharString((char)c2).name;
    }

    private String maybeGetName() throws IOException, SAXException {
        NameCacheEntry nameCacheEntry = this.maybeGetNameCacheEntry();
        return nameCacheEntry == null ? null : nameCacheEntry.name;
    }

    private String parsePublicId() throws IOException, SAXException {
        String string = this.getQuotedString("F-033", null);
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (" \r\n-'()+,./:=?;!*#@$_%0123456789".indexOf(c2) != -1 || c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z') continue;
            this.fatal("P-016", new Object[]{new Character(c2)});
        }
        this.strTmp = new StringBuffer();
        this.strTmp.append(string);
        return this.normalize(false);
    }

    private String parseSystemId() throws IOException, SAXException {
        String string = this.getQuotedString("F-034", null);
        return this.resolveURI(string);
    }

    private void fatal(String string) throws SAXException {
        this.fatal(string, null, null);
    }

    private void whitespace(String string) throws IOException, SAXException {
        if (!this.maybeWhitespace()) {
            this.fatal("P-004", new Object[]{messages.getMessage(this.locale, string)});
        }
    }

    private boolean isXmlLang(String string) {
        int n2;
        if (string.length() < 2) {
            return false;
        }
        char c2 = string.charAt(1);
        if (c2 == '-') {
            c2 = string.charAt(0);
            if (c2 != 'i' && c2 != 'I' && c2 != 'x' && c2 != 'X') {
                return false;
            }
            n2 = 1;
        } else if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z') {
            c2 = string.charAt(0);
            if (!(c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z')) {
                return false;
            }
            n2 = 2;
        } else {
            return false;
        }
        while (n2 < string.length() && (c2 = string.charAt(n2)) == '-') {
            while (++n2 < string.length() && ((c2 = string.charAt(n2)) >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z')) {
            }
        }
        return string.length() == n2 && c2 != '-';
    }

    private boolean peek(String string) throws IOException, SAXException {
        return this.in.peek(string, null);
    }

    private String normalize(boolean bl2) throws SAXException {
        String string = this.strTmp.toString();
        String string2 = string.trim();
        boolean bl3 = false;
        if (string != string2) {
            string = string2;
            string2 = null;
            bl3 = true;
        }
        this.strTmp = new StringBuffer();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (!XmlChars.isSpace(c2)) {
                this.strTmp.append(c2);
                continue;
            }
            this.strTmp.append(' ');
            while (++i2 < string.length() && XmlChars.isSpace(string.charAt(i2))) {
                bl3 = true;
            }
            --i2;
        }
        if (this.isValidating && this.isStandalone && bl2 && (string2 == null || bl3)) {
            this.error("V-019", null);
        }
        if (bl3) {
            return this.strTmp.toString();
        }
        return string;
    }

    private void readVersion(boolean bl2, String string) throws IOException, SAXException {
        String string2 = this.maybeReadAttribute("version", bl2);
        if (bl2 && string2 == null) {
            this.fatal("P-025", new Object[]{string});
        }
        if (string2 != null) {
            int n2 = string2.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = string2.charAt(i2);
                if (c2 >= '0' && c2 <= '9' || c2 == '_' || c2 == '.' || c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 == ':' || c2 == '-') continue;
                this.fatal("P-026", new Object[]{string2});
            }
        }
        if (string2 != null && !string2.equals(string)) {
            this.error("P-027", new Object[]{string, string2});
        }
    }

    private void pushReader(char[] cArray, String string, boolean bl2) throws SAXException {
        if (bl2 && !this.isInAttribute) {
            this.lexicalHandler.startEntity(string);
        }
        InputEntity inputEntity = InputEntity.getInputEntity(this.errHandler, this.locale);
        inputEntity.init(cArray, string, this.in, !bl2);
        this.in = inputEntity;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) throws SAXException {
        if (locale != null && !messages.isLocaleSupported(locale.toString())) {
            throw new SAXException(messages.getMessage(this.locale, "P-078", new Object[]{locale}));
        }
        this.locale = locale;
    }

    private boolean defaultAttributes(ElementDecl elementDecl) throws SAXException {
        boolean bl2 = false;
        Enumeration enumeration = elementDecl.attributes.keys();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            if (this.attTmp.getValue(string2) != null) continue;
            AttributeDecl attributeDecl = (AttributeDecl)elementDecl.attributes.get(string2);
            if (this.isValidating && attributeDecl.isRequired) {
                if (this.namespaces && !this.prefixes && this.nsAttTmp.contains(string2)) continue;
                this.error("V-009", new Object[]{string2});
            }
            if ((string = attributeDecl.defaultValue) == null) continue;
            if (this.isValidating && this.isStandalone && !attributeDecl.isFromInternalSubset) {
                this.error("V-010", new Object[]{string2});
            }
            if (this.namespaces) {
                this.processAttributeNS(string2, attributeDecl.type, string, string, false, true, null);
            } else {
                this.attTmp.addAttribute("", "", string2, attributeDecl.type, string, string, false);
            }
            bl2 = true;
        }
        return bl2;
    }

    private boolean maybeElement(ElementValidator elementValidator) throws IOException, SAXException {
        Object object;
        String string;
        boolean bl2 = false;
        boolean bl3 = true;
        NameCacheEntry nameCacheEntry = this.maybeGetNameCacheEntry();
        if (nameCacheEntry == null) {
            return false;
        }
        if (elementValidator != null) {
            elementValidator.consume(nameCacheEntry.name);
        }
        ElementDecl elementDecl = (ElementDecl)this.elements.get(nameCacheEntry.name);
        if (this.isValidating) {
            if (elementDecl == null || elementDecl.contentType == null) {
                this.error("V-005", new Object[]{nameCacheEntry.name});
                elementDecl = new ElementDecl(nameCacheEntry.name);
                elementDecl.contentType = strANY;
                this.elements.put(nameCacheEntry.name, elementDecl);
            }
            if (elementValidator == null && this.rootElementName != null && !this.rootElementName.equals(nameCacheEntry.name)) {
                this.error("V-006", new Object[]{nameCacheEntry.name, this.rootElementName});
            }
        }
        int n2 = this.in.getLineNumber();
        boolean bl4 = this.in.maybeWhitespace();
        Vector vector = null;
        if (this.namespaces) {
            this.nsSupport.pushContext();
            this.seenNSDecl = false;
        }
        int n3 = 0;
        while (true) {
            String string2;
            String string3;
            if (n3 > this.elementAttributeLimit) {
                this.fatal("P-087", new Object[]{new Integer(this.elementAttributeLimit)});
            }
            if (this.in.peekc('>')) break;
            if (this.in.peekc('/')) {
                bl3 = false;
                break;
            }
            if (!bl4) {
                this.fatal("P-030");
            }
            if ((string3 = this.maybeGetName()) == null) {
                this.fatal("P-031", new Object[]{new Character(this.getc())});
            }
            if (this.attTmp.getValue(string3) != null) {
                this.fatal("P-032", new Object[]{string3});
            }
            this.in.maybeWhitespace();
            this.nextChar('=', "F-026", string3);
            this.in.maybeWhitespace();
            this.doLexicalPE = false;
            this.parseLiteral(false);
            bl4 = this.in.maybeWhitespace();
            String string4 = string = elementDecl == null ? null : (AttributeDecl)elementDecl.attributes.get(string3);
            if (string == null) {
                if (this.isValidating) {
                    this.error("V-007", new Object[]{string3, nameCacheEntry.name});
                }
                object = this.strTmp.toString();
            } else {
                if (!"CDATA".equals(((AttributeDecl)((Object)string)).type)) {
                    object = this.normalize(!((AttributeDecl)((Object)string)).isFromInternalSubset);
                    if (this.isValidating) {
                        this.validateAttributeSyntax((AttributeDecl)((Object)string), (String)object);
                    }
                } else {
                    object = this.strTmp.toString();
                }
                if (this.isValidating && ((AttributeDecl)((Object)string)).isFixed && !((String)object).equals(((AttributeDecl)((Object)string)).defaultValue)) {
                    this.error("V-008", new Object[]{string3, nameCacheEntry.name, ((AttributeDecl)((Object)string)).defaultValue});
                }
            }
            if (XmlLang.equals(string3) && !this.isXmlLang((String)object)) {
                this.error("P-033", new Object[]{object});
            }
            String string5 = string == null ? "CDATA" : ((AttributeDecl)((Object)string)).type;
            String string6 = string2 = string == null ? null : ((AttributeDecl)((Object)string)).defaultValue;
            if (this.namespaces) {
                vector = this.processAttributeNS(string3, string5, (String)object, string2, true, false, vector);
            } else {
                this.attTmp.addAttribute("", "", string3, string5, (String)object, string2, true);
            }
            bl2 = true;
            ++n3;
        }
        if (elementDecl != null) {
            this.attTmp.setIdAttributeName(elementDecl.id);
        }
        if (elementDecl != null && elementDecl.attributes.size() != 0) {
            boolean bl5 = bl2 = this.defaultAttributes(elementDecl) || bl2;
        }
        if (this.seenNSDecl) {
            n3 = this.attTmp.getLength();
            for (int i2 = 0; i2 < n3; ++i2) {
                string = this.attTmp.getQName(i2);
                if (string.startsWith("xmlns") && (string.length() == 5 || string.charAt(5) == ':')) continue;
                object = this.processName(string, true, false);
                this.attTmp.setURI(i2, object[0]);
                this.attTmp.setLocalName(i2, object[1]);
            }
        } else if (vector != null && this.errHandler != null) {
            for (n3 = 0; n3 < vector.size(); ++n3) {
                this.errHandler.error((SAXParseException)vector.elementAt(n3));
            }
        }
        if (this.namespaces) {
            String[] stringArray = this.processName(nameCacheEntry.name, false, false);
            this.contentHandler.startElement(stringArray[0], stringArray[1], stringArray[2], this.attTmp);
        } else {
            this.contentHandler.startElement("", "", nameCacheEntry.name, this.attTmp);
        }
        if (bl2) {
            this.attTmp.clear();
            if (this.isValidating && this.namespaces && !this.prefixes) {
                this.nsAttTmp.removeAllElements();
            }
        }
        elementValidator = this.newValidator(elementDecl);
        if (bl3) {
            this.content(elementDecl, false, elementValidator);
            if (!this.in.peek(nameCacheEntry.name, nameCacheEntry.chars)) {
                this.fatal("P-034", new Object[]{nameCacheEntry.name, new Integer(n2)});
            }
            this.in.maybeWhitespace();
        }
        this.nextChar('>', "F-027", nameCacheEntry.name);
        elementValidator.done();
        if (this.namespaces) {
            String[] stringArray = this.processName(nameCacheEntry.name, false, false);
            this.contentHandler.endElement(stringArray[0], stringArray[1], stringArray[2]);
            Enumeration enumeration = this.nsSupport.getDeclaredPrefixes();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                this.contentHandler.endPrefixMapping(string);
            }
            this.nsSupport.popContext();
        } else {
            this.contentHandler.endElement("", "", nameCacheEntry.name);
        }
        return true;
    }

    private ExternalEntity maybeExternalID() throws IOException, SAXException {
        String string = null;
        if (this.peek("PUBLIC")) {
            this.whitespace("F-009");
            string = this.parsePublicId();
        } else if (!this.peek("SYSTEM")) {
            return null;
        }
        ExternalEntity externalEntity = new ExternalEntity(this.in);
        externalEntity.publicId = string;
        this.whitespace("F-008");
        externalEntity.verbatimSystemId = this.getQuotedString("F-034", null);
        externalEntity.systemId = this.resolveURI(externalEntity.verbatimSystemId);
        return externalEntity;
    }

    private void externalParameterEntity(ExternalEntity externalEntity) throws IOException, SAXException {
        if (this.isStandalone && this.fastStandalone) {
            return;
        }
        this.inExternalPE = true;
        try {
            this.pushReader(externalEntity);
        }
        catch (IOException iOException) {
            this.fatal("P-082", new Object[]{externalEntity.systemId}, iOException);
        }
        InputEntity inputEntity = this.in;
        try {
            this.maybeTextDecl();
        }
        catch (IOException iOException) {
            this.in = this.in.pop();
            this.fatal("P-082", new Object[]{externalEntity.systemId}, iOException);
        }
        while (!inputEntity.isEOF()) {
            if (this.in.isEOF()) {
                this.in = this.in.pop();
                continue;
            }
            this.doLexicalPE = false;
            if (this.maybeWhitespace() || this.maybePEReference()) continue;
            this.doLexicalPE = true;
            if (this.maybeMarkupDecl() || this.maybeConditionalSect()) continue;
        }
        if (!inputEntity.isEOF()) {
            this.fatal("P-059", new Object[]{this.in.getName()});
        }
        this.in = this.in.pop();
        this.inExternalPE = !this.in.isDocument();
        this.doLexicalPE = false;
    }

    private boolean pushReader(ExternalEntity externalEntity) throws SAXException, IOException {
        if (!externalEntity.isPE && !this.isInAttribute) {
            this.lexicalHandler.startEntity(externalEntity.name);
        }
        InputEntity inputEntity = InputEntity.getInputEntity(this.errHandler, this.locale);
        InputSource inputSource = externalEntity.getInputSource(this.resolver);
        inputEntity.init(inputSource, externalEntity.name, this.in, externalEntity.isPE);
        this.in = inputEntity;
        return true;
    }

    private NameCacheEntry maybeGetNameCacheEntry() throws IOException, SAXException {
        char c2 = this.getc();
        if (!XmlChars.isLetter(c2) && c2 != ':' && c2 != '_') {
            this.ungetc();
            return null;
        }
        return this.nameCharString(c2);
    }

    private NameCacheEntry nameCharString(char c2) throws IOException, SAXException {
        int n2 = 1;
        this.nameTmp[0] = c2;
        while ((c2 = this.in.getNameChar()) != '\u0000') {
            if (n2 >= this.nameTmp.length) {
                char[] cArray = new char[this.nameTmp.length + 10];
                System.arraycopy(this.nameTmp, 0, cArray, 0, this.nameTmp.length);
                this.nameTmp = cArray;
            }
            this.nameTmp[n2++] = c2;
        }
        return this.nameCache.lookupEntry(this.nameTmp, n2);
    }

    void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.dtdHandler = dTDHandler;
    }

    void setEntityResolver(EntityResolver entityResolver) {
        this.resolver = entityResolver;
    }

    void setErrorHandler(ErrorHandler errorHandler) {
        this.errHandler = errorHandler;
    }

    public void parse(InputSource inputSource) throws SAXException, IOException {
        this.init();
        this.parseInternal(inputSource);
    }

    private void parseInternal(InputSource inputSource) throws SAXException, IOException {
        block15: {
            if (inputSource == null) {
                this.fatal("P-000");
            }
            try {
                try {
                    this.in = InputEntity.getInputEntity(this.errHandler, this.locale);
                    this.in.init(inputSource, null, null, false);
                    this.contentHandler.setDocumentLocator(this.locator);
                    this.contentHandler.startDocument();
                    this.maybeXmlDecl();
                    this.maybeMisc(false);
                    if (!this.maybeDoctypeDecl() && this.isValidating) {
                        this.warning("V-001", null);
                    }
                    this.maybeMisc(false);
                    this.donePrologue = true;
                    if (!this.in.peekc('<') || !this.maybeElement(null)) {
                        this.fatal("P-067");
                    }
                    this.afterRoot();
                    this.maybeMisc(true);
                    if (!this.in.isEOF()) {
                        this.fatal("P-001", new Object[]{Integer.toHexString(this.getc())});
                    }
                    this.contentHandler.endDocument();
                }
                catch (EndOfInputException endOfInputException) {
                    if (!this.in.isDocument()) {
                        String string = this.in.getName();
                        do {
                            this.in = this.in.pop();
                        } while (this.in.isInternal());
                        this.fatal("P-002", new Object[]{string}, endOfInputException);
                    } else {
                        this.fatal("P-003", null, endOfInputException);
                    }
                    Object var5_3 = null;
                    this.strTmp = null;
                    this.attTmp = null;
                    this.nameTmp = null;
                    this.nameCache = null;
                    this.nsAttTmp = null;
                    if (this.in != null) {
                        this.in.close();
                        this.in = null;
                    }
                    this.params.clear();
                    this.entities.clear();
                    this.notations.clear();
                    this.elements.clear();
                    this.afterDocument();
                    break block15;
                }
                catch (RuntimeException runtimeException) {
                    throw new SAXParseException(runtimeException.getMessage() != null ? runtimeException.getMessage() : runtimeException.getClass().getName(), this.locator.getPublicId(), this.locator.getSystemId(), this.locator.getLineNumber(), this.locator.getColumnNumber(), runtimeException);
                }
                Object var5_2 = null;
                this.strTmp = null;
                this.attTmp = null;
                this.nameTmp = null;
                this.nameCache = null;
                this.nsAttTmp = null;
                if (this.in != null) {
                    this.in.close();
                    this.in = null;
                }
                this.params.clear();
                this.entities.clear();
                this.notations.clear();
                this.elements.clear();
                this.afterDocument();
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                this.strTmp = null;
                this.attTmp = null;
                this.nameTmp = null;
                this.nameCache = null;
                this.nsAttTmp = null;
                if (this.in != null) {
                    this.in.close();
                    this.in = null;
                }
                this.params.clear();
                this.entities.clear();
                this.notations.clear();
                this.elements.clear();
                this.afterDocument();
                throw throwable;
            }
        }
    }

    void setDeclHandler(DeclHandler declHandler) {
        this.declHandler = declHandler;
    }

    void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexicalHandler = lexicalHandler;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    void error(String string, Object[] objectArray) throws SAXException {
        SAXParseException sAXParseException = new SAXParseException(messages.getMessage(this.locale, string, objectArray), this.locator);
        this.errHandler.error(sAXParseException);
    }

    private void fatal(String string, Object[] objectArray) throws SAXException {
        this.fatal(string, objectArray, null);
    }

    private void warning(String string, Object[] objectArray) throws SAXException {
        SAXParseException sAXParseException = new SAXParseException(messages.getMessage(this.locale, string, objectArray), this.locator);
        this.errHandler.warning(sAXParseException);
    }

    private void nextChar(char c2, String string, String string2) throws IOException, SAXException {
        while (this.in.isEOF() && !this.in.isDocument()) {
            this.in = this.in.pop();
        }
        if (!this.in.peekc(c2)) {
            this.fatal("P-008", new Object[]{new Character(c2), messages.getMessage(this.locale, string), string2 == null ? "" : '\"' + string2 + '\"'});
        }
    }

    private String resolveURI(String string) throws SAXException {
        int n2 = string.indexOf(58);
        if (n2 == -1 || string.indexOf(47) < n2) {
            String string2 = this.in.getSystemId();
            if (string2 == null) {
                this.fatal("P-055", new Object[]{string});
            }
            if (string.length() == 0) {
                string = ".";
            }
            string2 = string2.substring(0, string2.lastIndexOf(47) + 1);
            if (string.charAt(0) != '/') {
                string = string2 + string;
            } else {
                int n3 = string2.indexOf(58);
                String string3 = n3 == -1 ? "file:" : string2.substring(0, n3 + 1);
                string = string3 + string;
            }
        }
        if (string.indexOf(35) != -1) {
            this.error("P-056", new Object[]{string});
        }
        return string;
    }

    private void builtin(String string, String string2) {
        InternalEntity internalEntity = new InternalEntity(string, string2.toCharArray());
        this.entities.put(string, internalEntity);
    }

    private String getMarkupDeclname(String string, boolean bl2) throws IOException, SAXException {
        this.whitespace(string);
        String string2 = this.maybeGetName();
        if (string2 == null) {
            this.fatal("P-005", new Object[]{messages.getMessage(this.locale, string)});
        }
        return string2;
    }

    private String maybeReadAttribute(String string, boolean bl2) throws IOException, SAXException {
        if (!this.maybeWhitespace()) {
            if (!bl2) {
                return null;
            }
            this.fatal("P-024", new Object[]{string});
        }
        if (!this.peek(string)) {
            if (bl2) {
                this.fatal("P-024", new Object[]{string});
            } else {
                this.ungetc();
                return null;
            }
        }
        this.maybeWhitespace();
        this.nextChar('=', "F-023", null);
        this.maybeWhitespace();
        return this.getQuotedString("F-035", string);
    }

    private String[] processName(String string, boolean bl2, boolean bl3) throws SAXException {
        String[] stringArray = this.nsSupport.processName(string, this.namePartsTmp, bl2);
        if (stringArray == null) {
            String string2 = XmlNames.getLocalPart(string);
            stringArray = new String[]{"", string2 != null ? string2.intern() : "", string.intern()};
            String string3 = "P-084";
            Object[] objectArray = new Object[]{string};
            if (bl3) {
                throw new SAXParseException(messages.getMessage(this.locale, string3, objectArray), this.locator);
            }
            this.error(string3, objectArray);
        }
        return stringArray;
    }

    void validateAttributeSyntax(AttributeDecl attributeDecl, String string) throws SAXException {
    }

    private String getMixedOrChildren(ElementDecl elementDecl) throws IOException, SAXException {
        this.strTmp = new StringBuffer();
        this.nextChar('(', "F-028", elementDecl.name);
        InputEntity inputEntity = this.in;
        this.maybeWhitespace();
        this.strTmp.append('(');
        if (this.peek("#PCDATA")) {
            this.strTmp.append("#PCDATA");
            this.getMixed(elementDecl.name, inputEntity);
            elementDecl.ignoreWhitespace = false;
        } else {
            elementDecl.model = this.getcps(elementDecl.name, inputEntity);
            elementDecl.ignoreWhitespace = true;
        }
        return this.strTmp.toString();
    }

    public Locale chooseLocale(String[] stringArray) throws SAXException {
        Locale locale = messages.chooseLocale(stringArray);
        if (locale != null) {
            this.setLocale(locale);
        }
        return locale;
    }

    ContentModel newContentModel(String string) {
        return null;
    }

    ContentModel newContentModel(char c2, ContentModel contentModel) {
        return null;
    }

    private ContentModel getFrequency(ContentModel contentModel) throws IOException, SAXException {
        char c2 = this.getc();
        if (c2 == '?' || c2 == '+' || c2 == '*') {
            this.strTmp.append(c2);
            if (contentModel == null) {
                return null;
            }
            if (contentModel.type == '\u0000') {
                contentModel.type = c2;
                return contentModel;
            }
            return this.newContentModel(c2, contentModel);
        }
        this.ungetc();
        return contentModel;
    }

    ElementValidator newValidator(ElementDecl elementDecl) {
        return ElementValidator.ANY;
    }

    private boolean maybeReferenceInContent(ElementDecl elementDecl, ElementValidator elementValidator) throws IOException, SAXException {
        if (!this.in.peekc('&')) {
            return false;
        }
        if (!this.in.peekc('#')) {
            String string = this.maybeGetName();
            if (string == null) {
                this.fatal("P-009");
            }
            this.nextChar(';', "F-020", string);
            this.expandEntityInContent(elementDecl, string, elementValidator);
            return true;
        }
        elementValidator.text();
        this.contentHandler.characters(this.charTmp, 0, this.surrogatesToCharTmp(this.parseCharNumber()));
        return true;
    }

    private void content(ElementDecl elementDecl, boolean bl2, ElementValidator elementValidator) throws IOException, SAXException {
        block6: {
            while (true) {
                if (this.in.peekc('<')) {
                    if (this.maybeElement(elementValidator)) continue;
                    if (this.in.peekc('/')) {
                        return;
                    }
                    if (this.maybeComment(true) || this.maybePI(true)) continue;
                    if (this.in.peek("![CDATA[", null)) {
                        this.lexicalHandler.startCDATA();
                        this.in.unparsedContent(this.contentHandler, elementValidator, elementDecl != null && elementDecl.ignoreWhitespace, this.isStandalone && this.isValidating && !elementDecl.isFromInternalSubset ? "V-023" : null);
                        this.lexicalHandler.endCDATA();
                        continue;
                    }
                    char c2 = this.getc();
                    this.fatal("P-079", new Object[]{Integer.toHexString(c2), new Character(c2)});
                }
                if (elementDecl != null && elementDecl.ignoreWhitespace && this.in.ignorableWhitespace(this.contentHandler)) {
                    if (!this.isValidating || !this.isStandalone || elementDecl.isFromInternalSubset) continue;
                    this.error("V-011", new Object[]{elementDecl.name});
                    continue;
                }
                if (this.in.parsedContent(this.contentHandler, elementValidator)) continue;
                if (this.in.isEOF()) break block6;
                if (!this.maybeReferenceInContent(elementDecl, elementValidator)) break;
            }
            throw new InternalError();
        }
        if (!bl2) {
            this.fatal("P-035");
        }
    }

    private InputEntity peekDeclaration(String string) throws IOException, SAXException {
        if (!this.in.peekc('<')) {
            return null;
        }
        InputEntity inputEntity = this.in;
        if (this.in.peek(string, null)) {
            return inputEntity;
        }
        this.in.ungetc();
        return null;
    }

    private void getMixed(String string, InputEntity inputEntity) throws IOException, SAXException {
        this.maybeWhitespace();
        if (this.peek(")*") || this.peek(")")) {
            if (this.isValidating && this.in != inputEntity) {
                this.error("V-014", new Object[]{string});
            }
            this.strTmp.append(')');
            return;
        }
        Vector vector = null;
        if (this.isValidating) {
            vector = new Vector();
        }
        while (this.peek("|")) {
            this.strTmp.append('|');
            this.maybeWhitespace();
            String string2 = this.maybeGetName();
            if (string2 == null) {
                this.fatal("P-042", new Object[]{string, Integer.toHexString(this.getc())});
            }
            if (this.isValidating) {
                if (vector.contains(string2)) {
                    this.error("V-015", new Object[]{string2});
                } else {
                    vector.addElement(string2);
                }
            }
            this.strTmp.append(string2);
            this.maybeWhitespace();
        }
        if (!this.peek(")*")) {
            this.fatal("P-043", new Object[]{string, new Character(this.getc())});
        }
        if (this.isValidating && this.in != inputEntity) {
            this.error("V-014", new Object[]{string});
        }
        this.strTmp.append(')');
    }

    static InputEntity access$100(Parser2 parser2) {
        return parser2.in;
    }

    private void expandEntityInLiteral(String string, SimpleHashtable simpleHashtable, boolean bl2) throws SAXException, IOException {
        Object object = simpleHashtable.get(string);
        if (this.entityExpansionLimit != -1 && this.entityExpansionCount++ >= this.entityExpansionLimit) {
            this.fatal("P-086", new Object[]{new Integer(this.entityExpansionLimit)});
        }
        if (object instanceof InternalEntity) {
            InternalEntity internalEntity = (InternalEntity)object;
            if (this.isValidating && this.isStandalone && !internalEntity.isFromInternalSubset) {
                this.error("V-002", new Object[]{string});
            }
            this.pushReader(internalEntity.buf, string, !internalEntity.isPE);
        } else if (object instanceof ExternalEntity) {
            if (!bl2) {
                this.fatal("P-013", new Object[]{string});
            }
            this.pushReader((ExternalEntity)object);
        } else if (object == null) {
            this.fatal(simpleHashtable == this.params ? "V-022" : "P-014", new Object[]{string});
        }
    }

    private void fatal(String string, Object[] objectArray, Exception exception) throws SAXException {
        SAXParseException sAXParseException = new SAXParseException(messages.getMessage(this.locale, string, objectArray), this.locator, exception);
        this.errHandler.fatalError(sAXParseException);
        throw sAXParseException;
    }

    private String getQuotedString(String string, String string2) throws IOException, SAXException {
        char c2;
        char c3 = this.in.getc();
        if (c3 != '\'' && c3 != '\"') {
            this.fatal("P-015", new Object[]{messages.getMessage(this.locale, string, new Object[]{string2})});
        }
        this.strTmp = new StringBuffer();
        while ((c2 = this.in.getc()) != c3) {
            this.strTmp.append(c2);
        }
        return this.strTmp.toString();
    }

    private ContentModel getcps(String string, InputEntity inputEntity) throws IOException, SAXException {
        boolean bl2 = false;
        char c2 = '\u0000';
        ContentModel contentModel = null;
        ContentModel contentModel2 = null;
        ContentModel contentModel3 = null;
        do {
            String string2;
            if ((string2 = this.maybeGetName()) != null) {
                this.strTmp.append(string2);
                contentModel = this.getFrequency(this.newContentModel(string2));
            } else if (this.peek("(")) {
                InputEntity inputEntity2 = this.in;
                this.strTmp.append('(');
                this.maybeWhitespace();
                contentModel = this.getFrequency(this.getcps(string, inputEntity2));
            } else {
                this.fatal(c2 == '\u0000' ? "P-039" : (c2 == ',' ? "P-037" : "P-038"), new Object[]{new Character(this.getc())});
            }
            this.maybeWhitespace();
            if (bl2) {
                char c3 = this.getc();
                if (contentModel2 != null) {
                    contentModel2 = contentModel2.next = this.newContentModel(c2, contentModel);
                }
                if (c3 == c2) {
                    this.strTmp.append(c2);
                    this.maybeWhitespace();
                    continue;
                }
                if (c3 == ')') {
                    this.ungetc();
                    continue;
                }
                this.fatal(c2 == '\u0000' ? "P-041" : "P-040", new Object[]{new Character(c3), new Character(c2)});
            } else {
                c2 = this.getc();
                if (c2 != '|' && c2 != ',') {
                    contentModel3 = contentModel2 = contentModel;
                    this.ungetc();
                    continue;
                }
                bl2 = true;
                contentModel3 = contentModel2 = this.newContentModel(c2, contentModel);
                this.strTmp.append(c2);
            }
            this.maybeWhitespace();
        } while (!this.peek(")"));
        if (this.isValidating && this.in != inputEntity) {
            this.error("V-014", new Object[]{string});
        }
        this.strTmp.append(')');
        return this.getFrequency(contentModel3);
    }

    private void expandEntityInContent(ElementDecl elementDecl, String string, ElementValidator elementValidator) throws SAXException, IOException {
        Object object = this.entities.get(string);
        InputEntity inputEntity = this.in;
        if (object == null) {
            this.fatal("P-014", new Object[]{string});
        }
        if (this.entityExpansionLimit != -1 && this.entityExpansionCount++ >= this.entityExpansionLimit) {
            this.fatal("P-086", new Object[]{new Integer(this.entityExpansionLimit)});
        }
        if (object instanceof InternalEntity) {
            InternalEntity internalEntity = (InternalEntity)object;
            if (this.isValidating && this.isStandalone && !internalEntity.isFromInternalSubset) {
                this.error("V-002", new Object[]{string});
            }
            this.pushReader(internalEntity.buf, string, true);
            this.content(elementDecl, true, elementValidator);
            if (this.in != inputEntity && !this.in.isEOF()) {
                while (this.in.isInternal()) {
                    this.in = this.in.pop();
                }
                this.fatal("P-052", new Object[]{string});
            }
            this.lexicalHandler.endEntity(string);
            this.in = this.in.pop();
        } else if (object instanceof ExternalEntity) {
            ExternalEntity externalEntity = (ExternalEntity)object;
            if (externalEntity.notation != null) {
                this.fatal("P-053", new Object[]{string});
            }
            if (this.isValidating && this.isStandalone && !externalEntity.isFromInternalSubset) {
                this.error("V-002", new Object[]{string});
            }
            this.externalParsedEntity(elementDecl, externalEntity, elementValidator);
        } else {
            throw new InternalError(string);
        }
    }

    private boolean externalParsedEntity(ElementDecl elementDecl, ExternalEntity externalEntity, ElementValidator elementValidator) throws IOException, SAXException {
        if (!this.pushReader(externalEntity)) {
            if (!this.isInAttribute) {
                this.lexicalHandler.endEntity(externalEntity.name);
            }
            return false;
        }
        this.maybeTextDecl();
        this.content(elementDecl, true, elementValidator);
        if (!this.in.isEOF()) {
            this.fatal("P-058", new Object[]{externalEntity.name});
        }
        this.in = this.in.pop();
        if (!this.isInAttribute) {
            this.lexicalHandler.endEntity(externalEntity.name);
        }
        return true;
    }

    private Vector processAttributeNS(String string, String string2, String string3, String string4, boolean bl2, boolean bl3, Vector vector) throws SAXException {
        if (string.startsWith("xmlns")) {
            boolean bl4;
            boolean bl5 = bl4 = string.length() == 5;
            if (bl4 || string.charAt(5) == ':') {
                String string5 = bl4 ? "" : string.substring(6);
                if (!this.nsSupport.declarePrefix(string5, string3)) {
                    this.error("P-083", new Object[]{string5});
                }
                this.contentHandler.startPrefixMapping(string5, string3);
                if (this.prefixes) {
                    this.attTmp.addAttribute("", string5, string.intern(), string2, string3, string4, bl2);
                } else if (this.isValidating && !bl3) {
                    this.nsAttTmp.addElement(string);
                }
                this.seenNSDecl = true;
                return vector;
            }
        }
        try {
            String[] stringArray = this.processName(string, true, true);
            this.attTmp.addAttribute(stringArray[0], stringArray[1], stringArray[2], string2, string3, string4, bl2);
        }
        catch (SAXException sAXException) {
            if (vector == null) {
                vector = new Vector();
            }
            vector.addElement(sAXException);
            this.attTmp.addAttribute("", string, string, string2, string3, string4, bl2);
        }
        return vector;
    }

    static final class Catalog
    extends MessageCatalog {
        Catalog() {
            super(class$org$apache$crimson$parser$Parser2 == null ? (class$org$apache$crimson$parser$Parser2 = Parser2.class$("org.apache.crimson.parser.Parser2")) : class$org$apache$crimson$parser$Parser2);
        }
    }

    class DocLocator
    implements Locator {
        private final Parser2 this$0;

        public int getColumnNumber() {
            return Parser2.access$100(this.this$0) == null ? -1 : Parser2.access$100(this.this$0).getColumnNumber();
        }

        public int getLineNumber() {
            return Parser2.access$100(this.this$0) == null ? -1 : Parser2.access$100(this.this$0).getLineNumber();
        }

        public String getPublicId() {
            return Parser2.access$100(this.this$0) == null ? null : Parser2.access$100(this.this$0).getPublicId();
        }

        public String getSystemId() {
            return Parser2.access$100(this.this$0) == null ? null : Parser2.access$100(this.this$0).getSystemId();
        }

        DocLocator(Parser2 parser2) {
            this.this$0 = parser2;
        }
    }

    static class NameCache {
        NameCacheEntry[] hashtable = new NameCacheEntry[541];

        NameCache() {
        }

        String lookup(char[] cArray, int n2) {
            return this.lookupEntry((char[])cArray, (int)n2).name;
        }

        NameCacheEntry lookupEntry(char[] cArray, int n2) {
            int n3 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                n3 = n3 * 31 + cArray[i2];
            }
            n3 &= Integer.MAX_VALUE;
            NameCacheEntry nameCacheEntry = this.hashtable[n3 %= this.hashtable.length];
            while (nameCacheEntry != null) {
                if (nameCacheEntry.matches(cArray, n2)) {
                    return nameCacheEntry;
                }
                nameCacheEntry = nameCacheEntry.next;
            }
            nameCacheEntry = new NameCacheEntry();
            nameCacheEntry.chars = new char[n2];
            System.arraycopy(cArray, 0, nameCacheEntry.chars, 0, n2);
            nameCacheEntry.name = new String(nameCacheEntry.chars);
            nameCacheEntry.name = nameCacheEntry.name.intern();
            nameCacheEntry.next = this.hashtable[n3];
            this.hashtable[n3] = nameCacheEntry;
            return nameCacheEntry;
        }
    }

    static class NameCacheEntry {
        String name;
        char[] chars;
        NameCacheEntry next;

        NameCacheEntry() {
        }

        boolean matches(char[] cArray, int n2) {
            if (this.chars.length != n2) {
                return false;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                if (cArray[i2] == this.chars[i2]) continue;
                return false;
            }
            return true;
        }
    }

    private static class NullHandler
    extends DefaultHandler
    implements LexicalHandler,
    DeclHandler {
        private NullHandler() {
        }

        public void endCDATA() {
        }

        public void endDTD() {
        }

        public void startCDATA() {
        }

        public void comment(char[] cArray, int n2, int n3) {
        }

        public void endEntity(String string) {
        }

        public void startEntity(String string) {
        }

        NullHandler(1 var1_1) {
            this();
        }

        public void elementDecl(String string, String string2) {
        }

        public void internalEntityDecl(String string, String string2) {
        }

        public void externalEntityDecl(String string, String string2, String string3) {
        }

        public void startDTD(String string, String string2, String string3) {
        }

        public void attributeDecl(String string, String string2, String string3, String string4, String string5) {
        }
    }
}

