/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.kerberos;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.security.auth.kerberos.ServicePermission;

final class KrbServicePermissionCollection
extends PermissionCollection
implements Serializable {
    private transient List perms = new ArrayList();
    private static final long serialVersionUID = -4118834211490102011L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("permissions", class$java$util$Vector == null ? (class$java$util$Vector = KrbServicePermissionCollection.class$("java.util.Vector")) : class$java$util$Vector)};
    static Class class$java$util$Vector;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        Vector vector = (Vector)getField.get("permissions", null);
        this.perms = new ArrayList(vector.size());
        this.perms.addAll(vector);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Vector vector = new Vector(this.perms.size());
        vector.addAll(this.perms);
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("permissions", vector);
        objectOutputStream.writeFields();
    }

    public void add(Permission permission) {
        if (!(permission instanceof ServicePermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        this.perms.add(0, permission);
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof ServicePermission)) {
            return false;
        }
        ServicePermission servicePermission = (ServicePermission)permission;
        int n2 = servicePermission.getMask();
        int n3 = 0;
        int n4 = n2;
        int n5 = this.perms.size();
        for (int i2 = 0; i2 < n5; ++i2) {
            ServicePermission servicePermission2 = (ServicePermission)this.perms.get(i2);
            if ((n4 & servicePermission2.getMask()) == 0 || !servicePermission2.impliesIgnoreMask(servicePermission)) continue;
            if (((n3 |= servicePermission2.getMask()) & n2) == n2) {
                return true;
            }
            n4 = n2 ^ n3;
        }
        return false;
    }

    public Enumeration elements() {
        return Collections.enumeration(this.perms);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

