/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.UnsupportedEncodingException;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import sun.io.CharToByteConverter;

public abstract class Handler {
    private static final int offValue = Level.OFF.intValue();
    private LogManager manager = LogManager.getLogManager();
    private Filter filter;
    private Formatter formatter;
    private Level logLevel = Level.ALL;
    private ErrorManager errorManager = new ErrorManager();
    private String encoding;
    boolean sealed = true;

    protected Handler() {
    }

    void checkAccess() throws SecurityException {
        if (this.sealed) {
            this.manager.checkAccess();
        }
    }

    public abstract void close() throws SecurityException;

    public abstract void flush();

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) throws SecurityException, UnsupportedEncodingException {
        this.checkAccess();
        if (string != null) {
            CharToByteConverter.getConverter(string);
        }
        this.encoding = string;
    }

    public ErrorManager getErrorManager() {
        this.checkAccess();
        return this.errorManager;
    }

    public void setErrorManager(ErrorManager errorManager) {
        this.checkAccess();
        if (errorManager == null) {
            throw new NullPointerException();
        }
        this.errorManager = errorManager;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) throws SecurityException {
        this.checkAccess();
        this.filter = filter;
    }

    public Formatter getFormatter() {
        return this.formatter;
    }

    public void setFormatter(Formatter formatter) throws SecurityException {
        this.checkAccess();
        formatter.getClass();
        this.formatter = formatter;
    }

    public synchronized Level getLevel() {
        return this.logLevel;
    }

    public synchronized void setLevel(Level level) throws SecurityException {
        if (level == null) {
            throw new NullPointerException();
        }
        this.checkAccess();
        this.logLevel = level;
    }

    public abstract void publish(LogRecord var1);

    public boolean isLoggable(LogRecord logRecord) {
        int n2 = this.getLevel().intValue();
        if (logRecord.getLevel().intValue() < n2 || n2 == offValue) {
            return false;
        }
        Filter filter = this.getFilter();
        if (filter == null) {
            return true;
        }
        return filter.isLoggable(logRecord);
    }

    protected void reportError(String string, Exception exception, int n2) {
        try {
            this.errorManager.error(string, exception, n2);
        }
        catch (Exception exception2) {
            System.err.println("Handler.reportError caught:");
            exception2.printStackTrace();
        }
    }
}

