/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Map;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.PKIXExtensions;

public class OIDMap {
    private static final String ROOT = "x509.info.extensions";
    private static final String AUTH_KEY_IDENTIFIER = "x509.info.extensions.AuthorityKeyIdentifier";
    private static final String SUB_KEY_IDENTIFIER = "x509.info.extensions.SubjectKeyIdentifier";
    private static final String KEY_USAGE = "x509.info.extensions.KeyUsage";
    private static final String PRIVATE_KEY_USAGE = "x509.info.extensions.PrivateKeyUsage";
    private static final String POLICY_MAPPINGS = "x509.info.extensions.PolicyMappings";
    private static final String SUB_ALT_NAME = "x509.info.extensions.SubjectAlternativeName";
    private static final String ISSUER_ALT_NAME = "x509.info.extensions.IssuerAlternativeName";
    private static final String BASIC_CONSTRAINTS = "x509.info.extensions.BasicConstraints";
    private static final String NAME_CONSTRAINTS = "x509.info.extensions.NameConstraints";
    private static final String POLICY_CONSTRAINTS = "x509.info.extensions.PolicyConstraints";
    private static final String CRL_NUMBER = "x509.info.extensions.CRLNumber";
    private static final String CRL_REASON = "x509.info.extensions.CRLReasonCode";
    private static final String NETSCAPE_CERT = "x509.info.extensions.NetscapeCertType";
    private static final String CERT_POLICIES = "x509.info.extensions.CertificatePolicies";
    private static final String EXT_KEY_USAGE = "x509.info.extensions.ExtendedKeyUsage";
    private static final String INHIBIT_ANY_POLICY = "x509.info.extensions.InhibitAnyPolicy";
    private static final String CRL_DIST_POINTS = "x509.info.extensions.CRLDistributionPoints";
    private static final int[] NetscapeCertType_data = new int[]{2, 16, 840, 1, 113730, 1, 1};
    private static final Map oidMap = new HashMap();
    private static final Map nameMap = new HashMap();

    static {
        OIDMap.addInternal(SUB_KEY_IDENTIFIER, PKIXExtensions.SubjectKey_Id, "sun.security.x509.SubjectKeyIdentifierExtension");
        OIDMap.addInternal(KEY_USAGE, PKIXExtensions.KeyUsage_Id, "sun.security.x509.KeyUsageExtension");
        OIDMap.addInternal(PRIVATE_KEY_USAGE, PKIXExtensions.PrivateKeyUsage_Id, "sun.security.x509.PrivateKeyUsageExtension");
        OIDMap.addInternal(SUB_ALT_NAME, PKIXExtensions.SubjectAlternativeName_Id, "sun.security.x509.SubjectAlternativeNameExtension");
        OIDMap.addInternal(ISSUER_ALT_NAME, PKIXExtensions.IssuerAlternativeName_Id, "sun.security.x509.IssuerAlternativeNameExtension");
        OIDMap.addInternal(BASIC_CONSTRAINTS, PKIXExtensions.BasicConstraints_Id, "sun.security.x509.BasicConstraintsExtension");
        OIDMap.addInternal(CRL_NUMBER, PKIXExtensions.CRLNumber_Id, "sun.security.x509.CRLNumberExtension");
        OIDMap.addInternal(CRL_REASON, PKIXExtensions.ReasonCode_Id, "sun.security.x509.CRLReasonCodeExtension");
        OIDMap.addInternal(NAME_CONSTRAINTS, PKIXExtensions.NameConstraints_Id, "sun.security.x509.NameConstraintsExtension");
        OIDMap.addInternal(POLICY_MAPPINGS, PKIXExtensions.PolicyMappings_Id, "sun.security.x509.PolicyMappingsExtension");
        OIDMap.addInternal(AUTH_KEY_IDENTIFIER, PKIXExtensions.AuthorityKey_Id, "sun.security.x509.AuthorityKeyIdentifierExtension");
        OIDMap.addInternal(POLICY_CONSTRAINTS, PKIXExtensions.PolicyConstraints_Id, "sun.security.x509.PolicyConstraintsExtension");
        OIDMap.addInternal(NETSCAPE_CERT, ObjectIdentifier.newInternal(NetscapeCertType_data), "sun.security.x509.NetscapeCertTypeExtension");
        OIDMap.addInternal(CERT_POLICIES, PKIXExtensions.CertificatePolicies_Id, "sun.security.x509.CertificatePoliciesExtension");
        OIDMap.addInternal(EXT_KEY_USAGE, PKIXExtensions.ExtendedKeyUsage_Id, "sun.security.x509.ExtendedKeyUsageExtension");
        OIDMap.addInternal(INHIBIT_ANY_POLICY, PKIXExtensions.InhibitAnyPolicy_Id, "sun.security.x509.InhibitAnyPolicyExtension");
        OIDMap.addInternal(CRL_DIST_POINTS, PKIXExtensions.CRLDistributionPoints_Id, "sun.security.x509.CRLDistributionPointsExtension");
    }

    private OIDMap() {
    }

    public static Class getClass(String string) throws CertificateException {
        OIDInfo oIDInfo = (OIDInfo)nameMap.get(string);
        return oIDInfo == null ? null : oIDInfo.getClazz();
    }

    public static Class getClass(ObjectIdentifier objectIdentifier) throws CertificateException {
        OIDInfo oIDInfo = (OIDInfo)oidMap.get(objectIdentifier);
        return oIDInfo == null ? null : oIDInfo.getClazz();
    }

    public static String getName(ObjectIdentifier objectIdentifier) {
        OIDInfo oIDInfo = (OIDInfo)oidMap.get(objectIdentifier);
        return oIDInfo == null ? null : oIDInfo.name;
    }

    public static ObjectIdentifier getOID(String string) {
        OIDInfo oIDInfo = (OIDInfo)nameMap.get(string);
        return oIDInfo == null ? null : oIDInfo.oid;
    }

    public static void addAttribute(String string, String string2, Class clazz) throws CertificateException {
        ObjectIdentifier objectIdentifier;
        try {
            objectIdentifier = new ObjectIdentifier(string2);
        }
        catch (IOException iOException) {
            throw new CertificateException("Invalid Object identifier: " + string2);
        }
        OIDInfo oIDInfo = new OIDInfo(string, objectIdentifier, clazz);
        if (oidMap.put(objectIdentifier, oIDInfo) != null) {
            throw new CertificateException("Object identifier already exists: " + string2);
        }
        if (nameMap.put(string, oIDInfo) != null) {
            throw new CertificateException("Name already exists: " + string);
        }
    }

    private static void addInternal(String string, ObjectIdentifier objectIdentifier, String string2) {
        OIDInfo oIDInfo = new OIDInfo(string, objectIdentifier, string2);
        oidMap.put(objectIdentifier, oIDInfo);
        nameMap.put(string, oIDInfo);
    }

    private static class OIDInfo {
        final ObjectIdentifier oid;
        final String name;
        final String className;
        private volatile Class clazz;

        Class getClazz() throws CertificateException {
            try {
                Class clazz = this.clazz;
                if (clazz == null) {
                    this.clazz = clazz = Class.forName(this.className);
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (CertificateException)new CertificateException("Could not load class: " + classNotFoundException).initCause(classNotFoundException);
            }
        }

        OIDInfo(String string, ObjectIdentifier objectIdentifier, Class clazz) {
            this.name = string;
            this.oid = objectIdentifier;
            this.className = clazz.getName();
            this.clazz = clazz;
        }

        OIDInfo(String string, ObjectIdentifier objectIdentifier, String string2) {
            this.name = string;
            this.oid = objectIdentifier;
            this.className = string2;
        }
    }
}

