/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import com.sun.security.auth.PrincipalComparator;
import java.awt.AWTPermission;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.NetPermission;
import java.net.SocketPermission;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Identity;
import java.security.IdentityScope;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.Security;
import java.security.UnresolvedPermission;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.PropertyPermission;
import java.util.Set;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import sun.net.www.ParseUtil;
import sun.security.provider.IdentityDatabase;
import sun.security.provider.PolicyInfo;
import sun.security.provider.PolicyParser;
import sun.security.provider.SelfPermission;
import sun.security.provider.SystemIdentity;
import sun.security.provider.SystemSigner;
import sun.security.util.Debug;
import sun.security.util.PropertyExpander;
import sun.security.util.ResourcesMgr;
import sun.security.util.SecurityConstants;

public class PolicyFile
extends Policy {
    private static final Debug debug = Debug.getInstance("policy");
    private static final String SELF = "${{self}}";
    private static final String X500PRINCIPAL = "javax.security.auth.x500.X500Principal";
    private static final String POLICY = "java.security.policy";
    private static final String SECURITY_MANAGER = "java.security.manager";
    private static final String POLICY_URL = "policy.url.";
    private static final String AUTH_POLICY = "java.security.auth.policy";
    private static final String AUTH_POLICY_URL = "auth.policy.url.";
    private static final int DEFAULT_CACHE_SIZE = 1;
    private static IdentityScope scope = null;
    private PolicyInfo policyInfo;
    private boolean constructed = false;
    private boolean expandProperties = true;
    private boolean ignoreIdentityScope = false;
    private boolean allowSystemProperties = true;
    private boolean notUtf8 = false;
    private static final Class[] PARAMS0 = new Class[0];
    private static final Class[] PARAMS1 = new Class[]{class$java$lang$String == null ? (class$java$lang$String = PolicyFile.class$("java.lang.String")) : class$java$lang$String};
    private static final Class[] PARAMS2 = new Class[]{class$java$lang$String == null ? (class$java$lang$String = PolicyFile.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = PolicyFile.class$("java.lang.String")) : class$java$lang$String};
    static Class class$java$lang$String;
    static Class class$java$io$FilePermission;
    static Class class$java$net$SocketPermission;
    static Class class$java$lang$RuntimePermission;
    static Class class$java$util$PropertyPermission;
    static Class class$java$net$NetPermission;
    static Class class$java$security$AllPermission;
    static Class class$java$awt$AWTPermission;
    static Class class$sun$security$provider$PolicyFile;

    public PolicyFile() {
        this.init();
    }

    private void init() {
        int n2;
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(this){
            private final PolicyFile this$0;

            public Object run() {
                PolicyFile.access$002(this.this$0, "true".equalsIgnoreCase(Security.getProperty("policy.expandProperties")));
                PolicyFile.access$102(this.this$0, "true".equalsIgnoreCase(Security.getProperty("policy.ignoreIdentityScope")));
                PolicyFile.access$202(this.this$0, "true".equalsIgnoreCase(Security.getProperty("policy.allowSystemProperty")));
                PolicyFile.access$302(this.this$0, "false".equalsIgnoreCase(System.getProperty("sun.security.policy.utf8")));
                return System.getProperty("sun.security.policy.numcaches");
            }
            {
                this.this$0 = policyFile;
            }
        });
        if (string != null) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 1;
            }
        } else {
            n2 = 1;
        }
        PolicyInfo policyInfo = new PolicyInfo(n2);
        this.initPolicyFile(policyInfo);
        this.policyInfo = policyInfo;
    }

    public void refresh() {
        this.init();
    }

    private static boolean isTrusted(Identity identity) {
        SystemSigner systemSigner;
        SystemIdentity systemIdentity;
        return identity instanceof SystemIdentity ? (systemIdentity = (SystemIdentity)identity).isTrusted() : identity instanceof SystemSigner && (systemSigner = (SystemSigner)identity).isTrusted();
    }

    static IdentityScope access$700() {
        return scope;
    }

    static boolean access$200(PolicyFile policyFile) {
        return policyFile.allowSystemProperties;
    }

    static boolean access$002(PolicyFile policyFile, boolean bl2) {
        policyFile.expandProperties = bl2;
        return policyFile.expandProperties;
    }

    static boolean access$102(PolicyFile policyFile, boolean bl2) {
        policyFile.ignoreIdentityScope = bl2;
        return policyFile.ignoreIdentityScope;
    }

    static boolean access$202(PolicyFile policyFile, boolean bl2) {
        policyFile.allowSystemProperties = bl2;
        return policyFile.allowSystemProperties;
    }

    static boolean access$302(PolicyFile policyFile, boolean bl2) {
        policyFile.notUtf8 = bl2;
        return policyFile.notUtf8;
    }

    private void initPolicyFile(PolicyInfo policyInfo) {
        boolean bl2 = this.initPolicyFile(POLICY, POLICY_URL, policyInfo);
        if (!bl2) {
            this.initStaticPolicy(policyInfo);
        }
        this.initPolicyFile(AUTH_POLICY, AUTH_POLICY_URL, policyInfo);
    }

    private void initStaticPolicy(PolicyInfo policyInfo) {
        AccessController.doPrivileged(new PrivilegedAction(this, policyInfo){
            private final PolicyInfo val$newInfo;
            private final PolicyFile this$0;

            public Object run() {
                PolicyEntry policyEntry = new PolicyEntry(new CodeSource(null, null));
                policyEntry.add(SecurityConstants.LOCAL_LISTEN_PERMISSION);
                policyEntry.add(new PropertyPermission("java.version", "read"));
                policyEntry.add(new PropertyPermission("java.vendor", "read"));
                policyEntry.add(new PropertyPermission("java.vendor.url", "read"));
                policyEntry.add(new PropertyPermission("java.class.version", "read"));
                policyEntry.add(new PropertyPermission("os.name", "read"));
                policyEntry.add(new PropertyPermission("os.version", "read"));
                policyEntry.add(new PropertyPermission("os.arch", "read"));
                policyEntry.add(new PropertyPermission("file.separator", "read"));
                policyEntry.add(new PropertyPermission("path.separator", "read"));
                policyEntry.add(new PropertyPermission("line.separator", "read"));
                policyEntry.add(new PropertyPermission("java.specification.version", "read"));
                policyEntry.add(new PropertyPermission("java.specification.vendor", "read"));
                policyEntry.add(new PropertyPermission("java.specification.name", "read"));
                policyEntry.add(new PropertyPermission("java.vm.specification.version", "read"));
                policyEntry.add(new PropertyPermission("java.vm.specification.vendor", "read"));
                policyEntry.add(new PropertyPermission("java.vm.specification.name", "read"));
                policyEntry.add(new PropertyPermission("java.vm.version", "read"));
                policyEntry.add(new PropertyPermission("java.vm.vendor", "read"));
                policyEntry.add(new PropertyPermission("java.vm.name", "read"));
                this.val$newInfo.policyEntries.add(policyEntry);
                try {
                    File file = new File(PropertyExpander.expand("${java.home}/lib/ext/*"));
                    policyEntry = new PolicyEntry(new CodeSource(ParseUtil.fileToEncodedURL(file), null));
                    policyEntry.add(SecurityConstants.ALL_PERMISSION);
                    this.val$newInfo.policyEntries.add(policyEntry);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
            {
                this.this$0 = policyFile;
                this.val$newInfo = policyInfo;
            }
        });
    }

    static Debug access$400() {
        return debug;
    }

    private InputStream getInputStream(URL uRL) throws IOException {
        if ("file".equals(uRL.getProtocol())) {
            String string = uRL.getFile().replace('/', File.separatorChar);
            string = ParseUtil.decode(string);
            return new FileInputStream(string);
        }
        return uRL.openStream();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private String printPD(ProtectionDomain protectionDomain) {
        Principal[] principalArray = protectionDomain.getPrincipals();
        String string = "<no principals>";
        if (principalArray != null && principalArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer("(principals ");
            for (int i2 = 0; i2 < principalArray.length; ++i2) {
                stringBuffer.append(principalArray[i2].getClass().getName() + " \"" + principalArray[i2].getName() + "\"");
                if (i2 < principalArray.length - 1) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append(")");
            }
            string = stringBuffer.toString();
        }
        return "PD CodeSource: " + protectionDomain.getCodeSource() + "\n\t" + "PD ClassLoader: " + protectionDomain.getClassLoader() + "\n\t" + "PD Principals: " + string;
    }

    private CodeSource canonicalizeCodebase(CodeSource codeSource, boolean bl2) {
        CodeSource codeSource2;
        block17: {
            Serializable serializable;
            String string = null;
            codeSource2 = codeSource;
            URL uRL = codeSource.getLocation();
            if (uRL != null) {
                try {
                    serializable = uRL.openConnection().getPermission();
                }
                catch (IOException iOException) {
                    serializable = null;
                }
                if (serializable instanceof FilePermission) {
                    string = serializable.getName();
                } else if (serializable == null && uRL.getProtocol().equals("file")) {
                    string = uRL.getFile().replace('/', File.separatorChar);
                    string = ParseUtil.decode(string);
                }
            }
            if (string != null) {
                try {
                    serializable = null;
                    if (string.endsWith("*")) {
                        string = string.substring(0, string.length() - 1);
                        boolean bl3 = false;
                        if (string.endsWith(File.separator)) {
                            bl3 = true;
                        }
                        if (string.equals("")) {
                            string = System.getProperty("user.dir");
                        }
                        File file = new File(string);
                        string = file.getCanonicalPath();
                        StringBuffer stringBuffer = new StringBuffer(string);
                        if (!string.endsWith(File.separator) && (bl3 || file.isDirectory())) {
                            stringBuffer.append(File.separatorChar);
                        }
                        stringBuffer.append('*');
                        string = stringBuffer.toString();
                    } else {
                        string = new File(string).getCanonicalPath();
                    }
                    serializable = ParseUtil.fileToEncodedURL(new File(string));
                    if (bl2) {
                        codeSource2 = new CodeSource((URL)serializable, this.getSignerCertificates(codeSource));
                        break block17;
                    }
                    codeSource2 = new CodeSource((URL)serializable, codeSource.getCertificates());
                }
                catch (IOException iOException) {
                    if (bl2) {
                        codeSource2 = new CodeSource(codeSource.getLocation(), this.getSignerCertificates(codeSource));
                    }
                    break block17;
                }
            }
            if (bl2) {
                codeSource2 = new CodeSource(codeSource.getLocation(), this.getSignerCertificates(codeSource));
            }
        }
        return codeSource2;
    }

    private boolean replacePrincipals(List list, KeyStore keyStore) {
        if (list == null || list.size() == 0 || keyStore == null) {
            return true;
        }
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            PolicyParser.PrincipalEntry principalEntry = (PolicyParser.PrincipalEntry)listIterator.next();
            if (!principalEntry.principalClass.equals("PolicyParser.REPLACE_NAME")) continue;
            String string = this.getDN(principalEntry.principalName, keyStore);
            if (string == null) {
                return false;
            }
            if (debug != null) {
                debug.println("  Replacing \"" + principalEntry.principalName + "\" with " + X500PRINCIPAL + "/\"" + string + "\"");
            }
            principalEntry.principalClass = X500PRINCIPAL;
            principalEntry.principalName = string;
        }
        return true;
    }

    private void expandPermissionName(PolicyParser.PermissionEntry permissionEntry, KeyStore keyStore) throws Exception {
        int n2;
        int n3;
        if (permissionEntry.name == null || permissionEntry.name.indexOf("${{", 0) == -1) {
            return;
        }
        int n4 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n3 = permissionEntry.name.indexOf("${{", n4)) != -1 && (n2 = permissionEntry.name.indexOf("}}", n3)) >= 1) {
            String string;
            stringBuffer.append(permissionEntry.name.substring(n4, n3));
            String string2 = string = permissionEntry.name.substring(n3 + 3, n2);
            int n5 = string.indexOf(":");
            if (n5 != -1) {
                string2 = string.substring(0, n5);
            }
            if (string2.equalsIgnoreCase("self")) {
                stringBuffer.append(permissionEntry.name.substring(n3, n2 + 2));
                n4 = n2 + 2;
                continue;
            }
            if (string2.equalsIgnoreCase("alias")) {
                if (n5 == -1) {
                    MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("alias name not provided (pe.name)"));
                    Object[] objectArray = new Object[]{permissionEntry.name};
                    throw new Exception(messageFormat.format(objectArray));
                }
                String string3 = string.substring(n5 + 1);
                if ((string3 = this.getDN(string3, keyStore)) == null) {
                    MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("unable to perform substitution on alias, suffix"));
                    Object[] objectArray = new Object[]{string.substring(n5 + 1)};
                    throw new Exception(messageFormat.format(objectArray));
                }
                stringBuffer.append("javax.security.auth.x500.X500Principal \"" + string3 + "\"");
                n4 = n2 + 2;
                continue;
            }
            MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("substitution value, prefix, unsupported"));
            Object[] objectArray = new Object[]{string2};
            throw new Exception(messageFormat.format(objectArray));
        }
        stringBuffer.append(permissionEntry.name.substring(n4));
        if (debug != null) {
            debug.println("  Permission name expanded from:\n\t" + permissionEntry.name + "\nto\n\t" + stringBuffer.toString());
        }
        permissionEntry.name = stringBuffer.toString();
    }

    public boolean implies(ProtectionDomain protectionDomain, Permission permission) {
        Map map = this.policyInfo.getPdMapping();
        PermissionCollection permissionCollection = (PermissionCollection)map.get(protectionDomain);
        if (permissionCollection != null) {
            return permissionCollection.implies(permission);
        }
        permissionCollection = this.getPermissions(protectionDomain);
        if (permissionCollection == null) {
            return false;
        }
        map.put(protectionDomain, permissionCollection);
        return permissionCollection.implies(permission);
    }

    public PermissionCollection getPermissions(CodeSource codeSource) {
        return this.getPermissions(new Permissions(), codeSource);
    }

    public PermissionCollection getPermissions(ProtectionDomain protectionDomain) {
        Permissions permissions = new Permissions();
        if (protectionDomain == null) {
            return permissions;
        }
        this.getPermissions(permissions, protectionDomain);
        PermissionCollection permissionCollection = protectionDomain.getPermissions();
        if (permissionCollection != null) {
            Enumeration enumeration = permissionCollection.elements();
            while (enumeration.hasMoreElements()) {
                permissions.add((Permission)enumeration.nextElement());
            }
        }
        return permissions;
    }

    protected Certificate[] getSignerCertificates(CodeSource codeSource) {
        int n2;
        Certificate[] certificateArray = null;
        certificateArray = codeSource.getCertificates();
        if (certificateArray == null) {
            return null;
        }
        for (n2 = 0; n2 < certificateArray.length; ++n2) {
            if (certificateArray[n2] instanceof X509Certificate) continue;
            return codeSource.getCertificates();
        }
        int n3 = 0;
        for (n2 = 0; n2 < certificateArray.length; ++n2) {
            ++n3;
            while (n2 + 1 < certificateArray.length && ((Object)((X509Certificate)certificateArray[n2]).getIssuerDN()).equals(((X509Certificate)certificateArray[n2 + 1]).getSubjectDN())) {
                ++n2;
            }
        }
        if (n3 == certificateArray.length) {
            return certificateArray;
        }
        ArrayList arrayList = new ArrayList();
        for (n2 = 0; n2 < certificateArray.length; ++n2) {
            arrayList.add(certificateArray[n2]);
            while (n2 + 1 < certificateArray.length && ((Object)((X509Certificate)certificateArray[n2]).getIssuerDN()).equals(((X509Certificate)certificateArray[n2 + 1]).getSubjectDN())) {
                ++n2;
            }
        }
        Object[] objectArray = new Certificate[arrayList.size()];
        arrayList.toArray(objectArray);
        return objectArray;
    }

    private boolean init(URL uRL, PolicyInfo policyInfo) {
        boolean bl2;
        block5: {
            bl2 = false;
            PolicyParser policyParser = new PolicyParser(this.expandProperties);
            try {
                InputStreamReader inputStreamReader = this.notUtf8 ? new InputStreamReader(this.getInputStream(uRL)) : new InputStreamReader(this.getInputStream(uRL), "UTF-8");
                policyParser.read(inputStreamReader);
                inputStreamReader.close();
                KeyStore keyStore = this.initKeyStore(uRL, policyParser.getKeyStoreUrl(), policyParser.getKeyStoreType());
                Enumeration enumeration = policyParser.grantElements();
                while (enumeration.hasMoreElements()) {
                    PolicyParser.GrantEntry grantEntry = (PolicyParser.GrantEntry)enumeration.nextElement();
                    this.addGrantEntry(grantEntry, keyStore, policyInfo);
                }
                bl2 = true;
            }
            catch (PolicyParser.ParsingException parsingException) {
                MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("java.security.policy: error parsing policy:\n\tmessage"));
                Object[] objectArray = new Object[]{uRL, parsingException.getLocalizedMessage()};
                System.err.println(messageFormat.format(objectArray));
                if (debug != null) {
                    parsingException.printStackTrace();
                }
            }
            catch (Exception exception) {
                if (debug == null) break block5;
                debug.println("error parsing " + uRL);
                debug.println(exception.toString());
                exception.printStackTrace();
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkForTrustedIdentity(Certificate certificate, PolicyInfo policyInfo) {
        Certificate[] certificateArray;
        if (certificate == null) {
            return false;
        }
        if (this.ignoreIdentityScope) {
            return false;
        }
        Serializable serializable = class$sun$security$provider$PolicyFile == null ? (class$sun$security$provider$PolicyFile = PolicyFile.class$("sun.security.provider.PolicyFile")) : class$sun$security$provider$PolicyFile;
        synchronized (serializable) {
            if (scope == null && (certificateArray = (Certificate[])AccessController.doPrivileged(new PrivilegedAction(this){
                private final PolicyFile this$0;

                public Object run() {
                    return IdentityScope.getSystemScope();
                }
                {
                    this.this$0 = policyFile;
                }
            })) instanceof IdentityDatabase) {
                scope = certificateArray;
            }
        }
        if (scope == null) {
            this.ignoreIdentityScope = true;
            return false;
        }
        serializable = (Identity)AccessController.doPrivileged(new PrivilegedAction(this, certificate){
            private final Certificate val$cert;
            private final PolicyFile this$0;

            public Object run() {
                return PolicyFile.access$700().getIdentity(this.val$cert.getPublicKey());
            }
            {
                this.this$0 = policyFile;
                this.val$cert = certificate;
            }
        });
        if (PolicyFile.isTrusted((Identity)serializable)) {
            if (debug != null) {
                debug.println("Adding policy entry for trusted Identity: ");
                AccessController.doPrivileged(new PrivilegedAction(this, (Identity)serializable){
                    private final Identity val$id;
                    private final PolicyFile this$0;

                    public Object run() {
                        PolicyFile.access$400().println("  identity = " + this.val$id);
                        return null;
                    }
                    {
                        this.this$0 = policyFile;
                        this.val$id = identity;
                    }
                });
                debug.println("");
            }
            certificateArray = new Certificate[]{certificate};
            PolicyEntry policyEntry = new PolicyEntry(new CodeSource(null, certificateArray));
            policyEntry.add(SecurityConstants.ALL_PERMISSION);
            Object object = policyInfo.identityPolicyEntries;
            synchronized (object) {
                policyInfo.identityPolicyEntries.add(policyEntry);
            }
            object = policyInfo.aliasMapping;
            synchronized (object) {
                policyInfo.aliasMapping.put(certificate, ((Identity)serializable).getName());
            }
            return true;
        }
        return false;
    }

    private boolean subjectListImpliesPrincipalEntry(List list, PolicyParser.PrincipalEntry principalEntry) {
        ListIterator listIterator = list.listIterator(0);
        while (listIterator.hasNext()) {
            PolicyParser.PrincipalEntry principalEntry2 = (PolicyParser.PrincipalEntry)listIterator.next();
            if (!principalEntry.principalClass.equals("WILDCARD_PRINCIPAL_CLASS") && !principalEntry.principalClass.equals(principalEntry2.principalClass) || !principalEntry.principalName.equals("WILDCARD_PRINCIPAL_NAME") && !principalEntry.principalName.equals(principalEntry2.principalName)) continue;
            return true;
        }
        return false;
    }

    private String getDN(String string, KeyStore keyStore) {
        Certificate certificate = null;
        try {
            certificate = keyStore.getCertificate(string);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.println("  Error retrieving certificate for '" + string + "': " + exception.toString());
            }
            return null;
        }
        if (certificate == null || !(certificate instanceof X509Certificate)) {
            if (debug != null) {
                debug.println("  -- No certificate for '" + string + "' - ignoring entry");
            }
            return null;
        }
        X509Certificate x509Certificate = (X509Certificate)certificate;
        X500Principal x500Principal = new X500Principal(x509Certificate.getSubjectX500Principal().toString());
        return x500Principal.getName();
    }

    private String[][] getPrincipalInfo(PolicyParser.PrincipalEntry principalEntry, Principal[] principalArray) {
        if (!principalEntry.principalClass.equals("WILDCARD_PRINCIPAL_CLASS") && !principalEntry.principalName.equals("WILDCARD_PRINCIPAL_NAME")) {
            String[][] stringArray = new String[1][2];
            stringArray[0][0] = principalEntry.principalClass;
            stringArray[0][1] = principalEntry.principalName;
            return stringArray;
        }
        if (!principalEntry.principalClass.equals("WILDCARD_PRINCIPAL_CLASS") && principalEntry.principalName.equals("WILDCARD_PRINCIPAL_NAME")) {
            LinkedList linkedList = new LinkedList();
            for (int i2 = 0; i2 < principalArray.length; ++i2) {
                if (!principalEntry.principalClass.equals(principalArray[i2].getClass().getName())) continue;
                linkedList.add(principalArray[i2]);
            }
            String[][] stringArray = new String[linkedList.size()][2];
            int n2 = 0;
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                Principal principal = (Principal)iterator.next();
                stringArray[n2][0] = principal.getClass().getName();
                stringArray[n2][1] = principal.getName();
                ++n2;
            }
            return stringArray;
        }
        String[][] stringArray = new String[principalArray.length][2];
        for (int i3 = 0; i3 < principalArray.length; ++i3) {
            stringArray[i3][0] = principalArray[i3].getClass().getName();
            stringArray[i3][1] = principalArray[i3].getName();
        }
        return stringArray;
    }

    static CodeSource access$600(PolicyFile policyFile, CodeSource codeSource, boolean bl2) {
        return policyFile.canonicalizeCodebase(codeSource, bl2);
    }

    private PermissionCollection getPermissions(Permissions permissions, CodeSource codeSource) {
        CodeSource codeSource2 = (CodeSource)AccessController.doPrivileged(new PrivilegedAction(this, codeSource){
            private final CodeSource val$cs;
            private final PolicyFile this$0;

            public Object run() {
                return PolicyFile.access$600(this.this$0, this.val$cs, true);
            }
            {
                this.this$0 = policyFile;
                this.val$cs = codeSource;
            }
        });
        return this.getPermissions(permissions, codeSource2, null);
    }

    private PermissionCollection getPermissions(Permissions permissions, ProtectionDomain protectionDomain) {
        CodeSource codeSource;
        if (debug != null) {
            debug.println("getPermissions:\n\t" + this.printPD(protectionDomain));
        }
        if ((codeSource = protectionDomain.getCodeSource()) == null) {
            return permissions;
        }
        CodeSource codeSource2 = (CodeSource)AccessController.doPrivileged(new PrivilegedAction(this, codeSource){
            private final CodeSource val$cs;
            private final PolicyFile this$0;

            public Object run() {
                return PolicyFile.access$600(this.this$0, this.val$cs, true);
            }
            {
                this.this$0 = policyFile;
                this.val$cs = codeSource;
            }
        });
        return this.getPermissions(permissions, codeSource2, protectionDomain.getPrincipals());
    }

    private boolean initPolicyFile(String string, String string2, PolicyInfo policyInfo) {
        Boolean bl2 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(this, string, policyInfo, string2){
            private final String val$propname;
            private final PolicyInfo val$newInfo;
            private final String val$urlname;
            private final PolicyFile this$0;

            public Object run() {
                String string;
                URL uRL;
                Object object;
                String string2;
                boolean bl2 = false;
                if (PolicyFile.access$200(this.this$0) && (string2 = System.getProperty(this.val$propname)) != null) {
                    boolean bl3;
                    block13: {
                        bl3 = false;
                        if (string2.startsWith("=")) {
                            bl3 = true;
                            string2 = string2.substring(1);
                        }
                        try {
                            string2 = PropertyExpander.expand(string2);
                            object = new File(string2);
                            uRL = ((File)object).exists() ? ParseUtil.fileToEncodedURL(new File(((File)object).getCanonicalPath())) : new URL(string2);
                            if (PolicyFile.access$400() != null) {
                                PolicyFile.access$400().println("reading " + uRL);
                            }
                            if (PolicyFile.access$500(this.this$0, uRL, this.val$newInfo)) {
                                bl2 = true;
                            }
                        }
                        catch (Exception exception) {
                            if (PolicyFile.access$400() == null) break block13;
                            PolicyFile.access$400().println("caught exception: " + exception);
                        }
                    }
                    if (bl3) {
                        if (PolicyFile.access$400() != null) {
                            PolicyFile.access$400().println("overriding other policies!");
                        }
                        return bl2;
                    }
                }
                int n2 = 1;
                while ((string = Security.getProperty(this.val$urlname + n2)) != null) {
                    block14: {
                        try {
                            uRL = null;
                            object = PropertyExpander.expand(string).replace(File.separatorChar, '/');
                            uRL = string.startsWith("file:${java.home}/") || string.startsWith("file:${user.home}/") ? new File(((String)object).substring(5)).toURI().toURL() : new URI((String)object).toURL();
                            if (PolicyFile.access$400() != null) {
                                PolicyFile.access$400().println("reading " + uRL);
                            }
                            if (PolicyFile.access$500(this.this$0, uRL, this.val$newInfo)) {
                                bl2 = true;
                            }
                        }
                        catch (Exception exception) {
                            if (PolicyFile.access$400() == null) break block14;
                            PolicyFile.access$400().println("error reading policy " + exception);
                            exception.printStackTrace();
                        }
                    }
                    ++n2;
                }
                return bl2;
            }
            {
                this.this$0 = policyFile;
                this.val$propname = string;
                this.val$newInfo = policyInfo;
                this.val$urlname = string2;
            }
        });
        return bl2;
    }

    static boolean access$500(PolicyFile policyFile, URL uRL, PolicyInfo policyInfo) {
        return policyFile.init(uRL, policyInfo);
    }

    private void addGrantEntry(PolicyParser.GrantEntry grantEntry, KeyStore keyStore, PolicyInfo policyInfo) {
        Object object;
        Object object2;
        if (debug != null) {
            debug.println("Adding policy entry: ");
            debug.println("  signedBy " + grantEntry.signedBy);
            debug.println("  codeBase " + grantEntry.codeBase);
            if (grantEntry.principals != null && grantEntry.principals.size() > 0) {
                object2 = grantEntry.principals.listIterator();
                while (object2.hasNext()) {
                    object = (PolicyParser.PrincipalEntry)object2.next();
                    debug.println("  " + ((PolicyParser.PrincipalEntry)object).toString());
                }
            }
        }
        try {
            object2 = this.getCodeSource(grantEntry, keyStore, policyInfo);
            if (object2 == null) {
                return;
            }
            if (!this.replacePrincipals(grantEntry.principals, keyStore)) {
                return;
            }
            object = new PolicyEntry((CodeSource)object2, grantEntry.principals);
            Enumeration enumeration = grantEntry.permissionElements();
            while (enumeration.hasMoreElements()) {
                Object[] objectArray;
                Object object3;
                PolicyParser.PermissionEntry permissionEntry = (PolicyParser.PermissionEntry)enumeration.nextElement();
                try {
                    Permission permission;
                    this.expandPermissionName(permissionEntry, keyStore);
                    if (permissionEntry.permission.equals("javax.security.auth.PrivateCredentialPermission") && permissionEntry.name.endsWith(" self")) {
                        permissionEntry.name = permissionEntry.name.substring(0, permissionEntry.name.indexOf("self")) + SELF;
                    }
                    if (permissionEntry.name != null && permissionEntry.name.indexOf(SELF) != -1) {
                        object3 = permissionEntry.signedBy != null ? this.getCertificates(keyStore, permissionEntry.signedBy, policyInfo) : null;
                        permission = new SelfPermission(permissionEntry.permission, permissionEntry.name, permissionEntry.action, (Certificate[])object3);
                    } else {
                        permission = PolicyFile.getInstance(permissionEntry.permission, permissionEntry.name, permissionEntry.action);
                    }
                    ((PolicyEntry)object).add(permission);
                    if (debug == null) continue;
                    debug.println("  " + permission);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    object3 = permissionEntry.signedBy != null ? this.getCertificates(keyStore, permissionEntry.signedBy, policyInfo) : null;
                    if (object3 == null && permissionEntry.signedBy != null) continue;
                    objectArray = new UnresolvedPermission(permissionEntry.permission, permissionEntry.name, permissionEntry.action, (Certificate[])object3);
                    ((PolicyEntry)object).add((Permission)objectArray);
                    if (debug == null) continue;
                    debug.println("  " + objectArray);
                }
                catch (InvocationTargetException invocationTargetException) {
                    object3 = new MessageFormat(ResourcesMgr.getString("java.security.policy: error adding Permission, perm:\n\tmessage"));
                    objectArray = new Object[]{permissionEntry.permission, invocationTargetException.getTargetException().toString()};
                    System.err.println(object3.format(objectArray));
                }
                catch (Exception exception) {
                    object3 = new MessageFormat(ResourcesMgr.getString("java.security.policy: error adding Permission, perm:\n\tmessage"));
                    objectArray = new Object[]{permissionEntry.permission, exception.toString()};
                    System.err.println(object3.format(objectArray));
                }
            }
            policyInfo.policyEntries.add(object);
        }
        catch (Exception exception) {
            object = new MessageFormat(ResourcesMgr.getString("java.security.policy: error adding Entry:\n\tmessage"));
            Object[] objectArray = new Object[]{exception.toString()};
            System.err.println(((Format)object).format(objectArray));
        }
        if (debug != null) {
            debug.println();
        }
    }

    private CodeSource getCodeSource(PolicyParser.GrantEntry grantEntry, KeyStore keyStore, PolicyInfo policyInfo) throws MalformedURLException {
        Certificate[] certificateArray = null;
        if (grantEntry.signedBy != null && (certificateArray = this.getCertificates(keyStore, grantEntry.signedBy, policyInfo)) == null) {
            if (debug != null) {
                debug.println("  -- No certs for alias '" + grantEntry.signedBy + "' - ignoring entry");
            }
            return null;
        }
        URL uRL = grantEntry.codeBase != null ? new URL(grantEntry.codeBase) : null;
        return this.canonicalizeCodebase(new CodeSource(uRL, certificateArray), false);
    }

    private KeyStore initKeyStore(URL uRL, String string, String string2) {
        if (string != null) {
            try {
                URL uRL2 = null;
                try {
                    uRL2 = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    uRL2 = new URL(uRL, string);
                }
                if (debug != null) {
                    debug.println("reading keystore" + uRL2);
                }
                BufferedInputStream bufferedInputStream = new BufferedInputStream(this.getInputStream(uRL2));
                KeyStore keyStore = string2 != null ? KeyStore.getInstance(string2) : KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(bufferedInputStream, null);
                ((InputStream)bufferedInputStream).close();
                return keyStore;
            }
            catch (Exception exception) {
                if (debug != null) {
                    exception.printStackTrace();
                }
                return null;
            }
        }
        return null;
    }

    private static final Permission getKnownInstance(Class clazz, String string, String string2) {
        if (clazz.equals(class$java$io$FilePermission == null ? (class$java$io$FilePermission = PolicyFile.class$("java.io.FilePermission")) : class$java$io$FilePermission)) {
            return new FilePermission(string, string2);
        }
        if (clazz.equals(class$java$net$SocketPermission == null ? (class$java$net$SocketPermission = PolicyFile.class$("java.net.SocketPermission")) : class$java$net$SocketPermission)) {
            return new SocketPermission(string, string2);
        }
        if (clazz.equals(class$java$lang$RuntimePermission == null ? (class$java$lang$RuntimePermission = PolicyFile.class$("java.lang.RuntimePermission")) : class$java$lang$RuntimePermission)) {
            return new RuntimePermission(string, string2);
        }
        if (clazz.equals(class$java$util$PropertyPermission == null ? (class$java$util$PropertyPermission = PolicyFile.class$("java.util.PropertyPermission")) : class$java$util$PropertyPermission)) {
            return new PropertyPermission(string, string2);
        }
        if (clazz.equals(class$java$net$NetPermission == null ? (class$java$net$NetPermission = PolicyFile.class$("java.net.NetPermission")) : class$java$net$NetPermission)) {
            return new NetPermission(string, string2);
        }
        if (clazz.equals(class$java$security$AllPermission == null ? (class$java$security$AllPermission = PolicyFile.class$("java.security.AllPermission")) : class$java$security$AllPermission)) {
            return SecurityConstants.ALL_PERMISSION;
        }
        if (clazz.equals(class$java$awt$AWTPermission == null ? (class$java$awt$AWTPermission = PolicyFile.class$("java.awt.AWTPermission")) : class$java$awt$AWTPermission)) {
            return new AWTPermission(string, string2);
        }
        return null;
    }

    private static final Permission getInstance(String string, String string2, String string3) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Class clazz = Class.forName(string);
        Permission permission = PolicyFile.getKnownInstance(clazz, string2, string3);
        if (permission != null) {
            return permission;
        }
        if (string2 == null && string3 == null) {
            try {
                Constructor constructor = clazz.getConstructor(PARAMS0);
                return (Permission)constructor.newInstance(new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    Constructor constructor = clazz.getConstructor(PARAMS1);
                    return (Permission)constructor.newInstance(new Object[]{string2});
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    Constructor constructor = clazz.getConstructor(PARAMS2);
                    return (Permission)constructor.newInstance(new Object[]{string2, string3});
                }
            }
        }
        if (string2 != null && string3 == null) {
            try {
                Constructor constructor = clazz.getConstructor(PARAMS1);
                return (Permission)constructor.newInstance(new Object[]{string2});
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Constructor constructor = clazz.getConstructor(PARAMS2);
                return (Permission)constructor.newInstance(new Object[]{string2, string3});
            }
        }
        Constructor constructor = clazz.getConstructor(PARAMS2);
        return (Permission)constructor.newInstance(new Object[]{string2, string3});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Permissions getPermissions(Permissions permissions, CodeSource codeSource, Principal[] principalArray) {
        PolicyEntry policyEntry;
        int n2 = this.policyInfo.policyEntries.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            policyEntry = (PolicyEntry)this.policyInfo.policyEntries.get(i2);
            this.addPermissions(permissions, codeSource, principalArray, policyEntry);
        }
        Certificate[] certificateArray = this.policyInfo.identityPolicyEntries;
        synchronized (this.policyInfo.identityPolicyEntries) {
            int n3;
            n2 = this.policyInfo.identityPolicyEntries.size();
            for (n3 = 0; n3 < n2; ++n3) {
                policyEntry = (PolicyEntry)this.policyInfo.identityPolicyEntries.get(n3);
                this.addPermissions(permissions, codeSource, principalArray, policyEntry);
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            if (!this.ignoreIdentityScope && (certificateArray = codeSource.getCertificates()) != null) {
                for (n3 = 0; n3 < certificateArray.length; ++n3) {
                    Object object;
                    Map map = this.policyInfo.aliasMapping;
                    synchronized (map) {
                        object = this.policyInfo.aliasMapping.get(certificateArray[n3]);
                    }
                    if (object != null || !this.checkForTrustedIdentity(certificateArray[n3], this.policyInfo)) continue;
                    permissions.add(SecurityConstants.ALL_PERMISSION);
                }
            }
            return permissions;
        }
    }

    private void expandSelf(SelfPermission selfPermission, List list, Principal[] principalArray, Permissions permissions) {
        block18: {
            Object object;
            Object object2;
            int n2;
            if (list == null || list.size() == 0) {
                if (debug != null) {
                    debug.println("Ignoring permission " + selfPermission.getSelfType() + " with target name (" + selfPermission.getSelfName() + ").  " + "No Principal(s) specified " + "in the grant clause.  " + "SELF-based target names are " + "only valid in the context " + "of a Principal-based grant entry.");
                }
                return;
            }
            int n3 = 0;
            StringBuffer stringBuffer = new StringBuffer();
            while ((n2 = selfPermission.getSelfName().indexOf(SELF, n3)) != -1) {
                stringBuffer.append(selfPermission.getSelfName().substring(n3, n2));
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    object2 = (PolicyParser.PrincipalEntry)listIterator.next();
                    object = this.getPrincipalInfo((PolicyParser.PrincipalEntry)object2, principalArray);
                    for (int i2 = 0; i2 < ((String[][])object).length; ++i2) {
                        if (i2 != 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(object[i2][0] + " " + "\"" + object[i2][1] + "\"");
                    }
                    if (!listIterator.hasNext()) continue;
                    stringBuffer.append(", ");
                }
                n3 = n2 + SELF.length();
            }
            stringBuffer.append(selfPermission.getSelfName().substring(n3));
            if (debug != null) {
                debug.println("  expanded:\n\t" + selfPermission.getSelfName() + "\n  into:\n\t" + stringBuffer.toString());
            }
            try {
                permissions.add(PolicyFile.getInstance(selfPermission.getSelfType(), stringBuffer.toString(), selfPermission.getSelfActions()));
            }
            catch (ClassNotFoundException classNotFoundException) {
                object2 = permissions.elements();
                object = null;
                while (object2.hasMoreElements()) {
                    Permission permission = (Permission)object2.nextElement();
                    if (!permission.getClass().getName().equals(selfPermission.getSelfType())) continue;
                    object = permission.getClass();
                    break;
                }
                if (object == null) {
                    permissions.add(new UnresolvedPermission(selfPermission.getSelfType(), stringBuffer.toString(), selfPermission.getSelfActions(), selfPermission.getCerts()));
                }
                try {
                    if (selfPermission.getSelfActions() == null) {
                        try {
                            Constructor constructor = object.getConstructor(PARAMS1);
                            permissions.add((Permission)constructor.newInstance(new Object[]{stringBuffer.toString()}));
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            Constructor constructor = object.getConstructor(PARAMS2);
                            permissions.add((Permission)constructor.newInstance(new Object[]{stringBuffer.toString(), selfPermission.getSelfActions()}));
                        }
                    }
                    Constructor constructor = object.getConstructor(PARAMS2);
                    permissions.add((Permission)constructor.newInstance(new Object[]{stringBuffer.toString(), selfPermission.getSelfActions()}));
                }
                catch (Exception exception) {
                    if (debug != null) {
                        debug.println("self entry expansion  instantiation failed: " + exception.toString());
                    }
                }
            }
            catch (Exception exception) {
                if (debug == null) break block18;
                debug.println(exception.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Certificate[] getCertificates(KeyStore keyStore, String string, PolicyInfo policyInfo) {
        Object[] objectArray;
        List list = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            objectArray = stringTokenizer.nextToken().trim();
            ++n2;
            Certificate certificate = null;
            Map map = policyInfo.aliasMapping;
            synchronized (map) {
                certificate = (Certificate)policyInfo.aliasMapping.get(objectArray);
                if (certificate == null && keyStore != null) {
                    try {
                        certificate = keyStore.getCertificate((String)objectArray);
                    }
                    catch (KeyStoreException keyStoreException) {
                        // empty catch block
                    }
                    if (certificate != null) {
                        policyInfo.aliasMapping.put(objectArray, certificate);
                        policyInfo.aliasMapping.put(certificate, objectArray);
                    }
                }
            }
            if (certificate == null) continue;
            if (list == null) {
                list = new ArrayList();
            }
            list.add(certificate);
        }
        if (list != null && n2 == list.size()) {
            objectArray = new Certificate[list.size()];
            list.toArray(objectArray);
            return objectArray;
        }
        return null;
    }

    private void addPermissions(Permissions permissions, CodeSource codeSource, Principal[] principalArray, PolicyEntry policyEntry) {
        Boolean bl2;
        boolean bl3 = false;
        if (debug != null) {
            debug.println("evaluate codesources:\n\tPolicy CodeSource: " + policyEntry.getCodeSource() + "\n" + "\tActive CodeSource: " + codeSource);
        }
        if (!(bl2 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(this, policyEntry, codeSource){
            private final PolicyEntry val$entry;
            private final CodeSource val$cs;
            private final PolicyFile this$0;

            public Object run() {
                return new Boolean(this.val$entry.getCodeSource().implies(this.val$cs));
            }
            {
                this.this$0 = policyFile;
                this.val$entry = policyEntry;
                this.val$cs = codeSource;
            }
        })).booleanValue()) {
            if (debug != null) {
                debug.println("evaluation (codesource) failed");
            }
        } else {
            Object object;
            Principal[] principalArray2 = principalArray;
            List list = policyEntry.getPrincipals();
            LinkedList linkedList = new LinkedList();
            if (principalArray2 != null && principalArray2.length != 0) {
                object = null;
                for (int i2 = 0; i2 < principalArray2.length; ++i2) {
                    object = new PolicyParser.PrincipalEntry(principalArray2[i2].getClass().getName(), principalArray2[i2].getName());
                    linkedList.add(object);
                }
            }
            if (debug != null) {
                debug.println("evaluate principals:\n\tPolicy Principals: " + list + "\n" + "\tActive Principals: " + linkedList);
            }
            if (list == null || list.size() == 0) {
                bl3 = true;
            } else if (linkedList.size() != 0) {
                object = list.listIterator(0);
                while (object.hasNext()) {
                    PolicyParser.PrincipalEntry principalEntry = (PolicyParser.PrincipalEntry)object.next();
                    try {
                        Class clazz = Class.forName(principalEntry.principalClass, true, Thread.currentThread().getContextClassLoader());
                        Constructor constructor = clazz.getConstructor(PARAMS1);
                        PrincipalComparator principalComparator = (PrincipalComparator)constructor.newInstance(new Object[]{principalEntry.principalName});
                        if (debug != null) {
                            debug.println("found PrincipalComparator " + principalComparator.getClass().getName());
                        }
                        Subject subject = new Subject();
                        AccessController.doPrivileged(new PrivilegedAction(this, subject, principalArray2){
                            private final Subject val$subject;
                            private final Principal[] val$pdp;
                            private final PolicyFile this$0;

                            public Object run() {
                                Set set = this.val$subject.getPrincipals();
                                for (int i2 = 0; i2 < this.val$pdp.length; ++i2) {
                                    set.add(this.val$pdp[i2]);
                                }
                                return null;
                            }
                            {
                                this.this$0 = policyFile;
                                this.val$subject = subject;
                                this.val$pdp = principalArray;
                            }
                        });
                        bl3 = principalComparator.implies(subject);
                        if (bl3) continue;
                    }
                    catch (Exception exception) {
                        if (debug != null) {
                            debug.println("Exception while attempting to construct PrincipalComparator");
                            exception.printStackTrace();
                        }
                        if (bl3 = this.subjectListImpliesPrincipalEntry(linkedList, principalEntry)) continue;
                    }
                    break;
                }
            }
            if (!bl3) {
                if (debug != null) {
                    debug.println("evaluation failed");
                }
            } else {
                if (debug != null) {
                    debug.println("evaluation (codesource/principals) passed");
                }
                for (int i3 = 0; i3 < policyEntry.permissions.size(); ++i3) {
                    Permission permission = (Permission)policyEntry.permissions.get(i3);
                    if (debug != null) {
                        debug.println("  granting " + permission);
                    }
                    if (permission instanceof SelfPermission) {
                        this.expandSelf((SelfPermission)permission, list, principalArray2, permissions);
                        continue;
                    }
                    permissions.add(permission);
                }
            }
        }
    }

    private static class PolicyEntry {
        private final CodeSource codesource;
        final List permissions;
        private final List principals;

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(ResourcesMgr.getString("("));
            stringBuffer.append(this.getCodeSource());
            stringBuffer.append("\n");
            for (int i2 = 0; i2 < this.permissions.size(); ++i2) {
                Permission permission = (Permission)this.permissions.get(i2);
                stringBuffer.append(ResourcesMgr.getString(" "));
                stringBuffer.append(ResourcesMgr.getString(" "));
                stringBuffer.append(permission);
                stringBuffer.append(ResourcesMgr.getString("\n"));
            }
            stringBuffer.append(ResourcesMgr.getString(")"));
            stringBuffer.append(ResourcesMgr.getString("\n"));
            return stringBuffer.toString();
        }

        CodeSource getCodeSource() {
            return this.codesource;
        }

        PolicyEntry(CodeSource codeSource) {
            this(codeSource, null);
        }

        void add(Permission permission) {
            this.permissions.add(permission);
        }

        List getPrincipals() {
            return this.principals;
        }

        PolicyEntry(CodeSource codeSource, List list) {
            this.codesource = codeSource;
            this.permissions = new ArrayList();
            this.principals = list;
        }
    }
}

