/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.tcp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.rmi.server.LogStream;
import java.rmi.server.RMIFailureHandler;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UID;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.WeakHashMap;
import sun.rmi.runtime.Log;
import sun.rmi.runtime.NewThreadAction;
import sun.rmi.transport.Channel;
import sun.rmi.transport.Connection;
import sun.rmi.transport.DGCAckHandler;
import sun.rmi.transport.Endpoint;
import sun.rmi.transport.StreamRemoteCall;
import sun.rmi.transport.Target;
import sun.rmi.transport.Transport;
import sun.rmi.transport.proxy.HttpReceiveSocket;
import sun.rmi.transport.tcp.ConnectionMultiplexer;
import sun.rmi.transport.tcp.TCPChannel;
import sun.rmi.transport.tcp.TCPConnection;
import sun.rmi.transport.tcp.TCPEndpoint;
import sun.security.action.GetIntegerAction;
import sun.security.action.GetPropertyAction;

public class TCPTransport
extends Transport
implements Runnable {
    static final int logLevel = LogStream.parseLevel(TCPTransport.getLogLevel());
    static final Log tcpLog = Log.getLog("sun.rmi.transport.tcp", "tcp", logLevel);
    private static int threadNum = 0;
    private static final ThreadLocal threadConnectionHandler = new ThreadLocal();
    private final LinkedList epList;
    private ServerSocket server = null;
    private final Map channelTable = new HashMap(11);
    static final RMISocketFactory defaultSocketFactory = RMISocketFactory.getDefaultSocketFactory();
    private static final int connectionReadTimeout = (Integer)AccessController.doPrivileged(new GetIntegerAction("sun.rmi.transport.tcp.readTimeout", 0x6DDD00));
    private transient long acceptFailureTime = 0L;
    private transient int acceptFailureCount;

    static int access$200() {
        return connectionReadTimeout;
    }

    private synchronized void listen() throws RemoteException {
        TCPEndpoint tCPEndpoint = this.getEndpoint();
        int n2 = tCPEndpoint.getPort();
        if (this.server == null) {
            if (tcpLog.isLoggable(Log.BRIEF)) {
                tcpLog.log(Log.BRIEF, "(port " + n2 + ") create server socket");
            }
            try {
                this.server = tCPEndpoint.newServerSocket();
                Thread thread = (Thread)AccessController.doPrivileged(new NewThreadAction(this, "TCP Accept-" + n2, true));
                thread.start();
            }
            catch (BindException bindException) {
                throw new ExportException("Port already in use: " + n2, bindException);
            }
            catch (IOException iOException) {
                throw new ExportException("Listen failed on port: " + n2, iOException);
            }
        } else {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkListen(n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        if (tcpLog.isLoggable(Log.BRIEF)) {
            tcpLog.log(Log.BRIEF, "listening on port " + this.getEndpoint().getPort());
        }
        ServerSocket serverSocket;
        while ((serverSocket = this.server) != null) {
            Object var8_14;
            Throwable throwable = null;
            try {
                Socket socket = serverSocket.accept();
                InetAddress inetAddress = socket.getInetAddress();
                String string = inetAddress != null ? inetAddress.getHostAddress() : "0.0.0.0";
                Thread thread = (Thread)AccessController.doPrivileged(new NewThreadAction(new ConnectionHandler(this, socket, string), "TCP Connection(" + ++threadNum + ")-" + string, true, true));
                thread.start();
                var8_14 = null;
                if (throwable == null) continue;
            }
            catch (Throwable throwable2) {
                var8_14 = null;
                if (throwable == null) throw throwable2;
                if (!(throwable instanceof SecurityException)) {
                    try {
                        TCPEndpoint.shedConnectionCaches();
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (throwable instanceof IOException || throwable instanceof OutOfMemoryError || throwable instanceof NoClassDefFoundError || throwable instanceof MissingResourceException || throwable instanceof SecurityException) {
                    if (this.continueAfterAcceptFailure(throwable)) throw throwable2;
                    return;
                }
                if (!(throwable instanceof RuntimeException)) throw (Error)throwable;
                throw (RuntimeException)throwable;
            }
            if (!(throwable instanceof SecurityException)) {
                try {
                    TCPEndpoint.shedConnectionCaches();
                }
                catch (OutOfMemoryError outOfMemoryError) {
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (throwable instanceof IOException || throwable instanceof OutOfMemoryError || throwable instanceof NoClassDefFoundError || throwable instanceof MissingResourceException || throwable instanceof SecurityException) {
                if (this.continueAfterAcceptFailure(throwable)) continue;
                return;
            }
            if (!(throwable instanceof RuntimeException)) throw (Error)throwable;
            throw (RuntimeException)throwable;
            {
                catch (IOException iOException) {
                    IOException iOException2 = iOException;
                    var8_14 = null;
                    if (iOException2 == null) continue;
                    if (!(iOException2 instanceof SecurityException)) {
                        try {
                            TCPEndpoint.shedConnectionCaches();
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (iOException2 instanceof IOException || iOException2 instanceof OutOfMemoryError || iOException2 instanceof NoClassDefFoundError || iOException2 instanceof MissingResourceException || iOException2 instanceof SecurityException) {
                        if (this.continueAfterAcceptFailure(iOException2)) continue;
                        return;
                    }
                    if (!(iOException2 instanceof RuntimeException)) throw (Error)((Object)iOException2);
                    throw (RuntimeException)((Object)iOException2);
                }
                catch (RuntimeException runtimeException) {
                    RuntimeException runtimeException2 = runtimeException;
                    var8_14 = null;
                    if (runtimeException2 == null) continue;
                    if (!(runtimeException2 instanceof SecurityException)) {
                        try {
                            TCPEndpoint.shedConnectionCaches();
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (runtimeException2 instanceof IOException || runtimeException2 instanceof OutOfMemoryError || runtimeException2 instanceof NoClassDefFoundError || runtimeException2 instanceof MissingResourceException || runtimeException2 instanceof SecurityException) {
                        if (this.continueAfterAcceptFailure(runtimeException2)) continue;
                        return;
                    }
                    if (!(runtimeException2 instanceof RuntimeException)) throw (Error)((Object)runtimeException2);
                    throw runtimeException2;
                }
                catch (Error error) {
                    Error error2 = error;
                    var8_14 = null;
                    if (error2 == null) continue;
                    if (!(error2 instanceof SecurityException)) {
                        try {
                            TCPEndpoint.shedConnectionCaches();
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (error2 instanceof IOException || error2 instanceof OutOfMemoryError || error2 instanceof NoClassDefFoundError || error2 instanceof MissingResourceException || error2 instanceof SecurityException) {
                        if (!this.continueAfterAcceptFailure(error2)) return;
                        continue;
                    }
                    if (!(error2 instanceof RuntimeException)) throw error2;
                    throw (RuntimeException)((Object)error2);
                }
            }
            break;
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shedConnectionCaches() {
        int n2;
        TCPChannel[] tCPChannelArray;
        Map map = this.channelTable;
        synchronized (map) {
            tCPChannelArray = new TCPChannel[this.channelTable.size()];
            Iterator iterator = this.channelTable.values().iterator();
            n2 = 0;
            while (iterator.hasNext()) {
                tCPChannelArray[n2] = (TCPChannel)iterator.next();
                ++n2;
            }
        }
        while (--n2 >= 0) {
            tCPChannelArray[n2].shedCache();
        }
    }

    public static String getClientHost() throws ServerNotActiveException {
        ConnectionHandler connectionHandler = (ConnectionHandler)threadConnectionHandler.get();
        if (connectionHandler != null) {
            return connectionHandler.getClientHost();
        }
        throw new ServerNotActiveException("not in a remote call");
    }

    private static String getLogLevel() {
        return (String)AccessController.doPrivileged(new GetPropertyAction("sun.rmi.transport.tcp.logLevel"));
    }

    static ThreadLocal access$100() {
        return threadConnectionHandler;
    }

    private synchronized boolean continueAfterAcceptFailure(Throwable throwable) {
        boolean bl2;
        RMIFailureHandler rMIFailureHandler = RMISocketFactory.getFailureHandler();
        if (rMIFailureHandler != null) {
            bl2 = throwable instanceof Exception ? rMIFailureHandler.failure((Exception)throwable) : rMIFailureHandler.failure(new InvocationTargetException(throwable));
        } else {
            long l2 = System.currentTimeMillis();
            if (this.acceptFailureTime == 0L || l2 - this.acceptFailureTime > 5000L) {
                this.acceptFailureTime = l2;
                this.acceptFailureCount = 0;
            } else {
                ++this.acceptFailureCount;
                if (this.acceptFailureCount >= 10) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            bl2 = true;
        }
        return bl2;
    }

    static void access$300(Socket socket) {
        TCPTransport.closeSocket(socket);
    }

    private static void closeSocket(Socket socket) {
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void checkAcceptPermission(AccessControlContext accessControlContext) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        ConnectionHandler connectionHandler = (ConnectionHandler)threadConnectionHandler.get();
        if (connectionHandler == null) {
            throw new Error("checkAcceptPermission not in ConnectionHandler thread");
        }
        connectionHandler.checkAcceptPermission(securityManager, accessControlContext);
    }

    TCPTransport(LinkedList linkedList) {
        this.epList = linkedList;
        if (tcpLog.isLoggable(Log.BRIEF)) {
            tcpLog.log(Log.BRIEF, "Version = 2, ep = " + this.getEndpoint());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleMessages(Connection connection, boolean bl2) {
        int n2 = this.getEndpoint().getPort();
        try {
            DataInputStream dataInputStream = new DataInputStream(connection.getInputStream());
            block19: do {
                int n3;
                if ((n3 = dataInputStream.read()) == -1) {
                    if (tcpLog.isLoggable(Log.BRIEF)) {
                        tcpLog.log(Log.BRIEF, "(port " + n2 + ") connection closed");
                    }
                    break;
                }
                if (tcpLog.isLoggable(Log.BRIEF)) {
                    tcpLog.log(Log.BRIEF, "(port " + n2 + ") op = " + n3);
                }
                switch (n3) {
                    case 80: {
                        StreamRemoteCall streamRemoteCall = new StreamRemoteCall(connection);
                        if (this.serviceCall(streamRemoteCall)) continue block19;
                        return;
                    }
                    case 82: {
                        DataOutputStream dataOutputStream = new DataOutputStream(connection.getOutputStream());
                        dataOutputStream.writeByte(83);
                        connection.releaseOutputStream();
                        break;
                    }
                    case 84: {
                        DGCAckHandler.received(UID.read(dataInputStream));
                        break;
                    }
                    default: {
                        throw new IOException("unknown transport op " + n3);
                    }
                }
            } while (bl2);
        }
        catch (IOException iOException) {
            if (tcpLog.isLoggable(Log.BRIEF)) {
                tcpLog.log(Log.BRIEF, "(port " + n2 + ") exception: ", iOException);
            }
        }
        finally {
            try {
                connection.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free(Endpoint endpoint) {
        if (endpoint instanceof TCPEndpoint) {
            Map map = this.channelTable;
            synchronized (map) {
                TCPChannel tCPChannel = (TCPChannel)this.channelTable.remove(endpoint);
                if (tCPChannel != null) {
                    tCPChannel.shedCache();
                }
            }
        }
    }

    public void exportObject(Target target) throws RemoteException {
        this.listen();
        target.setExportedTransport(this);
        super.exportObject(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TCPEndpoint getEndpoint() {
        LinkedList linkedList = this.epList;
        synchronized (linkedList) {
            return (TCPEndpoint)this.epList.getLast();
        }
    }

    static Map access$400(TCPTransport tCPTransport) {
        return tCPTransport.channelTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel getChannel(Endpoint endpoint) {
        Channel channel = null;
        if (endpoint instanceof TCPEndpoint) {
            Map map = this.channelTable;
            synchronized (map) {
                channel = (Channel)this.channelTable.get(endpoint);
                if (channel == null) {
                    channel = new TCPChannel(this, (TCPEndpoint)endpoint);
                    this.channelTable.put(endpoint, channel);
                }
            }
        }
        return channel;
    }

    static TCPEndpoint access$000(TCPTransport tCPTransport) {
        return tCPTransport.getEndpoint();
    }

    private class ConnectionHandler
    implements Runnable {
        private static final int POST = 1347375956;
        private AccessControlContext okContext;
        private WeakHashMap authCache;
        private SecurityManager cacheSecurityManager;
        private Socket socket;
        private String remoteHost;
        private final TCPTransport this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            TCPEndpoint tCPEndpoint = TCPTransport.access$000(this.this$0);
            int n2 = tCPEndpoint.getPort();
            TCPTransport.access$100().set(this);
            try {
                this.socket.setTcpNoDelay(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (TCPTransport.access$200() > 0) {
                    this.socket.setSoTimeout(TCPTransport.access$200());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                InputStream inputStream = this.socket.getInputStream();
                InputStream inputStream2 = inputStream.markSupported() ? inputStream : new BufferedInputStream(inputStream);
                inputStream2.mark(4);
                DataInputStream dataInputStream = new DataInputStream(inputStream2);
                int n3 = dataInputStream.readInt();
                if (n3 == 1347375956) {
                    tcpLog.log(Log.BRIEF, "decoding HTTP-wrapped call");
                    inputStream2.reset();
                    try {
                        this.socket = new HttpReceiveSocket(this.socket, inputStream2, null);
                        this.remoteHost = "0.0.0.0";
                        inputStream = this.socket.getInputStream();
                        inputStream2 = new BufferedInputStream(inputStream);
                        dataInputStream = new DataInputStream(inputStream2);
                        n3 = dataInputStream.readInt();
                    }
                    catch (IOException iOException) {
                        throw new RemoteException("Error HTTP-unwrapping call", iOException);
                    }
                }
                short s2 = dataInputStream.readShort();
                if (n3 != 1246907721 || s2 != 2) {
                    TCPTransport.access$300(this.socket);
                    return;
                }
                OutputStream outputStream = this.socket.getOutputStream();
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
                DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);
                int n4 = this.socket.getPort();
                if (tcpLog.isLoggable(Log.BRIEF)) {
                    tcpLog.log(Log.BRIEF, "accepted socket from [" + this.remoteHost + ":" + n4 + "]");
                }
                byte by = dataInputStream.readByte();
                switch (by) {
                    case 76: {
                        TCPEndpoint tCPEndpoint2 = new TCPEndpoint(this.remoteHost, this.socket.getLocalPort(), tCPEndpoint.getClientSocketFactory(), tCPEndpoint.getServerSocketFactory());
                        TCPChannel tCPChannel = new TCPChannel(this.this$0, tCPEndpoint2);
                        TCPConnection tCPConnection = new TCPConnection(tCPChannel, this.socket, inputStream2, bufferedOutputStream);
                        this.this$0.handleMessages(tCPConnection, false);
                        return;
                    }
                    case 75: {
                        dataOutputStream.writeByte(78);
                        if (tcpLog.isLoggable(Log.VERBOSE)) {
                            tcpLog.log(Log.VERBOSE, "(port " + n2 + ") " + "suggesting " + this.remoteHost + ":" + n4);
                        }
                        dataOutputStream.writeUTF(this.remoteHost);
                        dataOutputStream.writeInt(n4);
                        dataOutputStream.flush();
                        String string = dataInputStream.readUTF();
                        int n5 = dataInputStream.readInt();
                        if (tcpLog.isLoggable(Log.VERBOSE)) {
                            tcpLog.log(Log.VERBOSE, "(port " + n2 + ") client using " + string + ":" + n5);
                        }
                        TCPEndpoint tCPEndpoint3 = new TCPEndpoint(this.remoteHost, this.socket.getLocalPort(), tCPEndpoint.getClientSocketFactory(), tCPEndpoint.getServerSocketFactory());
                        TCPChannel tCPChannel = new TCPChannel(this.this$0, tCPEndpoint3);
                        TCPConnection tCPConnection = new TCPConnection(tCPChannel, this.socket, inputStream2, bufferedOutputStream);
                        this.this$0.handleMessages(tCPConnection, true);
                        return;
                    }
                    case 77: {
                        ConnectionMultiplexer connectionMultiplexer;
                        if (tcpLog.isLoggable(Log.VERBOSE)) {
                            tcpLog.log(Log.VERBOSE, "(port " + n2 + ") accepting multiplex protocol");
                        }
                        dataOutputStream.writeByte(78);
                        if (tcpLog.isLoggable(Log.VERBOSE)) {
                            tcpLog.log(Log.VERBOSE, "(port " + n2 + ") suggesting " + this.remoteHost + ":" + n4);
                        }
                        dataOutputStream.writeUTF(this.remoteHost);
                        dataOutputStream.writeInt(n4);
                        dataOutputStream.flush();
                        TCPEndpoint tCPEndpoint4 = new TCPEndpoint(dataInputStream.readUTF(), dataInputStream.readInt(), tCPEndpoint.getClientSocketFactory(), tCPEndpoint.getServerSocketFactory());
                        if (tcpLog.isLoggable(Log.VERBOSE)) {
                            tcpLog.log(Log.VERBOSE, "(port " + n2 + ") client using " + tCPEndpoint4.getHost() + ":" + tCPEndpoint4.getPort());
                        }
                        Map map = TCPTransport.access$400(this.this$0);
                        synchronized (map) {
                            TCPChannel tCPChannel = (TCPChannel)this.this$0.getChannel(tCPEndpoint4);
                            connectionMultiplexer = new ConnectionMultiplexer(tCPChannel, inputStream2, outputStream, false);
                            tCPChannel.useMultiplexer(connectionMultiplexer);
                        }
                        connectionMultiplexer.run();
                        return;
                    }
                    default: {
                        dataOutputStream.writeByte(79);
                        dataOutputStream.flush();
                        return;
                    }
                }
            }
            catch (IOException iOException) {
                tcpLog.log(Log.BRIEF, "terminated with exception:", iOException);
                return;
            }
            finally {
                TCPTransport.access$300(this.socket);
            }
        }

        String getClientHost() {
            return this.remoteHost;
        }

        void checkAcceptPermission(SecurityManager securityManager, AccessControlContext accessControlContext) {
            if (securityManager != this.cacheSecurityManager) {
                this.okContext = null;
                this.authCache = new WeakHashMap();
                this.cacheSecurityManager = securityManager;
            }
            if (accessControlContext.equals(this.okContext) || this.authCache.containsKey(accessControlContext)) {
                return;
            }
            InetAddress inetAddress = this.socket.getInetAddress();
            String string = inetAddress != null ? inetAddress.getHostAddress() : "*";
            securityManager.checkAccept(string, this.socket.getPort());
            this.authCache.put(accessControlContext, new SoftReference(accessControlContext));
            this.okContext = accessControlContext;
        }

        ConnectionHandler(TCPTransport tCPTransport, Socket socket, String string) {
            this.this$0 = tCPTransport;
            this.cacheSecurityManager = null;
            this.socket = socket;
            this.remoteHost = string;
        }
    }
}

