/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.tcp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import sun.rmi.runtime.Log;
import sun.rmi.transport.Channel;
import sun.rmi.transport.Connection;
import sun.rmi.transport.proxy.RMISocketInfo;
import sun.rmi.transport.tcp.TCPChannel;
import sun.rmi.transport.tcp.TCPTransport;

public class TCPConnection
implements Connection {
    private Socket socket;
    private Channel channel;
    private InputStream in = null;
    private OutputStream out = null;
    private long expiration = Long.MAX_VALUE;
    private long lastuse = Long.MIN_VALUE;
    private long roundtrip = 5L;

    public void close() throws IOException {
        TCPTransport.tcpLog.log(Log.BRIEF, "close connection");
        if (this.socket != null) {
            this.socket.close();
        } else {
            this.in.close();
            this.out.close();
        }
    }

    public void releaseInputStream() {
    }

    public void releaseOutputStream() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    public boolean isDead() {
        OutputStream outputStream;
        InputStream inputStream;
        long l2 = System.currentTimeMillis();
        if (this.roundtrip > 0L && l2 < this.lastuse + this.roundtrip) {
            return false;
        }
        try {
            inputStream = this.getInputStream();
            outputStream = this.getOutputStream();
        }
        catch (IOException iOException) {
            return true;
        }
        int n2 = 0;
        try {
            outputStream.write(82);
            outputStream.flush();
            n2 = inputStream.read();
        }
        catch (IOException iOException) {
            TCPTransport.tcpLog.log(Log.VERBOSE, "exception: ", iOException);
            TCPTransport.tcpLog.log(Log.BRIEF, "server ping failed");
            return true;
        }
        if (n2 == 83) {
            this.roundtrip = (System.currentTimeMillis() - l2) * 2L;
            return false;
        }
        if (TCPTransport.tcpLog.isLoggable(Log.BRIEF)) {
            TCPTransport.tcpLog.log(Log.BRIEF, n2 == -1 ? "server has been deactivated" : "server protocol error: ping response = " + n2);
        }
        return true;
    }

    public boolean isReusable() {
        if (this.socket != null && this.socket instanceof RMISocketInfo) {
            return ((RMISocketInfo)((Object)this.socket)).isReusable();
        }
        return true;
    }

    void setExpiration(long l2) {
        this.expiration = l2;
    }

    void setLastUseTime(long l2) {
        this.lastuse = l2;
    }

    boolean expired(long l2) {
        return this.expiration <= l2;
    }

    public InputStream getInputStream() throws IOException {
        if (this.in == null) {
            this.in = new BufferedInputStream(this.socket.getInputStream());
        }
        return this.in;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.out == null) {
            this.out = new BufferedOutputStream(this.socket.getOutputStream());
        }
        return this.out;
    }

    public Channel getChannel() {
        return this.channel;
    }

    TCPConnection(TCPChannel tCPChannel, Socket socket) {
        this(tCPChannel, socket, null, null);
    }

    TCPConnection(TCPChannel tCPChannel, InputStream inputStream, OutputStream outputStream) {
        this(tCPChannel, null, inputStream, outputStream);
    }

    TCPConnection(TCPChannel tCPChannel, Socket socket, InputStream inputStream, OutputStream outputStream) {
        this.socket = socket;
        this.channel = tCPChannel;
        this.in = inputStream;
        this.out = outputStream;
    }
}

