/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import sun.nio.cs.StandardCharsets;
import sun.nio.cs.Surrogate;
import sun.nio.cs.Unicode;
import sun.nio.cs.UnicodeDecoder;
import sun.nio.cs.UnicodeEncoder;

class UTF_16BE
extends Unicode {
    public UTF_16BE() {
        super("UTF-16BE", StandardCharsets.aliasesFor("UTF-16BE"));
    }

    public String historicalName() {
        return "UnicodeBigUnmarked";
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static class Decoder
    extends UnicodeDecoder {
        public Decoder(Charset charset) {
            super(charset, 1);
        }
    }

    private static class Encoder
    extends UnicodeEncoder {
        public boolean canEncode(char c2) {
            if (Surrogate.isHigh(c2) || Surrogate.isLow(c2)) {
                return false;
            }
            return c2 <= '\uffff';
        }

        public Encoder(Charset charset) {
            super(charset, 0, false);
        }
    }
}

