/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.CharBuffer;
import java.nio.charset.CoderResult;

public class Surrogate {
    public static final char MIN_HIGH = '\ud800';
    public static final char MAX_HIGH = '\udbff';
    public static final char MIN_LOW = '\udc00';
    public static final char MAX_LOW = '\udfff';
    public static final char MIN = '\ud800';
    public static final char MAX = '\udfff';
    public static final int UCS4_MIN = 65536;
    public static final int UCS4_MAX = 0x10FFFF;
    static final boolean $assertionsDisabled = !(class$sun$nio$cs$Surrogate == null ? (class$sun$nio$cs$Surrogate = Surrogate.class$("sun.nio.cs.Surrogate")) : class$sun$nio$cs$Surrogate).desiredAssertionStatus();
    static Class class$sun$nio$cs$Surrogate;

    private Surrogate() {
    }

    public static int toUCS4(char c2, char c3) {
        if (!($assertionsDisabled || Surrogate.isHigh(c2) && Surrogate.isLow(c3))) {
            throw new AssertionError();
        }
        return ((c2 & 0x3FF) << 10 | c3 & 0x3FF) + 65536;
    }

    public static char high(int n2) {
        if (!$assertionsDisabled && !Surrogate.neededFor(n2)) {
            throw new AssertionError();
        }
        return (char)(0xD800 | n2 - 65536 >> 10 & 0x3FF);
    }

    public static char low(int n2) {
        if (!$assertionsDisabled && !Surrogate.neededFor(n2)) {
            throw new AssertionError();
        }
        return (char)(0xDC00 | n2 - 65536 & 0x3FF);
    }

    public static boolean is(int n2) {
        return 55296 <= n2 && n2 <= 57343;
    }

    public static boolean isHigh(int n2) {
        return 55296 <= n2 && n2 <= 56319;
    }

    public static boolean isLow(int n2) {
        return 56320 <= n2 && n2 <= 57343;
    }

    public static boolean neededFor(int n2) {
        return n2 >= 65536 && n2 <= 0x10FFFF;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public static class Generator {
        private CoderResult error = CoderResult.OVERFLOW;
        static final boolean $assertionsDisabled = !(class$sun$nio$cs$Surrogate == null ? (class$sun$nio$cs$Surrogate = Surrogate.class$("sun.nio.cs.Surrogate")) : class$sun$nio$cs$Surrogate).desiredAssertionStatus();

        public int generate(int n2, int n3, char[] cArray, int n4, int n5) {
            if (n2 <= 65535) {
                if (Surrogate.is(n2)) {
                    this.error = CoderResult.malformedForLength(n3);
                    return -1;
                }
                if (n5 - n4 < 1) {
                    this.error = CoderResult.OVERFLOW;
                    return -1;
                }
                cArray[n4] = (char)n2;
                this.error = null;
                return 1;
            }
            if (n2 < 65536) {
                this.error = CoderResult.malformedForLength(n3);
                return -1;
            }
            if (n2 <= 0x10FFFF) {
                if (n5 - n4 < 2) {
                    this.error = CoderResult.OVERFLOW;
                    return -1;
                }
                cArray[n4] = Surrogate.high(n2);
                cArray[n4 + 1] = Surrogate.low(n2);
                this.error = null;
                return 2;
            }
            this.error = CoderResult.unmappableForLength(n3);
            return -1;
        }

        public int generate(int n2, int n3, CharBuffer charBuffer) {
            if (n2 <= 65535) {
                if (Surrogate.is(n2)) {
                    this.error = CoderResult.malformedForLength(n3);
                    return -1;
                }
                if (charBuffer.remaining() < 1) {
                    this.error = CoderResult.OVERFLOW;
                    return -1;
                }
                charBuffer.put((char)n2);
                this.error = null;
                return 1;
            }
            if (n2 < 65536) {
                this.error = CoderResult.malformedForLength(n3);
                return -1;
            }
            if (n2 <= 0x10FFFF) {
                if (charBuffer.remaining() < 2) {
                    this.error = CoderResult.OVERFLOW;
                    return -1;
                }
                charBuffer.put(Surrogate.high(n2));
                charBuffer.put(Surrogate.low(n2));
                this.error = null;
                return 2;
            }
            this.error = CoderResult.unmappableForLength(n3);
            return -1;
        }

        public CoderResult error() {
            if (!$assertionsDisabled && this.error == null) {
                throw new AssertionError();
            }
            return this.error;
        }
    }

    public static class Parser {
        private int character;
        private CoderResult error = CoderResult.UNDERFLOW;
        private boolean isPair;
        static final boolean $assertionsDisabled = !(class$sun$nio$cs$Surrogate == null ? (class$sun$nio$cs$Surrogate = Surrogate.class$("sun.nio.cs.Surrogate")) : class$sun$nio$cs$Surrogate).desiredAssertionStatus();

        public int character() {
            if (!$assertionsDisabled && this.error != null) {
                throw new AssertionError();
            }
            return this.character;
        }

        public int increment() {
            if (!$assertionsDisabled && this.error != null) {
                throw new AssertionError();
            }
            return this.isPair ? 2 : 1;
        }

        public boolean isPair() {
            if (!$assertionsDisabled && this.error != null) {
                throw new AssertionError();
            }
            return this.isPair;
        }

        public int parse(char c2, char[] cArray, int n2, int n3) {
            if (!$assertionsDisabled && cArray[n2] != c2) {
                throw new AssertionError();
            }
            if (Surrogate.isHigh(c2)) {
                if (n3 - n2 < 2) {
                    this.error = CoderResult.UNDERFLOW;
                    return -1;
                }
                char c3 = cArray[n2 + 1];
                if (Surrogate.isLow(c3)) {
                    this.character = Surrogate.toUCS4(c2, c3);
                    this.isPair = true;
                    this.error = null;
                    return this.character;
                }
                this.error = CoderResult.malformedForLength(1);
                return -1;
            }
            if (Surrogate.isLow(c2)) {
                this.error = CoderResult.malformedForLength(1);
                return -1;
            }
            this.character = c2;
            this.isPair = false;
            this.error = null;
            return this.character;
        }

        public int parse(char c2, CharBuffer charBuffer) {
            if (Surrogate.isHigh(c2)) {
                if (!charBuffer.hasRemaining()) {
                    this.error = CoderResult.UNDERFLOW;
                    return -1;
                }
                char c3 = charBuffer.get();
                if (Surrogate.isLow(c3)) {
                    this.character = Surrogate.toUCS4(c2, c3);
                    this.isPair = true;
                    this.error = null;
                    return this.character;
                }
                this.error = CoderResult.malformedForLength(1);
                return -1;
            }
            if (Surrogate.isLow(c2)) {
                this.error = CoderResult.malformedForLength(1);
                return -1;
            }
            this.character = c2;
            this.isPair = false;
            this.error = null;
            return this.character;
        }

        public CoderResult error() {
            if (!$assertionsDisabled && this.error == null) {
                throw new AssertionError();
            }
            return this.error;
        }

        public CoderResult unmappableResult() {
            if (!$assertionsDisabled && this.error != null) {
                throw new AssertionError();
            }
            return CoderResult.unmappableForLength(this.isPair ? 2 : 1);
        }
    }
}

