/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import sun.misc.SoftCache;

public class SoftCache
extends AbstractMap
implements Map {
    private Map hash;
    private ReferenceQueue queue = new ReferenceQueue();
    private Set entrySet = null;

    public int size() {
        return this.entrySet().size();
    }

    public SoftCache() {
        this.hash = new HashMap();
    }

    public void clear() {
        this.processQueue();
        this.hash.clear();
    }

    private void processQueue() {
        ValueCell valueCell;
        while ((valueCell = (ValueCell)this.queue.poll()) != null) {
            if (ValueCell.access$000(valueCell)) {
                this.hash.remove(ValueCell.access$100(valueCell));
                continue;
            }
            ValueCell.access$210();
        }
    }

    public boolean isEmpty() {
        return this.entrySet().isEmpty();
    }

    public SoftCache(int n2) {
        this.hash = new HashMap(n2);
    }

    public SoftCache(int n2, float f2) {
        this.hash = new HashMap(n2, f2);
    }

    public boolean containsKey(Object object) {
        return ValueCell.access$300(this.hash.get(object), false) != null;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet(this, null);
        }
        return this.entrySet;
    }

    static void access$900(SoftCache softCache) {
        softCache.processQueue();
    }

    protected Object fill(Object object) {
        return null;
    }

    public Object get(Object object) {
        this.processQueue();
        Object object2 = this.hash.get(object);
        if (object2 == null && (object2 = this.fill(object)) != null) {
            this.hash.put(object, ValueCell.access$400(object, object2, this.queue));
            return object2;
        }
        return ValueCell.access$300(object2, false);
    }

    public Object remove(Object object) {
        this.processQueue();
        return ValueCell.access$300(this.hash.remove(object), true);
    }

    static boolean access$600(Object object, Object object2) {
        return SoftCache.valEquals(object, object2);
    }

    private static boolean valEquals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    static ReferenceQueue access$500(SoftCache softCache) {
        return softCache.queue;
    }

    static Map access$700(SoftCache softCache) {
        return softCache.hash;
    }

    public Object put(Object object, Object object2) {
        this.processQueue();
        ValueCell valueCell = ValueCell.access$400(object, object2, this.queue);
        return ValueCell.access$300(this.hash.put(object, valueCell), true);
    }

    private class Entry
    implements Map.Entry {
        private Map.Entry ent;
        private Object value;
        private final SoftCache this$0;

        public int hashCode() {
            Object object = this.getKey();
            return (object == null ? 0 : object.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public Object getKey() {
            return this.ent.getKey();
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return SoftCache.access$600(this.ent.getKey(), entry.getKey()) && SoftCache.access$600(this.value, entry.getValue());
        }

        public Object setValue(Object object) {
            return this.ent.setValue(ValueCell.access$400(this.ent.getKey(), object, SoftCache.access$500(this.this$0)));
        }

        static Map.Entry access$1000(Entry entry) {
            return entry.ent;
        }

        Entry(SoftCache softCache, Map.Entry entry, Object object) {
            this.this$0 = softCache;
            this.ent = entry;
            this.value = object;
        }
    }

    private class EntrySet
    extends AbstractSet {
        Set hashEntries;
        private final SoftCache this$0;

        public int size() {
            int n2 = 0;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ++n2;
                iterator.next();
            }
            return n2;
        }

        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        public boolean remove(Object object) {
            SoftCache.access$900(this.this$0);
            if (object instanceof Entry) {
                return this.hashEntries.remove(Entry.access$1000((Entry)object));
            }
            return false;
        }

        public Iterator iterator() {
            return new Iterator(this){
                Iterator hashIterator;
                Entry next;
                private final EntrySet this$1;

                public void remove() {
                    this.hashIterator.remove();
                }

                public boolean hasNext() {
                    while (this.hashIterator.hasNext()) {
                        Map.Entry entry = (Map.Entry)this.hashIterator.next();
                        ValueCell valueCell = (ValueCell)entry.getValue();
                        Object object = null;
                        if (valueCell != null && (object = valueCell.get()) == null) continue;
                        this.next = new Entry(EntrySet.access$800(this.this$1), entry, object);
                        return true;
                    }
                    return false;
                }

                public Object next() {
                    if (this.next == null && !this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Entry entry = this.next;
                    this.next = null;
                    return entry;
                }
                {
                    this.this$1 = entrySet;
                    this.hashIterator = this.this$1.hashEntries.iterator();
                    this.next = null;
                }
            };
        }

        private EntrySet(SoftCache softCache) {
            this.this$0 = softCache;
            this.hashEntries = SoftCache.access$700(this.this$0).entrySet();
        }

        static SoftCache access$800(EntrySet entrySet) {
            return entrySet.this$0;
        }

        EntrySet(SoftCache softCache, 1 var2_2) {
            this(softCache);
        }
    }

    private static class ValueCell
    extends SoftReference {
        private static Object INVALID_KEY = new Object();
        private static int dropped = 0;
        private Object key;

        static int access$210() {
            return dropped--;
        }

        private void drop() {
            super.clear();
            this.key = INVALID_KEY;
            ++dropped;
        }

        private boolean isValid() {
            return this.key != INVALID_KEY;
        }

        static boolean access$000(ValueCell valueCell) {
            return valueCell.isValid();
        }

        static Object access$300(Object object, boolean bl2) {
            return ValueCell.strip(object, bl2);
        }

        private static Object strip(Object object, boolean bl2) {
            if (object == null) {
                return null;
            }
            ValueCell valueCell = (ValueCell)object;
            Object object2 = valueCell.get();
            if (bl2) {
                valueCell.drop();
            }
            return object2;
        }

        static Object access$100(ValueCell valueCell) {
            return valueCell.key;
        }

        private ValueCell(Object object, Object object2, ReferenceQueue referenceQueue) {
            super(object2, referenceQueue);
            this.key = object;
        }

        static ValueCell access$400(Object object, Object object2, ReferenceQueue referenceQueue) {
            return ValueCell.create(object, object2, referenceQueue);
        }

        private static ValueCell create(Object object, Object object2, ReferenceQueue referenceQueue) {
            if (object2 == null) {
                return null;
            }
            return new ValueCell(object, object2, referenceQueue);
        }
    }
}

