/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import sun.misc.ExtensionInfo;
import sun.misc.ExtensionInstallationException;
import sun.misc.ExtensionInstallationProvider;
import sun.misc.JarFilter;
import sun.misc.Launcher;
import sun.net.www.ParseUtil;
import sun.security.action.GetPropertyAction;

public class ExtensionDependency {
    private static Vector providers;
    static final boolean DEBUG = false;

    static File[] access$000() {
        return ExtensionDependency.getExtDirs();
    }

    private static File[] getExtDirs() {
        File[] fileArray;
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("java.ext.dirs"));
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            int n2 = stringTokenizer.countTokens();
            ExtensionDependency.debug("getExtDirs count " + n2);
            fileArray = new File[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                fileArray[i2] = new File(stringTokenizer.nextToken());
                ExtensionDependency.debug("getExtDirs dirs[" + i2 + "] " + fileArray[i2]);
            }
        } else {
            fileArray = new File[]{};
            ExtensionDependency.debug("getExtDirs dirs " + fileArray);
        }
        ExtensionDependency.debug("getExtDirs dirs.length " + fileArray.length);
        return fileArray;
    }

    private File[] getInstalledExtensions() throws IOException {
        return (File[])AccessController.doPrivileged(new PrivilegedAction(this){
            private final ExtensionDependency this$0;

            public Object run() {
                try {
                    return ExtensionDependency.access$300(ExtensionDependency.access$000());
                }
                catch (IOException iOException) {
                    ExtensionDependency.access$100("Cannot get list of installed extensions");
                    ExtensionDependency.access$200(this.this$0, iOException);
                    return new URL[0];
                }
            }
            {
                this.this$0 = extensionDependency;
            }
        });
    }

    static void access$100(String string) {
        ExtensionDependency.debug(string);
    }

    private static void debug(String string) {
    }

    private void debugException(Throwable throwable) {
    }

    protected boolean checkExtensions(JarFile jarFile) throws ExtensionInstallationException {
        Manifest manifest;
        try {
            manifest = jarFile.getManifest();
        }
        catch (IOException iOException) {
            return false;
        }
        if (manifest == null) {
            return true;
        }
        boolean bl2 = true;
        Attributes attributes = manifest.getMainAttributes();
        if (attributes != null) {
            String string = attributes.getValue(Attributes.Name.EXTENSION_LIST);
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    ExtensionDependency.debug("The file " + jarFile.getName() + " appears to depend on " + string2);
                    String string3 = string2 + "-" + Attributes.Name.EXTENSION_NAME.toString();
                    if (attributes.getValue(string3) == null) {
                        ExtensionDependency.debug("The jar file " + jarFile.getName() + " appers to depend on " + string2 + " but does not define the " + string3 + " attribute in its manifest ");
                        continue;
                    }
                    if (this.checkExtension(string2, attributes)) continue;
                    ExtensionDependency.debug("Failed installing " + string2);
                    bl2 = false;
                }
            } else {
                ExtensionDependency.debug("No dependencies for " + jarFile.getName());
            }
        }
        return bl2;
    }

    public static synchronized boolean checkExtensionsDependencies(JarFile jarFile) {
        if (providers == null) {
            return true;
        }
        try {
            ExtensionDependency extensionDependency = new ExtensionDependency();
            return extensionDependency.checkExtensions(jarFile);
        }
        catch (ExtensionInstallationException extensionInstallationException) {
            ExtensionDependency.debug(extensionInstallationException.getMessage());
            return false;
        }
    }

    public static synchronized void addExtensionInstallationProvider(ExtensionInstallationProvider extensionInstallationProvider) {
        if (providers == null) {
            providers = new Vector();
        }
        providers.add(extensionInstallationProvider);
    }

    public static synchronized void removeExtensionInstallationProvider(ExtensionInstallationProvider extensionInstallationProvider) {
        providers.remove(extensionInstallationProvider);
    }

    static File[] access$300(File[] fileArray) throws IOException {
        return ExtensionDependency.getExtFiles(fileArray);
    }

    private static File[] getExtFiles(File[] fileArray) throws IOException {
        Vector vector = new Vector();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            String[] stringArray = fileArray[i2].list(new JarFilter());
            ExtensionDependency.debug("getExtFiles files.length " + stringArray.length);
            if (stringArray == null) continue;
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                File file = new File(fileArray[i2], stringArray[i3]);
                vector.add(file);
                ExtensionDependency.debug("getExtFiles f[" + i3 + "] " + file);
            }
        }
        Object[] objectArray = new File[vector.size()];
        vector.copyInto(objectArray);
        ExtensionDependency.debug("getExtFiles ua.length " + objectArray.length);
        return objectArray;
    }

    private File checkExtensionExists(String string) {
        String string2 = string;
        String[] stringArray = new String[]{".jar", ".zip"};
        return (File)AccessController.doPrivileged(new PrivilegedAction(this, stringArray, string2){
            private final String[] val$fileExt;
            private final String val$extName;
            private final ExtensionDependency this$0;

            public Object run() {
                try {
                    File[] fileArray = ExtensionDependency.access$000();
                    for (int i2 = 0; i2 < fileArray.length; ++i2) {
                        for (int i3 = 0; i3 < this.val$fileExt.length; ++i3) {
                            File file = this.val$extName.toLowerCase().endsWith(this.val$fileExt[i3]) ? new File(fileArray[i2], this.val$extName) : new File(fileArray[i2], this.val$extName + this.val$fileExt[i3]);
                            ExtensionDependency.access$100("checkExtensionExists:fileName " + file.getName());
                            if (!file.exists()) continue;
                            return file;
                        }
                    }
                    return null;
                }
                catch (Exception exception) {
                    ExtensionDependency.access$200(this.this$0, exception);
                    return null;
                }
            }
            {
                this.this$0 = extensionDependency;
                this.val$fileExt = stringArray;
                this.val$extName = string;
            }
        });
    }

    private Boolean addNewExtensionsToClassLoader(Launcher.ExtClassLoader extClassLoader) {
        try {
            File[] fileArray = this.getInstalledExtensions();
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                File file = fileArray[i2];
                URL uRL = (URL)AccessController.doPrivileged(new PrivilegedAction(this, file){
                    private final File val$instFile;
                    private final ExtensionDependency this$0;

                    public Object run() {
                        try {
                            return ParseUtil.fileToEncodedURL(this.val$instFile);
                        }
                        catch (MalformedURLException malformedURLException) {
                            ExtensionDependency.access$200(this.this$0, malformedURLException);
                            return null;
                        }
                    }
                    {
                        this.this$0 = extensionDependency;
                        this.val$instFile = file;
                    }
                });
                if (uRL == null) continue;
                URL[] uRLArray = extClassLoader.getURLs();
                boolean bl2 = false;
                for (int i3 = 0; i3 < uRLArray.length; ++i3) {
                    ExtensionDependency.debug("URL[" + i3 + "] is " + uRLArray[i3] + " looking for " + uRL);
                    if (uRLArray[i3].toString().compareToIgnoreCase(uRL.toString()) != 0) continue;
                    bl2 = true;
                    ExtensionDependency.debug("Found !");
                }
                if (bl2) continue;
                ExtensionDependency.debug("Not Found ! adding to the classloader " + uRL);
                extClassLoader.addExtURL(uRL);
            }
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return Boolean.TRUE;
    }

    static void access$200(ExtensionDependency extensionDependency, Throwable throwable) {
        extensionDependency.debugException(throwable);
    }

    protected boolean checkExtension(String string, Attributes attributes) throws ExtensionInstallationException {
        ExtensionDependency.debug("Checking extension " + string);
        if (this.checkExtensionAgainstInstalled(string, attributes)) {
            return true;
        }
        ExtensionDependency.debug("Extension not currently installed ");
        ExtensionInfo extensionInfo = new ExtensionInfo(string, attributes);
        return this.installExtension(extensionInfo, null);
    }

    boolean checkExtensionAgainstInstalled(String string, Attributes attributes) throws ExtensionInstallationException {
        File[] fileArray;
        File file = this.checkExtensionExists(string);
        if (file != null) {
            try {
                if (this.checkExtensionAgainst(string, attributes, file)) {
                    return true;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.debugException(fileNotFoundException);
            }
            catch (IOException iOException) {
                this.debugException(iOException);
            }
            return false;
        }
        try {
            fileArray = this.getInstalledExtensions();
        }
        catch (IOException iOException) {
            this.debugException(iOException);
            return false;
        }
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            try {
                if (!this.checkExtensionAgainst(string, attributes, fileArray[i2])) continue;
                return true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.debugException(fileNotFoundException);
                continue;
            }
            catch (IOException iOException) {
                this.debugException(iOException);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean installExtension(ExtensionInfo extensionInfo, ExtensionInfo extensionInfo2) throws ExtensionInstallationException {
        Vector vector;
        Object object = providers;
        synchronized (object) {
            vector = (Vector)providers.clone();
        }
        object = vector.elements();
        while (object.hasMoreElements()) {
            ExtensionInstallationProvider extensionInstallationProvider = (ExtensionInstallationProvider)object.nextElement();
            if (extensionInstallationProvider == null || !extensionInstallationProvider.installExtension(extensionInfo, extensionInfo2)) continue;
            ExtensionDependency.debug(extensionInfo.name + " installation successful");
            Launcher.ExtClassLoader extClassLoader = (Launcher.ExtClassLoader)Launcher.getLauncher().getClassLoader().getParent();
            this.addNewExtensionsToClassLoader(extClassLoader);
            return true;
        }
        ExtensionDependency.debug(extensionInfo.name + " installation failed");
        return false;
    }

    protected boolean checkExtensionAgainst(String string, Attributes attributes, File file) throws IOException, FileNotFoundException, ExtensionInstallationException {
        Attributes attributes2;
        Manifest manifest;
        ExtensionDependency.debug("Checking extension " + string + " against " + file.getName());
        try {
            manifest = (Manifest)AccessController.doPrivileged(new PrivilegedExceptionAction(this, file){
                private final File val$file;
                private final ExtensionDependency this$0;

                public Object run() throws IOException, FileNotFoundException {
                    if (!this.val$file.exists()) {
                        throw new FileNotFoundException(this.val$file.getName());
                    }
                    JarFile jarFile = new JarFile(this.val$file);
                    return jarFile.getManifest();
                }
                {
                    this.this$0 = extensionDependency;
                    this.val$file = file;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof FileNotFoundException) {
                throw (FileNotFoundException)privilegedActionException.getException();
            }
            throw (IOException)privilegedActionException.getException();
        }
        ExtensionInfo extensionInfo = new ExtensionInfo(string, attributes);
        ExtensionDependency.debug("Requested Extension : " + extensionInfo);
        int n2 = 4;
        ExtensionInfo extensionInfo2 = null;
        if (manifest != null && (attributes2 = manifest.getMainAttributes()) != null) {
            extensionInfo2 = new ExtensionInfo(null, attributes2);
            ExtensionDependency.debug("Extension Installed " + extensionInfo2);
            n2 = extensionInfo2.isCompatibleWith(extensionInfo);
            switch (n2) {
                case 0: {
                    ExtensionDependency.debug("Extensions are compatible");
                    return true;
                }
                case 4: {
                    ExtensionDependency.debug("Extensions are incompatible");
                    return false;
                }
            }
            ExtensionDependency.debug("Extensions require an upgrade or vendor switch");
            return this.installExtension(extensionInfo, extensionInfo2);
        }
        return true;
    }
}

