/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import java.awt.BasicStroke;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.PathIterator;
import sun.dc.pr.PRException;
import sun.dc.pr.Rasterizer;
import sun.java2d.SunGraphics2D;
import sun.java2d.pipe.CompositePipe;
import sun.java2d.pipe.DuctusRenderer;
import sun.java2d.pipe.ShapeDrawPipe;

public class DuctusShapeRenderer
extends DuctusRenderer
implements ShapeDrawPipe {
    CompositePipe outpipe;

    public DuctusShapeRenderer(CompositePipe compositePipe) {
        this.outpipe = compositePipe;
    }

    public void draw(SunGraphics2D sunGraphics2D, Shape shape) {
        BasicStroke basicStroke;
        if (sunGraphics2D.stroke instanceof BasicStroke) {
            basicStroke = (BasicStroke)sunGraphics2D.stroke;
        } else {
            shape = sunGraphics2D.stroke.createStrokedShape(shape);
            basicStroke = null;
        }
        this.renderPath(sunGraphics2D, shape, basicStroke);
    }

    public void fill(SunGraphics2D sunGraphics2D, Shape shape) {
        this.renderPath(sunGraphics2D, shape, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void renderPath(SunGraphics2D sunGraphics2D, Shape shape, BasicStroke basicStroke) {
        byte[] byArray;
        Object object;
        Rasterizer rasterizer;
        block16: {
            block15: {
                PathIterator pathIterator = shape.getPathIterator(sunGraphics2D.transform);
                boolean bl2 = basicStroke != null && sunGraphics2D.strokeHint != 2;
                boolean bl3 = sunGraphics2D.strokeState == 0;
                rasterizer = DuctusShapeRenderer.createShapeRasterizer(pathIterator, sunGraphics2D.transform, basicStroke, bl3, bl2, 0.5f);
                object = null;
                byArray = null;
                try {
                    try {
                        Rectangle rectangle;
                        int[] nArray;
                        block18: {
                            block17: {
                                nArray = new int[4];
                                rasterizer.getAlphaBox(nArray);
                                rectangle = new Rectangle(nArray[0], nArray[1], nArray[2] - nArray[0], nArray[3] - nArray[1]);
                                sunGraphics2D.getCompClip().clipBoxToBounds(nArray);
                                if (nArray[0] >= nArray[2]) break block17;
                                if (nArray[1] < nArray[3]) break block18;
                            }
                            Object var20_13 = null;
                            break block15;
                        }
                        rasterizer.setOutputArea(nArray[0], nArray[1], nArray[2] - nArray[0], nArray[3] - nArray[1]);
                        object = this.outpipe.startSequence(sunGraphics2D, shape, rectangle, nArray);
                        int n2 = Rasterizer.TILE_SIZE;
                        byArray = DuctusShapeRenderer.getAlphaTile();
                        for (int i2 = nArray[1]; i2 < nArray[3]; i2 += n2) {
                            for (int i3 = nArray[0]; i3 < nArray[2]; i3 += n2) {
                                byte[] byArray2;
                                int n3 = Math.min(n2, nArray[2] - i3);
                                int n4 = Math.min(n2, nArray[3] - i2);
                                int n5 = rasterizer.getTileState();
                                if (n5 == 0 || !this.outpipe.needTile(object, i3, i2, n3, n4)) {
                                    rasterizer.nextTile();
                                    this.outpipe.skipTile(object, i3, i2);
                                    continue;
                                }
                                if (n5 == 2) {
                                    byArray2 = byArray;
                                    DuctusShapeRenderer.getAlpha(rasterizer, byArray, 1, n2, 0);
                                } else {
                                    byArray2 = null;
                                    rasterizer.nextTile();
                                }
                                this.outpipe.renderPathTile(object, byArray2, 0, n2, i3, i2, n3, n4);
                            }
                        }
                        break block16;
                    }
                    catch (PRException pRException) {
                        pRException.printStackTrace();
                        Object var20_15 = null;
                        DuctusShapeRenderer.dropRasterizer(rasterizer);
                        if (object != null) {
                            this.outpipe.endSequence(object);
                        }
                        if (byArray == null) return;
                        DuctusShapeRenderer.dropAlphaTile(byArray);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var20_16 = null;
                    DuctusShapeRenderer.dropRasterizer(rasterizer);
                    if (object != null) {
                        this.outpipe.endSequence(object);
                    }
                    if (byArray == null) throw throwable;
                    DuctusShapeRenderer.dropAlphaTile(byArray);
                    throw throwable;
                }
            }
            DuctusShapeRenderer.dropRasterizer(rasterizer);
            if (object != null) {
                this.outpipe.endSequence(object);
            }
            if (byArray == null) return;
            DuctusShapeRenderer.dropAlphaTile(byArray);
            return;
        }
        Object var20_14 = null;
        DuctusShapeRenderer.dropRasterizer(rasterizer);
        if (object != null) {
            this.outpipe.endSequence(object);
        }
        if (byArray == null) return;
        DuctusShapeRenderer.dropAlphaTile(byArray);
    }
}

