/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Vector;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.CompositeView;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.BlockView;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.ParagraphView;
import javax.swing.text.html.StyleSheet;

class TableView
extends BoxView
implements ViewFactory {
    private AttributeSet attr;
    private StyleSheet.BoxPainter painter;
    private int cellSpacing;
    private int captionIndex = -1;
    private boolean relativeCells;
    private boolean multiRowCells;
    int[] columnSpans;
    int[] columnOffsets;
    SizeRequirements totalColumnRequirements;
    SizeRequirements[] columnRequirements;
    RowIterator rowIterator = new RowIterator(this);
    ColumnIterator colIterator = new ColumnIterator(this);
    Vector rows = new Vector();
    boolean gridValid = false;
    private static final BitSet EMPTY = new BitSet();

    public int getColumnCount() {
        return this.columnSpans.length;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    protected void invalidateGrid() {
        this.gridValid = false;
    }

    protected void setPropertiesFromAttributes() {
        StyleSheet styleSheet = this.getStyleSheet();
        this.attr = styleSheet.getViewAttributes(this);
        this.painter = styleSheet.getBoxPainter(this.attr);
        if (this.attr != null) {
            this.setInsets((short)this.painter.getInset(1, this), (short)this.painter.getInset(2, this), (short)this.painter.getInset(3, this), (short)this.painter.getInset(4, this));
        }
    }

    void updateGrid() {
        if (!this.gridValid) {
            int n2;
            Object object;
            int n3;
            this.relativeCells = false;
            this.multiRowCells = false;
            this.captionIndex = -1;
            this.rows.removeAllElements();
            int n4 = this.getViewCount();
            for (n3 = 0; n3 < n4; ++n3) {
                Object object2;
                View view = this.getView(n3);
                if (view instanceof RowView) {
                    this.rows.addElement(view);
                    object2 = (RowView)view;
                    ((RowView)object2).clearFilledColumns();
                    ((RowView)object2).rowIndex = this.rows.size() - 1;
                    ((RowView)object2).viewIndex = n3;
                    continue;
                }
                object2 = view.getElement().getAttributes().getAttribute(StyleConstants.NameAttribute);
                if (!(object2 instanceof HTML.Tag) || (object = (HTML.Tag)object2) != HTML.Tag.CAPTION) continue;
                this.captionIndex = n3;
            }
            n3 = 0;
            int n5 = this.rows.size();
            for (n2 = 0; n2 < n5; ++n2) {
                object = this.getRow(n2);
                int n6 = 0;
                int n7 = 0;
                while (n7 < ((CompositeView)object).getViewCount()) {
                    int n8;
                    AttributeSet attributeSet;
                    CSS.LengthValue lengthValue;
                    View view = ((CompositeView)object).getView(n7);
                    if (!this.relativeCells && (lengthValue = (CSS.LengthValue)(attributeSet = view.getAttributes()).getAttribute(CSS.Attribute.WIDTH)) != null && lengthValue.isPercentage()) {
                        this.relativeCells = true;
                    }
                    while (((RowView)object).isFilled(n6)) {
                        ++n6;
                    }
                    int n9 = this.getRowsOccupied(view);
                    if (n9 > 1) {
                        this.multiRowCells = true;
                    }
                    if ((n8 = this.getColumnsOccupied(view)) > 1 || n9 > 1) {
                        int n10 = n2 + n9;
                        int n11 = n6 + n8;
                        for (int i2 = n2; i2 < n10; ++i2) {
                            for (int i3 = n6; i3 < n11; ++i3) {
                                if (i2 == n2 && i3 == n6) continue;
                                this.addFill(i2, i3);
                            }
                        }
                        if (n8 > 1) {
                            n6 += n8 - 1;
                        }
                    }
                    ++n7;
                    ++n6;
                }
                n3 = Math.max(n3, n6);
            }
            this.columnSpans = new int[n3];
            this.columnOffsets = new int[n3];
            this.columnRequirements = new SizeRequirements[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                this.columnRequirements[n2] = new SizeRequirements();
                this.columnRequirements[n2].maximum = Integer.MAX_VALUE;
            }
            this.gridValid = true;
        }
    }

    void updateInsets() {
        short s2 = (short)this.painter.getInset(1, this);
        short s3 = (short)this.painter.getInset(3, this);
        if (this.captionIndex != -1) {
            View view = this.getView(this.captionIndex);
            short s4 = (short)view.getPreferredSpan(1);
            AttributeSet attributeSet = view.getAttributes();
            Object object = attributeSet.getAttribute(CSS.Attribute.CAPTION_SIDE);
            if (object != null && object.equals("bottom")) {
                s3 = (short)(s3 + s4);
            } else {
                s2 = (short)(s2 + s4);
            }
        }
        this.setInsets(s2, (short)this.painter.getInset(2, this), s3, (short)this.painter.getInset(4, this));
    }

    public int getColumnSpan(int n2) {
        if (n2 < this.columnSpans.length) {
            return this.columnSpans[n2];
        }
        return 0;
    }

    public int getRowSpan(int n2) {
        RowView rowView = this.getRow(n2);
        if (rowView != null) {
            return this.getSpan(1, rowView.viewIndex);
        }
        return 0;
    }

    void calculateColumnRequirements(int n2) {
        int n3;
        View view;
        int n4;
        int n5;
        int n6;
        RowView rowView;
        int n7;
        int n8;
        for (n8 = 0; n8 < this.columnRequirements.length; ++n8) {
            SizeRequirements sizeRequirements = this.columnRequirements[n8];
            sizeRequirements.minimum = 0;
            sizeRequirements.preferred = 0;
            sizeRequirements.maximum = Integer.MAX_VALUE;
        }
        n8 = 0;
        int n9 = this.getRowCount();
        for (n7 = 0; n7 < n9; ++n7) {
            rowView = this.getRow(n7);
            n6 = 0;
            n5 = rowView.getViewCount();
            n4 = 0;
            while (n4 < n5) {
                view = rowView.getView(n4);
                while (rowView.isFilled(n6)) {
                    ++n6;
                }
                n3 = this.getRowsOccupied(view);
                int n10 = this.getColumnsOccupied(view);
                if (n10 == 1) {
                    this.checkSingleColumnCell(n2, n6, view);
                } else {
                    n8 = 1;
                    n6 += n10 - 1;
                }
                ++n4;
                ++n6;
            }
        }
        if (n8 != 0) {
            for (n7 = 0; n7 < n9; ++n7) {
                rowView = this.getRow(n7);
                n6 = 0;
                n5 = rowView.getViewCount();
                n4 = 0;
                while (n4 < n5) {
                    view = rowView.getView(n4);
                    while (rowView.isFilled(n6)) {
                        ++n6;
                    }
                    n3 = this.getColumnsOccupied(view);
                    if (n3 > 1) {
                        this.checkMultiColumnCell(n2, n6, n3, view);
                        n6 += n3 - 1;
                    }
                    ++n4;
                    ++n6;
                }
            }
        }
    }

    public int getMultiRowSpan(int n2, int n3) {
        RowView rowView = this.getRow(n2);
        RowView rowView2 = this.getRow(n3);
        if (rowView != null && rowView2 != null) {
            int n4 = rowView.viewIndex;
            int n5 = rowView2.viewIndex;
            int n6 = this.getOffset(1, n5) - this.getOffset(1, n4) + this.getSpan(1, n5);
            return n6;
        }
        return 0;
    }

    void addFill(int n2, int n3) {
        RowView rowView = this.getRow(n2);
        if (rowView != null) {
            rowView.fillColumn(n3);
        }
    }

    protected void layoutMajorAxis(int n2, int n3, int[] nArray, int[] nArray2) {
        this.rowIterator.setLayoutArrays(nArray, nArray2);
        CSS.calculateTiledLayout(this.rowIterator, n2);
        if (this.captionIndex != -1) {
            int n4;
            View view = this.getView(this.captionIndex);
            nArray2[this.captionIndex] = n4 = (int)view.getPreferredSpan(1);
            short s2 = (short)this.painter.getInset(3, this);
            nArray[this.captionIndex] = s2 != this.getBottomInset() ? n2 + s2 : (int)(-this.getTopInset());
        }
    }

    protected void layoutMinorAxis(int n2, int n3, int[] nArray, int[] nArray2) {
        this.updateGrid();
        int n4 = this.getRowCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            RowView rowView = this.getRow(i2);
            rowView.layoutChanged(n3);
        }
        this.layoutColumns(n2, this.columnOffsets, this.columnSpans, this.columnRequirements);
        super.layoutMinorAxis(n2, n3, nArray, nArray2);
    }

    static BitSet access$300() {
        return EMPTY;
    }

    protected void layoutColumns(int n2, int[] nArray, int[] nArray2, SizeRequirements[] sizeRequirementsArray) {
        Arrays.fill(nArray, 0);
        Arrays.fill(nArray2, 0);
        this.colIterator.setLayoutArrays(nArray, nArray2, n2);
        CSS.calculateTiledLayout(this.colIterator, n2);
    }

    public AttributeSet getAttributes() {
        if (this.attr == null) {
            StyleSheet styleSheet = this.getStyleSheet();
            this.attr = styleSheet.getViewAttributes(this);
        }
        return this.attr;
    }

    public TableView(Element element) {
        super(element, 1);
        this.totalColumnRequirements = new SizeRequirements();
    }

    void checkMultiColumnCell(int n2, int n3, int n4, View view) {
        int n5;
        Object[] objectArray;
        SizeRequirements[] sizeRequirementsArray;
        int n6;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        for (n6 = 0; n6 < n4; ++n6) {
            sizeRequirementsArray = this.columnRequirements[n3 + n6];
            l2 += (long)sizeRequirementsArray.minimum;
            l3 += (long)sizeRequirementsArray.preferred;
            l4 += (long)sizeRequirementsArray.maximum;
        }
        n6 = (int)view.getMinimumSpan(n2);
        if ((long)n6 > l2) {
            sizeRequirementsArray = new SizeRequirements[n4];
            for (int i2 = 0; i2 < n4; ++i2) {
                sizeRequirementsArray[i2] = this.columnRequirements[n3 + i2];
            }
            objectArray = new int[n4];
            int[] nArray = new int[n4];
            SizeRequirements.calculateTiledPositions(n6, null, sizeRequirementsArray, nArray, objectArray);
            for (int i3 = 0; i3 < n4; ++i3) {
                SizeRequirements sizeRequirements = sizeRequirementsArray[i3];
                sizeRequirements.minimum = Math.max(objectArray[i3], sizeRequirements.minimum);
                sizeRequirements.preferred = Math.max(sizeRequirements.minimum, sizeRequirements.preferred);
                sizeRequirements.maximum = Math.max(sizeRequirements.preferred, sizeRequirements.maximum);
            }
        }
        if ((long)(n5 = (int)view.getPreferredSpan(n2)) > l3) {
            objectArray = new SizeRequirements[n4];
            for (int i4 = 0; i4 < n4; ++i4) {
                objectArray[i4] = (int)this.columnRequirements[n3 + i4];
            }
            int[] nArray = new int[n4];
            int[] nArray2 = new int[n4];
            SizeRequirements.calculateTiledPositions(n5, null, (SizeRequirements[])objectArray, nArray2, nArray);
            for (int i5 = 0; i5 < n4; ++i5) {
                int n7 = objectArray[i5];
                n7.preferred = Math.max(nArray[i5], n7.preferred);
                n7.maximum = Math.max(n7.preferred, n7.maximum);
            }
        }
    }

    void checkSingleColumnCell(int n2, int n3, View view) {
        SizeRequirements sizeRequirements = this.columnRequirements[n3];
        sizeRequirements.minimum = Math.max((int)view.getMinimumSpan(n2), sizeRequirements.minimum);
        sizeRequirements.preferred = Math.max((int)view.getPreferredSpan(n2), sizeRequirements.preferred);
    }

    public void replace(int n2, int n3, View[] viewArray) {
        super.replace(n2, n3, viewArray);
        this.invalidateGrid();
    }

    protected int getColumnsOccupied(View view) {
        String string;
        AttributeSet attributeSet = view.getElement().getAttributes();
        if (attributeSet.isDefined(HTML.Attribute.COLSPAN) && (string = (String)attributeSet.getAttribute(HTML.Attribute.COLSPAN)) != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1;
    }

    protected int getRowsOccupied(View view) {
        String string;
        AttributeSet attributeSet = view.getElement().getAttributes();
        if (attributeSet.isDefined(HTML.Attribute.ROWSPAN) && (string = (String)attributeSet.getAttribute(HTML.Attribute.ROWSPAN)) != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1;
    }

    public void setParent(View view) {
        super.setParent(view);
        if (view != null) {
            this.setPropertiesFromAttributes();
        }
    }

    public ViewFactory getViewFactory() {
        return this;
    }

    protected StyleSheet getStyleSheet() {
        HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
        return hTMLDocument.getStyleSheet();
    }

    static int access$100(TableView tableView) {
        return tableView.cellSpacing;
    }

    static boolean access$000(TableView tableView) {
        return tableView.relativeCells;
    }

    static boolean access$200(TableView tableView) {
        return tableView.multiRowCells;
    }

    RowView getRow(int n2) {
        if (n2 < this.rows.size()) {
            return (RowView)this.rows.elementAt(n2);
        }
        return null;
    }

    public void paint(Graphics graphics, Shape shape) {
        int n2;
        int n3;
        Rectangle rectangle = shape.getBounds();
        this.setSize(rectangle.width, rectangle.height);
        if (this.captionIndex != -1) {
            n3 = (int)this.painter.getInset(1, this);
            n2 = (int)this.painter.getInset(3, this);
            if (n3 != this.getTopInset()) {
                int n4 = this.getTopInset() - n3;
                rectangle.y += n4;
                rectangle.height -= n4;
            } else {
                rectangle.height -= this.getBottomInset() - n2;
            }
        }
        this.painter.paint(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this);
        n3 = this.getViewCount();
        for (n2 = 0; n2 < n3; ++n2) {
            View view = this.getView(n2);
            view.paint(graphics, this.getChildAllocation(n2, shape));
        }
    }

    protected SizeRequirements calculateMajorAxisRequirements(int n2, SizeRequirements sizeRequirements) {
        this.updateInsets();
        this.rowIterator.updateAdjustments();
        sizeRequirements = CSS.calculateTiledRequirements(this.rowIterator, sizeRequirements);
        sizeRequirements.maximum = sizeRequirements.preferred;
        return sizeRequirements;
    }

    protected SizeRequirements calculateMinorAxisRequirements(int n2, SizeRequirements sizeRequirements) {
        String string;
        Object object;
        int n3;
        this.updateGrid();
        this.calculateColumnRequirements(n2);
        if (sizeRequirements == null) {
            sizeRequirements = new SizeRequirements();
        }
        long l2 = 0L;
        long l3 = 0L;
        int n4 = this.columnRequirements.length;
        for (n3 = 0; n3 < n4; ++n3) {
            object = this.columnRequirements[n3];
            l2 += (long)((SizeRequirements)object).minimum;
            l3 += (long)((SizeRequirements)object).preferred;
        }
        n3 = (n4 - 1) * this.cellSpacing;
        sizeRequirements.minimum = (int)(l2 += (long)n3);
        sizeRequirements.preferred = (int)(l3 += (long)n3);
        sizeRequirements.maximum = (int)l3;
        object = this.getAttributes();
        CSS.LengthValue lengthValue = (CSS.LengthValue)object.getAttribute(CSS.Attribute.WIDTH);
        if (BlockView.spanSetFromAttributes(n2, sizeRequirements, lengthValue, null) && sizeRequirements.minimum < (int)l2) {
            sizeRequirements.minimum = sizeRequirements.preferred = (int)l2;
            sizeRequirements.maximum = sizeRequirements.preferred;
        }
        this.totalColumnRequirements.minimum = sizeRequirements.minimum;
        this.totalColumnRequirements.preferred = sizeRequirements.preferred;
        this.totalColumnRequirements.maximum = sizeRequirements.maximum;
        Object object2 = object.getAttribute(CSS.Attribute.TEXT_ALIGN);
        sizeRequirements.alignment = object2 != null ? ((string = object2.toString()).equals("left") ? 0.0f : (string.equals("center") ? 0.5f : (string.equals("right") ? 1.0f : 0.0f))) : 0.0f;
        return sizeRequirements;
    }

    protected View getViewAtPoint(int n2, int n3, Rectangle rectangle) {
        int n4 = this.getViewCount();
        View view = null;
        Rectangle rectangle2 = new Rectangle();
        for (int i2 = 0; i2 < n4; ++i2) {
            rectangle2.setBounds(rectangle);
            this.childAllocation(i2, rectangle2);
            view = this.getView(i2);
            if (!(view instanceof RowView) || (view = ((RowView)view).findViewAtPoint(n2, n3, rectangle2)) == null) continue;
            rectangle.setBounds(rectangle2);
            return view;
        }
        return super.getViewAtPoint(n2, n3, rectangle);
    }

    protected View getViewAtPosition(int n2, Rectangle rectangle) {
        int n3 = this.getViewCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            View view = this.getView(i2);
            int n4 = view.getStartOffset();
            int n5 = view.getEndOffset();
            if (n2 < n4 || n2 >= n5) continue;
            if (rectangle != null) {
                this.childAllocation(i2, rectangle);
            }
            return view;
        }
        if (n2 == this.getEndOffset()) {
            View view = this.getView(n3 - 1);
            if (rectangle != null) {
                this.childAllocation(n3 - 1, rectangle);
            }
            return view;
        }
        return null;
    }

    public View create(Element element) {
        ViewFactory viewFactory;
        Object object;
        Object object2 = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (object2 instanceof HTML.Tag) {
            object = (HTML.Tag)object2;
            if (object == HTML.Tag.TR) {
                return this.createTableRow(element);
            }
            if (object == HTML.Tag.TD || object == HTML.Tag.TH) {
                return new CellView(this, element);
            }
            if (object == HTML.Tag.CAPTION) {
                return new ParagraphView(element);
            }
        }
        if ((object = this.getParent()) != null && (viewFactory = ((View)object).getViewFactory()) != null) {
            return viewFactory.create(element);
        }
        return null;
    }

    protected RowView createTableRow(Element element) {
        Object object = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (object == HTML.Tag.TR) {
            return new RowView(this, element);
        }
        return null;
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.changedUpdate(documentEvent, shape, this);
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.insertUpdate(documentEvent, shape, this);
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.removeUpdate(documentEvent, shape, this);
    }

    protected void forwardUpdate(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Container container;
        super.forwardUpdate(elementChange, documentEvent, shape, viewFactory);
        if (shape != null && (container = this.getContainer()) != null) {
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    class CellView
    extends BlockView {
        private final TableView this$0;

        protected void layoutMajorAxis(int n2, int n3, int[] nArray, int[] nArray2) {
            int n4;
            super.layoutMajorAxis(n2, n3, nArray, nArray2);
            int n5 = 0;
            int n6 = nArray2.length;
            for (n4 = 0; n4 < n6; ++n4) {
                n5 += nArray2[n4];
            }
            n4 = 0;
            if (n5 < n2) {
                String string = (String)this.getElement().getAttributes().getAttribute(HTML.Attribute.VALIGN);
                if (string == null) {
                    AttributeSet attributeSet = this.getElement().getParentElement().getAttributes();
                    string = (String)attributeSet.getAttribute(HTML.Attribute.VALIGN);
                }
                if (string == null || string.equals("middle")) {
                    n4 = (n2 - n5) / 2;
                } else if (string.equals("bottom")) {
                    n4 = n2 - n5;
                }
            }
            if (n4 != 0) {
                int n7 = 0;
                while (n7 < n6) {
                    int n8 = n7++;
                    nArray[n8] = nArray[n8] + n4;
                }
            }
        }

        protected SizeRequirements calculateMajorAxisRequirements(int n2, SizeRequirements sizeRequirements) {
            SizeRequirements sizeRequirements2 = super.calculateMajorAxisRequirements(n2, sizeRequirements);
            sizeRequirements2.maximum = Integer.MAX_VALUE;
            return sizeRequirements2;
        }

        protected SizeRequirements calculateMinorAxisRequirements(int n2, SizeRequirements sizeRequirements) {
            SizeRequirements sizeRequirements2 = super.calculateMinorAxisRequirements(n2, sizeRequirements);
            int n3 = this.getViewCount();
            int n4 = 0;
            for (int i2 = 0; i2 < n3; ++i2) {
                View view = this.getView(i2);
                n4 = Math.max((int)view.getMinimumSpan(n2), n4);
            }
            sizeRequirements2.minimum = Math.min(sizeRequirements2.minimum, n4);
            return sizeRequirements2;
        }

        public CellView(TableView tableView, Element element) {
            this.this$0 = tableView;
            super(element, 1);
        }
    }

    class ColumnIterator
    implements CSS.LayoutIterator {
        private int col;
        private int[] percentages;
        private int[] adjustmentWeights;
        private int[] offsets;
        private int[] spans;
        private final TableView this$0;

        public float getLeadingCollapseSpan() {
            return TableView.access$100(this.this$0);
        }

        public float getTrailingCollapseSpan() {
            return TableView.access$100(this.this$0);
        }

        public int getAdjustmentWeight() {
            return this.adjustmentWeights[this.col];
        }

        public int getCount() {
            return this.this$0.columnRequirements.length;
        }

        public int getOffset() {
            return this.offsets[this.col];
        }

        public int getSpan() {
            return this.spans[this.col];
        }

        void disablePercentages() {
            this.percentages = null;
        }

        public float getMaximumSpan(float f2) {
            if (this.percentages != null && this.percentages[this.col] != 0) {
                return Math.max(this.percentages[this.col], this.this$0.columnRequirements[this.col].preferred);
            }
            return this.this$0.columnRequirements[this.col].maximum;
        }

        public float getMinimumSpan(float f2) {
            if (this.percentages != null && this.percentages[this.col] != 0) {
                return Math.max(this.percentages[this.col], this.this$0.columnRequirements[this.col].minimum);
            }
            return this.this$0.columnRequirements[this.col].minimum;
        }

        public float getPreferredSpan(float f2) {
            if (this.percentages != null && this.percentages[this.col] != 0) {
                return Math.max(this.percentages[this.col], this.this$0.columnRequirements[this.col].minimum);
            }
            return this.this$0.columnRequirements[this.col].preferred;
        }

        public void setIndex(int n2) {
            this.col = n2;
        }

        public void setOffset(int n2) {
            this.offsets[this.col] = n2;
        }

        public void setSpan(int n2) {
            this.spans[this.col] = n2;
        }

        private void updatePercentagesAndAdjustmentWeights(int n2) {
            int n3;
            this.adjustmentWeights = new int[this.this$0.columnRequirements.length];
            for (n3 = 0; n3 < this.this$0.columnRequirements.length; ++n3) {
                this.adjustmentWeights[n3] = 0;
            }
            this.percentages = (int[])(TableView.access$000(this.this$0) ? new int[this.this$0.columnRequirements.length] : null);
            n3 = this.this$0.getRowCount();
            for (int i2 = 0; i2 < n3; ++i2) {
                RowView rowView = this.this$0.getRow(i2);
                int n4 = 0;
                int n5 = rowView.getViewCount();
                int n6 = 0;
                while (n6 < n5) {
                    View view = rowView.getView(n6);
                    while (rowView.isFilled(n4)) {
                        ++n4;
                    }
                    int n7 = this.this$0.getRowsOccupied(view);
                    int n8 = this.this$0.getColumnsOccupied(view);
                    AttributeSet attributeSet = view.getAttributes();
                    CSS.LengthValue lengthValue = (CSS.LengthValue)attributeSet.getAttribute(CSS.Attribute.WIDTH);
                    if (lengthValue != null) {
                        int n9 = (int)(lengthValue.getValue(n2) / (float)n8 + 0.5f);
                        for (int i3 = 0; i3 < n8; ++i3) {
                            if (lengthValue.isPercentage()) {
                                this.percentages[n4 + i3] = Math.max(this.percentages[n4 + i3], n9);
                                this.adjustmentWeights[n4 + i3] = Math.max(this.adjustmentWeights[n4 + i3], 1);
                                continue;
                            }
                            this.adjustmentWeights[n4 + i3] = Math.max(this.adjustmentWeights[n4 + i3], 0);
                        }
                    }
                    n4 += n8 - 1;
                    ++n6;
                    ++n4;
                }
            }
        }

        public void setLayoutArrays(int[] nArray, int[] nArray2, int n2) {
            this.offsets = nArray;
            this.spans = nArray2;
            this.updatePercentagesAndAdjustmentWeights(n2);
        }

        ColumnIterator(TableView tableView) {
            this.this$0 = tableView;
        }
    }

    class RowIterator
    implements CSS.LayoutIterator {
        private int row;
        private int[] adjustments;
        private int[] offsets;
        private int[] spans;
        private final TableView this$0;

        public float getLeadingCollapseSpan() {
            return TableView.access$100(this.this$0);
        }

        public float getTrailingCollapseSpan() {
            return TableView.access$100(this.this$0);
        }

        public int getAdjustmentWeight() {
            return 0;
        }

        public int getCount() {
            return this.this$0.rows.size();
        }

        public int getOffset() {
            RowView rowView = this.this$0.getRow(this.row);
            if (rowView != null) {
                return this.offsets[rowView.viewIndex];
            }
            return 0;
        }

        public int getSpan() {
            RowView rowView = this.this$0.getRow(this.row);
            if (rowView != null) {
                return this.spans[rowView.viewIndex];
            }
            return 0;
        }

        void updateAdjustments() {
            int n2 = 1;
            if (TableView.access$200(this.this$0)) {
                int n3 = this.this$0.getRowCount();
                this.adjustments = new int[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    RowView rowView = this.this$0.getRow(i2);
                    if (!rowView.multiRowCells) continue;
                    int n4 = rowView.getViewCount();
                    for (int i3 = 0; i3 < n4; ++i3) {
                        View view = rowView.getView(i3);
                        int n5 = this.this$0.getRowsOccupied(view);
                        if (n5 <= 1) continue;
                        int n6 = (int)view.getPreferredSpan(n2);
                        this.adjustMultiRowSpan(n6, n5, i2);
                    }
                }
            } else {
                this.adjustments = null;
            }
        }

        public float getMaximumSpan(float f2) {
            return this.getPreferredSpan(f2);
        }

        public float getMinimumSpan(float f2) {
            return this.getPreferredSpan(f2);
        }

        public float getPreferredSpan(float f2) {
            RowView rowView = this.this$0.getRow(this.row);
            if (rowView != null) {
                int n2 = this.adjustments != null ? this.adjustments[this.row] : 0;
                return rowView.getPreferredSpan(this.this$0.getAxis()) + (float)(n2 += 2 * TableView.access$100(this.this$0));
            }
            return 0.0f;
        }

        public void setIndex(int n2) {
            this.row = n2;
        }

        public void setOffset(int n2) {
            RowView rowView = this.this$0.getRow(this.row);
            if (rowView != null) {
                this.offsets[rowView.viewIndex] = n2;
            }
        }

        public void setSpan(int n2) {
            RowView rowView = this.this$0.getRow(this.row);
            if (rowView != null) {
                this.spans[rowView.viewIndex] = n2;
            }
        }

        void adjustMultiRowSpan(int n2, int n3, int n4) {
            int n5;
            if (n4 + n3 > this.getCount() && (n3 = this.getCount() - n4) < 1) {
                return;
            }
            int n6 = 0;
            for (n5 = 0; n5 < n3; ++n5) {
                RowView rowView = this.this$0.getRow(n4 + n5);
                n6 = (int)((float)n6 + rowView.getPreferredSpan(1));
            }
            if (n2 > n6) {
                n5 = n2 - n6;
                int n7 = n5 / n3;
                int n8 = n7 + (n5 - n7 * n3);
                RowView rowView = this.this$0.getRow(n4);
                this.adjustments[n4] = Math.max(this.adjustments[n4], n8);
                for (int i2 = 1; i2 < n3; ++i2) {
                    this.adjustments[n4 + i2] = Math.max(this.adjustments[n4 + i2], n7);
                }
            }
        }

        void setLayoutArrays(int[] nArray, int[] nArray2) {
            this.offsets = nArray;
            this.spans = nArray2;
        }

        RowIterator(TableView tableView) {
            this.this$0 = tableView;
        }
    }

    public class RowView
    extends BoxView {
        private StyleSheet.BoxPainter painter;
        private AttributeSet attr;
        BitSet fillColumns;
        int rowIndex;
        int viewIndex;
        boolean multiRowCells;
        private final TableView this$0;

        int getColumnCount() {
            int n2 = 0;
            int n3 = this.fillColumns.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                if (!this.fillColumns.get(i2)) continue;
                ++n2;
            }
            return this.getViewCount() + n2;
        }

        void clearFilledColumns() {
            this.fillColumns.and(TableView.access$300());
        }

        void setPropertiesFromAttributes() {
            StyleSheet styleSheet = this.getStyleSheet();
            this.attr = styleSheet.getViewAttributes(this);
            this.painter = styleSheet.getBoxPainter(this.attr);
        }

        public float getMaximumSpan(int n2) {
            float f2 = n2 == 0 ? 2.1474836E9f : super.getMaximumSpan(n2);
            return f2;
        }

        public float getMinimumSpan(int n2) {
            float f2 = n2 == 0 ? (float)(this.this$0.totalColumnRequirements.minimum + this.getLeftInset() + this.getRightInset()) : super.getMinimumSpan(n2);
            return f2;
        }

        public float getPreferredSpan(int n2) {
            float f2 = n2 == 0 ? (float)(this.this$0.totalColumnRequirements.preferred + this.getLeftInset() + this.getRightInset()) : super.getPreferredSpan(n2);
            return f2;
        }

        public int getResizeWeight(int n2) {
            return 1;
        }

        void fillColumn(int n2) {
            this.fillColumns.set(n2);
        }

        boolean isFilled(int n2) {
            return this.fillColumns.get(n2);
        }

        protected void layoutMajorAxis(int n2, int n3, int[] nArray, int[] nArray2) {
            int n4 = 0;
            int n5 = this.getViewCount();
            int n6 = 0;
            while (n6 < n5) {
                View view = this.getView(n6);
                while (this.isFilled(n4)) {
                    ++n4;
                }
                int n7 = this.this$0.getColumnsOccupied(view);
                nArray2[n6] = this.this$0.columnSpans[n4];
                nArray[n6] = this.this$0.columnOffsets[n4];
                if (n7 > 1) {
                    int n8 = this.this$0.columnSpans.length;
                    for (int i2 = 1; i2 < n7; ++i2) {
                        if (n4 + i2 >= n8) continue;
                        int n9 = n6;
                        nArray2[n9] = nArray2[n9] + this.this$0.columnSpans[n4 + i2];
                    }
                    n4 += n7 - 1;
                }
                ++n6;
                ++n4;
            }
        }

        protected void layoutMinorAxis(int n2, int n3, int[] nArray, int[] nArray2) {
            super.layoutMinorAxis(n2, n3, nArray, nArray2);
            int n4 = 0;
            int n5 = this.getViewCount();
            int n6 = 0;
            while (n6 < n5) {
                View view = this.getView(n6);
                while (this.isFilled(n4)) {
                    ++n4;
                }
                int n7 = this.this$0.getColumnsOccupied(view);
                int n8 = this.this$0.getRowsOccupied(view);
                if (n8 > 1) {
                    int n9 = this.rowIndex;
                    int n10 = Math.min(this.rowIndex + n8 - 1, this.this$0.getRowCount() - 1);
                    nArray2[n6] = this.this$0.getMultiRowSpan(n9, n10);
                }
                if (n7 > 1) {
                    n4 += n7 - 1;
                }
                ++n6;
                ++n4;
            }
        }

        public AttributeSet getAttributes() {
            return this.attr;
        }

        public void replace(int n2, int n3, View[] viewArray) {
            super.replace(n2, n3, viewArray);
            this.this$0.invalidateGrid();
        }

        public void preferenceChanged(View view, boolean bl2, boolean bl3) {
            super.preferenceChanged(view, bl2, bl3);
            if (TableView.access$200(this.this$0) && bl3) {
                for (int i2 = this.rowIndex - 1; i2 >= 0; --i2) {
                    RowView rowView = this.this$0.getRow(i2);
                    if (!rowView.multiRowCells) continue;
                    rowView.preferenceChanged(null, false, true);
                    break;
                }
            }
        }

        protected StyleSheet getStyleSheet() {
            HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
            return hTMLDocument.getStyleSheet();
        }

        public void paint(Graphics graphics, Shape shape) {
            Rectangle rectangle = (Rectangle)shape;
            this.painter.paint(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this);
            super.paint(graphics, rectangle);
        }

        protected SizeRequirements calculateMajorAxisRequirements(int n2, SizeRequirements sizeRequirements) {
            SizeRequirements sizeRequirements2 = new SizeRequirements();
            sizeRequirements2.minimum = this.this$0.totalColumnRequirements.minimum;
            sizeRequirements2.maximum = this.this$0.totalColumnRequirements.maximum;
            sizeRequirements2.preferred = this.this$0.totalColumnRequirements.preferred;
            sizeRequirements2.alignment = 0.0f;
            return sizeRequirements2;
        }

        protected SizeRequirements calculateMinorAxisRequirements(int n2, SizeRequirements sizeRequirements) {
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            this.multiRowCells = false;
            int n3 = this.getViewCount();
            for (int i2 = 0; i2 < n3; ++i2) {
                View view = this.getView(i2);
                if (this.this$0.getRowsOccupied(view) > 1) {
                    this.multiRowCells = true;
                    l4 = Math.max((long)((int)view.getMaximumSpan(n2)), l4);
                    continue;
                }
                l2 = Math.max((long)((int)view.getMinimumSpan(n2)), l2);
                l3 = Math.max((long)((int)view.getPreferredSpan(n2)), l3);
                l4 = Math.max((long)((int)view.getMaximumSpan(n2)), l4);
            }
            if (sizeRequirements == null) {
                sizeRequirements = new SizeRequirements();
                sizeRequirements.alignment = 0.5f;
            }
            sizeRequirements.preferred = (int)l3;
            sizeRequirements.minimum = (int)l2;
            sizeRequirements.maximum = (int)l4;
            return sizeRequirements;
        }

        public RowView(TableView tableView, Element element) {
            this.this$0 = tableView;
            super(element, 0);
            this.fillColumns = new BitSet();
            this.setPropertiesFromAttributes();
        }

        View findViewAtPoint(int n2, int n3, Rectangle rectangle) {
            int n4 = this.getViewCount();
            for (int i2 = 0; i2 < n4; ++i2) {
                if (!this.getChildAllocation(i2, rectangle).contains(n2, n3)) continue;
                this.childAllocation(i2, rectangle);
                return this.getView(i2);
            }
            return null;
        }

        protected View getViewAtPosition(int n2, Rectangle rectangle) {
            int n3 = this.getViewCount();
            for (int i2 = 0; i2 < n3; ++i2) {
                View view = this.getView(i2);
                int n4 = view.getStartOffset();
                int n5 = view.getEndOffset();
                if (n2 < n4 || n2 >= n5) continue;
                if (rectangle != null) {
                    this.childAllocation(i2, rectangle);
                }
                return view;
            }
            if (n2 == this.getEndOffset()) {
                View view = this.getView(n3 - 1);
                if (rectangle != null) {
                    this.childAllocation(n3 - 1, rectangle);
                }
                return view;
            }
            return null;
        }

        public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            super.changedUpdate(documentEvent, shape, viewFactory);
            int n2 = documentEvent.getOffset();
            if (n2 <= this.getStartOffset() && n2 + documentEvent.getLength() >= this.getEndOffset()) {
                this.setPropertiesFromAttributes();
            }
        }
    }
}

