/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.basic.BasicFileChooserUI;
import sun.awt.shell.ShellFolder;

public class BasicDirectoryModel
extends AbstractListModel
implements PropertyChangeListener {
    private JFileChooser filechooser = null;
    private Vector fileCache = new Vector(50);
    private LoadFilesThread loadThread = null;
    private Vector files = null;
    private Vector directories = null;
    private int fetchID = 0;

    public int getSize() {
        return this.fileCache.size();
    }

    public void fireContentsChanged() {
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    public void invalidateFileCache() {
        if (this.loadThread != null) {
            this.loadThread.interrupt();
            LoadFilesThread.access$000(this.loadThread);
            this.loadThread = null;
        }
    }

    public void validateFileCache() {
        File file = this.filechooser.getCurrentDirectory();
        if (file == null) {
            return;
        }
        if (this.loadThread != null) {
            this.loadThread.interrupt();
            LoadFilesThread.access$000(this.loadThread);
        }
        ++this.fetchID;
        this.loadThread = new LoadFilesThread(this, file, this.fetchID);
        this.loadThread.start();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == "directoryChanged" || string == "fileViewChanged" || string == "fileFilterChanged" || string == "FileHidingChanged" || string == "fileSelectionChanged") {
            this.validateFileCache();
        } else if ("UI".equals(string)) {
            BasicFileChooserUI basicFileChooserUI;
            BasicDirectoryModel basicDirectoryModel;
            Object object = propertyChangeEvent.getOldValue();
            if (object instanceof BasicFileChooserUI && (basicDirectoryModel = (basicFileChooserUI = (BasicFileChooserUI)object).getModel()) != null) {
                basicDirectoryModel.invalidateFileCache();
            }
        } else if ("JFileChooserDialogIsClosingProperty".equals(string)) {
            this.invalidateFileCache();
        }
    }

    public Object getElementAt(int n2) {
        return this.fileCache.get(n2);
    }

    public int indexOf(Object object) {
        return this.fileCache.indexOf(object);
    }

    public boolean contains(Object object) {
        return this.fileCache.contains(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getDirectories() {
        Vector vector = this.fileCache;
        synchronized (vector) {
            if (this.directories != null) {
                return this.directories;
            }
            Vector vector2 = this.getFiles();
            return this.directories;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getFiles() {
        Vector vector = this.fileCache;
        synchronized (vector) {
            if (this.files != null) {
                return this.files;
            }
            this.files = new Vector();
            this.directories = new Vector();
            this.directories.addElement(this.filechooser.getFileSystemView().createFileObject(this.filechooser.getCurrentDirectory(), ".."));
            for (int i2 = 0; i2 < this.getSize(); ++i2) {
                File file = (File)this.fileCache.get(i2);
                if (this.filechooser.isTraversable(file)) {
                    this.directories.add(file);
                    continue;
                }
                this.files.add(file);
            }
            return this.files;
        }
    }

    protected void sort(Vector vector) {
        ShellFolder.sortFiles(vector);
    }

    public BasicDirectoryModel(JFileChooser jFileChooser) {
        this.filechooser = jFileChooser;
        this.validateFileCache();
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
    }

    static int access$300(BasicDirectoryModel basicDirectoryModel) {
        return basicDirectoryModel.fetchID;
    }

    protected boolean lt(File file, File file2) {
        int n2 = file.getName().toLowerCase().compareTo(file2.getName().toLowerCase());
        if (n2 != 0) {
            return n2 < 0;
        }
        return file.getName().compareTo(file2.getName()) < 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renameFile(File file, File file2) {
        Vector vector = this.fileCache;
        synchronized (vector) {
            if (file.renameTo(file2)) {
                this.validateFileCache();
                return true;
            }
            return false;
        }
    }

    static void access$600(BasicDirectoryModel basicDirectoryModel, Object object, int n2, int n3) {
        basicDirectoryModel.fireIntervalRemoved(object, n2, n3);
    }

    static void access$700(BasicDirectoryModel basicDirectoryModel, Object object, int n2, int n3) {
        basicDirectoryModel.fireIntervalAdded(object, n2, n3);
    }

    static Vector access$200(BasicDirectoryModel basicDirectoryModel) {
        return basicDirectoryModel.fileCache;
    }

    static JFileChooser access$100(BasicDirectoryModel basicDirectoryModel) {
        return basicDirectoryModel.filechooser;
    }

    static Vector access$402(BasicDirectoryModel basicDirectoryModel, Vector vector) {
        basicDirectoryModel.files = vector;
        return basicDirectoryModel.files;
    }

    static Vector access$502(BasicDirectoryModel basicDirectoryModel, Vector vector) {
        basicDirectoryModel.directories = vector;
        return basicDirectoryModel.directories;
    }

    class DoChangeContents
    implements Runnable {
        private List addFiles;
        private List remFiles;
        private boolean doFire;
        private int fid;
        private int addStart;
        private int remStart;
        private int change;
        private final BasicDirectoryModel this$0;

        synchronized void cancel() {
            this.doFire = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            if (BasicDirectoryModel.access$300(this.this$0) == this.fid && this.doFire) {
                int n2 = this.remFiles == null ? 0 : this.remFiles.size();
                int n3 = this.addFiles == null ? 0 : this.addFiles.size();
                Vector vector = BasicDirectoryModel.access$200(this.this$0);
                synchronized (vector) {
                    if (n2 > 0) {
                        BasicDirectoryModel.access$200(this.this$0).removeAll(this.remFiles);
                    }
                    if (n3 > 0) {
                        BasicDirectoryModel.access$200(this.this$0).addAll(this.addStart, this.addFiles);
                    }
                    BasicDirectoryModel.access$402(this.this$0, null);
                    BasicDirectoryModel.access$502(this.this$0, null);
                }
                if (n2 > 0 && n3 == 0) {
                    BasicDirectoryModel.access$600(this.this$0, this.this$0, this.remStart, this.remStart + n2 - 1);
                } else if (n3 > 0 && n2 == 0 && BasicDirectoryModel.access$200(this.this$0).size() > n3) {
                    BasicDirectoryModel.access$700(this.this$0, this.this$0, this.addStart, this.addStart + n3 - 1);
                } else {
                    this.this$0.fireContentsChanged();
                }
            }
        }

        public DoChangeContents(BasicDirectoryModel basicDirectoryModel, List list, int n2, List list2, int n3, int n4) {
            this.this$0 = basicDirectoryModel;
            this.doFire = true;
            this.addStart = 0;
            this.remStart = 0;
            this.addFiles = list;
            this.addStart = n2;
            this.remFiles = list2;
            this.remStart = n3;
            this.fid = n4;
        }
    }

    class LoadFilesThread
    extends Thread {
        File currentDirectory;
        int fid;
        Vector runnables;
        private final BasicDirectoryModel this$0;

        private void cancelRunnables() {
            this.cancelRunnables(this.runnables);
        }

        public void run() {
            int n2;
            FileSystemView fileSystemView = BasicDirectoryModel.access$100(this.this$0).getFileSystemView();
            File[] fileArray = fileSystemView.getFiles(this.currentDirectory, BasicDirectoryModel.access$100(this.this$0).isFileHidingEnabled());
            Vector vector = new Vector();
            if (this.isInterrupted()) {
                return;
            }
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                if (!BasicDirectoryModel.access$100(this.this$0).accept(fileArray[i2])) continue;
                vector.addElement(fileArray[i2]);
            }
            if (this.isInterrupted()) {
                return;
            }
            this.this$0.sort(vector);
            Vector vector2 = new Vector(50);
            Vector vector3 = new Vector();
            for (int i3 = 0; i3 < vector.size(); ++i3) {
                File file = (File)vector.elementAt(i3);
                n2 = BasicDirectoryModel.access$100(this.this$0).isTraversable(file);
                if (n2 != 0) {
                    vector2.addElement(file);
                } else if (n2 == 0 && BasicDirectoryModel.access$100(this.this$0).isFileSelectionEnabled()) {
                    vector3.addElement(file);
                }
                if (!this.isInterrupted()) continue;
                return;
            }
            Vector vector4 = new Vector(vector2);
            vector4.addAll(vector3);
            int n3 = vector4.size();
            n2 = BasicDirectoryModel.access$200(this.this$0).size();
            if (n3 > n2) {
                int n4 = n2;
                int n5 = n3;
                block2: for (int i4 = 0; i4 < n2; ++i4) {
                    if (vector4.get(i4).equals(BasicDirectoryModel.access$200(this.this$0).get(i4))) continue;
                    n4 = i4;
                    for (int i5 = i4; i5 < n3; ++i5) {
                        if (!vector4.get(i5).equals(BasicDirectoryModel.access$200(this.this$0).get(i4))) continue;
                        n5 = i5;
                        break block2;
                    }
                    break;
                }
                if (n4 >= 0 && n5 > n4 && ((Object)vector4.subList(n5, n3)).equals(BasicDirectoryModel.access$200(this.this$0).subList(n4, n2))) {
                    this.invokeLater(new DoChangeContents(this.this$0, vector4.subList(n4, n5), n4, null, 0, this.fid));
                    vector4 = null;
                }
            } else if (n3 < n2) {
                int n6 = -1;
                int n7 = -1;
                for (int i6 = 0; i6 < n3; ++i6) {
                    if (vector4.get(i6).equals(BasicDirectoryModel.access$200(this.this$0).get(i6))) continue;
                    n6 = i6;
                    n7 = i6 + n2 - n3;
                    break;
                }
                if (n6 >= 0 && n7 > n6 && ((Object)BasicDirectoryModel.access$200(this.this$0).subList(n7, n2)).equals(vector4.subList(n6, n3))) {
                    this.invokeLater(new DoChangeContents(this.this$0, null, 0, new Vector(BasicDirectoryModel.access$200(this.this$0).subList(n6, n7)), n6, this.fid));
                    vector4 = null;
                }
            }
            if (vector4 != null && !BasicDirectoryModel.access$200(this.this$0).equals(vector4)) {
                this.invokeLater(new DoChangeContents(this.this$0, vector4, 0, BasicDirectoryModel.access$200(this.this$0), 0, this.fid));
            }
            if (this.isInterrupted()) {
                this.cancelRunnables(this.runnables);
            }
        }

        private void invokeLater(Runnable runnable) {
            this.runnables.addElement(runnable);
            SwingUtilities.invokeLater(runnable);
        }

        public void cancelRunnables(Vector vector) {
            for (int i2 = 0; i2 < vector.size(); ++i2) {
                ((DoChangeContents)vector.elementAt(i2)).cancel();
            }
        }

        static void access$000(LoadFilesThread loadFilesThread) {
            loadFilesThread.cancelRunnables();
        }

        public LoadFilesThread(BasicDirectoryModel basicDirectoryModel, File file, int n2) {
            this.this$0 = basicDirectoryModel;
            super("Basic L&F File Loading Thread");
            this.currentDirectory = null;
            this.runnables = new Vector(10);
            this.currentDirectory = file;
            this.fid = n2;
        }
    }
}

