/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PermissionsEnumerator;
import java.security.PermissionsHash;
import java.security.UnresolvedPermission;
import java.security.UnresolvedPermissionCollection;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public final class Permissions
extends PermissionCollection
implements Serializable {
    private transient Map permsMap = new HashMap(11);
    private transient boolean hasUnresolved = false;
    private PermissionCollection allPermission = null;
    private static final long serialVersionUID = 4858622370623524688L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("perms", class$java$util$Hashtable == null ? (class$java$util$Hashtable = Permissions.class$("java.util.Hashtable")) : class$java$util$Hashtable), new ObjectStreamField("allPermission", class$java$security$PermissionCollection == null ? (class$java$security$PermissionCollection = Permissions.class$("java.security.PermissionCollection")) : class$java$security$PermissionCollection)};
    static Class class$java$security$UnresolvedPermission;
    static Class class$java$util$Hashtable;
    static Class class$java$security$PermissionCollection;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.allPermission = (PermissionCollection)getField.get("allPermission", null);
        Hashtable hashtable = (Hashtable)getField.get("perms", null);
        this.permsMap = new HashMap(hashtable.size() * 2);
        this.permsMap.putAll(hashtable);
        UnresolvedPermissionCollection unresolvedPermissionCollection = (UnresolvedPermissionCollection)this.permsMap.get(class$java$security$UnresolvedPermission == null ? (class$java$security$UnresolvedPermission = Permissions.class$("java.security.UnresolvedPermission")) : class$java$security$UnresolvedPermission);
        this.hasUnresolved = unresolvedPermissionCollection != null && unresolvedPermissionCollection.elements().hasMoreElements();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Hashtable hashtable = new Hashtable(this.permsMap.size() * 2);
        hashtable.putAll(this.permsMap);
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("allPermission", this.allPermission);
        putField.put("perms", hashtable);
        objectOutputStream.writeFields();
    }

    public void add(Permission permission) {
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly Permissions object");
        }
        PermissionCollection permissionCollection = this.getPermissionCollection(permission, true);
        permissionCollection.add(permission);
        if (permission instanceof AllPermission) {
            this.allPermission = permissionCollection;
        }
        if (permission instanceof UnresolvedPermission) {
            this.hasUnresolved = true;
        }
    }

    public boolean implies(Permission permission) {
        if (this.allPermission != null) {
            return true;
        }
        PermissionCollection permissionCollection = this.getPermissionCollection(permission, false);
        if (permissionCollection != null) {
            return permissionCollection.implies(permission);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration elements() {
        if (this.hasUnresolved) {
            ArrayList arrayList = new ArrayList();
            Map map = this.permsMap;
            synchronized (map) {
                arrayList.addAll(this.permsMap.values());
            }
            return new PermissionsEnumerator(arrayList.iterator());
        }
        return new PermissionsEnumerator(this.permsMap.values().iterator());
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private PermissionCollection getUnresolvedPermissions(Permission permission) {
        UnresolvedPermissionCollection unresolvedPermissionCollection = (UnresolvedPermissionCollection)this.permsMap.get(class$java$security$UnresolvedPermission == null ? (class$java$security$UnresolvedPermission = Permissions.class$("java.security.UnresolvedPermission")) : class$java$security$UnresolvedPermission);
        if (unresolvedPermissionCollection == null) {
            return null;
        }
        List list = unresolvedPermissionCollection.getUnresolvedPermissions(permission);
        if (list == null) {
            return null;
        }
        Certificate[] certificateArray = null;
        Object[] objectArray = permission.getClass().getSigners();
        int n2 = 0;
        if (objectArray != null) {
            int n3;
            for (n3 = 0; n3 < objectArray.length; ++n3) {
                if (!(objectArray[n3] instanceof Certificate)) continue;
                ++n2;
            }
            certificateArray = new Certificate[n2];
            n2 = 0;
            for (n3 = 0; n3 < objectArray.length; ++n3) {
                if (!(objectArray[n3] instanceof Certificate)) continue;
                certificateArray[n2++] = (Certificate)objectArray[n3];
            }
        }
        PermissionCollection permissionCollection = null;
        int n4 = list.size();
        for (int i2 = 0; i2 < n4; ++i2) {
            UnresolvedPermission unresolvedPermission = (UnresolvedPermission)list.get(i2);
            Permission permission2 = unresolvedPermission.resolve(permission, certificateArray);
            if (permission2 == null) continue;
            if (permissionCollection == null && (permissionCollection = permission.newPermissionCollection()) == null) {
                permissionCollection = new PermissionsHash();
            }
            permissionCollection.add(permission2);
        }
        return permissionCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PermissionCollection getPermissionCollection(Permission permission, boolean bl2) {
        Class clazz = permission.getClass();
        if (!this.hasUnresolved && !bl2) {
            return (PermissionCollection)this.permsMap.get(clazz);
        }
        PermissionCollection permissionCollection = null;
        Map map = this.permsMap;
        synchronized (map) {
            permissionCollection = (PermissionCollection)this.permsMap.get(clazz);
            if (permissionCollection == null) {
                PermissionCollection permissionCollection2 = permissionCollection = this.hasUnresolved ? this.getUnresolvedPermissions(permission) : null;
                if (permissionCollection == null && bl2 && (permissionCollection = permission.newPermissionCollection()) == null) {
                    permissionCollection = new PermissionsHash();
                }
                if (permissionCollection != null) {
                    this.permsMap.put(clazz, permissionCollection);
                }
            }
        }
        return permissionCollection;
    }
}

