/*
 * Decompiled with CFR 0.152.
 */
package java.nio.charset;

import java.lang.ref.WeakReference;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.util.HashMap;
import java.util.Map;

public class CoderResult {
    private static final int CR_UNDERFLOW = 0;
    private static final int CR_OVERFLOW = 1;
    private static final int CR_ERROR_MIN = 2;
    private static final int CR_MALFORMED = 2;
    private static final int CR_UNMAPPABLE = 3;
    private static final String[] names;
    private final int type;
    private final int length;
    public static final CoderResult UNDERFLOW;
    public static final CoderResult OVERFLOW;
    private static Cache malformedCache;
    private static Cache unmappableCache;
    static final boolean $assertionsDisabled;
    static Class class$java$nio$charset$CoderResult;

    public int length() {
        if (!this.isError()) {
            throw new UnsupportedOperationException();
        }
        return this.length;
    }

    static {
        $assertionsDisabled = !(class$java$nio$charset$CoderResult == null ? (class$java$nio$charset$CoderResult = CoderResult.class$("java.nio.charset.CoderResult")) : class$java$nio$charset$CoderResult).desiredAssertionStatus();
        names = new String[]{"UNDERFLOW", "OVERFLOW", "MALFORMED", "UNMAPPABLE"};
        UNDERFLOW = new CoderResult(0, 0);
        OVERFLOW = new CoderResult(1, 0);
        malformedCache = new Cache(){

            public CoderResult create(int n2) {
                return new CoderResult(2, n2, null);
            }
        };
        unmappableCache = new Cache(){

            public CoderResult create(int n2) {
                return new CoderResult(3, n2, null);
            }
        };
    }

    public void throwException() throws CharacterCodingException {
        switch (this.type) {
            case 0: {
                throw new BufferUnderflowException();
            }
            case 1: {
                throw new BufferOverflowException();
            }
            case 2: {
                throw new MalformedInputException(this.length);
            }
            case 3: {
                throw new UnmappableCharacterException(this.length);
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public boolean isError() {
        return this.type >= 2;
    }

    public boolean isMalformed() {
        return this.type == 2;
    }

    public boolean isOverflow() {
        return this.type == 1;
    }

    public boolean isUnderflow() {
        return this.type == 0;
    }

    public boolean isUnmappable() {
        return this.type == 3;
    }

    private CoderResult(int n2, int n3) {
        this.type = n2;
        this.length = n3;
    }

    public String toString() {
        String string = names[this.type];
        return this.isError() ? string + "[" + this.length + "]" : string;
    }

    public static CoderResult malformedForLength(int n2) {
        return Cache.access$200(malformedCache, n2);
    }

    public static CoderResult unmappableForLength(int n2) {
        return Cache.access$200(unmappableCache, n2);
    }

    CoderResult(int n2, int n3, 1 var3_3) {
        this(n2, n3);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private static abstract class Cache {
        private Map cache = null;

        private Cache() {
        }

        protected abstract CoderResult create(int var1);

        private synchronized CoderResult get(int n2) {
            if (n2 <= 0) {
                throw new IllegalArgumentException("Non-positive length");
            }
            Integer n3 = new Integer(n2);
            CoderResult coderResult = null;
            if (this.cache == null) {
                this.cache = new HashMap();
            } else {
                WeakReference weakReference = (WeakReference)this.cache.get(n3);
                if (weakReference != null) {
                    coderResult = (CoderResult)weakReference.get();
                }
            }
            if (coderResult == null) {
                coderResult = this.create(n2);
                this.cache.put(n3, new WeakReference(coderResult));
            }
            return coderResult;
        }

        Cache(1 var1_1) {
            this();
        }

        static CoderResult access$200(Cache cache, int n2) {
            return cache.get(n2);
        }
    }
}

