/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.HeapFloatBufferR;

class HeapFloatBuffer
extends FloatBuffer {
    public float get() {
        return this.hb[this.ix(this.nextGetIndex())];
    }

    public boolean isDirect() {
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    public float get(int n2) {
        return this.hb[this.ix(this.checkIndex(n2))];
    }

    protected int ix(int n2) {
        return n2 + this.offset;
    }

    HeapFloatBuffer(int n2, int n3) {
        super(-1, 0, n3, n2, new float[n2], 0);
    }

    HeapFloatBuffer(float[] fArray, int n2, int n3) {
        super(-1, n2, n2 + n3, fArray.length, fArray, 0);
    }

    protected HeapFloatBuffer(float[] fArray, int n2, int n3, int n4, int n5, int n6) {
        super(n2, n3, n4, n5, fArray, n6);
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }

    public FloatBuffer asReadOnlyBuffer() {
        return new HeapFloatBufferR(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    public FloatBuffer compact() {
        System.arraycopy(this.hb, this.ix(this.position()), this.hb, this.ix(0), this.remaining());
        this.position(this.remaining());
        this.limit(this.capacity());
        return this;
    }

    public FloatBuffer duplicate() {
        return new HeapFloatBuffer(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    public FloatBuffer slice() {
        return new HeapFloatBuffer(this.hb, -1, 0, this.remaining(), this.remaining(), this.position() + this.offset);
    }

    public FloatBuffer put(float f2) {
        this.hb[this.ix((int)this.nextPutIndex())] = f2;
        return this;
    }

    public FloatBuffer put(int n2, float f2) {
        this.hb[this.ix((int)this.checkIndex((int)n2))] = f2;
        return this;
    }

    public FloatBuffer get(float[] fArray, int n2, int n3) {
        HeapFloatBuffer.checkBounds(n2, n3, fArray.length);
        if (n3 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.hb, this.ix(this.position()), fArray, n2, n3);
        this.position(this.position() + n3);
        return this;
    }

    public FloatBuffer put(float[] fArray, int n2, int n3) {
        HeapFloatBuffer.checkBounds(n2, n3, fArray.length);
        if (n3 > this.remaining()) {
            throw new BufferOverflowException();
        }
        System.arraycopy(fArray, n2, this.hb, this.ix(this.position()), n3);
        this.position(this.position() + n3);
        return this;
    }

    public FloatBuffer put(FloatBuffer floatBuffer) {
        if (floatBuffer instanceof HeapFloatBuffer) {
            if (floatBuffer == this) {
                throw new IllegalArgumentException();
            }
            HeapFloatBuffer heapFloatBuffer = (HeapFloatBuffer)floatBuffer;
            int n2 = heapFloatBuffer.remaining();
            if (n2 > this.remaining()) {
                throw new BufferOverflowException();
            }
            System.arraycopy(heapFloatBuffer.hb, heapFloatBuffer.ix(heapFloatBuffer.position()), this.hb, this.ix(this.position()), n2);
            heapFloatBuffer.position(heapFloatBuffer.position() + n2);
            this.position(this.position() + n2);
        } else if (floatBuffer.isDirect()) {
            int n3 = floatBuffer.remaining();
            if (n3 > this.remaining()) {
                throw new BufferOverflowException();
            }
            floatBuffer.get(this.hb, this.ix(this.position()), n3);
            this.position(this.position() + n3);
        } else {
            super.put(floatBuffer);
        }
        return this;
    }
}

