/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.HeapCharBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.StringCharBuffer;

public abstract class CharBuffer
extends Buffer
implements Comparable,
CharSequence {
    final char[] hb;
    final int offset;
    boolean isReadOnly;

    public abstract char get();

    public final int arrayOffset() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.offset;
    }

    public int hashCode() {
        int n2 = 1;
        int n3 = this.position();
        for (int i2 = this.limit() - 1; i2 >= n3; --i2) {
            n2 = 31 * n2 + this.get(i2);
        }
        return n2;
    }

    public final int length() {
        return this.remaining();
    }

    public final boolean hasArray() {
        return this.hb != null && !this.isReadOnly;
    }

    public abstract boolean isDirect();

    public final char[] array() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.hb;
    }

    public final char charAt(int n2) {
        return this.get(this.position() + this.checkIndex(n2, 1));
    }

    public abstract char get(int var1);

    CharBuffer(int n2, int n3, int n4, int n5) {
        this(n2, n3, n4, n5, null, 0);
    }

    CharBuffer(int n2, int n3, int n4, int n5, char[] cArray, int n6) {
        super(n2, n3, n4, n5);
        this.hb = cArray;
        this.offset = n6;
    }

    public abstract CharSequence subSequence(int var1, int var2);

    public int compareTo(Object object) {
        CharBuffer charBuffer = (CharBuffer)object;
        int n2 = this.position() + Math.min(this.remaining(), charBuffer.remaining());
        int n3 = this.position();
        int n4 = charBuffer.position();
        while (n3 < n2) {
            char c2;
            char c3 = this.get(n3);
            if (c3 != (c2 = charBuffer.get(n4)) && (c3 == c3 || c2 == c2)) {
                if (c3 < c2) {
                    return -1;
                }
                return 1;
            }
            ++n3;
            ++n4;
        }
        return this.remaining() - charBuffer.remaining();
    }

    public boolean equals(Object object) {
        if (!(object instanceof CharBuffer)) {
            return false;
        }
        CharBuffer charBuffer = (CharBuffer)object;
        if (this.remaining() != charBuffer.remaining()) {
            return false;
        }
        int n2 = this.position();
        int n3 = this.limit() - 1;
        int n4 = charBuffer.limit() - 1;
        while (n3 >= n2) {
            char c2;
            char c3 = this.get(n3);
            if (c3 != (c2 = charBuffer.get(n4)) && (c3 == c3 || c2 == c2)) {
                return false;
            }
            --n3;
            --n4;
        }
        return true;
    }

    public String toString() {
        return this.toString(this.position(), this.limit());
    }

    abstract String toString(int var1, int var2);

    public abstract ByteOrder order();

    public abstract CharBuffer asReadOnlyBuffer();

    public abstract CharBuffer compact();

    public abstract CharBuffer duplicate();

    public abstract CharBuffer slice();

    public abstract CharBuffer put(char var1);

    public static CharBuffer allocate(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        return new HeapCharBuffer(n2, n2);
    }

    public abstract CharBuffer put(int var1, char var2);

    public CharBuffer get(char[] cArray) {
        return this.get(cArray, 0, cArray.length);
    }

    public final CharBuffer put(char[] cArray) {
        return this.put(cArray, 0, cArray.length);
    }

    public static CharBuffer wrap(char[] cArray) {
        return CharBuffer.wrap(cArray, 0, cArray.length);
    }

    public CharBuffer get(char[] cArray, int n2, int n3) {
        CharBuffer.checkBounds(n2, n3, cArray.length);
        if (n3 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        int n4 = n2 + n3;
        for (int i2 = n2; i2 < n4; ++i2) {
            cArray[i2] = this.get();
        }
        return this;
    }

    public CharBuffer put(char[] cArray, int n2, int n3) {
        CharBuffer.checkBounds(n2, n3, cArray.length);
        if (n3 > this.remaining()) {
            throw new BufferOverflowException();
        }
        int n4 = n2 + n3;
        for (int i2 = n2; i2 < n4; ++i2) {
            this.put(cArray[i2]);
        }
        return this;
    }

    public static CharBuffer wrap(char[] cArray, int n2, int n3) {
        try {
            return new HeapCharBuffer(cArray, n2, n3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IndexOutOfBoundsException();
        }
    }

    public static CharBuffer wrap(CharSequence charSequence) {
        return CharBuffer.wrap(charSequence, 0, charSequence.length());
    }

    public static CharBuffer wrap(CharSequence charSequence, int n2, int n3) {
        try {
            return new StringCharBuffer(charSequence, n2, n3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IndexOutOfBoundsException();
        }
    }

    public final CharBuffer put(String string) {
        return this.put(string, 0, string.length());
    }

    public CharBuffer put(String string, int n2, int n3) {
        CharBuffer.checkBounds(n2, n3 - n2, string.length());
        for (int i2 = n2; i2 < n3; ++i2) {
            this.put(string.charAt(i2));
        }
        return this;
    }

    public CharBuffer put(CharBuffer charBuffer) {
        if (charBuffer == this) {
            throw new IllegalArgumentException();
        }
        int n2 = charBuffer.remaining();
        if (n2 > this.remaining()) {
            throw new BufferOverflowException();
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.put(charBuffer.get());
        }
        return this;
    }
}

