/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.Hashtable;

public class FeatureDescriptor {
    private Reference classRef;
    private boolean expert;
    private boolean hidden;
    private boolean preferred;
    private String shortDescription;
    private String name;
    private String displayName;
    private Hashtable table;

    public FeatureDescriptor() {
    }

    public boolean isExpert() {
        return this.expert;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isPreferred() {
        return this.preferred;
    }

    public void setExpert(boolean bl2) {
        this.expert = bl2;
    }

    public void setHidden(boolean bl2) {
        this.hidden = bl2;
    }

    public void setPreferred(boolean bl2) {
        this.preferred = bl2;
    }

    FeatureDescriptor(FeatureDescriptor featureDescriptor) {
        this.expert = featureDescriptor.expert;
        this.hidden = featureDescriptor.hidden;
        this.preferred = featureDescriptor.preferred;
        this.name = featureDescriptor.name;
        this.shortDescription = featureDescriptor.shortDescription;
        this.displayName = featureDescriptor.displayName;
        this.classRef = featureDescriptor.classRef;
        this.addTable(featureDescriptor.table);
    }

    Class getClass0() {
        return (Class)FeatureDescriptor.getObject(this.classRef);
    }

    void setClass0(Class clazz) {
        this.classRef = FeatureDescriptor.createReference(clazz);
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            return this.getName();
        }
        return this.displayName;
    }

    public String getName() {
        return this.name;
    }

    public String getShortDescription() {
        if (this.shortDescription == null) {
            return this.getDisplayName();
        }
        return this.shortDescription;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setShortDescription(String string) {
        this.shortDescription = string;
    }

    public Enumeration attributeNames() {
        if (this.table == null) {
            this.table = new Hashtable();
        }
        return this.table.keys();
    }

    private void addTable(Hashtable hashtable) {
        if (hashtable == null) {
            return;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = hashtable.get(string);
            this.setValue(string, object);
        }
    }

    FeatureDescriptor(FeatureDescriptor featureDescriptor, FeatureDescriptor featureDescriptor2) {
        this.expert = featureDescriptor.expert | featureDescriptor2.expert;
        this.hidden = featureDescriptor.hidden | featureDescriptor2.hidden;
        this.preferred = featureDescriptor.preferred | featureDescriptor2.preferred;
        this.name = featureDescriptor2.name;
        this.shortDescription = featureDescriptor.shortDescription;
        if (featureDescriptor2.shortDescription != null) {
            this.shortDescription = featureDescriptor2.shortDescription;
        }
        this.displayName = featureDescriptor.displayName;
        if (featureDescriptor2.displayName != null) {
            this.displayName = featureDescriptor2.displayName;
        }
        this.classRef = featureDescriptor.classRef;
        if (featureDescriptor2.classRef != null) {
            this.classRef = featureDescriptor2.classRef;
        }
        this.addTable(featureDescriptor.table);
        this.addTable(featureDescriptor2.table);
    }

    public Object getValue(String string) {
        if (this.table == null) {
            return null;
        }
        return this.table.get(string);
    }

    public void setValue(String string, Object object) {
        if (this.table == null) {
            this.table = new Hashtable();
        }
        this.table.put(string, object);
    }

    static Object getObject(Reference reference) {
        return reference == null ? null : reference.get();
    }

    static String capitalize(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toUpperCase(cArray[0]);
        return new String(cArray);
    }

    static Reference createReference(Object object) {
        return FeatureDescriptor.createReference(object, false);
    }

    static Reference createReference(Object object, boolean bl2) {
        Reference reference = null;
        if (object != null) {
            reference = bl2 ? new SoftReference(object) : new WeakReference(object);
        }
        return reference;
    }
}

