/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.ItemSelectable;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.CheckboxPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;

public class Checkbox
extends Component
implements ItemSelectable,
Accessible {
    String label;
    boolean state;
    CheckboxGroup group;
    transient ItemListener itemListener;
    private static final String base = "checkbox";
    private static int nameCounter;
    private static final long serialVersionUID = 7270714317450821763L;
    private int checkboxSerializedDataVersion = 1;
    static Class class$java$awt$event$ItemListener;

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            Checkbox.initIDs();
        }
        nameCounter = 0;
    }

    public Checkbox() throws HeadlessException {
        this("", false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = this.getToolkit().createCheckbox(this);
            }
            super.addNotify();
        }
    }

    private static native void initIDs();

    public boolean getState() {
        return this.state;
    }

    public void setState(boolean bl2) {
        CheckboxGroup checkboxGroup = this.group;
        if (checkboxGroup != null) {
            if (bl2) {
                checkboxGroup.setSelectedCheckbox(this);
            } else if (checkboxGroup.getSelectedCheckbox() == this) {
                bl2 = true;
            }
        }
        this.setStateInternal(bl2);
    }

    void setStateInternal(boolean bl2) {
        this.state = bl2;
        CheckboxPeer checkboxPeer = (CheckboxPeer)this.peer;
        if (checkboxPeer != null) {
            checkboxPeer.setState(bl2);
        }
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    boolean eventEnabled(AWTEvent aWTEvent) {
        if (aWTEvent.id == 701) {
            return (this.eventMask & 0x200L) != 0L || this.itemListener != null;
        }
        return super.eventEnabled(aWTEvent);
    }

    public CheckboxGroup getCheckboxGroup() {
        return this.group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCheckboxGroup(CheckboxGroup checkboxGroup) {
        boolean bl2;
        CheckboxGroup checkboxGroup2;
        if (this.group == checkboxGroup) {
            return;
        }
        Checkbox checkbox = this;
        synchronized (checkbox) {
            checkboxGroup2 = this.group;
            bl2 = this.getState();
            this.group = checkboxGroup;
            CheckboxPeer checkboxPeer = (CheckboxPeer)this.peer;
            if (checkboxPeer != null) {
                checkboxPeer.setCheckboxGroup(checkboxGroup);
            }
            if (this.group != null && this.getState()) {
                if (this.group.getSelectedCheckbox() != null) {
                    this.setState(false);
                } else {
                    this.group.setSelectedCheckbox(this);
                }
            }
        }
        if (checkboxGroup2 != null && bl2) {
            checkboxGroup2.setSelectedCheckbox(null);
        }
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        ItemListener itemListener = this.itemListener;
        if (itemListener != null) {
            itemListener.itemStateChanged(itemEvent);
        }
    }

    public synchronized ItemListener[] getItemListeners() {
        return (ItemListener[])this.getListeners(class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = Checkbox.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener);
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        if (itemListener == null) {
            return;
        }
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        if (itemListener == null) {
            return;
        }
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException, HeadlessException {
        Object object;
        GraphicsEnvironment.checkHeadless();
        objectInputStream.defaultReadObject();
        while (null != (object = objectInputStream.readObject())) {
            String string = ((String)object).intern();
            if ("itemL" == string) {
                this.addItemListener((ItemListener)objectInputStream.readObject());
                continue;
            }
            objectInputStream.readObject();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "itemL", this.itemListener);
        objectOutputStream.writeObject(null);
    }

    public Object[] getSelectedObjects() {
        if (this.state) {
            Object[] objectArray = new Object[]{this.label};
            return objectArray;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String constructComponentName() {
        Class clazz = this.getClass();
        synchronized (clazz) {
            return base + nameCounter++;
        }
    }

    public String getLabel() {
        return this.label;
    }

    protected String paramString() {
        String string = super.paramString();
        String string2 = this.label;
        if (string2 != null) {
            string = string + ",label=" + string2;
        }
        return string + ",state=" + this.state;
    }

    public Checkbox(String string) throws HeadlessException {
        this(string, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLabel(String string) {
        boolean bl2 = false;
        Checkbox checkbox = this;
        synchronized (checkbox) {
            if (!(string == this.label || this.label != null && this.label.equals(string))) {
                this.label = string;
                CheckboxPeer checkboxPeer = (CheckboxPeer)this.peer;
                if (checkboxPeer != null) {
                    checkboxPeer.setLabel(string);
                }
                bl2 = true;
            }
        }
        if (bl2 && this.valid) {
            this.invalidate();
        }
    }

    public Checkbox(String string, boolean bl2) throws HeadlessException {
        this(string, bl2, null);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTCheckbox(this);
        }
        return this.accessibleContext;
    }

    public Checkbox(String string, CheckboxGroup checkboxGroup, boolean bl2) throws HeadlessException {
        this(string, bl2, checkboxGroup);
    }

    public Checkbox(String string, boolean bl2, CheckboxGroup checkboxGroup) throws HeadlessException {
        GraphicsEnvironment.checkHeadless();
        this.label = string;
        this.state = bl2;
        this.group = checkboxGroup;
        if (bl2 && checkboxGroup != null) {
            checkboxGroup.setSelectedCheckbox(this);
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public EventListener[] getListeners(Class clazz) {
        ItemListener itemListener = null;
        if (clazz != (class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = Checkbox.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener)) {
            return super.getListeners(clazz);
        }
        itemListener = this.itemListener;
        return AWTEventMulticaster.getListeners(itemListener, clazz);
    }

    protected class AccessibleAWTCheckbox
    extends Component.AccessibleAWTComponent
    implements ItemListener,
    AccessibleAction,
    AccessibleValue {
        private final Checkbox this$0;

        public int getAccessibleActionCount() {
            return 0;
        }

        public boolean doAccessibleAction(int n2) {
            return false;
        }

        public AccessibleAWTCheckbox(Checkbox checkbox) {
            this.this$0 = checkbox;
            super(checkbox);
            checkbox.addItemListener(this);
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Checkbox checkbox = (Checkbox)itemEvent.getSource();
            if (this.this$0.accessibleContext != null) {
                if (checkbox.getState()) {
                    this.this$0.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.CHECKED);
                } else {
                    this.this$0.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.CHECKED, null);
                }
            }
        }

        public Number getCurrentAccessibleValue() {
            return null;
        }

        public Number getMaximumAccessibleValue() {
            return null;
        }

        public Number getMinimumAccessibleValue() {
            return null;
        }

        public boolean setCurrentAccessibleValue(Number number) {
            return false;
        }

        public String getAccessibleActionDescription(int n2) {
            return null;
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.CHECK_BOX;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (this.this$0.getState()) {
                accessibleStateSet.add(AccessibleState.CHECKED);
            }
            return accessibleStateSet;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }
    }
}

