/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractLine;
import com.sun.media.sound.AbstractMixer;
import com.sun.media.sound.PortMixerProvider;
import java.util.Vector;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.CompoundControl;
import javax.sound.sampled.Control;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Port;

class PortMixer
extends AbstractMixer {
    private static final int SRC_UNKNOWN = 1;
    private static final int SRC_MICROPHONE = 2;
    private static final int SRC_LINE_IN = 3;
    private static final int SRC_COMPACT_DISC = 4;
    private static final int SRC_MASK = 255;
    private static final int DST_UNKNOWN = 256;
    private static final int DST_SPEAKER = 512;
    private static final int DST_HEADPHONE = 768;
    private static final int DST_LINE_OUT = 1024;
    private static final int DST_MASK = 65280;
    private Port.Info[] portInfos;
    private PortMixerPort[] ports;
    private long id;
    static Class class$javax$sound$sampled$Port;

    int getMixerIndex() {
        return ((PortMixerProvider.PortMixerInfo)this.getMixerInfo()).getIndex();
    }

    long getID() {
        return this.id;
    }

    protected void implClose() {
        long l2 = this.id;
        this.id = 0L;
        PortMixer.nClose(l2);
        if (this.ports != null) {
            for (int i2 = 0; i2 < this.ports.length; ++i2) {
                if (this.ports[i2] == null) continue;
                PortMixerPort.access$000(this.ports[i2]);
            }
        }
    }

    protected void implOpen() throws LineUnavailableException {
        this.id = PortMixer.nOpen(this.getMixerIndex());
    }

    protected void implStart() {
    }

    protected void implStop() {
    }

    private static native long nOpen(int var0) throws LineUnavailableException;

    static float access$1200(long l2) {
        return PortMixer.nControlGetFloatValue(l2);
    }

    private static native float nControlGetFloatValue(long var0);

    static int access$800(long l2) {
        return PortMixer.nControlGetIntValue(l2);
    }

    private static native int nControlGetIntValue(long var0);

    private static native int nGetPortCount(long var0);

    private static native void nClose(long var0);

    static void access$1100(long l2, float f2) {
        PortMixer.nControlSetFloatValue(l2, f2);
    }

    private static native void nControlSetFloatValue(long var0, float var2);

    private static native int nGetPortType(long var0, int var2);

    static void access$700(long l2, int n2) {
        PortMixer.nControlSetIntValue(l2, n2);
    }

    private static native void nControlSetIntValue(long var0, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    PortMixer(PortMixerProvider.PortMixerInfo portMixerInfo) {
        int n2;
        int n3;
        int n4;
        int n5;
        block11: {
            super(portMixerInfo, null, null, null);
            this.id = 0L;
            n5 = 0;
            n4 = 0;
            n3 = 0;
            try {
                int n6;
                try {
                    this.id = PortMixer.nOpen(this.getMixerIndex());
                    if (this.id != 0L) {
                        n5 = PortMixer.nGetPortCount(this.id);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.portInfos = new Port.Info[n5];
                for (n2 = 0; n2 < n5; n4 += ((n6 = PortMixer.nGetPortType(this.id, n2)) & 0xFF) != 0 ? 1 : 0, n3 += (n6 & 0xFF00) != 0 ? 1 : 0, ++n2) {
                    this.portInfos[n2] = this.getPortInfo(n2, n6);
                }
                Object var8_8 = null;
                if (this.id == 0L) break block11;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (this.id != 0L) {
                    PortMixer.nClose(this.id);
                }
                this.id = 0L;
                throw throwable;
            }
            PortMixer.nClose(this.id);
        }
        this.id = 0L;
        this.sourceLineInfo = new Port.Info[n4];
        this.targetLineInfo = new Port.Info[n3];
        n4 = 0;
        n3 = 0;
        n2 = 0;
        while (n2 < n5) {
            if (this.portInfos[n2].isSource()) {
                this.sourceLineInfo[n4++] = this.portInfos[n2];
            } else {
                this.targetLineInfo[n3++] = this.portInfos[n2];
            }
            ++n2;
        }
        return;
    }

    private static native String nGetPortName(long var0, int var2);

    static void access$300(long l2, int n2, Vector vector) {
        PortMixer.nGetControls(l2, n2, vector);
    }

    private static native void nGetControls(long var0, int var2, Vector var3);

    public int getMaxLines(Line.Info info) {
        Line.Info info2 = this.getLineInfo(info);
        if (info2 == null) {
            return 0;
        }
        if (info2 instanceof Port.Info) {
            return 1;
        }
        return 0;
    }

    Port getPort(int n2) {
        if (this.ports == null) {
            this.ports = new PortMixerPort[this.portInfos.length];
        }
        if (this.ports[n2] == null) {
            this.ports[n2] = new PortMixerPort(this.portInfos[n2], this, n2, null);
            return this.ports[n2];
        }
        return this.ports[n2];
    }

    private Port.Info getPortInfo(int n2, int n3) {
        switch (n3) {
            case 1: {
                return new PortInfo(PortMixer.nGetPortName(this.getID(), n2), true, null);
            }
            case 2: {
                return Port.Info.MICROPHONE;
            }
            case 3: {
                return Port.Info.LINE_IN;
            }
            case 4: {
                return Port.Info.COMPACT_DISC;
            }
            case 256: {
                return new PortInfo(PortMixer.nGetPortName(this.getID(), n2), false, null);
            }
            case 512: {
                return Port.Info.SPEAKER;
            }
            case 768: {
                return Port.Info.HEADPHONE;
            }
            case 1024: {
                return Port.Info.LINE_OUT;
            }
        }
        return null;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public Line getLine(Line.Info info) throws LineUnavailableException {
        Line.Info info2 = this.getLineInfo(info);
        if (info2 != null && info2 instanceof Port.Info) {
            for (int i2 = 0; i2 < this.portInfos.length; ++i2) {
                if (!info2.equals(this.portInfos[i2])) continue;
                return this.getPort(i2);
            }
        }
        throw new IllegalArgumentException("Line unsupported: " + info);
    }

    static class 1 {
    }

    private static class BoolCtrl
    extends BooleanControl {
        private long controlID;
        private boolean closed = false;

        public boolean getValue() {
            if (!this.closed) {
                return PortMixer.access$800(this.controlID) != 0;
            }
            return false;
        }

        public void setValue(boolean bl2) {
            if (!this.closed) {
                PortMixer.access$700(this.controlID, bl2 ? 1 : 0);
            }
        }

        static boolean access$402(BoolCtrl boolCtrl, boolean bl2) {
            boolCtrl.closed = bl2;
            return boolCtrl.closed;
        }

        private BoolCtrl(long l2, String string) {
            this(l2, BoolCtrl.createType(string));
        }

        private BoolCtrl(long l2, BooleanControl.Type type) {
            super(type, false);
            this.controlID = l2;
        }

        private static BooleanControl.Type createType(String string) {
            if (string.equals("Mute")) {
                return BooleanControl.Type.MUTE;
            }
            if (string.equals("Select")) {
                // empty if block
            }
            return new BCT(string, null);
        }

        private static class BCT
        extends BooleanControl.Type {
            private BCT(String string) {
                super(string);
            }

            BCT(String string, 1 var2_2) {
                this(string);
            }
        }
    }

    private static class CompCtrl
    extends CompoundControl {
        private CompCtrl(String string, Control[] controlArray) {
            super(new CCT(string, null), controlArray);
        }

        private static class CCT
        extends CompoundControl.Type {
            private CCT(String string) {
                super(string);
            }

            CCT(String string, 1 var2_2) {
                this(string);
            }
        }
    }

    private static class FloatCtrl
    extends FloatControl {
        private long controlID;
        private boolean closed = false;
        private static final FloatControl.Type[] FLOAT_CONTROL_TYPES = new FloatControl.Type[]{null, FloatControl.Type.BALANCE, FloatControl.Type.MASTER_GAIN, FloatControl.Type.PAN, FloatControl.Type.VOLUME};

        public float getValue() {
            if (!this.closed) {
                return PortMixer.access$1200(this.controlID);
            }
            return this.getMinimum();
        }

        public void setValue(float f2) {
            if (!this.closed) {
                PortMixer.access$1100(this.controlID, f2);
            }
        }

        static boolean access$502(FloatCtrl floatCtrl, boolean bl2) {
            floatCtrl.closed = bl2;
            return floatCtrl.closed;
        }

        private FloatCtrl(long l2, int n2, float f2, float f3, float f4, String string) {
            this(l2, FLOAT_CONTROL_TYPES[n2], f2, f3, f4, string);
        }

        private FloatCtrl(long l2, String string, float f2, float f3, float f4, String string2) {
            this(l2, new FCT(string, null), f2, f3, f4, string2);
        }

        private FloatCtrl(long l2, FloatControl.Type type, float f2, float f3, float f4, String string) {
            super(type, f2, f3, f4, 1000, f2, string);
            this.controlID = l2;
        }

        private static class FCT
        extends FloatControl.Type {
            private FCT(String string) {
                super(string);
            }

            FCT(String string, 1 var2_2) {
                this(string);
            }
        }
    }

    private static class PortInfo
    extends Port.Info {
        private PortInfo(String string, boolean bl2) {
            super(class$javax$sound$sampled$Port == null ? (class$javax$sound$sampled$Port = PortMixer.class$("javax.sound.sampled.Port")) : class$javax$sound$sampled$Port, string, bl2);
        }

        PortInfo(String string, boolean bl2, 1 var3_3) {
            this(string, bl2);
        }
    }

    private static class PortMixerPort
    extends AbstractLine
    implements Port {
        private int portIndex;
        private long id;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            AbstractMixer abstractMixer = this.mixer;
            synchronized (abstractMixer) {
                if (this.isOpen()) {
                    this.setOpen(false);
                    this.implClose();
                    this.mixer.close(this);
                }
            }
        }

        private void disposeControls() {
            this.enableControls(this.controls, false);
            this.controls = new Control[0];
        }

        void implClose() {
            this.enableControls(this.controls, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void implOpen() throws LineUnavailableException {
            long l2 = ((PortMixer)this.mixer).getID();
            if (this.id == 0L || l2 != this.id || this.controls.length == 0) {
                Vector vector;
                this.id = l2;
                Vector vector2 = vector = new Vector();
                synchronized (vector2) {
                    PortMixer.access$300(this.id, this.portIndex, vector);
                    this.controls = new Control[vector.size()];
                    for (int i2 = 0; i2 < this.controls.length; ++i2) {
                        this.controls[i2] = (Control)vector.elementAt(i2);
                    }
                }
            } else {
                this.enableControls(this.controls, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void open() throws LineUnavailableException {
            AbstractMixer abstractMixer = this.mixer;
            synchronized (abstractMixer) {
                if (!this.isOpen()) {
                    this.mixer.open(this);
                    try {
                        this.implOpen();
                        this.setOpen(true);
                    }
                    catch (LineUnavailableException lineUnavailableException) {
                        this.mixer.close(this);
                        throw lineUnavailableException;
                    }
                }
            }
        }

        static void access$000(PortMixerPort portMixerPort) {
            portMixerPort.disposeControls();
        }

        private void enableControls(Control[] controlArray, boolean bl2) {
            for (int i2 = 0; i2 < controlArray.length; ++i2) {
                if (controlArray[i2] instanceof BoolCtrl) {
                    BoolCtrl.access$402((BoolCtrl)controlArray[i2], !bl2);
                    continue;
                }
                if (controlArray[i2] instanceof FloatCtrl) {
                    FloatCtrl.access$502((FloatCtrl)controlArray[i2], !bl2);
                    continue;
                }
                if (!(controlArray[i2] instanceof CompoundControl)) continue;
                this.enableControls(((CompoundControl)controlArray[i2]).getMemberControls(), bl2);
            }
        }

        private PortMixerPort(Port.Info info, PortMixer portMixer, int n2) {
            super(info, portMixer, null);
            this.portIndex = n2;
        }

        PortMixerPort(Port.Info info, PortMixer portMixer, int n2, 1 var4_4) {
            this(info, portMixer, n2);
        }
    }
}

