/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.ColorType;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthUI;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ToolTipUI;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

class SynthToolTipUI
extends ToolTipUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;
    static Class class$com$sun$java$swing$plaf$gtk$SynthContext;

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.fetchStyle((JToolTip)propertyChangeEvent.getSource());
        }
        if (string.equals("tiptext") || "font".equals(string) || "foreground".equals(string)) {
            JToolTip jToolTip = (JToolTip)propertyChangeEvent.getSource();
            String string2 = jToolTip.getTipText();
            BasicHTML.updateRenderer(jToolTip, string2);
        } else if ("component".equals(string)) {
            this.componentChanged((JToolTip)propertyChangeEvent.getSource());
        }
    }

    private int getComponentState(JComponent jComponent) {
        JComponent jComponent2 = ((JToolTip)jComponent).getComponent();
        if (jComponent2 != null && !jComponent2.isEnabled()) {
            return 8;
        }
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    private void componentChanged(JComponent jComponent) {
    }

    private void fetchStyle(JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent, 1);
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        synthContext.dispose();
    }

    private void installComponents(JComponent jComponent) {
        BasicHTML.updateRenderer(jComponent, ((JToolTip)jComponent).getTipText());
    }

    protected void installDefaults(JComponent jComponent) {
        this.fetchStyle(jComponent);
        this.componentChanged(jComponent);
    }

    protected void installListeners(JComponent jComponent) {
        jComponent.addPropertyChangeListener(this);
    }

    public void installUI(JComponent jComponent) {
        this.installDefaults(jComponent);
        this.installComponents(jComponent);
        this.installListeners(jComponent);
    }

    private void uninstallComponents(JComponent jComponent) {
        BasicHTML.updateRenderer(jComponent, "");
    }

    protected void uninstallDefaults(JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    protected void uninstallListeners(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this);
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults(jComponent);
        this.uninstallComponents(jComponent);
        this.uninstallListeners(jComponent);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n2) {
        return SynthContext.getContext(class$com$sun$java$swing$plaf$gtk$SynthContext == null ? (class$com$sun$java$swing$plaf$gtk$SynthContext = SynthToolTipUI.class$("com.sun.java.swing.plaf.gtk.SynthContext")) : class$com$sun$java$swing$plaf$gtk$SynthContext, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n2);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension.width = (int)((float)dimension.width + (view.getMaximumSpan(0) - view.getPreferredSpan(0)));
        }
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension.width = (int)((float)dimension.width - (view.getPreferredSpan(0) - view.getMinimumSpan(0)));
        }
        return dimension;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        Insets insets = jComponent.getInsets();
        Dimension dimension = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        String string = ((JToolTip)jComponent).getTipText();
        if (string != null) {
            View view;
            View view2 = view = jComponent != null ? (View)jComponent.getClientProperty("html") : null;
            if (view != null) {
                dimension.width += (int)view.getPreferredSpan(0);
                dimension.height += (int)view.getPreferredSpan(1);
            } else {
                Font font = synthContext.getStyle().getFont(synthContext);
                FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
                dimension.width += synthContext.getStyle().getSynthGraphics(synthContext).computeStringWidth(synthContext, font, fontMetrics, string);
                dimension.height += fontMetrics.getHeight();
            }
        }
        synthContext.dispose();
        return dimension;
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        JToolTip jToolTip = (JToolTip)synthContext.getComponent();
        String string = jToolTip.getToolTipText();
        Insets insets = jToolTip.getInsets();
        View view = (View)jToolTip.getClientProperty("html");
        if (view != null) {
            Rectangle rectangle = new Rectangle(insets.left, insets.top, jToolTip.getWidth() - (insets.left + insets.right), jToolTip.getHeight() - (insets.top + insets.bottom));
            view.paint(graphics, rectangle);
        } else {
            graphics.setColor(synthContext.getStyle().getColor(synthContext, ColorType.TEXT_FOREGROUND));
            graphics.setFont(this.style.getFont(synthContext));
            synthContext.getStyle().getSynthGraphics(synthContext).paintText(synthContext, graphics, jToolTip.getTipText(), insets.left, insets.top, -1);
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthToolTipUI();
    }
}

