/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.DefaultMenuLayout;
import com.sun.java.swing.plaf.gtk.LazyActionMap;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import com.sun.java.swing.plaf.gtk.SynthMenuItemUI;
import com.sun.java.swing.plaf.gtk.SynthPopupMenuUI;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ComponentInputMap;
import javax.swing.InputMap;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.PopupMenuUI;
import javax.swing.plaf.UIResource;

class SynthPopupMenuUI
extends PopupMenuUI
implements PropertyChangeListener,
SynthUI {
    private int maxTextWidth;
    private int maxAcceleratorWidth;
    static boolean menuKeyboardHelperInstalled = false;
    static MenuKeyboardHelper menuKeyboardHelper = null;
    protected JPopupMenu popupMenu = null;
    private SynthStyle style;
    private static transient MouseGrabber mouseGrabber = null;
    private transient PopupMenuListener basicPopupMenuListener = null;
    static Class class$com$sun$java$swing$plaf$gtk$SynthPopupMenuUI;
    static Class class$com$sun$java$swing$plaf$gtk$SynthContext;

    int getMaxAcceleratorWidth() {
        return this.maxAcceleratorWidth;
    }

    int getMaxTextWidth() {
        return this.maxTextWidth;
    }

    SynthPopupMenuUI() {
    }

    public void installDefaults() {
        if (this.popupMenu.getLayout() == null || this.popupMenu.getLayout() instanceof UIResource) {
            this.popupMenu.setLayout(new DefaultMenuLayout(this.popupMenu, 1));
        }
        this.fetchStyle(this.popupMenu);
    }

    protected void installKeyboardActions() {
    }

    protected void installListeners() {
        if (mouseGrabber == null) {
            mouseGrabber = new MouseGrabber();
        }
        if (this.basicPopupMenuListener == null) {
            this.basicPopupMenuListener = this.createPopupMenuListener();
        }
        this.popupMenu.addPopupMenuListener(this.basicPopupMenuListener);
        if (!menuKeyboardHelperInstalled) {
            if (menuKeyboardHelper == null) {
                menuKeyboardHelper = new MenuKeyboardHelper(null);
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.addChangeListener(menuKeyboardHelper);
        }
        this.popupMenu.addPropertyChangeListener(this);
    }

    void resetAcceleratorWidths() {
        this.maxAcceleratorWidth = 0;
        this.maxTextWidth = 0;
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext(this.popupMenu, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
        if (this.popupMenu.getLayout() instanceof UIResource) {
            this.popupMenu.setLayout(null);
        }
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.popupMenu, null);
        SwingUtilities.replaceUIInputMap(this.popupMenu, 2, null);
    }

    protected void uninstallListeners() {
        if (this.basicPopupMenuListener != null) {
            this.popupMenu.removePopupMenuListener(this.basicPopupMenuListener);
        }
        this.popupMenu.removePropertyChangeListener(this);
    }

    int adjustAcceleratorWidth(int n2) {
        this.maxAcceleratorWidth = Math.max(this.maxAcceleratorWidth, n2);
        return this.maxAcceleratorWidth;
    }

    int adjustTextWidth(int n2) {
        this.maxTextWidth = Math.max(this.maxTextWidth, n2);
        return this.maxTextWidth;
    }

    public boolean isPopupTrigger(MouseEvent mouseEvent) {
        return mouseEvent.getID() == 502 && (mouseEvent.getModifiers() & 4) != 0;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.fetchStyle(this.popupMenu);
        }
    }

    static List access$500() {
        return SynthPopupMenuUI.getPopups();
    }

    private static List getPopups() {
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
        ArrayList arrayList = new ArrayList(menuElementArray.length);
        for (int i2 = 0; i2 < menuElementArray.length; ++i2) {
            if (!(menuElementArray[i2] instanceof JPopupMenu)) continue;
            arrayList.add((JPopupMenu)menuElementArray[i2]);
        }
        return arrayList;
    }

    static ActionMap getActionMap() {
        return LazyActionMap.getActionMap(class$com$sun$java$swing$plaf$gtk$SynthPopupMenuUI == null ? (class$com$sun$java$swing$plaf$gtk$SynthPopupMenuUI = SynthPopupMenuUI.class$("com.sun.java.swing.plaf.gtk.SynthPopupMenuUI")) : class$com$sun$java$swing$plaf$gtk$SynthPopupMenuUI, "PopupMenu.actionMap");
    }

    public static void loadActionMap(ActionMap actionMap) {
        actionMap.put("cancel", new CancelAction(null));
        actionMap.put("selectNext", new SelectNextItemAction(SelectNextItemAction.FORWARD));
        actionMap.put("selectPrevious", new SelectNextItemAction(SelectNextItemAction.BACKWARD));
        actionMap.put("selectParent", new SelectParentChildAction(SelectParentChildAction.PARENT));
        actionMap.put("selectChild", new SelectParentChildAction(SelectParentChildAction.CHILD));
        actionMap.put("return", new ReturnAction(null));
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    private void fetchStyle(JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent, 1);
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        synthContext.dispose();
    }

    public void installUI(JComponent jComponent) {
        this.popupMenu = (JPopupMenu)jComponent;
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.popupMenu = null;
    }

    static JPopupMenu access$800() {
        return SynthPopupMenuUI.getLastPopup();
    }

    private static JPopupMenu getLastPopup() {
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
        JPopupMenu jPopupMenu = null;
        for (int i2 = menuElementArray.length - 1; jPopupMenu == null && i2 >= 0; --i2) {
            if (!(menuElementArray[i2] instanceof JPopupMenu)) continue;
            jPopupMenu = (JPopupMenu)menuElementArray[i2];
        }
        return jPopupMenu;
    }

    static MenuElement access$400() {
        return SynthPopupMenuUI.getFirstPopup();
    }

    private static MenuElement getFirstPopup() {
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
        MenuElement menuElement = null;
        for (int i2 = 0; menuElement == null && i2 < menuElementArray.length; ++i2) {
            if (!(menuElementArray[i2] instanceof JPopupMenu)) continue;
            menuElement = menuElementArray[i2];
        }
        return menuElement;
    }

    private PopupMenuListener createPopupMenuListener() {
        return new BasicPopupMenuListener(this, null);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n2) {
        return SynthContext.getContext(class$com$sun$java$swing$plaf$gtk$SynthContext == null ? (class$com$sun$java$swing$plaf$gtk$SynthContext = SynthPopupMenuUI.class$("com.sun.java.swing.plaf.gtk.SynthContext")) : class$com$sun$java$swing$plaf$gtk$SynthContext, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n2);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
    }

    static Window access$300(Component component) {
        return SynthPopupMenuUI.getWindow(component);
    }

    private static Window getWindow(Component component) {
        Component component2;
        for (component2 = component; !(component2 instanceof Window) && component2 != null; component2 = component2.getParent()) {
        }
        return (Window)component2;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    static boolean access$600(MenuElement menuElement, MenuElement menuElement2) {
        return SynthPopupMenuUI.checkInvokerEqual(menuElement, menuElement2);
    }

    private static boolean checkInvokerEqual(MenuElement menuElement, MenuElement menuElement2) {
        Component component = menuElement.getComponent();
        Component component2 = menuElement2.getComponent();
        if (component instanceof JPopupMenu) {
            component = ((JPopupMenu)component).getInvoker();
        }
        if (component2 instanceof JPopupMenu) {
            component2 = ((JPopupMenu)component2).getInvoker();
        }
        return component == component2;
    }

    private static MenuElement nextEnabledChild(MenuElement[] menuElementArray, int n2, int n3) {
        for (int i2 = n2; i2 <= n3; ++i2) {
            Component component;
            if (menuElementArray[i2] == null || (component = menuElementArray[i2].getComponent()) == null || !component.isEnabled()) continue;
            return menuElementArray[i2];
        }
        return null;
    }

    private static MenuElement previousEnabledChild(MenuElement[] menuElementArray, int n2, int n3) {
        for (int i2 = n2; i2 >= n3; --i2) {
            Component component;
            if (menuElementArray[i2] == null || (component = menuElementArray[i2].getComponent()) == null || !component.isEnabled()) continue;
            return menuElementArray[i2];
        }
        return null;
    }

    static MenuElement access$900(MenuElement[] menuElementArray, int n2, boolean bl2) {
        return SynthPopupMenuUI.findEnabledChild(menuElementArray, n2, bl2);
    }

    private static MenuElement findEnabledChild(MenuElement[] menuElementArray, int n2, boolean bl2) {
        MenuElement menuElement = null;
        if (bl2) {
            menuElement = SynthPopupMenuUI.nextEnabledChild(menuElementArray, n2 + 1, menuElementArray.length - 1);
            if (menuElement == null) {
                menuElement = SynthPopupMenuUI.nextEnabledChild(menuElementArray, 0, n2 - 1);
            }
        } else {
            menuElement = SynthPopupMenuUI.previousEnabledChild(menuElementArray, n2 - 1, 0);
            if (menuElement == null) {
                menuElement = SynthPopupMenuUI.previousEnabledChild(menuElementArray, menuElementArray.length - 1, n2 + 1);
            }
        }
        return menuElement;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthPopupMenuUI();
    }

    static InputMap getInputMap(JPopupMenu jPopupMenu, JComponent jComponent) {
        ComponentInputMap componentInputMap = null;
        PopupMenuUI popupMenuUI = jPopupMenu.getUI();
        SynthContext synthContext = null;
        Object[] objectArray = null;
        if (popupMenuUI instanceof SynthPopupMenuUI) {
            synthContext = ((SynthPopupMenuUI)popupMenuUI).getContext(jPopupMenu, 1);
            objectArray = (Object[])synthContext.getStyle().get(synthContext, "PopupMenu.selectedWindowInputMapBindings");
        }
        if (objectArray == null) {
            objectArray = new Object[]{"ESCAPE", "cancel", "DOWN", "selectNext", "KP_DOWN", "selectNext", "UP", "selectPrevious", "KP_UP", "selectPrevious", "LEFT", "selectParent", "KP_LEFT", "selectParent", "RIGHT", "selectChild", "KP_RIGHT", "selectChild", "ENTER", "return", "SPACE", "return"};
        }
        componentInputMap = LookAndFeel.makeComponentInputMap(jComponent, objectArray);
        if (!jPopupMenu.getComponentOrientation().isLeftToRight()) {
            Object[] objectArray2 = null;
            if (synthContext != null) {
                objectArray2 = (Object[])synthContext.getStyle().get(synthContext, "PopupMenu.selectedWindowInputMapBindings.RightToLeft");
            }
            if (objectArray2 == null) {
                objectArray2 = new Object[]{"LEFT", "selectChild", "KP_LEFT", "selectChild", "RIGHT", "selectParent", "KP_RIGHT", "selectParent"};
            }
            ComponentInputMap componentInputMap2 = LookAndFeel.makeComponentInputMap(jComponent, objectArray2);
            ((InputMap)componentInputMap2).setParent(componentInputMap);
            componentInputMap = componentInputMap2;
        }
        if (synthContext != null) {
            synthContext.dispose();
        }
        return componentInputMap;
    }

    static MenuElement access$1000(MenuElement[] menuElementArray, MenuElement menuElement, boolean bl2) {
        return SynthPopupMenuUI.findEnabledChild(menuElementArray, menuElement, bl2);
    }

    private static MenuElement findEnabledChild(MenuElement[] menuElementArray, MenuElement menuElement, boolean bl2) {
        for (int i2 = 0; i2 < menuElementArray.length; ++i2) {
            if (menuElementArray[i2] != menuElement) continue;
            return SynthPopupMenuUI.findEnabledChild(menuElementArray, i2, bl2);
        }
        return null;
    }

    private class BasicPopupMenuListener
    implements PopupMenuListener {
        private final SynthPopupMenuUI this$0;

        private BasicPopupMenuListener(SynthPopupMenuUI synthPopupMenuUI) {
            this.this$0 = synthPopupMenuUI;
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            SynthLookAndFeel.playSound((JComponent)popupMenuEvent.getSource(), "PopupMenu.popupSound");
        }

        BasicPopupMenuListener(SynthPopupMenuUI synthPopupMenuUI, 1 var2_2) {
            this(synthPopupMenuUI);
        }
    }

    private static class CancelAction
    extends AbstractAction {
        private CancelAction() {
        }

        CancelAction(1 var1_1) {
            this();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MenuElement[] menuElementArray;
            JPopupMenu jPopupMenu = SynthPopupMenuUI.access$800();
            if (jPopupMenu != null) {
                jPopupMenu.putClientProperty("JPopupMenu.firePopupMenuCanceled", Boolean.TRUE);
            }
            if ((menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath()).length > 4) {
                MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length - 2];
                System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length - 2);
                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
            } else {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
        }
    }

    private static class MenuKeyboardHelper
    implements ChangeListener,
    KeyListener {
        private Component lastFocused = null;
        private MenuElement[] lastPathSelected = new MenuElement[0];
        private JPopupMenu lastPopup;
        private JRootPane invokerRootPane;
        private ActionMap menuActionMap = SynthPopupMenuUI.getActionMap();
        private InputMap menuInputMap;
        private boolean focusTraversalKeysEnabled;
        private boolean receivedKeyPressed = false;
        private FocusListener rootPaneFocusListener = new FocusAdapter(this){
            private final MenuKeyboardHelper this$0;
            {
                this.this$0 = menuKeyboardHelper;
            }

            public void focusGained(FocusEvent focusEvent) {
                Component component = focusEvent.getOppositeComponent();
                if (component != null) {
                    MenuKeyboardHelper.access$1102(this.this$0, component);
                }
                focusEvent.getComponent().removeFocusListener(this);
            }
        };

        private MenuKeyboardHelper() {
        }

        void removeItems() {
            if (this.lastFocused != null) {
                Window window;
                if (!this.lastFocused.requestFocusInWindow() && (window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow()) != null && "###focusableSwingPopup###".equals(window.getName())) {
                    this.lastFocused.requestFocus();
                }
                this.lastFocused = null;
            }
            if (this.invokerRootPane != null) {
                this.invokerRootPane.removeKeyListener(menuKeyboardHelper);
                this.invokerRootPane.setFocusTraversalKeysEnabled(this.focusTraversalKeysEnabled);
                this.removeUIInputMap(this.invokerRootPane, this.menuInputMap);
                this.removeUIActionMap(this.invokerRootPane, this.menuActionMap);
                this.invokerRootPane = null;
            }
            this.receivedKeyPressed = false;
        }

        MenuKeyboardHelper(1 var1_1) {
            this();
        }

        public void keyPressed(KeyEvent keyEvent) {
            this.receivedKeyPressed = true;
            MenuSelectionManager.defaultManager().processKeyEvent(keyEvent);
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (this.receivedKeyPressed) {
                this.receivedKeyPressed = false;
                MenuSelectionManager.defaultManager().processKeyEvent(keyEvent);
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
            if (this.receivedKeyPressed) {
                MenuSelectionManager.defaultManager().processKeyEvent(keyEvent);
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void stateChanged(ChangeEvent changeEvent) {
            if (!(UIManager.getLookAndFeel() instanceof SynthLookAndFeel)) {
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                menuSelectionManager.removeChangeListener(this);
                menuKeyboardHelperInstalled = false;
                return;
            }
            MenuSelectionManager menuSelectionManager = (MenuSelectionManager)changeEvent.getSource();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            JPopupMenu jPopupMenu = this.getActivePopup(menuElementArray);
            if (jPopupMenu != null && !jPopupMenu.isFocusable()) {
                return;
            }
            if (this.lastPathSelected.length != 0 && menuElementArray.length != 0 && !SynthPopupMenuUI.access$600(menuElementArray[0], this.lastPathSelected[0])) {
                this.removeItems();
                this.lastPathSelected = new MenuElement[0];
            }
            if (this.lastPathSelected.length == 0 && menuElementArray.length > 0) {
                void var5_10;
                if (jPopupMenu == null) {
                    if (menuElementArray.length != 2 || !(menuElementArray[0] instanceof JMenuBar) || !(menuElementArray[1] instanceof JMenu)) return;
                    JComponent jComponent = (JComponent)((Object)menuElementArray[1]);
                    jPopupMenu = ((JMenu)jComponent).getPopupMenu();
                } else {
                    Component component = jPopupMenu.getInvoker();
                    if (component instanceof JFrame) {
                        JRootPane jRootPane = ((JFrame)component).getRootPane();
                    } else if (component instanceof JApplet) {
                        JRootPane jRootPane = ((JApplet)component).getRootPane();
                    } else {
                        while (!(component instanceof JComponent)) {
                            if (component == null) {
                                return;
                            }
                            component = component.getParent();
                        }
                        JComponent jComponent = (JComponent)component;
                    }
                }
                this.lastFocused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                this.invokerRootPane = SwingUtilities.getRootPane((Component)var5_10);
                if (this.invokerRootPane != null) {
                    this.invokerRootPane.addFocusListener(this.rootPaneFocusListener);
                    this.invokerRootPane.requestFocus(true);
                    this.invokerRootPane.addKeyListener(menuKeyboardHelper);
                    this.focusTraversalKeysEnabled = this.invokerRootPane.getFocusTraversalKeysEnabled();
                    this.invokerRootPane.setFocusTraversalKeysEnabled(false);
                    this.menuInputMap = SynthPopupMenuUI.getInputMap(jPopupMenu, this.invokerRootPane);
                    this.addUIInputMap(this.invokerRootPane, this.menuInputMap);
                    this.addUIActionMap(this.invokerRootPane, this.menuActionMap);
                }
            } else if (this.lastPathSelected.length != 0 && menuElementArray.length == 0) {
                this.removeItems();
            } else if (jPopupMenu != this.lastPopup) {
                this.receivedKeyPressed = false;
            }
            this.lastPathSelected = menuElementArray;
            this.lastPopup = jPopupMenu;
        }

        void addUIActionMap(JComponent jComponent, ActionMap actionMap) {
            ActionMap actionMap2;
            ActionMap actionMap3 = null;
            for (actionMap2 = jComponent.getActionMap(); actionMap2 != null && !(actionMap2 instanceof UIResource); actionMap2 = actionMap2.getParent()) {
                actionMap3 = actionMap2;
            }
            if (actionMap3 == null) {
                jComponent.setActionMap(actionMap);
            } else {
                actionMap3.setParent(actionMap);
            }
            actionMap.setParent(actionMap2);
        }

        void removeUIActionMap(JComponent jComponent, ActionMap actionMap) {
            ActionMap actionMap2 = null;
            for (ActionMap actionMap3 = jComponent.getActionMap(); actionMap3 != null; actionMap3 = actionMap3.getParent()) {
                if (actionMap3 == actionMap) {
                    if (actionMap2 == null) {
                        jComponent.setActionMap(actionMap.getParent());
                        break;
                    }
                    actionMap2.setParent(actionMap.getParent());
                    break;
                }
                actionMap2 = actionMap3;
            }
        }

        void addUIInputMap(JComponent jComponent, InputMap inputMap) {
            InputMap inputMap2;
            InputMap inputMap3 = null;
            for (inputMap2 = jComponent.getInputMap(2); inputMap2 != null && !(inputMap2 instanceof UIResource); inputMap2 = inputMap2.getParent()) {
                inputMap3 = inputMap2;
            }
            if (inputMap3 == null) {
                jComponent.setInputMap(2, inputMap);
            } else {
                inputMap3.setParent(inputMap);
            }
            inputMap.setParent(inputMap2);
        }

        void removeUIInputMap(JComponent jComponent, InputMap inputMap) {
            InputMap inputMap2 = null;
            for (InputMap inputMap3 = jComponent.getInputMap(2); inputMap3 != null; inputMap3 = inputMap3.getParent()) {
                if (inputMap3 == inputMap) {
                    if (inputMap2 == null) {
                        jComponent.setInputMap(2, inputMap.getParent());
                        break;
                    }
                    inputMap2.setParent(inputMap.getParent());
                    break;
                }
                inputMap2 = inputMap3;
            }
        }

        JPopupMenu getActivePopup(MenuElement[] menuElementArray) {
            for (int i2 = menuElementArray.length - 1; i2 >= 0; --i2) {
                MenuElement menuElement = menuElementArray[i2];
                if (!(menuElement instanceof JPopupMenu)) continue;
                return (JPopupMenu)menuElement;
            }
            return null;
        }

        static Component access$1102(MenuKeyboardHelper menuKeyboardHelper, Component component) {
            menuKeyboardHelper.lastFocused = component;
            return menuKeyboardHelper.lastFocused;
        }
    }

    private static class MouseGrabber
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener,
    WindowListener,
    WindowFocusListener,
    ComponentListener,
    ChangeListener {
        Vector grabbed = new Vector();
        MenuElement lastGrabbed = null;
        boolean lastGrabbedMenuBarChild = false;
        MenuElement[] lastPathSelected = new MenuElement[0];

        public MouseGrabber() {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.addChangeListener(this);
        }

        void cancelPopupMenu() {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            JPopupMenu jPopupMenu = (JPopupMenu)SynthPopupMenuUI.access$400();
            if (this.lastGrabbed == jPopupMenu) {
                List list = SynthPopupMenuUI.access$500();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    JPopupMenu jPopupMenu2 = (JPopupMenu)iterator.next();
                    jPopupMenu2.putClientProperty("JPopupMenu.firePopupMenuCanceled", Boolean.TRUE);
                }
                MenuSelectionManager.defaultManager().clearSelectedPath();
                this.ungrabContainers();
            } else {
                this.lastGrabbed = jPopupMenu;
                this.lastGrabbedMenuBarChild = menuElementArray[0] instanceof JMenuBar;
            }
        }

        private void requestRemoveGrab() {
            this.ungrabContainers();
        }

        void ungrabContainers() {
            int n2 = this.grabbed.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Component component = (Component)this.grabbed.elementAt(i2);
                if (component instanceof Window) {
                    ((Window)component).removeWindowListener(this);
                    ((Window)component).removeWindowFocusListener(this);
                    ((Window)component).removeComponentListener(this);
                    continue;
                }
                component.removeMouseListener(this);
                component.removeMouseMotionListener(this);
                component.removeMouseWheelListener(this);
            }
            this.grabbed = new Vector();
            this.lastGrabbed = null;
            this.lastGrabbedMenuBarChild = false;
        }

        private void requestAddGrab(Component component) {
            Window window = SynthPopupMenuUI.access$300(component);
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            Component component2 = null;
            for (int i2 = 0; component2 == null && i2 < menuElementArray.length; ++i2) {
                if (!(menuElementArray[i2] instanceof JPopupMenu)) continue;
                component2 = menuElementArray[i2].getComponent();
            }
            this.grabContainer(window, component2);
        }

        public void componentHidden(ComponentEvent componentEvent) {
            this.cancelPopupMenu();
        }

        public void componentMoved(ComponentEvent componentEvent) {
            this.cancelPopupMenu();
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.cancelPopupMenu();
        }

        public void componentShown(ComponentEvent componentEvent) {
            this.cancelPopupMenu();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Component component = (Component)mouseEvent.getSource();
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            this.cancelPopupMenu();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            this.cancelPopupMenu();
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
            this.cancelPopupMenu();
        }

        public void windowClosing(WindowEvent windowEvent) {
            this.cancelPopupMenu();
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowGainedFocus(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
            this.cancelPopupMenu();
        }

        public void windowLostFocus(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (this.lastPathSelected.length != 0 && menuElementArray.length != 0 && !SynthPopupMenuUI.access$600(menuElementArray[0], this.lastPathSelected[0])) {
                this.requestRemoveGrab();
                this.lastPathSelected = new MenuElement[0];
            }
            if (this.lastPathSelected.length == 0 && menuElementArray.length != 0) {
                Component component = menuElementArray[0].getComponent();
                if (component instanceof JPopupMenu) {
                    component = ((JPopupMenu)component).getInvoker();
                }
                this.requestAddGrab(component);
            }
            if (this.lastPathSelected.length != 0 && menuElementArray.length == 0) {
                this.requestRemoveGrab();
            }
            if (menuElementArray != null && menuElementArray.length > 2 && menuElementArray[0] instanceof JMenuBar && this.lastGrabbedMenuBarChild && this.lastGrabbed != SynthPopupMenuUI.access$400()) {
                this.lastGrabbed = SynthPopupMenuUI.access$400();
                this.lastGrabbedMenuBarChild = menuElementArray[0] instanceof JMenuBar;
            }
            this.lastPathSelected = menuElementArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void grabContainer(Container container, Component component) {
            if (container == component) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            this.lastGrabbed = SynthPopupMenuUI.access$400();
            this.lastGrabbedMenuBarChild = menuElementArray[0] instanceof JMenuBar;
            Component component2 = null;
            if (container instanceof Window) {
                ((Window)container).addWindowListener(this);
                ((Window)container).addWindowFocusListener(this);
                ((Window)container).addComponentListener(this);
                this.grabbed.addElement(container);
            } else if (container instanceof JRootPane && ((component2 = ((JRootPane)container).getGlassPane()).getMouseListeners().length > 0 || component2.getMouseMotionListeners().length > 0 || component2.getMouseWheelListeners().length > 0)) {
                component2 = null;
            }
            Object object = container.getTreeLock();
            synchronized (object) {
                int n2 = container.getComponentCount();
                Component[] componentArray = container.getComponents();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Component component3 = componentArray[i2];
                    if (!component3.isVisible()) continue;
                    if (component3 != component2) {
                        component3.addMouseListener(this);
                        component3.addMouseMotionListener(this);
                        component3.addMouseWheelListener(this);
                        this.grabbed.addElement(component3);
                    }
                    if (!(component3 instanceof Container)) continue;
                    Container container2 = (Container)component3;
                    this.grabContainer(container2, component);
                }
            }
        }
    }

    private static class ReturnAction
    extends AbstractAction {
        private ReturnAction() {
        }

        ReturnAction(1 var1_1) {
            this();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Component component = keyboardFocusManager.getFocusOwner();
            if (component != null && !(component instanceof JRootPane)) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (menuElementArray.length > 0) {
                MenuElement menuElement = menuElementArray[menuElementArray.length - 1];
                if (menuElement instanceof JMenu) {
                    MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length + 1];
                    System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length);
                    menuElementArray2[menuElementArray.length] = ((JMenu)menuElement).getPopupMenu();
                    menuSelectionManager.setSelectedPath(menuElementArray2);
                } else if (menuElement instanceof JMenuItem) {
                    JMenuItem jMenuItem = (JMenuItem)menuElement;
                    if (jMenuItem.getUI() instanceof SynthMenuItemUI) {
                        ((SynthMenuItemUI)jMenuItem.getUI()).doClick(menuSelectionManager);
                    } else {
                        menuSelectionManager.clearSelectedPath();
                        jMenuItem.doClick(0);
                    }
                }
            }
        }
    }

    private static class SelectNextItemAction
    extends AbstractAction {
        static boolean FORWARD = true;
        static boolean BACKWARD = false;
        boolean direction;

        SelectNextItemAction(boolean bl2) {
            this.direction = bl2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (menuElementArray.length < 2) {
                return;
            }
            int n2 = menuElementArray.length;
            if (menuElementArray[0] instanceof JMenuBar && menuElementArray[1] instanceof JMenu && n2 == 2) {
                MenuElement[] menuElementArray2;
                JPopupMenu jPopupMenu = ((JMenu)menuElementArray[1]).getPopupMenu();
                MenuElement menuElement = SynthPopupMenuUI.access$900(jPopupMenu.getSubElements(), -1, FORWARD);
                if (menuElement != null) {
                    menuElementArray2 = new MenuElement[4];
                    menuElementArray2[3] = menuElement;
                } else {
                    menuElementArray2 = new MenuElement[3];
                }
                System.arraycopy(menuElementArray, 0, menuElementArray2, 0, 2);
                menuElementArray2[2] = jPopupMenu;
                menuSelectionManager.setSelectedPath(menuElementArray2);
            } else if (menuElementArray[n2 - 1] instanceof JPopupMenu && menuElementArray[n2 - 2] instanceof JMenu) {
                JMenu jMenu = (JMenu)menuElementArray[n2 - 2];
                JPopupMenu jPopupMenu = jMenu.getPopupMenu();
                MenuElement menuElement = SynthPopupMenuUI.access$900(jPopupMenu.getSubElements(), -1, this.direction);
                if (menuElement != null) {
                    MenuElement[] menuElementArray3 = new MenuElement[n2 + 1];
                    System.arraycopy(menuElementArray, 0, menuElementArray3, 0, n2);
                    menuElementArray3[n2] = menuElement;
                    menuSelectionManager.setSelectedPath(menuElementArray3);
                } else if (n2 > 2 && menuElementArray[n2 - 3] instanceof JPopupMenu && (menuElement = SynthPopupMenuUI.access$1000((jPopupMenu = (JPopupMenu)menuElementArray[n2 - 3]).getSubElements(), jMenu, this.direction)) != null && menuElement != jMenu) {
                    MenuElement[] menuElementArray4 = new MenuElement[n2 - 1];
                    System.arraycopy(menuElementArray, 0, menuElementArray4, 0, n2 - 2);
                    menuElementArray4[n2 - 2] = menuElement;
                    menuSelectionManager.setSelectedPath(menuElementArray4);
                }
            } else {
                MenuElement[] menuElementArray5 = menuElementArray[n2 - 2].getSubElements();
                MenuElement menuElement = SynthPopupMenuUI.access$1000(menuElementArray5, menuElementArray[n2 - 1], this.direction);
                if (menuElement == null) {
                    menuElement = SynthPopupMenuUI.access$900(menuElementArray5, -1, this.direction);
                }
                if (menuElement != null) {
                    menuElementArray[n2 - 1] = menuElement;
                    menuSelectionManager.setSelectedPath(menuElementArray);
                }
            }
        }
    }

    private static class SelectParentChildAction
    extends AbstractAction {
        static boolean PARENT = false;
        static boolean CHILD = true;
        boolean direction;

        SelectParentChildAction(boolean bl2) {
            this.direction = bl2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            int n2 = menuElementArray.length;
            if (this.direction == PARENT) {
                int n3 = n2 - 1;
                if (n2 > 2 && (menuElementArray[n3] instanceof JPopupMenu || menuElementArray[--n3] instanceof JPopupMenu) && !((JMenu)menuElementArray[n3 - 1]).isTopLevelMenu()) {
                    MenuElement[] menuElementArray2 = new MenuElement[n3];
                    System.arraycopy(menuElementArray, 0, menuElementArray2, 0, n3);
                    menuSelectionManager.setSelectedPath(menuElementArray2);
                    return;
                }
            } else if (n2 > 0 && menuElementArray[n2 - 1] instanceof JMenu && !((JMenu)menuElementArray[n2 - 1]).isTopLevelMenu()) {
                MenuElement[] menuElementArray3;
                JMenu jMenu = (JMenu)menuElementArray[n2 - 1];
                JPopupMenu jPopupMenu = jMenu.getPopupMenu();
                MenuElement[] menuElementArray4 = jPopupMenu.getSubElements();
                MenuElement menuElement = SynthPopupMenuUI.access$900(menuElementArray4, -1, true);
                if (menuElement == null) {
                    menuElementArray3 = new MenuElement[n2 + 1];
                } else {
                    menuElementArray3 = new MenuElement[n2 + 2];
                    menuElementArray3[n2 + 1] = menuElement;
                }
                System.arraycopy(menuElementArray, 0, menuElementArray3, 0, n2);
                menuElementArray3[n2] = jPopupMenu;
                menuSelectionManager.setSelectedPath(menuElementArray3);
                return;
            }
            if (n2 > 1 && menuElementArray[0] instanceof JMenuBar) {
                MenuElement menuElement = menuElementArray[1];
                MenuElement menuElement2 = SynthPopupMenuUI.access$1000(menuElementArray[0].getSubElements(), menuElement, this.direction);
                if (menuElement2 != null && menuElement2 != menuElement) {
                    MenuElement[] menuElementArray5 = n2 == 2 ? new MenuElement[]{menuElementArray[0], menuElement2} : new MenuElement[]{menuElementArray[0], menuElement2, ((JMenu)menuElement2).getPopupMenu()};
                    menuSelectionManager.setSelectedPath(menuElementArray5);
                }
            }
        }
    }
}

