/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.LazyActionMap;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthMenuItemUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;

class SynthMenuUI
extends SynthMenuItemUI
implements LazyActionMap.Loader {
    protected ChangeListener changeListener;
    protected PropertyChangeListener propertyChangeListener;
    protected MenuListener menuListener;
    private int lastMnemonic = 0;
    private InputMap selectedWindowInputMap;
    private static final boolean TRACE = false;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;
    private static boolean crossMenuMnemonic = true;

    SynthMenuUI() {
    }

    protected void installDefaults() {
        super.installDefaults();
        ((JMenu)this.menuItem).setDelay(200);
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        this.updateMnemonicBinding();
    }

    protected void installListeners() {
        super.installListeners();
        if (this.changeListener == null) {
            this.changeListener = this.createChangeListener(this.menuItem);
        }
        if (this.changeListener != null) {
            this.menuItem.addChangeListener(this.changeListener);
        }
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = this.createPropertyChangeListener(this.menuItem);
        }
        if (this.propertyChangeListener != null) {
            this.menuItem.addPropertyChangeListener(this.propertyChangeListener);
        }
        if (this.menuListener == null) {
            this.menuListener = this.createMenuListener(this.menuItem);
        }
        if (this.menuListener != null) {
            ((JMenu)this.menuItem).addMenuListener(this.menuListener);
        }
    }

    void registerActionMap() {
        LazyActionMap.installLazyActionMap(this.menuItem, this);
    }

    protected void uninstallDefaults() {
        this.menuItem.setArmed(false);
        this.menuItem.setSelected(false);
        this.menuItem.resetKeyboardActions();
        super.uninstallDefaults();
    }

    protected void uninstallKeyboardActions() {
        super.uninstallKeyboardActions();
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.changeListener != null) {
            this.menuItem.removeChangeListener(this.changeListener);
        }
        if (this.propertyChangeListener != null) {
            this.menuItem.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.menuListener != null) {
            ((JMenu)this.menuItem).removeMenuListener(this.menuListener);
        }
        this.changeListener = null;
        this.propertyChangeListener = null;
        this.menuListener = null;
    }

    void updateMnemonicBinding() {
        int n2;
        int n3 = this.menuItem.getModel().getMnemonic();
        SynthContext synthContext = this.getContext((JComponent)this.menuItem, 1);
        int[] nArray = (int[])synthContext.getStyle().get(synthContext, "Menu.shortcutKeys");
        synthContext.dispose();
        if (n3 == this.lastMnemonic || nArray == null) {
            return;
        }
        if (this.lastMnemonic != 0 && this.windowInputMap != null) {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                this.windowInputMap.remove(KeyStroke.getKeyStroke(this.lastMnemonic, nArray[n2], false));
            }
        }
        if (n3 != 0) {
            if (this.windowInputMap == null) {
                this.windowInputMap = this.createInputMap(2);
                SwingUtilities.replaceUIInputMap(this.menuItem, 2, this.windowInputMap);
            }
            for (n2 = 0; n2 < nArray.length; ++n2) {
                this.windowInputMap.put(KeyStroke.getKeyStroke(n3, nArray[n2], false), "selectMenu");
            }
        }
        this.lastMnemonic = n3;
    }

    static boolean access$300() {
        return crossMenuMnemonic;
    }

    protected String getPropertyPrefix() {
        return "Menu";
    }

    protected void setupPostTimer(JMenu jMenu) {
        Timer timer = new Timer(jMenu.getDelay(), new PostAction(jMenu, false));
        timer.setRepeats(false);
        timer.start();
    }

    private void fetchStyle(JMenuItem jMenuItem) {
        SynthContext synthContext = this.getContext((JComponent)jMenuItem, 1);
        crossMenuMnemonic = synthContext.getStyle().getBoolean(synthContext, "Menu.crossMenuMnemonic", false);
        synthContext.dispose();
    }

    static JPopupMenu getActivePopupMenu() {
        MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
        for (int i2 = menuElementArray.length - 1; i2 >= 0; --i2) {
            MenuElement menuElement = menuElementArray[i2];
            if (!(menuElement instanceof JPopupMenu)) continue;
            return (JPopupMenu)menuElement;
        }
        return null;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        if (((JMenu)this.menuItem).isTopLevelMenu()) {
            Dimension dimension = jComponent.getPreferredSize();
            return new Dimension(dimension.width, Short.MAX_VALUE);
        }
        return null;
    }

    protected PropertyChangeListener createPropertyChangeListener(JComponent jComponent) {
        return new PropertyChangeHandler(this, null);
    }

    public void loadActionMap(JComponent jComponent, ActionMap actionMap) {
        SynthMenuItemUI.loadActionMap(actionMap);
        actionMap.put("selectMenu", new PostAction((JMenu)this.menuItem, true));
    }

    static void access$400(MenuElement[] menuElementArray, MenuElement menuElement) {
        SynthMenuUI.appendPath(menuElementArray, menuElement);
    }

    private static void appendPath(MenuElement[] menuElementArray, MenuElement menuElement) {
        MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length + 1];
        System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length);
        menuElementArray2[menuElementArray.length] = menuElement;
        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
    }

    protected ChangeListener createChangeListener(JComponent jComponent) {
        return null;
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent jComponent) {
        return new MenuDragMouseHandler(this, null);
    }

    protected MenuKeyListener createMenuKeyListener(JComponent jComponent) {
        return new MenuKeyHandler(this, null);
    }

    protected MenuListener createMenuListener(JComponent jComponent) {
        return null;
    }

    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return new MouseInputHandler(this);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthMenuUI();
    }

    static class 1 {
    }

    private class MenuDragMouseHandler
    implements MenuDragMouseListener {
        private final SynthMenuUI this$0;

        private MenuDragMouseHandler(SynthMenuUI synthMenuUI) {
            this.this$0 = synthMenuUI;
        }

        public void menuDragMouseDragged(MenuDragMouseEvent menuDragMouseEvent) {
            Component component;
            if (!this.this$0.menuItem.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = menuDragMouseEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray = menuDragMouseEvent.getPath();
            Point point = menuDragMouseEvent.getPoint();
            if (point.x >= 0 && point.x < this.this$0.menuItem.getWidth() && point.y >= 0 && point.y < this.this$0.menuItem.getHeight()) {
                JMenu jMenu = (JMenu)this.this$0.menuItem;
                MenuElement[] menuElementArray2 = menuSelectionManager.getSelectedPath();
                if (menuElementArray2.length <= 0 || menuElementArray2[menuElementArray2.length - 1] != jMenu.getPopupMenu()) {
                    if (jMenu.isTopLevelMenu() || jMenu.getDelay() == 0 || menuDragMouseEvent.getID() == 506) {
                        SynthMenuUI.access$400(menuElementArray, jMenu.getPopupMenu());
                    } else {
                        menuSelectionManager.setSelectedPath(menuElementArray);
                        this.this$0.setupPostTimer(jMenu);
                    }
                }
            } else if (menuDragMouseEvent.getID() == 502 && (component = menuSelectionManager.componentForPoint(menuDragMouseEvent.getComponent(), menuDragMouseEvent.getPoint())) == null) {
                menuSelectionManager.clearSelectedPath();
            }
        }

        public void menuDragMouseEntered(MenuDragMouseEvent menuDragMouseEvent) {
        }

        public void menuDragMouseExited(MenuDragMouseEvent menuDragMouseEvent) {
        }

        public void menuDragMouseReleased(MenuDragMouseEvent menuDragMouseEvent) {
        }

        MenuDragMouseHandler(SynthMenuUI synthMenuUI, 1 var2_2) {
            this(synthMenuUI);
        }
    }

    private class MenuKeyHandler
    implements MenuKeyListener {
        private final SynthMenuUI this$0;

        private char lower(char c2) {
            return Character.toLowerCase(c2);
        }

        private MenuKeyHandler(SynthMenuUI synthMenuUI) {
            this.this$0 = synthMenuUI;
        }

        public void menuKeyPressed(MenuKeyEvent menuKeyEvent) {
            char c2 = menuKeyEvent.getKeyChar();
            if (!Character.isLetterOrDigit(c2)) {
                return;
            }
            MenuSelectionManager menuSelectionManager = menuKeyEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray = menuKeyEvent.getPath();
            MenuElement[] menuElementArray2 = menuSelectionManager.getSelectedPath();
            for (int i2 = menuElementArray2.length - 1; i2 >= 0; --i2) {
                if (menuElementArray2[i2] != this.this$0.menuItem) continue;
                JPopupMenu jPopupMenu = ((JMenu)this.this$0.menuItem).getPopupMenu();
                if (!jPopupMenu.isVisible()) {
                    return;
                }
                MenuElement[] menuElementArray3 = jPopupMenu.getSubElements();
                MenuElement menuElement = menuElementArray2[menuElementArray2.length - 1];
                int n2 = -1;
                int n3 = 0;
                int n4 = -1;
                int[] nArray = null;
                for (int i3 = 0; i3 < menuElementArray3.length; ++i3) {
                    int n5 = ((JMenuItem)menuElementArray3[i3]).getMnemonic();
                    if (this.lower((char)n5) == this.lower(c2)) {
                        if (n3 == 0) {
                            n4 = i3;
                            ++n3;
                        } else {
                            if (nArray == null) {
                                nArray = new int[menuElementArray3.length];
                                nArray[0] = n4;
                            }
                            nArray[n3++] = i3;
                        }
                    }
                    if (menuElement != menuElementArray3[i3]) continue;
                    n2 = n3 - 1;
                }
                if (n3 != 0) {
                    if (n3 == 1) {
                        JMenuItem jMenuItem = (JMenuItem)menuElementArray3[n4];
                        if (!(jMenuItem instanceof JMenu)) {
                            menuSelectionManager.clearSelectedPath();
                            jMenuItem.doClick();
                        }
                    } else {
                        MenuElement menuElement2 = null;
                        menuElement2 = menuElementArray3[nArray[(n2 + 1) % n3]];
                        MenuElement[] menuElementArray4 = new MenuElement[menuElementArray.length + 2];
                        System.arraycopy(menuElementArray, 0, menuElementArray4, 0, menuElementArray.length);
                        menuElementArray4[menuElementArray.length] = jPopupMenu;
                        menuElementArray4[menuElementArray.length + 1] = menuElement2;
                        menuSelectionManager.setSelectedPath(menuElementArray4);
                    }
                }
                menuKeyEvent.consume();
                return;
            }
        }

        public void menuKeyReleased(MenuKeyEvent menuKeyEvent) {
        }

        public void menuKeyTyped(MenuKeyEvent menuKeyEvent) {
            JPopupMenu jPopupMenu;
            if (!SynthMenuUI.access$300() && (jPopupMenu = SynthMenuUI.getActivePopupMenu()) != null && jPopupMenu != this.this$0.menuItem.getParent()) {
                return;
            }
            int n2 = this.this$0.menuItem.getMnemonic();
            if (n2 == 0) {
                return;
            }
            Object[] objectArray = menuKeyEvent.getPath();
            if (this.lower((char)n2) == this.lower(menuKeyEvent.getKeyChar())) {
                JPopupMenu jPopupMenu2 = ((JMenu)this.this$0.menuItem).getPopupMenu();
                ArrayList arrayList = new ArrayList(Arrays.asList(objectArray));
                arrayList.add(jPopupMenu2);
                MenuElement[] menuElementArray = jPopupMenu2.getSubElements();
                if (menuElementArray.length > 0) {
                    arrayList.add(menuElementArray[0]);
                }
                MenuSelectionManager menuSelectionManager = menuKeyEvent.getMenuSelectionManager();
                Object[] objectArray2 = new MenuElement[]{};
                objectArray2 = (MenuElement[])arrayList.toArray(objectArray2);
                menuSelectionManager.setSelectedPath((MenuElement[])objectArray2);
                menuKeyEvent.consume();
            }
        }

        MenuKeyHandler(SynthMenuUI synthMenuUI, 1 var2_2) {
            this(synthMenuUI);
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        private final SynthMenuUI this$0;

        protected MouseInputHandler(SynthMenuUI synthMenuUI) {
            this.this$0 = synthMenuUI;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)this.this$0.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)this.this$0.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (!jMenu.isTopLevelMenu()) {
                if (menuElementArray.length <= 0 || menuElementArray[menuElementArray.length - 1] != jMenu.getPopupMenu()) {
                    if (jMenu.getDelay() == 0) {
                        SynthMenuUI.access$400(this.this$0.getPath(), jMenu.getPopupMenu());
                    } else {
                        menuSelectionManager.setSelectedPath(this.this$0.getPath());
                        this.this$0.setupPostTimer(jMenu);
                    }
                }
            } else if (menuElementArray.length > 0 && menuElementArray[0] == jMenu.getParent()) {
                MenuElement[] menuElementArray2 = new MenuElement[]{(MenuElement)((Object)jMenu.getParent()), jMenu, jMenu.getPopupMenu()};
                menuSelectionManager.setSelectedPath(menuElementArray2);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Object object;
            JMenu jMenu = (JMenu)this.this$0.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            if (jMenu.isTopLevelMenu()) {
                if (jMenu.isSelected()) {
                    menuSelectionManager.clearSelectedPath();
                } else {
                    object = jMenu.getParent();
                    if (object != null && object instanceof JMenuBar) {
                        MenuElement[] menuElementArray = new MenuElement[]{(MenuElement)object, jMenu};
                        menuSelectionManager.setSelectedPath(menuElementArray);
                    }
                }
            }
            if (((MenuElement[])(object = menuSelectionManager.getSelectedPath())).length > 0 && object[((MenuElement[])object).length - 1] != jMenu.getPopupMenu()) {
                if (jMenu.isTopLevelMenu() || jMenu.getDelay() == 0) {
                    SynthMenuUI.access$400(object, jMenu.getPopupMenu());
                } else {
                    this.this$0.setupPostTimer(jMenu);
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)this.this$0.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.processMouseEvent(mouseEvent);
            if (!mouseEvent.isConsumed()) {
                menuSelectionManager.clearSelectedPath();
            }
        }
    }

    private static class PostAction
    extends AbstractAction {
        JMenu menu;
        boolean force = false;

        public boolean isEnabled() {
            return this.menu.getModel().isEnabled();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            if (!SynthMenuUI.access$300() && (object = SynthMenuUI.getActivePopupMenu()) != null && object != this.menu.getParent()) {
                return;
            }
            object = MenuSelectionManager.defaultManager();
            if (this.force) {
                Container container = this.menu.getParent();
                if (container != null && container instanceof JMenuBar) {
                    MenuElement[] menuElementArray = this.menu.getPopupMenu().getSubElements();
                    MenuElement[] menuElementArray2 = menuElementArray.length > 0 ? new MenuElement[]{(MenuElement)((Object)container), this.menu, this.menu.getPopupMenu(), menuElementArray[0]} : new MenuElement[]{(MenuElement)((Object)container), this.menu, this.menu.getPopupMenu()};
                    ((MenuSelectionManager)object).setSelectedPath(menuElementArray2);
                }
            } else {
                MenuElement[] menuElementArray = ((MenuSelectionManager)object).getSelectedPath();
                if (menuElementArray.length > 0 && menuElementArray[menuElementArray.length - 1] == this.menu) {
                    SynthMenuUI.access$400(menuElementArray, this.menu.getPopupMenu());
                }
            }
        }

        PostAction(JMenu jMenu, boolean bl2) {
            this.menu = jMenu;
            this.force = bl2;
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private final SynthMenuUI this$0;

        private PropertyChangeHandler(SynthMenuUI synthMenuUI) {
            this.this$0 = synthMenuUI;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("mnemonic")) {
                this.this$0.updateMnemonicBinding();
            }
        }

        PropertyChangeHandler(SynthMenuUI synthMenuUI, 1 var2_2) {
            this(synthMenuUI);
        }
    }
}

