/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.LazyActionMap;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultDesktopManager;
import javax.swing.DesktopManager;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SortingFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.DesktopPaneUI;

class SynthDesktopPaneUI
extends DesktopPaneUI
implements PropertyChangeListener,
SynthUI,
LazyActionMap.Loader {
    private static Dimension minSize = new Dimension(0, 0);
    private static Dimension maxSize = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    private SynthStyle style;
    protected JDesktopPane desktop;
    protected DesktopManager desktopManager;
    protected KeyStroke minimizeKey;
    protected KeyStroke maximizeKey;
    protected KeyStroke closeKey;
    protected KeyStroke navigateKey;
    protected KeyStroke navigateKey2;
    private static Vector framesCache;
    private boolean moving = false;
    private boolean resizing = false;
    private final int MOVE_RESIZE_INCREMENT = 10;
    static Class class$com$sun$java$swing$plaf$gtk$SynthContext;

    protected void installDefaults() {
        this.fetchStyle(this.desktop);
    }

    protected void installDesktopManager() {
        if (this.desktop.getDesktopManager() == null) {
            this.desktopManager = new DefaultDesktopManager();
            this.desktop.setDesktopManager(this.desktopManager);
        }
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(2);
        if (inputMap != null) {
            SwingUtilities.replaceUIInputMap(this.desktop, 2, inputMap);
        }
        if ((inputMap = this.getInputMap(1)) != null) {
            SwingUtilities.replaceUIInputMap(this.desktop, 1, inputMap);
        }
        LazyActionMap.installLazyActionMap(this.desktop, this);
        this.registerKeyboardActions();
    }

    protected void installListeners() {
        this.desktop.addPropertyChangeListener(this);
    }

    protected void registerKeyboardActions() {
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext(this.desktop, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    protected void uninstallDesktopManager() {
        if (this.desktop.getDesktopManager() == this.desktopManager) {
            this.desktop.setDesktopManager(null);
        }
        this.desktopManager = null;
    }

    protected void uninstallKeyboardActions() {
        this.unregisterKeyboardActions();
        SwingUtilities.replaceUIInputMap(this.desktop, 2, null);
        SwingUtilities.replaceUIInputMap(this.desktop, 1, null);
        SwingUtilities.replaceUIActionMap(this.desktop, null);
    }

    protected void uninstallListeners() {
        this.desktop.removePropertyChangeListener(this);
    }

    protected void unregisterKeyboardActions() {
    }

    private void verifyFramesCache() {
        if (framesCache == null) {
            framesCache = new Vector();
        }
        boolean bl2 = false;
        int n2 = framesCache.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            JInternalFrame jInternalFrame;
            JComponent jComponent;
            JComponent jComponent2 = (JComponent)framesCache.elementAt(i2);
            if (jComponent2 instanceof JInternalFrame) {
                jComponent = (JInternalFrame)jComponent2;
                if (!((JInternalFrame)jComponent).isClosed()) continue;
                bl2 = true;
                break;
            }
            if (!(jComponent2 instanceof JInternalFrame.JDesktopIcon) || !(jInternalFrame = ((JInternalFrame.JDesktopIcon)(jComponent = (JInternalFrame.JDesktopIcon)jComponent2)).getInternalFrame()).isClosed()) continue;
            bl2 = true;
            break;
        }
        JInternalFrame[] jInternalFrameArray = this.desktop.getAllFrames();
        if (bl2 || jInternalFrameArray.length != framesCache.size()) {
            int n3;
            framesCache.clear();
            int n4 = this.desktop.lowestLayer();
            for (int i3 = n3 = this.desktop.highestLayer(); i3 >= n4; --i3) {
                Component[] componentArray = this.desktop.getComponentsInLayer(i3);
                if (componentArray.length <= 0) continue;
                for (int i4 = 0; i4 < componentArray.length; ++i4) {
                    framesCache.addElement(componentArray[i4]);
                }
            }
        }
    }

    static void access$300(SynthDesktopPaneUI synthDesktopPaneUI) {
        synthDesktopPaneUI.verifyFramesCache();
    }

    static boolean access$100(SynthDesktopPaneUI synthDesktopPaneUI) {
        return synthDesktopPaneUI.moving;
    }

    static boolean access$200(SynthDesktopPaneUI synthDesktopPaneUI) {
        return synthDesktopPaneUI.resizing;
    }

    static boolean access$102(SynthDesktopPaneUI synthDesktopPaneUI, boolean bl2) {
        synthDesktopPaneUI.moving = bl2;
        return synthDesktopPaneUI.moving;
    }

    static boolean access$202(SynthDesktopPaneUI synthDesktopPaneUI, boolean bl2) {
        synthDesktopPaneUI.resizing = bl2;
        return synthDesktopPaneUI.resizing;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.fetchStyle((JDesktopPane)propertyChangeEvent.getSource());
        }
    }

    static Vector access$400() {
        return framesCache;
    }

    InputMap createInputMap(int n2) {
        Object[] objectArray;
        if (n2 == 2 && (objectArray = (Object[])UIManager.get("Desktop.windowBindings")) != null) {
            return LookAndFeel.makeComponentInputMap(this.desktop, objectArray);
        }
        return null;
    }

    InputMap getInputMap(int n2) {
        if (n2 == 2) {
            return this.createInputMap(n2);
        }
        if (n2 == 1) {
            return (InputMap)UIManager.get("Desktop.ancestorInputMap");
        }
        return null;
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.desktop = (JDesktopPane)jComponent;
        this.installDefaults();
        this.installDesktopManager();
        this.installKeyboardActions();
        this.installListeners();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions();
        this.uninstallDesktopManager();
        this.uninstallDefaults();
        this.uninstallListeners();
        this.desktop = null;
    }

    private void fetchStyle(JDesktopPane jDesktopPane) {
        SynthContext synthContext = this.getContext(jDesktopPane, 1);
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        synthContext.dispose();
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n2) {
        return SynthContext.getContext(class$com$sun$java$swing$plaf$gtk$SynthContext == null ? (class$com$sun$java$swing$plaf$gtk$SynthContext = SynthDesktopPaneUI.class$("com.sun.java.swing.plaf.gtk.SynthContext")) : class$com$sun$java$swing$plaf$gtk$SynthContext, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n2);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return maxSize;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return minSize;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public void loadActionMap(JComponent jComponent, ActionMap actionMap) {
        actionMap.put("restore", new OpenAction(this));
        actionMap.put("close", new CloseAction(this));
        actionMap.put("move", new MoveResizeAction(this, "move"));
        actionMap.put("resize", new MoveResizeAction(this, "resize"));
        actionMap.put("left", new MoveResizeAction(this, "left"));
        actionMap.put("shrinkLeft", new MoveResizeAction(this, "shrinkLeft"));
        actionMap.put("right", new MoveResizeAction(this, "right"));
        actionMap.put("shrinkRight", new MoveResizeAction(this, "shrinkRight"));
        actionMap.put("up", new MoveResizeAction(this, "up"));
        actionMap.put("shrinkUp", new MoveResizeAction(this, "shrinkUp"));
        actionMap.put("down", new MoveResizeAction(this, "down"));
        actionMap.put("shrinkDown", new MoveResizeAction(this, "shrinkDown"));
        actionMap.put("escape", new MoveResizeAction(this, "escape"));
        actionMap.put("minimize", new MinimizeAction(this));
        actionMap.put("maximize", new MaximizeAction(this));
        actionMap.put("selectNextFrame", new NavigateAction(this));
        actionMap.put("selectPreviousFrame", new PreviousAction(this, null));
        actionMap.put("navigateNext", new NavigateOutAction(this, true));
        actionMap.put("navigatePrevious", new NavigateOutAction(this, false));
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthDesktopPaneUI();
    }

    static class 1 {
    }

    protected class CloseAction
    extends AbstractAction {
        private final SynthDesktopPaneUI this$0;

        public boolean isEnabled() {
            return true;
        }

        protected CloseAction(SynthDesktopPaneUI synthDesktopPaneUI) {
            this.this$0 = synthDesktopPaneUI;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JInternalFrame jInternalFrame = this.this$0.desktop.getSelectedFrame();
            if (jInternalFrame == null) {
                return;
            }
            if (jInternalFrame.isClosable()) {
                try {
                    jInternalFrame.setClosed(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }

    protected class MaximizeAction
    extends AbstractAction {
        private final SynthDesktopPaneUI this$0;

        public boolean isEnabled() {
            return true;
        }

        protected MaximizeAction(SynthDesktopPaneUI synthDesktopPaneUI) {
            this.this$0 = synthDesktopPaneUI;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JInternalFrame jInternalFrame = this.this$0.desktop.getSelectedFrame();
            if (jInternalFrame == null) {
                return;
            }
            if (jInternalFrame.isMaximizable() && !jInternalFrame.isMaximum()) {
                if (jInternalFrame.isIcon()) {
                    try {
                        jInternalFrame.setIcon(false);
                        jInternalFrame.setMaximum(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else {
                    try {
                        jInternalFrame.setMaximum(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    protected class MinimizeAction
    extends AbstractAction {
        private final SynthDesktopPaneUI this$0;

        public boolean isEnabled() {
            return true;
        }

        protected MinimizeAction(SynthDesktopPaneUI synthDesktopPaneUI) {
            this.this$0 = synthDesktopPaneUI;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JInternalFrame jInternalFrame = this.this$0.desktop.getSelectedFrame();
            if (jInternalFrame == null) {
                return;
            }
            if (jInternalFrame.isIconifiable() && !jInternalFrame.isIcon()) {
                try {
                    jInternalFrame.setIcon(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }

    private class MoveResizeAction
    extends AbstractAction {
        private String command;
        private final SynthDesktopPaneUI this$0;

        public boolean isEnabled() {
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JInternalFrame jInternalFrame = this.this$0.desktop.getSelectedFrame();
            if (jInternalFrame == null) {
                return;
            }
            if ("move".equals(this.command)) {
                SynthDesktopPaneUI.access$102(this.this$0, true);
                SynthDesktopPaneUI.access$202(this.this$0, false);
                return;
            }
            if ("resize".equals(this.command)) {
                SynthDesktopPaneUI.access$102(this.this$0, false);
                SynthDesktopPaneUI.access$202(this.this$0, true);
                return;
            }
            if ("escape".equals(this.command)) {
                SynthDesktopPaneUI.access$102(this.this$0, SynthDesktopPaneUI.access$202(this.this$0, false));
                return;
            }
            if (!SynthDesktopPaneUI.access$100(this.this$0) && !SynthDesktopPaneUI.access$200(this.this$0)) {
                return;
            }
            Dimension dimension = jInternalFrame.getSize();
            Dimension dimension2 = jInternalFrame.getMinimumSize();
            Point point = jInternalFrame.getLocation();
            if ("left".equals(this.command)) {
                if (SynthDesktopPaneUI.access$100(this.this$0)) {
                    jInternalFrame.setLocation(point.x - 10, point.y);
                } else if (SynthDesktopPaneUI.access$200(this.this$0)) {
                    jInternalFrame.setLocation(point.x - 10, point.y);
                    jInternalFrame.setSize(dimension.width + 10, dimension.height);
                }
            } else if ("right".equals(this.command)) {
                if (SynthDesktopPaneUI.access$100(this.this$0)) {
                    jInternalFrame.setLocation(point.x + 10, point.y);
                } else if (SynthDesktopPaneUI.access$200(this.this$0)) {
                    jInternalFrame.setLocation(point.x, point.y);
                    jInternalFrame.setSize(dimension.width + 10, dimension.height);
                }
            } else if ("up".equals(this.command)) {
                if (SynthDesktopPaneUI.access$100(this.this$0)) {
                    jInternalFrame.setLocation(point.x, point.y - 10);
                } else if (SynthDesktopPaneUI.access$200(this.this$0)) {
                    jInternalFrame.setLocation(point.x, point.y - 10);
                    jInternalFrame.setSize(dimension.width, dimension.height + 10);
                }
            } else if ("down".equals(this.command)) {
                if (SynthDesktopPaneUI.access$100(this.this$0)) {
                    jInternalFrame.setLocation(point.x, point.y + 10);
                } else if (SynthDesktopPaneUI.access$200(this.this$0)) {
                    jInternalFrame.setLocation(point.x, point.y);
                    jInternalFrame.setSize(dimension.width, dimension.height + 10);
                }
            } else if ("shrinkLeft".equals(this.command) && SynthDesktopPaneUI.access$200(this.this$0)) {
                if (dimension2.width < dimension.width - 10) {
                    jInternalFrame.setLocation(point.x, point.y);
                    jInternalFrame.setSize(dimension.width - 10, dimension.height);
                } else {
                    jInternalFrame.setSize(dimension2.width, dimension.height);
                }
            } else if ("shrinkRight".equals(this.command) && SynthDesktopPaneUI.access$200(this.this$0)) {
                if (dimension2.width < dimension.width - 10) {
                    jInternalFrame.setLocation(point.x + 10, point.y);
                    jInternalFrame.setSize(dimension.width - 10, dimension.height);
                } else {
                    jInternalFrame.setLocation(point.x - dimension2.width + dimension.width, point.y);
                    jInternalFrame.setSize(dimension2.width, dimension.height);
                }
            } else if ("shrinkUp".equals(this.command) && SynthDesktopPaneUI.access$200(this.this$0)) {
                if (dimension2.height < dimension.height - 10) {
                    jInternalFrame.setLocation(point.x, point.y);
                    jInternalFrame.setSize(dimension.width, dimension.height - 10);
                } else {
                    jInternalFrame.setSize(dimension.width, dimension2.height);
                }
            } else if ("shrinkDown".equals(this.command) && SynthDesktopPaneUI.access$200(this.this$0)) {
                if (dimension2.height < dimension.height - 10) {
                    jInternalFrame.setLocation(point.x, point.y + 10);
                    jInternalFrame.setSize(dimension.width, dimension.height - 10);
                } else {
                    jInternalFrame.setLocation(point.x, point.y - dimension2.height + dimension.height);
                    jInternalFrame.setSize(dimension.width, dimension2.height);
                }
            }
        }

        public MoveResizeAction(SynthDesktopPaneUI synthDesktopPaneUI, String string) {
            this.this$0 = synthDesktopPaneUI;
            this.command = string;
        }
    }

    protected class NavigateAction
    extends AbstractAction {
        private final SynthDesktopPaneUI this$0;

        public boolean isEnabled() {
            return true;
        }

        protected NavigateAction(SynthDesktopPaneUI synthDesktopPaneUI) {
            this.this$0 = synthDesktopPaneUI;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent;
            int n2 = 0;
            SynthDesktopPaneUI.access$300(this.this$0);
            if (SynthDesktopPaneUI.access$400().size() == 0) {
                return;
            }
            JInternalFrame jInternalFrame = this.this$0.desktop.getSelectedFrame();
            if (jInternalFrame != null) {
                n2 = SynthDesktopPaneUI.access$400().indexOf(jInternalFrame);
            }
            if (n2 == -1 && (n2 = SynthDesktopPaneUI.access$400().indexOf(jInternalFrame.getDesktopIcon())) == -1) {
                return;
            }
            if (++n2 == SynthDesktopPaneUI.access$400().size()) {
                n2 = 0;
            }
            if ((jComponent = (JComponent)SynthDesktopPaneUI.access$400().elementAt(n2)) instanceof JInternalFrame) {
                try {
                    ((JInternalFrame)jComponent).setSelected(true);
                    this.this$0.desktopManager.activateFrame((JInternalFrame)jComponent);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else {
                if (!(jComponent instanceof JInternalFrame.JDesktopIcon)) {
                    return;
                }
                try {
                    ((JInternalFrame.JDesktopIcon)jComponent).getInternalFrame().setSelected(true);
                    this.this$0.desktopManager.activateFrame(((JInternalFrame.JDesktopIcon)jComponent).getInternalFrame());
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }

    private class NavigateOutAction
    extends AbstractAction {
        private boolean moveForward;
        private final SynthDesktopPaneUI this$0;

        public boolean isEnabled() {
            return true;
        }

        public NavigateOutAction(SynthDesktopPaneUI synthDesktopPaneUI, boolean bl2) {
            this.this$0 = synthDesktopPaneUI;
            this.moveForward = bl2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            FocusTraversalPolicy focusTraversalPolicy;
            Container container = this.this$0.desktop.getFocusCycleRootAncestor();
            if (container != null && (focusTraversalPolicy = container.getFocusTraversalPolicy()) != null && focusTraversalPolicy instanceof SortingFocusTraversalPolicy) {
                SortingFocusTraversalPolicy sortingFocusTraversalPolicy = (SortingFocusTraversalPolicy)focusTraversalPolicy;
                boolean bl2 = sortingFocusTraversalPolicy.getImplicitDownCycleTraversal();
                try {
                    sortingFocusTraversalPolicy.setImplicitDownCycleTraversal(false);
                    if (this.moveForward) {
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(this.this$0.desktop);
                    } else {
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent(this.this$0.desktop);
                    }
                }
                finally {
                    sortingFocusTraversalPolicy.setImplicitDownCycleTraversal(bl2);
                }
            }
        }
    }

    protected class OpenAction
    extends AbstractAction {
        private final SynthDesktopPaneUI this$0;

        public boolean isEnabled() {
            return true;
        }

        protected OpenAction(SynthDesktopPaneUI synthDesktopPaneUI) {
            this.this$0 = synthDesktopPaneUI;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JInternalFrame jInternalFrame = this.this$0.desktop.getSelectedFrame();
            if (jInternalFrame == null) {
                return;
            }
            try {
                if (jInternalFrame.isIcon()) {
                    jInternalFrame.setIcon(false);
                } else if (jInternalFrame.isMaximum()) {
                    jInternalFrame.setMaximum(false);
                }
                jInternalFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    private class PreviousAction
    extends AbstractAction {
        private final SynthDesktopPaneUI this$0;

        public boolean isEnabled() {
            return true;
        }

        private PreviousAction(SynthDesktopPaneUI synthDesktopPaneUI) {
            this.this$0 = synthDesktopPaneUI;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent;
            int n2 = 0;
            SynthDesktopPaneUI.access$300(this.this$0);
            if (SynthDesktopPaneUI.access$400().size() == 0) {
                return;
            }
            JInternalFrame jInternalFrame = this.this$0.desktop.getSelectedFrame();
            if (jInternalFrame != null) {
                n2 = SynthDesktopPaneUI.access$400().indexOf(jInternalFrame);
            }
            if (n2 == -1 && (n2 = SynthDesktopPaneUI.access$400().indexOf(jInternalFrame.getDesktopIcon())) == -1) {
                return;
            }
            if (--n2 == -1) {
                n2 = SynthDesktopPaneUI.access$400().size() - 1;
            }
            if ((jComponent = (JComponent)SynthDesktopPaneUI.access$400().elementAt(n2)) instanceof JInternalFrame) {
                try {
                    ((JInternalFrame)jComponent).setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else {
                if (!(jComponent instanceof JInternalFrame.JDesktopIcon)) {
                    return;
                }
                try {
                    ((JInternalFrame.JDesktopIcon)jComponent).getInternalFrame().setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        PreviousAction(SynthDesktopPaneUI synthDesktopPaneUI, 1 var2_2) {
            this(synthDesktopPaneUI);
        }
    }
}

