/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.Activation;

import com.sun.corba.se.ActivationIDL.EndPointInfo;
import com.sun.corba.se.ActivationIDL.InvalidORBid;
import com.sun.corba.se.ActivationIDL.LocatorPackage.ServerLocation;
import com.sun.corba.se.ActivationIDL.LocatorPackage.ServerLocationPerORB;
import com.sun.corba.se.ActivationIDL.NoSuchEndPoint;
import com.sun.corba.se.ActivationIDL.ORBAlreadyRegistered;
import com.sun.corba.se.ActivationIDL.ORBPortInfo;
import com.sun.corba.se.ActivationIDL.Repository;
import com.sun.corba.se.ActivationIDL.RepositoryPackage.ServerDef;
import com.sun.corba.se.ActivationIDL.Server;
import com.sun.corba.se.ActivationIDL.ServerAlreadyActive;
import com.sun.corba.se.ActivationIDL.ServerAlreadyInstalled;
import com.sun.corba.se.ActivationIDL.ServerAlreadyUninstalled;
import com.sun.corba.se.ActivationIDL.ServerHeldDown;
import com.sun.corba.se.ActivationIDL.ServerNotActive;
import com.sun.corba.se.ActivationIDL.ServerNotRegistered;
import com.sun.corba.se.ActivationIDL._ServerManagerImplBase;
import com.sun.corba.se.internal.Activation.ProcessMonitorThread;
import com.sun.corba.se.internal.Activation.ServerTableEntry;
import com.sun.corba.se.internal.POA.BadServerIdHandler;
import com.sun.corba.se.internal.POA.ForwardException;
import com.sun.corba.se.internal.POA.POAORB;
import com.sun.corba.se.internal.core.IOR;
import com.sun.corba.se.internal.core.ORB;
import com.sun.corba.se.internal.core.ServerGIOP;
import com.sun.corba.se.internal.ior.ObjectKey;
import com.sun.corba.se.internal.ior.POAObjectKeyTemplate;
import com.sun.corba.se.internal.orbutil.ORBClassLoader;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.OBJECT_NOT_EXIST;

public class ServerManagerImpl
extends _ServerManagerImplBase
implements BadServerIdHandler {
    HashMap serverTable;
    Repository repository;
    ServerGIOP sgiop;
    int initialPort;
    POAORB orb;
    String dbDirName;
    boolean debug = false;
    private int serverStartupDelay;
    static Class class$org$omg$CORBA$ORB;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getActiveServers() {
        int[] nArray = null;
        Serializable serializable = this.serverTable;
        synchronized (serializable) {
            ServerTableEntry serverTableEntry;
            ArrayList arrayList = new ArrayList(0);
            Iterator iterator = this.serverTable.keySet().iterator();
            try {
                while (iterator.hasNext()) {
                    Integer n2 = (Integer)iterator.next();
                    serverTableEntry = (ServerTableEntry)this.serverTable.get(n2);
                    if (!serverTableEntry.isValid() || !serverTableEntry.isActive()) continue;
                    arrayList.add(serverTableEntry);
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            nArray = new int[arrayList.size()];
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                serverTableEntry = (ServerTableEntry)arrayList.get(i2);
                nArray[i2] = serverTableEntry.getServerId();
            }
        }
        if (this.debug) {
            serializable = new StringBuffer();
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                ((StringBuffer)serializable).append(' ');
                ((StringBuffer)serializable).append(nArray[i3]);
            }
            System.out.println("ServerManagerImpl: getActiveServers returns" + ((StringBuffer)serializable).toString());
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(int n2) throws ServerAlreadyActive, ServerNotRegistered, ServerHeldDown {
        block9: {
            ServerTableEntry serverTableEntry;
            Integer n3 = new Integer(n2);
            HashMap hashMap = this.serverTable;
            synchronized (hashMap) {
                serverTableEntry = (ServerTableEntry)this.serverTable.get(n3);
            }
            if (serverTableEntry != null && serverTableEntry.isActive()) {
                if (this.debug) {
                    System.out.println("ServerManagerImpl: activate for server Id " + n2 + " failed because server is already active. " + "entry = " + serverTableEntry);
                }
                throw new ServerAlreadyActive(n2);
            }
            try {
                serverTableEntry = this.getEntry(n2);
                if (this.debug) {
                    System.out.println("ServerManagerImpl: locateServer called with  serverId=" + n2 + " endpointType=" + "IIOP_CLEAR_TEXT" + " block=false");
                }
                ServerLocation serverLocation = this.locateServer(serverTableEntry, "IIOP_CLEAR_TEXT", false);
                if (this.debug) {
                    System.out.println("ServerManagerImpl: activate for server Id " + n2 + " found location " + serverLocation.hostname + " and activated it");
                }
            }
            catch (NoSuchEndPoint noSuchEndPoint) {
                if (!this.debug) break block9;
                System.out.println("ServerManagerImpl: activate for server Id  threw NoSuchEndpoint exception, which was ignored");
            }
        }
    }

    public void install(int n2) throws ServerNotRegistered, ServerHeldDown, ServerAlreadyInstalled {
        ServerTableEntry serverTableEntry = this.getRunningEntry(n2);
        if (serverTableEntry != null) {
            this.repository.install(n2);
            serverTableEntry.install();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(int n2) throws ServerNotActive {
        Integer n3 = new Integer(n2);
        HashMap hashMap = this.serverTable;
        synchronized (hashMap) {
            block8: {
                ServerTableEntry serverTableEntry = (ServerTableEntry)this.serverTable.remove(n3);
                if (serverTableEntry == null) {
                    if (this.debug) {
                        System.out.println("ServerManagerImpl: shutdown for server Id " + n2 + " throws ServerNotActive.");
                    }
                    throw new ServerNotActive(n2);
                }
                try {
                    serverTableEntry.destroy();
                    if (this.debug) {
                        System.out.println("ServerManagerImpl: shutdown for server Id " + n2 + " completed.");
                    }
                }
                catch (Exception exception) {
                    if (!this.debug) break block8;
                    System.out.println("ServerManagerImpl: shutdown for server Id " + n2 + " threw exception " + exception);
                }
            }
        }
    }

    public void uninstall(int n2) throws ServerNotRegistered, ServerHeldDown, ServerAlreadyUninstalled {
        ServerTableEntry serverTableEntry = (ServerTableEntry)this.serverTable.get(new Integer(n2));
        if (serverTableEntry != null) {
            serverTableEntry = (ServerTableEntry)this.serverTable.remove(new Integer(n2));
            if (serverTableEntry == null) {
                if (this.debug) {
                    System.out.println("ServerManagerImpl: shutdown for server Id " + n2 + " throws ServerNotActive.");
                }
                throw new ServerHeldDown(n2);
            }
            serverTableEntry.uninstall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void active(int n2, Server server) throws ServerNotRegistered {
        Integer n3 = new Integer(n2);
        HashMap hashMap = this.serverTable;
        synchronized (hashMap) {
            ServerTableEntry serverTableEntry = (ServerTableEntry)this.serverTable.get(n3);
            if (serverTableEntry == null) {
                if (this.debug) {
                    System.out.println("ServerManagerImpl: active for server Id " + n2 + " called, but no such server is registered.");
                }
                throw new INTERNAL(1398079891, CompletionStatus.COMPLETED_NO);
            }
            if (this.debug) {
                System.out.println("ServerManagerImpl: active for server Id " + n2 + " called.  This server is now active.");
            }
            serverTableEntry.register(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerTableEntry getEntry(int n2) throws ServerNotRegistered {
        Integer n3 = new Integer(n2);
        ServerTableEntry serverTableEntry = null;
        HashMap hashMap = this.serverTable;
        synchronized (hashMap) {
            serverTableEntry = (ServerTableEntry)this.serverTable.get(n3);
            if (this.debug) {
                if (serverTableEntry == null) {
                    System.out.println("ServerManagerImpl: getEntry: no active server found.");
                } else {
                    System.out.println("ServerManagerImpl: getEntry:  active server found " + serverTableEntry + ".");
                }
            }
            if (serverTableEntry != null && !serverTableEntry.isValid()) {
                this.serverTable.remove(n3);
                serverTableEntry = null;
            }
            if (serverTableEntry == null) {
                ServerDef serverDef = this.repository.getServer(n2);
                serverTableEntry = new ServerTableEntry(n2, serverDef, this.initialPort, this.dbDirName, false, this.debug);
                this.serverTable.put(n3, serverTableEntry);
                serverTableEntry.activate();
            }
        }
        return serverTableEntry;
    }

    private ServerTableEntry getRunningEntry(int n2) throws ServerNotRegistered {
        ServerTableEntry serverTableEntry = this.getEntry(n2);
        try {
            ORBPortInfo[] oRBPortInfoArray = serverTableEntry.lookup("IIOP_CLEAR_TEXT");
        }
        catch (Exception exception) {
            return null;
        }
        return serverTableEntry;
    }

    public void handle(ObjectKey objectKey) throws ForwardException {
        IOR iOR = null;
        POAObjectKeyTemplate pOAObjectKeyTemplate = (POAObjectKeyTemplate)objectKey.getTemplate();
        int n2 = pOAObjectKeyTemplate.getServerId();
        String string = pOAObjectKeyTemplate.getORBId();
        try {
            ServerTableEntry serverTableEntry = this.getEntry(n2);
            ServerLocationPerORB serverLocationPerORB = this.locateServerForORB(serverTableEntry, string, true);
            if (this.debug) {
                System.out.println("ServerManagerImpl: handle called for server id" + n2 + "  orbid  " + string);
            }
            int n3 = 0;
            EndPointInfo[] endPointInfoArray = serverLocationPerORB.ports;
            for (int i2 = 0; i2 < endPointInfoArray.length; ++i2) {
                if (!endPointInfoArray[i2].endpointType.equals("IIOP_CLEAR_TEXT")) continue;
                n3 = endPointInfoArray[i2].port;
                break;
            }
            iOR = new IOR((ORB)this.orb, "IDL:org/omg/CORBA/Object:1.0", serverLocationPerORB.hostname, n3, objectKey);
        }
        catch (Exception exception) {
            if (this.debug) {
                System.out.println("ServerManagerImpl: handle throws OBJECT_NOT_EXIST");
            }
            throw new OBJECT_NOT_EXIST();
        }
        if (this.debug) {
            System.out.println("ServerManagerImpl: handle throws ForwardException");
        }
        try {
            Thread.sleep(this.serverStartupDelay);
        }
        catch (Exception exception) {
            System.out.println("Exception = " + exception);
            exception.printStackTrace();
        }
        throw new ForwardException(iOR);
    }

    public String[] getORBNames(int n2) throws ServerNotRegistered {
        try {
            ServerTableEntry serverTableEntry = this.getEntry(n2);
            return serverTableEntry.getORBList();
        }
        catch (Exception exception) {
            throw new ServerNotRegistered(n2);
        }
    }

    public int getEndpoint(String string) throws NoSuchEndPoint {
        return this.sgiop.getServerPort(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEndpoints(int n2, String string, EndPointInfo[] endPointInfoArray) throws NoSuchEndPoint, ServerNotRegistered, ORBAlreadyRegistered {
        Integer n3 = new Integer(n2);
        HashMap hashMap = this.serverTable;
        synchronized (hashMap) {
            ServerTableEntry serverTableEntry = (ServerTableEntry)this.serverTable.get(n3);
            if (serverTableEntry == null) {
                if (this.debug) {
                    System.out.println("ServerManagerImpl: registerEndpoint for server Id " + n2 + " called, but no such server is registered.");
                }
                throw new INTERNAL(1398079891, CompletionStatus.COMPLETED_NO);
            }
            if (this.debug) {
                System.out.println("ServerManagerImpl: registerEndpoints for server Id " + n2 + " called.  This server is now active.");
            }
            serverTableEntry.registerPorts(string, endPointInfoArray);
        }
    }

    public ServerLocation locateServer(int n2, String string) throws NoSuchEndPoint, ServerNotRegistered, ServerHeldDown {
        ServerTableEntry serverTableEntry = this.getEntry(n2);
        if (this.debug) {
            System.out.println("ServerManagerImpl: locateServer called with  serverId=" + n2 + " endpointType=" + string + " block=true");
        }
        return this.locateServer(serverTableEntry, string, true);
    }

    public ServerLocationPerORB locateServerForORB(int n2, String string) throws InvalidORBid, ServerNotRegistered, ServerHeldDown {
        ServerTableEntry serverTableEntry = this.getEntry(n2);
        if (this.debug) {
            System.out.println("ServerManagerImpl: locateServerForORB called with  serverId=" + n2 + " orbId=" + string + " block=true");
        }
        return this.locateServerForORB(serverTableEntry, string, true);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public int getServerPortForType(ServerLocationPerORB serverLocationPerORB, String string) throws NoSuchEndPoint {
        EndPointInfo[] endPointInfoArray = serverLocationPerORB.ports;
        for (int i2 = 0; i2 < endPointInfoArray.length; ++i2) {
            if (!endPointInfoArray[i2].endpointType.equals(string)) continue;
            return endPointInfoArray[i2].port;
        }
        throw new NoSuchEndPoint();
    }

    private ServerLocation locateServer(ServerTableEntry serverTableEntry, String string, boolean bl2) throws NoSuchEndPoint, ServerNotRegistered, ServerHeldDown {
        ServerLocation serverLocation = new ServerLocation();
        if (bl2) {
            String string2;
            ORBPortInfo[] oRBPortInfoArray;
            try {
                oRBPortInfoArray = serverTableEntry.lookup(string);
            }
            catch (Exception exception) {
                if (this.debug) {
                    System.out.println("ServerManagerImpl: locateServer: server held down");
                }
                throw new ServerHeldDown(serverTableEntry.getServerId());
            }
            serverLocation.hostname = string2 = this.orb.getServerEndpoint().getHostName();
            int n2 = oRBPortInfoArray != null ? oRBPortInfoArray.length : 0;
            serverLocation.ports = new ORBPortInfo[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                serverLocation.ports[i2] = new ORBPortInfo(oRBPortInfoArray[i2].orbId, oRBPortInfoArray[i2].port);
                if (!this.debug) continue;
                System.out.println("ServerManagerImpl: locateServer: server located at location " + serverLocation.hostname + " ORBid  " + oRBPortInfoArray[i2].orbId + " Port " + oRBPortInfoArray[i2].port);
            }
        }
        return serverLocation;
    }

    private ServerLocationPerORB locateServerForORB(ServerTableEntry serverTableEntry, String string, boolean bl2) throws InvalidORBid, ServerNotRegistered, ServerHeldDown {
        ServerLocationPerORB serverLocationPerORB = new ServerLocationPerORB();
        if (bl2) {
            String string2;
            EndPointInfo[] endPointInfoArray;
            try {
                endPointInfoArray = serverTableEntry.lookupForORB(string);
            }
            catch (InvalidORBid invalidORBid) {
                throw invalidORBid;
            }
            catch (Exception exception) {
                if (this.debug) {
                    System.out.println("ServerManagerImpl: locateServerForORB: server held down");
                }
                throw new ServerHeldDown(serverTableEntry.getServerId());
            }
            serverLocationPerORB.hostname = string2 = this.orb.getServerEndpoint().getHostName();
            int n2 = endPointInfoArray != null ? endPointInfoArray.length : 0;
            serverLocationPerORB.ports = new EndPointInfo[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                serverLocationPerORB.ports[i2] = new EndPointInfo(endPointInfoArray[i2].endpointType, endPointInfoArray[i2].port);
                if (!this.debug) continue;
                System.out.println("ServerManagerImpl: locateServer: server located at location " + serverLocationPerORB.hostname + " endpointType  " + endPointInfoArray[i2].endpointType + " Port " + endPointInfoArray[i2].port);
            }
        }
        return serverLocationPerORB;
    }

    ServerManagerImpl(POAORB pOAORB, ServerGIOP serverGIOP, Repository repository, String string, boolean bl2) {
        this.orb = pOAORB;
        this.sgiop = serverGIOP;
        this.repository = repository;
        this.dbDirName = string;
        this.debug = bl2;
        this.initialPort = pOAORB.getServerGIOP().getBootstrapEndpoint(0).getPort();
        this.serverTable = new HashMap(256);
        this.serverStartupDelay = 1000;
        String string2 = System.getProperty("com.sun.CORBA.activation.ServerStartupDelay");
        if (string2 != null) {
            try {
                this.serverStartupDelay = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        BadServerIdHandler badServerIdHandler = null;
        if (pOAORB.getBadServerIdHandlerClass() == null) {
            badServerIdHandler = this;
        } else {
            try {
                Class[] classArray = new Class[]{class$org$omg$CORBA$ORB == null ? (class$org$omg$CORBA$ORB = ServerManagerImpl.class$("org.omg.CORBA.ORB")) : class$org$omg$CORBA$ORB};
                Object[] objectArray = new Object[]{pOAORB};
                Class clazz = ORBClassLoader.loadClass(pOAORB.getBadServerIdHandlerClass());
                Constructor constructor = clazz.getConstructor(classArray);
                badServerIdHandler = (BadServerIdHandler)constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                throw new INITIALIZE("Error while creating BadServerIdHandler: " + exception.getMessage());
            }
        }
        pOAORB.setBadServerIdHandler(badServerIdHandler);
        pOAORB.connect(this);
        ProcessMonitorThread.start(this.serverTable);
    }
}

