/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.SunJSSE_b;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactorySpi;

public class TrustManagerFactory {
    private Provider a;
    private TrustManagerFactorySpi b;
    private String c;

    public final String getAlgorithm() {
        return this.c;
    }

    public static final String getDefaultAlgorithm() {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Security.getProperty("ssl.TrustManagerFactory.algorithm");
            }
        });
        if (string == null) {
            string = "SunX509";
        }
        return string;
    }

    public final void init(KeyStore keyStore) throws KeyStoreException {
        this.b.engineInit(keyStore);
    }

    public final Provider getProvider() {
        return this.a;
    }

    public final void init(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
        this.b.engineInit(managerFactoryParameters);
    }

    public final TrustManager[] getTrustManagers() {
        return this.b.engineGetTrustManagers();
    }

    public static final TrustManagerFactory getInstance(String string) throws NoSuchAlgorithmException {
        try {
            Object[] objectArray = SunJSSE_b.a(string, "TrustManagerFactory", (String)null);
            return new TrustManagerFactory((TrustManagerFactorySpi)objectArray[0], (Provider)objectArray[1], string);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException(string + " not found");
        }
    }

    protected TrustManagerFactory(TrustManagerFactorySpi trustManagerFactorySpi, Provider provider, String string) {
        this.b = trustManagerFactorySpi;
        this.a = provider;
        this.c = string;
    }

    public static final TrustManagerFactory getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("missing provider");
        }
        Object[] objectArray = SunJSSE_b.a(string, "TrustManagerFactory", string2);
        return new TrustManagerFactory((TrustManagerFactorySpi)objectArray[0], (Provider)objectArray[1], string);
    }

    public static final TrustManagerFactory getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("missing provider");
        }
        Object[] objectArray = SunJSSE_b.a(string, "TrustManagerFactory", provider);
        return new TrustManagerFactory((TrustManagerFactorySpi)objectArray[0], (Provider)objectArray[1], string);
    }
}

