/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.javaws.Resources;
import com.sun.javaws.debug.Debug;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.jnlp.FileContents;
import javax.jnlp.JNLPRandomAccessFile;

public final class JNLPRandomAccessFileImpl
implements JNLPRandomAccessFile {
    private RandomAccessFile _raf = null;
    private FileContents _contents = null;
    private long _length = 0L;
    private String _message = null;

    public byte readByte() throws IOException {
        return this._raf.readByte();
    }

    public char readChar() throws IOException {
        return this._raf.readChar();
    }

    public double readDouble() throws IOException {
        return this._raf.readDouble();
    }

    public float readFloat() throws IOException {
        return this._raf.readFloat();
    }

    public int read() throws IOException {
        return this._raf.read();
    }

    public int readInt() throws IOException {
        return this._raf.readInt();
    }

    public int readUnsignedByte() throws IOException {
        return this._raf.readUnsignedByte();
    }

    public int readUnsignedShort() throws IOException {
        return this._raf.readUnsignedShort();
    }

    public long getFilePointer() throws IOException {
        return this._raf.getFilePointer();
    }

    public long length() throws IOException {
        return this._raf.length();
    }

    public long readLong() throws IOException {
        return this._raf.readLong();
    }

    public short readShort() throws IOException {
        return this._raf.readShort();
    }

    public void close() throws IOException {
        this._raf.close();
    }

    public boolean readBoolean() throws IOException {
        return this._raf.readBoolean();
    }

    public void writeDouble(double d) throws IOException {
        this.checkWrite(8);
        this._raf.writeDouble(d);
    }

    public void writeFloat(float f) throws IOException {
        this.checkWrite(4);
        this._raf.writeFloat(f);
    }

    public int skipBytes(int n) throws IOException {
        return this._raf.skipBytes(n);
    }

    private void checkWrite(int n) throws IOException {
        if (this._raf.getFilePointer() + (long)n > this._contents.getMaxLength()) {
            throw new IOException(this._message);
        }
    }

    public void write(int n) throws IOException {
        this.checkWrite(1);
        this._raf.write(n);
    }

    public void writeByte(int n) throws IOException {
        this.checkWrite(1);
        this._raf.writeByte(n);
    }

    public void writeChar(int n) throws IOException {
        this.checkWrite(2);
        this._raf.writeChar(n);
    }

    public void writeInt(int n) throws IOException {
        this.checkWrite(4);
        this._raf.writeInt(n);
    }

    public void writeShort(int n) throws IOException {
        this.checkWrite(2);
        this._raf.writeShort(n);
    }

    public void seek(long l) throws IOException {
        this._raf.seek(l);
    }

    public void setLength(long l) throws IOException {
        if (l > this._contents.getMaxLength()) {
            throw new IOException(this._message);
        }
        this._raf.setLength(l);
    }

    public void writeLong(long l) throws IOException {
        this.checkWrite(8);
        this._raf.writeLong(l);
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.checkWrite(1);
        this._raf.writeBoolean(bl);
    }

    public int read(byte[] byArray) throws IOException {
        return this._raf.read(byArray);
    }

    public void readFully(byte[] byArray) throws IOException {
        this._raf.readFully(byArray);
    }

    public void write(byte[] byArray) throws IOException {
        if (byArray != null) {
            this.checkWrite(byArray.length);
        }
        this._raf.write(byArray);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this._raf.read(byArray, n, n2);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this._raf.readFully(byArray, n, n2);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.checkWrite(n2);
        this._raf.write(byArray, n, n2);
    }

    public String readLine() throws IOException {
        return this._raf.readLine();
    }

    public String readUTF() throws IOException {
        return this._raf.readUTF();
    }

    private int getUTFLen(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        int n2 = 2;
        int n3 = 0;
        while (n3 < n) {
            char c = cArray[n3];
            n2 = c >= '\u0001' && c <= '\u007f' ? ++n2 : (c > '\u07ff' ? (n2 += 3) : (n2 += 2));
            ++n3;
        }
        return n2;
    }

    public void writeBytes(String string) throws IOException {
        if (string != null) {
            this.checkWrite(string.length());
        }
        this._raf.writeBytes(string);
    }

    public void writeChars(String string) throws IOException {
        if (string != null) {
            this.checkWrite(string.length() * 2);
        }
        this._raf.writeChars(string);
    }

    public void writeUTF(String string) throws IOException {
        if (string != null) {
            this.checkWrite(this.getUTFLen(string));
        }
        this._raf.writeUTF(string);
    }

    JNLPRandomAccessFileImpl(File file, String string, FileContents fileContents) throws IOException {
        this._raf = new RandomAccessFile(file, string);
        this._length = this._raf.length();
        this._contents = fileContents;
        Debug.jawsAssert(this._contents != null, "must be set");
        if (this._message == null) {
            this._message = Resources.getString("APIImpl.persistence.filesizemessage");
        }
    }
}

