/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.ui.console;

import com.sun.javaws.ConfigProperties;
import com.sun.javaws.Resources;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.debug.Globals;
import com.sun.javaws.ui.general.GeneralUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class Console
extends OutputStream {
    private static Document _document;
    private static JFrame _frame;
    private static JTextArea _ta;
    private boolean _showConsole = false;
    private int _consoleSize = 0;
    private File _logFile;
    private PrintStream _consolePrintStream;
    private PrintStream _filePrintStream;
    private PrintStream _sockLogStream;

    public Console() {
        _frame = GeneralUtilities.createFrame(null);
        _ta = new JTextArea();
        _ta.setEditable(false);
        _ta.setLineWrap(true);
        _ta.setWrapStyleWord(true);
        _document = _ta.getDocument();
        _frame.setDefaultCloseOperation(2);
        _frame.addWindowListener(new WindowAdapter(this){
            private final Console this$0;
            {
                this.this$0 = console;
            }

            public void windowClosing(WindowEvent windowEvent) {
                Console.access$000();
            }
        });
        JButton jButton = new JButton(Resources.getString("console.clearButton"));
        jButton.setMnemonic(Resources.getVKCode("console.clearMnemonic"));
        jButton.addActionListener(new ActionListener(this){
            private final Console this$0;
            {
                this.this$0 = console;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                block2: {
                    Document document = Console.access$100();
                    if (document == null) break block2;
                    try {
                        document.remove(0, Console.access$100().getLength());
                    }
                    catch (BadLocationException badLocationException) {}
                }
            }
        });
        Container container = _frame.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 5, 2);
        container.add((Component)new JScrollPane(_ta), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 2;
        container.add((Component)jButton, gridBagConstraints);
        this.init();
    }

    static void access$000() {
        Console.dispose();
    }

    private static void dispose() {
        _document = null;
        _ta = null;
        _frame.dispose();
        _frame = null;
    }

    private void init() {
        this._consolePrintStream = new PrintStream(this);
        this._sockLogStream = Debug.getSocketStream();
        this.initshowConsole();
        this.initFileLogging();
    }

    private void initFileLogging() {
        String string = null;
        ConfigProperties configProperties = ConfigProperties.getInstance();
        String string2 = configProperties.getLogFilename();
        int n = string2.length();
        if (configProperties.isLogToFileEnabled()) {
            try {
                File file = null;
                if (n == 0 || string2.compareToIgnoreCase("TEMP") == 0) {
                    file = new File(configProperties.getLogFileDir());
                } else if (string2.endsWith("TEMP") && n > 5) {
                    file = new File(string2.substring(0, n - 5));
                } else {
                    file = new File(string2);
                    if (!file.exists() || !file.isDirectory()) {
                        file = null;
                    }
                }
                if (file != null) {
                    file.mkdirs();
                    this._logFile = File.createTempFile("javaws", ".log", file);
                    this._filePrintStream = new PrintStream(new FileOutputStream(this._logFile));
                    string = Resources.getString("console.logfilemsg", this._logFile.toString());
                } else {
                    this._logFile = new File(string2);
                    if (this._logFile.exists() && this._logFile.canWrite()) {
                        this._filePrintStream = new PrintStream(new FileOutputStream(string2, true));
                        string = Resources.getString("console.logfilemsg", this._logFile.toString());
                    } else if (this._logFile.createNewFile()) {
                        this._filePrintStream = new PrintStream(new FileOutputStream(this._logFile));
                        string = Resources.getString("console.logfilemsg", this._logFile.toString());
                    } else {
                        string = Resources.getString("console.logfilewarning", string2);
                    }
                }
            }
            catch (IOException iOException) {
                Debug.ignoredException(iOException);
                string = Resources.getString("console.logfilewarning", this._logFile.toString());
            }
        }
        this.redirectOutputs(this._consolePrintStream, string);
    }

    private void initshowConsole() {
        ConfigProperties configProperties = ConfigProperties.getInstance();
        this._showConsole = configProperties.getshowConsole();
        this._consoleSize = configProperties.getConsoleSize();
    }

    private boolean getshowConsole() {
        return this._showConsole;
    }

    public void write(int n) throws IOException {
        if (this._filePrintStream != null) {
            this._filePrintStream.write(n);
            this._filePrintStream.flush();
        }
        if (this._sockLogStream != null) {
            this._sockLogStream.write(n);
            this._sockLogStream.flush();
        }
        this.insert(String.valueOf((char)n));
    }

    public void setshowConsole(boolean bl) {
        this._showConsole = bl;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this._filePrintStream != null) {
            this._filePrintStream.write(byArray, n, n2);
            this._filePrintStream.flush();
        }
        if (this._sockLogStream != null) {
            this._sockLogStream.write(byArray, n, n2);
            this._sockLogStream.flush();
        }
        this.insert(new String(byArray, n, n2));
    }

    static int access$300(Console console) {
        return console._consoleSize;
    }

    private void insert(String string) {
        SwingUtilities.invokeLater(new Runnable(this, string){
            private final String val$string;
            private final Console this$0;

            public void run() {
                block4: {
                    if (Console.access$100() == null || Console.access$200() == null) break block4;
                    try {
                        int n = Console.access$100().getLength();
                        if (n > Console.access$300(this.this$0) && Console.access$300(this.this$0) > 0) {
                            Console.access$100().remove(0, n - Console.access$300(this.this$0));
                            n = Console.access$300(this.this$0);
                        }
                        Console.access$100().insertString(n, this.val$string, null);
                        if (Console.access$200().getCaretPosition() == n) {
                            Console.access$200().setCaretPosition(n + this.val$string.length());
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                }
            }
            {
                this.this$0 = console;
                this.val$string = string;
            }
        });
    }

    public void show(String string) {
        if (_frame != null && this.getshowConsole()) {
            _frame.pack();
            _frame.setBounds(10, 10, 410, 310);
            _frame.setTitle(Resources.getString("console.frameTitle", string));
            _frame.show();
        } else {
            Console.dispose();
        }
    }

    static JTextArea access$200() {
        return _ta;
    }

    static Document access$100() {
        return _document;
    }

    public static Document consoleErrorExit() {
        Document document = _document;
        if (_frame != null) {
            _frame.hide();
            Console.dispose();
        }
        return document;
    }

    private void redirectOutputs(PrintStream printStream, String string) {
        if (Globals.RedirectOutput && printStream != null) {
            System.setOut(printStream);
            System.setErr(printStream);
        }
        this._consolePrintStream.println(Resources.getString("appname") + " " + Resources.getString("console.message", new Date().toString()));
        this._consolePrintStream.println(Resources.getString("console.j2re", System.getProperty("java.version"), System.getProperty("java.vendor")));
        if (string != null) {
            System.err.println(string);
        }
    }
}

