/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.security;

import com.sun.javaws.cache.DiskCacheEntry;
import com.sun.javaws.cache.DownloadProtocol;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.debug.Globals;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.security.Resource;
import com.sun.javaws.util.URLUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class JNLPClassPath {
    private Stack _pendingJarDescs = new Stack();
    private ArrayList _loaders = new ArrayList();
    private Loader _appletLoader = null;
    private LaunchDesc _launchDesc = null;
    private HashMap _fileToUrls = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAllResources() {
        Object object;
        try {
            object = this.getNextPendingJarDesc();
            while (object != null) {
                this.createLoader((JARDesc)object);
                object = this.getNextPendingJarDesc();
            }
        }
        catch (IOException iOException) {
            Debug.ignoredException(iOException);
        }
        if (this._appletLoader != null) {
            object = this._loaders;
            synchronized (object) {
                this._loaders.add(this._appletLoader);
            }
        }
    }

    private synchronized JARDesc getNextPendingJarDesc() {
        return this._pendingJarDescs.isEmpty() ? null : (JARDesc)this._pendingJarDescs.pop();
    }

    public JNLPClassPath(LaunchDesc launchDesc, boolean bl) {
        Object object;
        this._launchDesc = launchDesc;
        if (bl) {
            object = URLUtil.getBase(launchDesc.getCanonicalHome());
            if (Globals.TraceStartup) {
                Debug.println("Classpath: " + object);
            }
            this._appletLoader = "file".equals(((URL)object).getProtocol()) ? new FileDirectoryLoader((URL)object) : new URLDirectoryLoader((URL)object);
        }
        if ((object = launchDesc.getResources()) != null) {
            JARDesc[] jARDescArray = ((ResourcesDesc)object).getEagerOrAllJarDescs(true);
            int n = jARDescArray.length - 1;
            while (n >= 0) {
                if (jARDescArray[n].isJavaFile()) {
                    if (Globals.TraceStartup) {
                        Debug.println("Classpath: " + jARDescArray[n].getLocation() + ":" + jARDescArray[n].getVersion());
                    }
                    this._pendingJarDescs.add(jARDescArray[n]);
                }
                --n;
            }
        }
    }

    static void access$200(URL uRL) throws IOException {
        JNLPClassPath.check(uRL);
    }

    private static void check(URL uRL) throws IOException {
        Permission permission;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (permission = uRL.openConnection().getPermission()) != null) {
            securityManager.checkPermission(permission);
        }
    }

    private synchronized JARDesc getIfPendingJarDesc(JARDesc jARDesc) {
        if (this._pendingJarDescs.contains(jARDesc)) {
            this._pendingJarDescs.remove(jARDesc);
            return jARDesc;
        }
        return null;
    }

    public synchronized JARDesc getJarDescFromFileURL(URL uRL) {
        return (JARDesc)this._fileToUrls.get(uRL.toString());
    }

    private Loader createLoader(JARDesc jARDesc) throws IOException {
        try {
            return (Loader)AccessController.doPrivileged(new PrivilegedExceptionAction(this, jARDesc){
                private final JARDesc val$jd;
                private final JNLPClassPath this$0;

                public Object run() throws IOException {
                    return JNLPClassPath.access$000(this.this$0, this.val$jd);
                }
                {
                    this.this$0 = jNLPClassPath;
                    this.val$jd = jARDesc;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (Globals.TraceStartup || Globals.TraceClassLoading) {
                Debug.println("Failed to create loader for: " + jARDesc + " (" + privilegedActionException.getException() + ")");
            }
            throw (IOException)privilegedActionException.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Loader createLoaderHelper(JARDesc jARDesc) throws IOException {
        URL uRL = jARDesc.getLocation();
        String string = jARDesc.getVersion();
        try {
            DiskCacheEntry diskCacheEntry = DownloadProtocol.getResource(uRL, string, 0, true, null);
            if (diskCacheEntry == null || !diskCacheEntry.getFile().exists()) {
                throw new IOException("Resource not found: " + jARDesc.getLocation() + ":" + jARDesc.getVersion());
            }
            String string2 = URLUtil.getEncodedPath(diskCacheEntry.getFile());
            URL uRL2 = new URL("file", "", string2);
            if (Globals.TraceStartup) {
                Debug.println("Creating loader for: " + uRL2);
            }
            JarLoader jarLoader = new JarLoader(uRL2);
            JNLPClassPath jNLPClassPath = this;
            synchronized (jNLPClassPath) {
                this._loaders.add(jarLoader);
                this._fileToUrls.put(uRL2.toString(), jARDesc);
            }
            return jarLoader;
        }
        catch (JNLPException jNLPException) {
            if (Globals.TraceStartup || Globals.TraceClassLoading) {
                Debug.println("Failed to download: " + jNLPException + " (" + jNLPException + ")");
            }
            Debug.ignoredException(jNLPException);
            throw new IOException(jNLPException.getMessage());
        }
    }

    public Resource getResource(String string) {
        return this.getResource(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource findNamedResource(String string, boolean bl) throws IOException {
        Object object;
        Resource resource = this.findNamedResourceInLoaders(string, bl);
        if (resource != null) {
            return resource;
        }
        JNLPClassPath jNLPClassPath = this;
        synchronized (jNLPClassPath) {
            if (this._pendingJarDescs.isEmpty()) {
                return null;
            }
        }
        ResourcesDesc.PackageInformation packageInformation = this._launchDesc.getResources().getPackageInformation(string);
        if (packageInformation != null) {
            object = packageInformation.getLaunchDesc().getResources().getPart(packageInformation.getPart());
            int n = 0;
            while (n < ((JARDesc[])object).length) {
                JARDesc jARDesc = this.getIfPendingJarDesc(object[n]);
                if (jARDesc != null) {
                    this.createLoader(jARDesc);
                }
                ++n;
            }
            resource = this.findNamedResourceInLoaders(string, bl);
            if (resource != null) {
                return resource;
            }
        }
        object = this.getNextPendingJarDesc();
        while (object != null) {
            Loader loader = this.createLoader((JARDesc)object);
            resource = loader.getResource(string, bl);
            if (resource != null) {
                return resource;
            }
            object = this.getNextPendingJarDesc();
        }
        if (this._appletLoader != null) {
            resource = this._appletLoader.getResource(string, bl);
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource findNamedResourceInLoaders(String string, boolean bl) throws IOException {
        int n = 0;
        JNLPClassPath jNLPClassPath = this;
        synchronized (jNLPClassPath) {
            n = this._loaders.size();
        }
        int n2 = 0;
        while (n2 < n) {
            Loader loader = null;
            JNLPClassPath jNLPClassPath2 = this;
            synchronized (jNLPClassPath2) {
                loader = (Loader)this._loaders.get(n2);
            }
            Resource resource = loader.getResource(string, bl);
            if (resource != null) {
                return resource;
            }
            ++n2;
        }
        return null;
    }

    public Resource getResource(String string, boolean bl) {
        if (Globals.TraceClassLoading) {
            Debug.println("getResource: " + string + " (check: " + bl + ")");
        }
        try {
            return this.findNamedResource(string, bl);
        }
        catch (IOException iOException) {
            Debug.ignoredException(iOException);
            return null;
        }
    }

    public URL checkURL(URL uRL) {
        try {
            JNLPClassPath.check(uRL);
        }
        catch (Exception exception) {
            return null;
        }
        return uRL;
    }

    static ArrayList access$100(JNLPClassPath jNLPClassPath) {
        return jNLPClassPath._loaders;
    }

    public Enumeration getResources(String string) {
        return this.getResources(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getResources(String string, boolean bl) {
        int n;
        this.loadAllResources();
        JNLPClassPath jNLPClassPath = this;
        synchronized (jNLPClassPath) {
            n = this._loaders.size();
        }
        int n2 = n;
        return new Enumeration(this, n2, string, bl){
            private int index;
            private Resource res;
            private final int val$size;
            private final String val$name;
            private final boolean val$check;
            private final JNLPClassPath this$0;

            public boolean hasMoreElements() {
                return this.next();
            }

            /*
             * Unable to fully structure code
             */
            private boolean next() {
                if (this.res == null) ** GOTO lbl7
                return true;
lbl-1000:
                // 1 sources

                {
                    var1_1 = (Loader)JNLPClassPath.access$100(this.this$0).get(this.index++);
                    this.res = var1_1.getResource(this.val$name, this.val$check);
                    if (this.res == null) continue;
                    return true;
lbl7:
                    // 2 sources

                    ** while (this.index < this.val$size)
                }
lbl8:
                // 1 sources

                return false;
            }

            public Object nextElement() {
                if (!this.next()) {
                    throw new NoSuchElementException();
                }
                Resource resource = this.res;
                this.res = null;
                return resource;
            }
            {
                this.this$0 = jNLPClassPath;
                this.val$size = n;
                this.val$name = string;
                this.val$check = bl;
                this.index = 0;
                this.res = null;
            }
        };
    }

    static Loader access$000(JNLPClassPath jNLPClassPath, JARDesc jARDesc) throws IOException {
        return jNLPClassPath.createLoaderHelper(jARDesc);
    }

    private static class FileDirectoryLoader
    extends Loader {
        private File dir;

        FileDirectoryLoader(URL uRL) {
            super(uRL);
            Debug.jawsAssert("file".equals(uRL.getProtocol()), "must be FILE URL");
            this.dir = new File(URLUtil.getPathFromURL(uRL));
        }

        Resource getResource(String string, boolean bl) {
            try {
                File file;
                URL uRL = new URL(this.getBaseURL(), string);
                if (!uRL.getFile().startsWith(this.getBaseURL().getFile())) {
                    return null;
                }
                if (bl) {
                    JNLPClassPath.access$200(uRL);
                }
                if ((file = new File(this.dir, string.replace('/', File.separatorChar))).exists()) {
                    return new Resource(this, string, uRL, file){
                        private final String val$name;
                        private final URL val$url;
                        private final File val$file;
                        private final FileDirectoryLoader this$0;

                        public int getContentLength() throws IOException {
                            return (int)this.val$file.length();
                        }

                        public InputStream getInputStream() throws IOException {
                            return new FileInputStream(this.val$file);
                        }

                        public String getName() {
                            return this.val$name;
                        }

                        public URL getCodeSourceURL() {
                            return this.this$0.getBaseURL();
                        }

                        public URL getURL() {
                            return this.val$url;
                        }
                        {
                            this.this$0 = fileDirectoryLoader;
                            this.val$name = string;
                            this.val$url = uRL;
                            this.val$file = file;
                        }
                    };
                }
            }
            catch (Exception exception) {
                return null;
            }
            return null;
        }
    }

    private static class JarLoader
    extends Loader {
        private JarFile jar;
        private URL csu;

        JarLoader(URL uRL) throws IOException {
            super(new URL("jar", "", -1, uRL + "!/"));
            this.jar = this.getJarFile(uRL);
            this.csu = uRL;
            Debug.jawsAssert("file".equals(uRL.getProtocol()), "Only works for file URLs");
        }

        Resource getResource(String string, boolean bl) {
            JarEntry jarEntry = this.jar.getJarEntry(string);
            if (jarEntry != null) {
                URL uRL;
                try {
                    uRL = new URL(this.getBaseURL(), string);
                    if (bl) {
                        JNLPClassPath.access$200(uRL);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    Debug.ignoredException(malformedURLException);
                    return null;
                }
                catch (IOException iOException) {
                    Debug.ignoredException(iOException);
                    return null;
                }
                catch (AccessControlException accessControlException) {
                    Debug.ignoredException(accessControlException);
                    return null;
                }
                return new Resource(this, string, uRL, jarEntry){
                    private final String val$name;
                    private final URL val$url;
                    private final JarEntry val$entry;
                    private final JarLoader this$0;

                    public int getContentLength() {
                        return (int)this.val$entry.getSize();
                    }

                    public InputStream getInputStream() throws IOException {
                        return JarLoader.access$400(this.this$0).getInputStream(this.val$entry);
                    }

                    public String getName() {
                        return this.val$name;
                    }

                    public URL getCodeSourceURL() {
                        return JarLoader.access$300(this.this$0);
                    }

                    public URL getURL() {
                        return this.val$url;
                    }

                    public Certificate[] getCertificates() {
                        return this.val$entry.getCertificates();
                    }

                    public Manifest getManifest() throws IOException {
                        return JarLoader.access$400(this.this$0).getManifest();
                    }
                    {
                        this.this$0 = jarLoader;
                        this.val$name = string;
                        this.val$url = uRL;
                        this.val$entry = jarEntry;
                    }
                };
            }
            return null;
        }

        static URL access$300(JarLoader jarLoader) {
            return jarLoader.csu;
        }

        static JarFile access$400(JarLoader jarLoader) {
            return jarLoader.jar;
        }

        private JarFile getJarFile(URL uRL) throws IOException {
            if ("file".equals(uRL.getProtocol())) {
                String string = URLUtil.getPathFromURL(uRL);
                File file = new File(string);
                if (!file.exists()) {
                    throw new FileNotFoundException(string);
                }
                return new JarFile(string);
            }
            throw new IOException("Must be file URL");
        }
    }

    private static abstract class Loader {
        private final URL base;

        URL getBaseURL() {
            return this.base;
        }

        Loader(URL uRL) {
            this.base = uRL;
        }

        Resource getResource(String string) {
            return this.getResource(string, true);
        }

        abstract Resource getResource(String var1, boolean var2);
    }

    private static class URLDirectoryLoader
    extends Loader {
        URLDirectoryLoader(URL uRL) {
            super(uRL);
        }

        Resource getResource(String string, boolean bl) {
            URLConnection uRLConnection;
            URL uRL;
            try {
                uRL = new URL(this.getBaseURL(), string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalArgumentException("name");
            }
            try {
                if (bl) {
                    JNLPClassPath.access$200(uRL);
                }
                if ((uRLConnection = uRL.openConnection()) instanceof HttpURLConnection) {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    int n = httpURLConnection.getResponseCode();
                    if (n >= 400) {
                        return null;
                    }
                } else {
                    InputStream inputStream = uRL.openStream();
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                return null;
            }
            return new Resource(this, string, uRL, uRLConnection){
                private final String val$name;
                private final URL val$url;
                private final URLConnection val$uc;
                private final URLDirectoryLoader this$0;

                public int getContentLength() throws IOException {
                    return this.val$uc.getContentLength();
                }

                public InputStream getInputStream() throws IOException {
                    return this.val$uc.getInputStream();
                }

                public String getName() {
                    return this.val$name;
                }

                public URL getCodeSourceURL() {
                    return this.this$0.getBaseURL();
                }

                public URL getURL() {
                    return this.val$url;
                }
                {
                    this.this$0 = uRLDirectoryLoader;
                    this.val$name = string;
                    this.val$url = uRL;
                    this.val$uc = uRLConnection;
                }
            };
        }
    }
}

