/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.plugin.util.Trace;
import sun.plugin.util.UserProfile;
import sun.security.action.GetBooleanAction;

public class PluginLogger {
    private static Logger logger = null;
    private static boolean logOn = false;
    private static boolean loggerInit = false;

    static {
        try {
            logOn = AccessController.doPrivileged(new GetBooleanAction("javaplugin.logging"));
            PluginLogger.initLogger();
        }
        catch (Throwable throwable) {
            Trace.printException(throwable);
        }
    }

    private static synchronized void initLogger() {
        if (!loggerInit && logOn) {
            loggerInit = true;
            logger = (Logger)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Logger logger = null;
                    try {
                        logger = Logger.getLogger("sun.plugin");
                        FileHandler fileHandler = new FileHandler(UserProfile.getLogFile());
                        logger.addHandler(fileHandler);
                        logger.setLevel(Level.ALL);
                    }
                    catch (Throwable throwable) {
                        Trace.printException(throwable);
                    }
                    return logger;
                }
            });
        }
    }

    public static boolean getLogging() {
        return logOn;
    }

    public static void setLogging(boolean bl) {
        logOn = bl;
        PluginLogger.initLogger();
    }

    public static void log(String string) {
        Logger logger = PluginLogger.getLogger();
        if (logger != null) {
            logger.log(Level.INFO, string);
        }
    }

    public static void logException(Throwable throwable) {
        PluginLogger.logException("THROW", throwable);
    }

    private static Logger getLogger() {
        PluginLogger.initLogger();
        if (logOn) {
            return logger;
        }
        return null;
    }

    public static void logException(String string, Throwable throwable) {
        Logger logger = PluginLogger.getLogger();
        if (logger != null) {
            logger.log(Level.FINER, string, throwable);
        }
    }
}

