/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.io.IOException;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.LogStream;
import java.rmi.server.ObjID;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import sun.rmi.runtime.Log;
import sun.rmi.server.Dispatcher;
import sun.rmi.server.UnicastServerRef;
import sun.rmi.transport.Channel;
import sun.rmi.transport.Endpoint;
import sun.rmi.transport.ObjectTable;
import sun.rmi.transport.Target;
import sun.security.action.GetPropertyAction;

public abstract class Transport {
    static final int logLevel = LogStream.parseLevel(Transport.getLogLevel());
    static final Log transportLog = Log.getLog("sun.rmi.transport.misc", "transport", logLevel);

    private static String getLogLevel() {
        return (String)AccessController.doPrivileged(new GetPropertyAction("sun.rmi.transport.logLevel"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean serviceCall(RemoteCall remoteCall) {
        Remote remote;
        Object object;
        try {
            object = ObjID.read(remoteCall.getInputStream());
        }
        catch (IOException iOException) {
            throw new MarshalException("unable to read objID", iOException);
        }
        Object object2 = ObjectTable.getTarget((ObjID)object);
        if (object2 == null || (remote = ((Target)object2).getImpl()) == null) {
            throw new NoSuchObjectException("no such object in table");
        }
        Transport transport = ((Target)object2).getExportedTransport();
        if (transport != null && !transport.equals(this)) {
            throw new NoSuchObjectException("no such object in table");
        }
        Dispatcher dispatcher = ((Target)object2).getDispatcher();
        ((Target)object2).incrementCallCount();
        try {
            transportLog.log(Log.VERBOSE, "call dispatcher");
            AccessControlContext accessControlContext = ((Target)object2).getAccessControlContext();
            ClassLoader classLoader = ((Target)object2).getContextClassLoader();
            Thread thread = Thread.currentThread();
            ClassLoader classLoader2 = thread.getContextClassLoader();
            try {
                thread.setContextClassLoader(classLoader);
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(this, accessControlContext, dispatcher, remote, remoteCall){
                        private final AccessControlContext val$acc;
                        private final Dispatcher val$disp;
                        private final Remote val$impl;
                        private final RemoteCall val$call;
                        private final Transport this$0;

                        public Object run() throws IOException {
                            this.this$0.checkAcceptPermission(this.val$acc);
                            this.val$disp.dispatch(this.val$impl, this.val$call);
                            return null;
                        }
                        {
                            this.this$0 = transport;
                            this.val$acc = accessControlContext;
                            this.val$disp = dispatcher;
                            this.val$impl = remote;
                            this.val$call = remoteCall;
                        }
                    }, accessControlContext);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (IOException)privilegedActionException.getException();
                }
            }
            finally {
                thread.setContextClassLoader(classLoader2);
            }
            ((Target)object2).decrementCallCount();
        }
        catch (IOException iOException) {
            try {
                transportLog.log(Log.BRIEF, "exception thrown by dispatcher: ", iOException);
                boolean bl2 = false;
                ((Target)object2).decrementCallCount();
                return bl2;
            }
            catch (Throwable throwable) {
                try {
                    ((Target)object2).decrementCallCount();
                    throw throwable;
                }
                catch (RemoteException remoteException) {
                    if (UnicastServerRef.callLog.isLoggable(Log.BRIEF)) {
                        object = "";
                        try {
                            object = "[" + RemoteServer.getClientHost() + "] ";
                        }
                        catch (ServerNotActiveException serverNotActiveException) {
                            // empty catch block
                        }
                        object2 = (String)object + "exception: ";
                        UnicastServerRef.callLog.log(Log.BRIEF, (String)object2, remoteException);
                    }
                    try {
                        object = remoteCall.getResultStream(false);
                        UnicastServerRef.clearStackTraces(remoteException);
                        object.writeObject(remoteException);
                        remoteCall.releaseOutputStream();
                    }
                    catch (IOException iOException2) {
                        transportLog.log(Log.BRIEF, "exception thrown marshalling exception: ", iOException2);
                        return false;
                    }
                }
            }
        }
        return true;
    }

    protected abstract void checkAcceptPermission(AccessControlContext var1);

    public abstract void free(Endpoint var1);

    public void exportObject(Target target) throws RemoteException {
        ObjectTable.putTarget(target);
    }

    public abstract Channel getChannel(Endpoint var1);
}

