/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.peer.DropTargetPeer;
import java.awt.event.InputEvent;
import java.awt.event.PaintEvent;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import sun.awt.DebugHelper;
import sun.awt.Graphics2Delegate;
import sun.awt.RepaintArea;
import sun.awt.X11GraphicsConfig;
import sun.awt.X11GraphicsDevice;
import sun.awt.X11SurfaceData;
import sun.awt.image.OffScreenImage;
import sun.awt.motif.MGlobalCursorManager;
import sun.awt.motif.MInputMethodControl;
import sun.awt.motif.MScrollPanePeer;
import sun.awt.motif.MToolkit;
import sun.awt.motif.MWindowAttributes;
import sun.awt.motif.MWindowPeer;
import sun.awt.motif.X11FontMetrics;
import sun.awt.motif.X11Image;
import sun.awt.motif.X11RemoteOffScreenImage;
import sun.awt.motif.X11VolatileImage;
import sun.java2d.SunGraphics2D;

public abstract class MComponentPeer
implements ComponentPeer,
DropTargetPeer {
    private static final DebugHelper dbg = DebugHelper.create(class$sun$awt$motif$MComponentPeer == null ? (class$sun$awt$motif$MComponentPeer = MComponentPeer.class$("sun.awt.motif.MComponentPeer")) : class$sun$awt$motif$MComponentPeer);
    Component target;
    long pData;
    long jniGlobalRef;
    protected X11GraphicsConfig graphicsConfig;
    X11SurfaceData surfaceData;
    int oldWidth = -1;
    int oldHeight = -1;
    private RepaintArea paintArea;
    boolean isLayouting = false;
    boolean paintPending = false;
    private boolean disposed = false;
    private static int JAWT_LOCK_ERROR = 1;
    private static int JAWT_LOCK_CLIP_CHANGED = 2;
    private static int JAWT_LOCK_BOUNDS_CHANGED = 4;
    private static int JAWT_LOCK_SURFACE_CHANGED = 8;
    private int drawState = JAWT_LOCK_CLIP_CHANGED | JAWT_LOCK_BOUNDS_CHANGED | JAWT_LOCK_SURFACE_CHANGED;
    static final int MOTIF_NA = 0;
    static final int MOTIF_V1 = 1;
    static final int MOTIF_V2 = 2;
    private Font font;
    private long backBuffer = 0L;
    private X11VolatileImage xBackBuffer = null;
    private static boolean pmoffscreen = false;
    static final Font defaultFont;
    public int serialNum = 0;
    static Class class$sun$awt$motif$MComponentPeer;

    public int getZOrderPosition_NoClientCode() {
        Container container = MComponentPeer.getParent_NoClientCode(this.target);
        if (container != null) {
            Component[] componentArray = MComponentPeer.getComponents_NoClientCode(container);
            int n2 = 0;
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                if (componentArray[i2] == this.target) {
                    return n2;
                }
                Object object = MToolkit.targetToPeer(componentArray[i2]);
                if (object == null || object instanceof LightweightPeer) continue;
                ++n2;
            }
        }
        return -1;
    }

    public int updatePriority() {
        return 5;
    }

    static {
        MComponentPeer.initIDs();
        defaultFont = new Font("Dialog", 0, 12);
    }

    MComponentPeer() {
    }

    public void beginLayout() {
        this.isLayouting = true;
    }

    public void beginValidate() {
    }

    public void destroyBuffers() {
        this.destroyBackBuffer(this.backBuffer);
        this.backBuffer = 0L;
        this.xBackBuffer = null;
    }

    public void disable() {
        this.setEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        boolean bl2 = false;
        if (!this.disposed) {
            MComponentPeer mComponentPeer = this;
            synchronized (mComponentPeer) {
                if (!this.disposed) {
                    bl2 = true;
                    this.disposed = true;
                }
            }
        }
        if (bl2) {
            this.disposeImpl();
        }
    }

    protected void disposeImpl() {
        X11SurfaceData x11SurfaceData = this.surfaceData;
        this.surfaceData = null;
        x11SurfaceData.invalidate();
        MToolkit.targetDisposedPeer(this.target, this);
        this.pDispose();
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void endLayout() {
        if (!(this.paintPending || this.paintArea.isEmpty() || this.target.getIgnoreRepaint())) {
            this.postEvent(new PaintEvent(this.target, 800, new Rectangle()));
        }
        this.isLayouting = false;
    }

    public void endValidate() {
        this.restoreFocus();
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public void hide() {
        this.setVisible(false);
    }

    private static native void initIDs();

    void initialize() {
        Font font;
        if (!this.target.isVisible()) {
            this.hide();
        }
        this.pInitialize();
        Color color = this.target.getForeground();
        if (color != null) {
            this.setForeground(color);
        }
        if ((color = this.target.getBackground()) != null) {
            this.setBackground(color);
        }
        if ((font = this.target.getFont()) != null) {
            this.setFont(font);
        }
        this.pSetCursor(this.target.getCursor());
        if (!this.target.isEnabled()) {
            this.disable();
        }
        Rectangle rectangle = this.target.getBounds();
        this.reshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (this.target.isVisible()) {
            this.show();
        }
        this.surfaceData = X11SurfaceData.createData(this);
    }

    native void pDisable();

    native void pDispose();

    native void pEnable();

    native void pHide();

    native void pInitialize();

    native void pMakeCursorVisible();

    native void pShow();

    native void restoreFocus();

    public void show() {
        this.setVisible(true);
    }

    public void updateCursorImmediately() {
        MGlobalCursorManager.getCursorManager().updateCursorImmediately();
    }

    public boolean canDetermineObscurity() {
        return true;
    }

    public boolean handlesWheelScrolling() {
        return false;
    }

    public boolean isFocusable() {
        return false;
    }

    public boolean isObscured() {
        MWindowPeer mWindowPeer;
        Container container;
        Container container2;
        Container container3 = container2 = this.target instanceof Container ? (Container)this.target : this.target.getParent();
        if (container2 == null) {
            return true;
        }
        while ((container = container2.getParent()) != null) {
            container2 = container;
        }
        if (container2 instanceof Window && (mWindowPeer = (MWindowPeer)container2.getPeer()) != null) {
            return mWindowPeer.winAttr.visibilityState != MWindowAttributes.AWT_UNOBSCURED;
        }
        return true;
    }

    public boolean isPaintPending() {
        return this.paintPending && this.isLayouting;
    }

    protected boolean shouldFocusOnClick() {
        return this.isFocusable();
    }

    public boolean checkNativePaintOnSetBounds(int n2, int n3) {
        return n2 != this.oldWidth || n3 != this.oldHeight;
    }

    void handleExpose(int n2, int n3, int n4, int n5) {
        if (!this.target.getIgnoreRepaint()) {
            this.postEvent(new PaintEvent(this.target, 800, new Rectangle(n2, n3, n4, n5)));
        }
    }

    void handleRepaint(int n2, int n3, int n4, int n5) {
        if (!this.target.getIgnoreRepaint()) {
            this.postEvent(new PaintEvent(this.target, 801, new Rectangle(n2, n3, n4, n5)));
        }
    }

    native void pReshape(int var1, int var2, int var3, int var4);

    public void reshape(int n2, int n3, int n4, int n5) {
        this.setBounds(n2, n3, n4, n5);
    }

    public void setBounds(int n2, int n3, int n4, int n5) {
        Object object;
        if (this.disposed) {
            return;
        }
        Container container = MComponentPeer.getParent_NoClientCode(this.target);
        this.paintPending = false;
        if (container != null && container instanceof ScrollPane) {
            object = (MScrollPanePeer)container.getPeer();
            if (!((MScrollPanePeer)object).ignore) {
                this.pReshape(n2, n3, n4, n5);
                ((MScrollPanePeer)object).childResized(n4, n5);
            }
        } else {
            this.pReshape(n2, n3, n4, n5);
        }
        if (n4 != this.oldWidth || n5 != this.oldHeight) {
            object = this.surfaceData;
            if (object != null) {
                this.surfaceData = X11SurfaceData.createData(this);
                ((X11SurfaceData)object).invalidate();
            }
            this.oldWidth = n4;
            this.oldHeight = n5;
        }
        ++this.serialNum;
    }

    private native long getWindow(long var1);

    private native void destroyBackBuffer(long var1);

    private native long createBackBuffer(long var1, int var3);

    private native void swapBuffers(long var1, int var3);

    public void repaint(long l2, int n2, int n3, int n4, int n5) {
    }

    public void notifyTextComponentChange(boolean bl2) {
        Container container = MComponentPeer.getParent_NoClientCode(this.target);
        while (container != null && !(container instanceof Frame) && !(container instanceof Dialog)) {
            container = MComponentPeer.getParent_NoClientCode(container);
        }
        if (container instanceof Frame || container instanceof Dialog) {
            if (bl2) {
                ((MInputMethodControl)((Object)container.getPeer())).addTextComponent(this);
            } else {
                ((MInputMethodControl)((Object)container.getPeer())).removeTextComponent(this);
            }
        }
    }

    public void setEnabled(boolean bl2) {
        if (bl2) {
            this.pEnable();
        } else {
            this.pDisable();
        }
    }

    public void setVisible(boolean bl2) {
        if (bl2) {
            Dimension dimension = this.target.getSize();
            this.oldWidth = dimension.width;
            this.oldHeight = dimension.height;
            this.pShow();
        } else {
            this.pHide();
        }
    }

    public void handleEvent(AWTEvent aWTEvent) {
        int n2 = aWTEvent.getID();
        switch (n2) {
            case 800: {
                this.paintPending = false;
            }
            case 801: {
                if (!this.isLayouting && !this.paintPending) {
                    this.paintArea.paint(this.target, false);
                }
                return;
            }
            case 501: {
                if (this.target != aWTEvent.getSource() || ((InputEvent)aWTEvent).isConsumed() || !this.shouldFocusOnClick() || this.target.isFocusOwner() || !MComponentPeer.canBeFocusedByClick(this.target)) break;
                this.target.requestFocusInWindow();
                break;
            }
        }
        this.nativeHandleEvent(aWTEvent);
    }

    native void nativeHandleEvent(AWTEvent var1);

    void postEvent(AWTEvent aWTEvent) {
        MToolkit.postEvent(MToolkit.targetToAppContext(this.target), aWTEvent);
    }

    public void createBuffers(int n2, BufferCapabilities bufferCapabilities) throws AWTException {
        if (!X11GraphicsDevice.isDBESupported()) {
            throw new AWTException("Page flipping is not supported");
        }
        if (n2 > 2) {
            throw new AWTException("Only double or single buffering is supported");
        }
        BufferCapabilities bufferCapabilities2 = this.graphicsConfig.getBufferCapabilities();
        if (!bufferCapabilities2.isPageFlipping()) {
            throw new AWTException("Page flipping is not supported");
        }
        long l2 = this.getWindow(this.pData);
        int n3 = MComponentPeer.getSwapAction(bufferCapabilities.getFlipContents());
        this.backBuffer = this.createBackBuffer(l2, n3);
        this.xBackBuffer = new X11VolatileImage(this.target, this.target.getWidth(), this.target.getHeight(), this.backBuffer);
    }

    private static int getSwapAction(BufferCapabilities.FlipContents flipContents) {
        if (flipContents == BufferCapabilities.FlipContents.BACKGROUND) {
            return 1;
        }
        if (flipContents == BufferCapabilities.FlipContents.PRIOR) {
            return 2;
        }
        if (flipContents == BufferCapabilities.FlipContents.COPIED) {
            return 3;
        }
        return 0;
    }

    public void flip(BufferCapabilities.FlipContents flipContents) {
        if (this.backBuffer == 0L) {
            throw new IllegalStateException("Buffers have not been created");
        }
        long l2 = this.getWindow(this.pData);
        int n2 = MComponentPeer.getSwapAction(flipContents);
        this.swapBuffers(l2, n2);
    }

    native void pSetBackground(Color var1);

    native void pSetForeground(Color var1);

    public native void pSetInnerForeground(Color var1);

    public native void pSetScrollbarBackground(Color var1);

    public void setBackground(Color color) {
        this.pSetBackground(color);
    }

    public void setForeground(Color color) {
        this.pSetForeground(color);
    }

    public native void setTargetBackground(Color var1);

    MComponentPeer(Component component) {
        this.init(component);
    }

    public void init(Component component) {
        this.target = component;
        this.paintArea = new RepaintArea();
        Container container = MToolkit.getNativeContainer(component);
        MComponentPeer mComponentPeer = (MComponentPeer)MToolkit.targetToPeer(container);
        this.create(mComponentPeer);
        if (container != null && container instanceof ScrollPane) {
            MScrollPanePeer mScrollPanePeer = (MScrollPanePeer)mComponentPeer;
            mScrollPanePeer.setScrollChild(this);
        }
        this.initialize();
    }

    static boolean canBeFocusedByClick(Component component) {
        if (component == null) {
            return false;
        }
        return component.isDisplayable() && component.isVisible() && component.isEnabled() && component.isFocusable();
    }

    native boolean _requestFocus(Component var1, boolean var2, boolean var3, long var4);

    public boolean requestFocus(Component component, boolean bl2, boolean bl3, long l2) {
        Window window;
        Container container;
        if (MComponentPeer.processSynchronousLightweightTransfer(this.target, component, bl2, bl3, l2)) {
            return true;
        }
        Container container2 = container = this.target instanceof Container ? (Container)this.target : this.target.getParent();
        while (container != null && !(container instanceof Window)) {
            container = MComponentPeer.getParent_NoClientCode(container);
        }
        if (container != null && !(window = (Window)container).isFocused() && MComponentPeer.getNativeFocusedWindow() == window) {
            return true;
        }
        return this._requestFocus(component, bl2, bl3, l2);
    }

    public native void pSetCursor(Cursor var1);

    public Dimension getMinimumSize() {
        return this.target.getSize();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    private native void pSetFont(Font var1);

    public void setFont(Font font) {
        if (font == null) {
            font = defaultFont;
        }
        this.pSetFont(font);
        if (this.target instanceof Container) {
            Container container = (Container)this.target;
            int n2 = container.getComponentCount();
            Component[] componentArray = container.getComponents();
            for (int i2 = 0; i2 < n2; ++i2) {
                ComponentPeer componentPeer;
                if (componentArray[i2] == null || (componentPeer = componentArray[i2].getPeer()) == null) continue;
                Font font2 = componentArray[i2].getFont();
                if (!font.equals(font2)) {
                    componentPeer.setFont(font2);
                    continue;
                }
                if (!(componentArray[i2] instanceof Container)) continue;
                componentPeer.setFont(font);
            }
        }
        this.font = font;
    }

    public synchronized Graphics getGraphics() {
        if (!this.disposed) {
            Font font;
            Color color;
            Component component = this.target;
            Color color2 = component.getBackground();
            if (color2 == null) {
                color2 = SystemColor.window;
            }
            if ((color = component.getForeground()) == null) {
                color = SystemColor.windowText;
            }
            if ((font = component.getFont()) == null) {
                font = defaultFont;
            }
            return new SunGraphics2D(this.surfaceData, color, color2, font);
        }
        return null;
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.target.getSize();
        if (graphics instanceof Graphics2D || graphics instanceof Graphics2Delegate) {
            graphics.clearRect(0, 0, dimension.width, dimension.height);
        } else {
            graphics.setColor(this.target.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(this.target.getForeground());
        }
        this.target.paint(graphics);
    }

    public void print(Graphics graphics) {
        Dimension dimension = this.target.getSize();
        if (graphics instanceof Graphics2D || graphics instanceof Graphics2Delegate) {
            graphics.clearRect(0, 0, dimension.width, dimension.height);
        } else {
            graphics.setColor(this.target.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(this.target.getForeground());
        }
        this.target.print(graphics);
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        GraphicsConfiguration graphicsConfiguration = this.graphicsConfig;
        if (graphicsConfiguration == null) {
            graphicsConfiguration = this.target.getGraphicsConfiguration();
        }
        return graphicsConfiguration;
    }

    public Image getBackBuffer() {
        if (this.backBuffer == 0L) {
            throw new IllegalStateException("Buffers have not been created");
        }
        return this.xBackBuffer;
    }

    public Image createImage(int n2, int n3) {
        ColorModel colorModel = this.getColorModel(1);
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n2, n3);
        if (X11SurfaceData.isAccelerationEnabled()) {
            return new X11RemoteOffScreenImage(this.target, colorModel, writableRaster, colorModel.isAlphaPremultiplied());
        }
        return new OffScreenImage(this.target, colorModel, writableRaster, colorModel.isAlphaPremultiplied());
    }

    public Point getLocationOnScreen() {
        return this.pGetLocationOnScreen();
    }

    native Point pGetLocationOnScreen();

    public Rectangle getBounds() {
        return this.target.getBounds();
    }

    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    static native Window getNativeFocusedWindow();

    public void addDropTarget(DropTarget dropTarget) {
        this.addNativeDropTarget(dropTarget);
    }

    native void addNativeDropTarget(DropTarget var1);

    public void removeDropTarget(DropTarget dropTarget) {
        this.removeNativeDropTarget(dropTarget);
    }

    native void removeNativeDropTarget(DropTarget var1);

    public void coalescePaintEvent(PaintEvent paintEvent) {
        Rectangle rectangle = paintEvent.getUpdateRect();
        this.paintArea.add(rectangle, paintEvent.getID());
    }

    public ColorModel getColorModel() {
        return this.graphicsConfig.getColorModel();
    }

    public ColorModel getColorModel(int n2) {
        return this.graphicsConfig.getColorModel(n2);
    }

    public VolatileImage createVolatileImage(int n2, int n3) {
        return new X11VolatileImage(this.target, n2, n3);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.target + "]";
    }

    public X11SurfaceData getSurfaceData() {
        return this.surfaceData;
    }

    abstract void create(MComponentPeer var1);

    void EFcreate(MComponentPeer mComponentPeer, int n2) {
    }

    void drawScrollbar(Graphics graphics, Color color, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) {
        Color color2 = graphics.getColor();
        double d2 = (double)(n3 - 2 * (n2 - 1)) / (double)Math.max(1, n5 - n4 + n7);
        int n8 = n2 + (int)(d2 * (double)(n6 - n4));
        int n9 = (int)(d2 * (double)n7);
        int n10 = n2 - 4;
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        if (n3 < 3 * n10) {
            n9 = 0;
            n8 = 0;
            if (n3 < 2 * n10 + 2) {
                n10 = (n3 - 2) / 2;
            }
        } else if (n9 < 7) {
            n8 = Math.max(0, n8 - (7 - n9 >> 1));
            n9 = 7;
        }
        int n11 = n2 / 2;
        int n12 = n11 - n10 / 2;
        int n13 = n11 + n10 / 2;
        Color color3 = new Color((int)((double)color.getRed() * 0.85), (int)((double)color.getGreen() * 0.85), (int)((double)color.getBlue() * 0.85));
        graphics.setColor(color3);
        if (bl2) {
            graphics.fillRect(0, 0, n3, n2);
        } else {
            graphics.fillRect(0, 0, n2, n3);
        }
        graphics.setColor(color);
        if (n8 > 0) {
            if (bl2) {
                graphics.fillRect(n8, 3, n9, n2 - 3);
            } else {
                graphics.fillRect(3, n8, n2 - 3, n9);
            }
        }
        nArray[0] = n11;
        nArray2[0] = 2;
        nArray[1] = n12;
        nArray2[1] = n10;
        nArray[2] = n13;
        nArray2[2] = n10;
        if (bl2) {
            graphics.fillPolygon(nArray2, nArray, 3);
        } else {
            graphics.fillPolygon(nArray, nArray2, 3);
        }
        nArray2[0] = n3 - 2;
        nArray2[1] = n3 - n10;
        nArray2[2] = n3 - n10;
        if (bl2) {
            graphics.fillPolygon(nArray2, nArray, 3);
        } else {
            graphics.fillPolygon(nArray, nArray2, 3);
        }
        color3 = color.brighter();
        graphics.setColor(color3);
        if (bl2) {
            graphics.drawLine(1, n2, n3 - 1, n2);
            graphics.drawLine(n3 - 1, 1, n3 - 1, n2);
            graphics.drawLine(1, n11, n10, n12);
            graphics.drawLine(n3 - n10, n12, n3 - n10, n13);
            graphics.drawLine(n3 - n10, n12, n3 - 2, n11);
        } else {
            graphics.drawLine(n2, 1, n2, n3 - 1);
            graphics.drawLine(1, n3 - 1, n2, n3 - 1);
            graphics.drawLine(n11, 1, n12, n10);
            graphics.drawLine(n12, n3 - n10, n13, n3 - n10);
            graphics.drawLine(n12, n3 - n10, n11, n3 - 2);
        }
        if (n8 > 0) {
            if (bl2) {
                graphics.drawLine(n8, 2, n8 + n9, 2);
                graphics.drawLine(n8, 2, n8, n2 - 3);
            } else {
                graphics.drawLine(2, n8, 2, n8 + n9);
                graphics.drawLine(2, n8, n2 - 3, n8);
            }
        }
        Color color4 = color.darker();
        graphics.setColor(color4);
        if (bl2) {
            graphics.drawLine(0, 0, 0, n2);
            graphics.drawLine(0, 0, n3 - 1, 0);
            graphics.drawLine(n10, n12, n10, n13);
            graphics.drawLine(n10, n13, 1, n11);
            graphics.drawLine(n3 - 2, n11, n3 - n10, n13);
        } else {
            graphics.drawLine(0, 0, n2, 0);
            graphics.drawLine(0, 0, 0, n3 - 1);
            graphics.drawLine(n12, n10, n13, n10);
            graphics.drawLine(n13, n10, n11, 1);
            graphics.drawLine(n11, n3 - 2, n13, n3 - n10);
        }
        if (n8 > 0) {
            if (bl2) {
                graphics.drawLine(n8 + n9, 2, n8 + n9, n2 - 2);
                graphics.drawLine(n8, n2 - 2, n8 + n9, n2 - 2);
            } else {
                graphics.drawLine(2, n8 + n9, n2 - 2, n8 + n9);
                graphics.drawLine(n2 - 2, n8, n2 - 2, n8 + n9);
            }
        }
        graphics.setColor(color2);
    }

    void draw3DOval(Graphics graphics, Color color, int n2, int n3, int n4, int n5, boolean bl2) {
        Color color2 = graphics.getColor();
        Color color3 = color.darker();
        Color color4 = color.brighter();
        graphics.setColor(bl2 ? color4 : color3);
        graphics.drawArc(n2, n3, n4, n5, 45, 180);
        graphics.setColor(bl2 ? color3 : color4);
        graphics.drawArc(n2, n3, n4, n5, 225, 180);
        graphics.setColor(color2);
    }

    void draw3DRect(Graphics graphics, Color color, int n2, int n3, int n4, int n5, boolean bl2) {
        Color color2 = graphics.getColor();
        Color color3 = color.darker();
        Color color4 = color.brighter();
        graphics.setColor(bl2 ? color4 : color3);
        graphics.drawLine(n2, n3, n2, n3 + n5);
        graphics.drawLine(n2 + 1, n3, n2 + n4 - 1, n3);
        graphics.setColor(bl2 ? color3 : color4);
        graphics.drawLine(n2 + 1, n3 + n5, n2 + n4, n3 + n5);
        graphics.drawLine(n2 + n4, n3, n2 + n4, n3 + n5 - 1);
        graphics.setColor(color2);
    }

    static native boolean processSynchronousLightweightTransfer(Component var0, Component var1, boolean var2, boolean var3, long var4);

    static native Component[] getComponents_NoClientCode(Container var0);

    static native Container getParent_NoClientCode(Component var0);

    public FontMetrics getFontMetrics(Font font) {
        return X11FontMetrics.getFontMetrics(font);
    }

    native int getNativeColor(Color var1, GraphicsConfiguration var2);

    public Image createImage(ImageProducer imageProducer) {
        return new X11Image(imageProducer);
    }

    public int checkImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        return MToolkit.checkScrImage(image, n2, n3, imageObserver);
    }

    public boolean prepareImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        return MToolkit.prepareScrImage(image, n2, n3, imageObserver);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    MComponentPeer(Component component, Object object) {
        this.init(component, object);
    }

    public void init(Component component, Object object) {
        this.target = component;
        this.paintArea = new RepaintArea();
        Container container = MToolkit.getNativeContainer(component);
        MComponentPeer mComponentPeer = (MComponentPeer)MToolkit.targetToPeer(container);
        this.create(mComponentPeer, object);
        this.initialize();
    }

    void create(MComponentPeer mComponentPeer, Object object) {
        this.create(mComponentPeer);
    }
}

