/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleExtendedTable;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleTable;
import javax.accessibility.AccessibleTableModelChange;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.Scrollable;
import javax.swing.SizeSequence;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.UIResource;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class JTable
extends JComponent
implements TableModelListener,
Scrollable,
TableColumnModelListener,
ListSelectionListener,
CellEditorListener,
Accessible {
    private static final String uiClassID = "TableUI";
    public static final int AUTO_RESIZE_OFF = 0;
    public static final int AUTO_RESIZE_NEXT_COLUMN = 1;
    public static final int AUTO_RESIZE_SUBSEQUENT_COLUMNS = 2;
    public static final int AUTO_RESIZE_LAST_COLUMN = 3;
    public static final int AUTO_RESIZE_ALL_COLUMNS = 4;
    protected TableModel dataModel;
    protected TableColumnModel columnModel;
    protected ListSelectionModel selectionModel;
    protected JTableHeader tableHeader;
    protected int rowHeight;
    protected int rowMargin;
    protected Color gridColor;
    protected boolean showHorizontalLines;
    protected boolean showVerticalLines;
    protected int autoResizeMode;
    protected boolean autoCreateColumnsFromModel;
    protected Dimension preferredViewportSize;
    protected boolean rowSelectionAllowed;
    protected boolean cellSelectionEnabled;
    protected transient Component editorComp;
    protected transient TableCellEditor cellEditor;
    protected transient int editingColumn;
    protected transient int editingRow;
    protected transient Hashtable defaultRenderersByColumnClass;
    protected transient Hashtable defaultEditorsByColumnClass;
    protected Color selectionForeground;
    protected Color selectionBackground;
    private SizeSequence rowModel;
    private boolean dragEnabled;
    private boolean surrendersFocusOnKeystroke;
    private PropertyChangeListener editorRemover = null;
    private boolean columnSelectionAdjusting;
    private boolean rowSelectionAdjusting;
    static Class class$java$lang$Object;
    static Class class$java$lang$Number;
    static Class class$java$lang$Float;
    static Class class$java$lang$Double;
    static Class class$java$util$Date;
    static Class class$javax$swing$Icon;
    static Class class$javax$swing$ImageIcon;
    static Class class$java$lang$Boolean;
    static Class class$java$lang$String;

    public int getAutoResizeMode() {
        return this.autoResizeMode;
    }

    public int getColumnCount() {
        return this.getColumnModel().getColumnCount();
    }

    public int getEditingColumn() {
        return this.editingColumn;
    }

    public int getEditingRow() {
        return this.editingRow;
    }

    public int getRowCount() {
        return this.getModel().getRowCount();
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public int getRowMargin() {
        return this.rowMargin;
    }

    public int getSelectedColumn() {
        return this.columnModel.getSelectionModel().getMinSelectionIndex();
    }

    public int getSelectedColumnCount() {
        return this.columnModel.getSelectedColumnCount();
    }

    public int getSelectedRow() {
        return this.selectionModel.getMinSelectionIndex();
    }

    public int getSelectedRowCount() {
        int n2 = this.selectionModel.getMinSelectionIndex();
        int n3 = this.selectionModel.getMaxSelectionIndex();
        int n4 = 0;
        for (int i2 = n2; i2 <= n3; ++i2) {
            if (!this.selectionModel.isSelectedIndex(i2)) continue;
            ++n4;
        }
        return n4;
    }

    public JTable() {
        this(null, null, null);
    }

    public void addNotify() {
        super.addNotify();
        this.configureEnclosingScrollPane();
    }

    public void clearSelection() {
        this.columnModel.getSelectionModel().clearSelection();
        this.selectionModel.clearSelection();
    }

    void compWriteObjectNotify() {
        super.compWriteObjectNotify();
        if (this.getToolTipText() == null) {
            ToolTipManager.sharedInstance().unregisterComponent(this);
        }
    }

    protected void configureEnclosingScrollPane() {
        Container container;
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport == null || jViewport.getView() != this) {
                return;
            }
            jScrollPane.setColumnHeaderView(this.getTableHeader());
            Border border = jScrollPane.getBorder();
            if (border == null || border instanceof UIResource) {
                jScrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
            }
        }
    }

    public void createDefaultColumnsFromModel() {
        TableModel tableModel = this.getModel();
        if (tableModel != null) {
            TableColumnModel tableColumnModel = this.getColumnModel();
            while (tableColumnModel.getColumnCount() > 0) {
                tableColumnModel.removeColumn(tableColumnModel.getColumn(0));
            }
            for (int i2 = 0; i2 < tableModel.getColumnCount(); ++i2) {
                TableColumn tableColumn = new TableColumn(i2);
                this.addColumn(tableColumn);
            }
        }
    }

    protected void createDefaultEditors() {
        this.defaultEditorsByColumnClass = new UIDefaults();
        this.setLazyEditor(class$java$lang$Object == null ? (class$java$lang$Object = JTable.class$("java.lang.Object")) : class$java$lang$Object, "javax.swing.JTable$GenericEditor");
        this.setLazyEditor(class$java$lang$Number == null ? (class$java$lang$Number = JTable.class$("java.lang.Number")) : class$java$lang$Number, "javax.swing.JTable$NumberEditor");
        this.setLazyEditor(class$java$lang$Boolean == null ? (class$java$lang$Boolean = JTable.class$("java.lang.Boolean")) : class$java$lang$Boolean, "javax.swing.JTable$BooleanEditor");
    }

    protected void createDefaultRenderers() {
        this.defaultRenderersByColumnClass = new UIDefaults();
        this.setLazyRenderer(class$java$lang$Object == null ? (class$java$lang$Object = JTable.class$("java.lang.Object")) : class$java$lang$Object, "javax.swing.table.DefaultTableCellRenderer");
        this.setLazyRenderer(class$java$lang$Number == null ? (class$java$lang$Number = JTable.class$("java.lang.Number")) : class$java$lang$Number, "javax.swing.JTable$NumberRenderer");
        this.setLazyRenderer(class$java$lang$Float == null ? (class$java$lang$Float = JTable.class$("java.lang.Float")) : class$java$lang$Float, "javax.swing.JTable$DoubleRenderer");
        this.setLazyRenderer(class$java$lang$Double == null ? (class$java$lang$Double = JTable.class$("java.lang.Double")) : class$java$lang$Double, "javax.swing.JTable$DoubleRenderer");
        this.setLazyRenderer(class$java$util$Date == null ? (class$java$util$Date = JTable.class$("java.util.Date")) : class$java$util$Date, "javax.swing.JTable$DateRenderer");
        this.setLazyRenderer(class$javax$swing$Icon == null ? (class$javax$swing$Icon = JTable.class$("javax.swing.Icon")) : class$javax$swing$Icon, "javax.swing.JTable$IconRenderer");
        this.setLazyRenderer(class$javax$swing$ImageIcon == null ? (class$javax$swing$ImageIcon = JTable.class$("javax.swing.ImageIcon")) : class$javax$swing$ImageIcon, "javax.swing.JTable$IconRenderer");
        this.setLazyRenderer(class$java$lang$Boolean == null ? (class$java$lang$Boolean = JTable.class$("java.lang.Boolean")) : class$java$lang$Boolean, "javax.swing.JTable$BooleanRenderer");
    }

    public void doLayout() {
        TableColumn tableColumn = this.getResizingColumn();
        if (tableColumn == null) {
            this.setWidthsFromPreferredWidths(false);
        } else {
            int n2 = this.viewIndexForColumn(tableColumn);
            int n3 = this.getWidth() - this.getColumnModel().getTotalColumnWidth();
            this.accommodateDelta(n2, n3);
            n3 = this.getWidth() - this.getColumnModel().getTotalColumnWidth();
            if (n3 != 0) {
                tableColumn.setWidth(tableColumn.getWidth() + n3);
            }
            this.setWidthsFromPreferredWidths(true);
        }
        super.doLayout();
    }

    protected void initializeLocalVars() {
        this.getSelectionModel().setAnchorSelectionIndex(0);
        this.setOpaque(true);
        this.createDefaultRenderers();
        this.createDefaultEditors();
        this.setTableHeader(this.createDefaultTableHeader());
        this.setShowGrid(true);
        this.setAutoResizeMode(2);
        this.setRowHeight(16);
        this.setRowMargin(1);
        this.setRowSelectionAllowed(true);
        this.setCellEditor(null);
        this.setEditingColumn(-1);
        this.setEditingRow(-1);
        this.setSurrendersFocusOnKeystroke(false);
        this.setPreferredScrollableViewportSize(new Dimension(450, 400));
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this);
        this.setAutoscrolls(true);
    }

    public void removeEditor() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.editorRemover);
        this.editorRemover = null;
        TableCellEditor tableCellEditor = this.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.removeCellEditorListener(this);
            if (this.editorComp != null) {
                this.remove(this.editorComp);
            }
            Rectangle rectangle = this.getCellRect(this.editingRow, this.editingColumn, false);
            this.setCellEditor(null);
            this.setEditingColumn(-1);
            this.setEditingRow(-1);
            this.editorComp = null;
            this.repaint(rectangle);
        }
    }

    public void removeNotify() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.editorRemover);
        this.editorRemover = null;
        this.unconfigureEnclosingScrollPane();
        super.removeNotify();
    }

    protected void resizeAndRepaint() {
        this.revalidate();
        this.repaint();
    }

    public void selectAll() {
        if (this.isEditing()) {
            this.removeEditor();
        }
        if (this.getRowCount() > 0 && this.getColumnCount() > 0) {
            this.setRowSelectionInterval(0, this.getRowCount() - 1);
            this.setColumnSelectionInterval(0, this.getColumnCount() - 1);
        }
    }

    protected void unconfigureEnclosingScrollPane() {
        Container container;
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport == null || jViewport.getView() != this) {
                return;
            }
            jScrollPane.setColumnHeaderView(null);
        }
    }

    public void updateUI() {
        Object object;
        TableColumnModel tableColumnModel = this.getColumnModel();
        for (int i2 = 0; i2 < tableColumnModel.getColumnCount(); ++i2) {
            object = tableColumnModel.getColumn(i2);
            this.updateSubComponentUI(((TableColumn)object).getCellRenderer());
            this.updateSubComponentUI(((TableColumn)object).getCellEditor());
            this.updateSubComponentUI(((TableColumn)object).getHeaderRenderer());
        }
        Enumeration enumeration = this.defaultRenderersByColumnClass.elements();
        while (enumeration.hasMoreElements()) {
            this.updateSubComponentUI(enumeration.nextElement());
        }
        object = this.defaultEditorsByColumnClass.elements();
        while (object.hasMoreElements()) {
            this.updateSubComponentUI(object.nextElement());
        }
        this.setUI((TableUI)UIManager.getUI(this));
        this.resizeAndRepaint();
    }

    public boolean getAutoCreateColumnsFromModel() {
        return this.autoCreateColumnsFromModel;
    }

    public boolean getCellSelectionEnabled() {
        return this.getRowSelectionAllowed() && this.getColumnSelectionAllowed();
    }

    public boolean getColumnSelectionAllowed() {
        return this.columnModel.getColumnSelectionAllowed();
    }

    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    public boolean getRowSelectionAllowed() {
        return this.rowSelectionAllowed;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.autoResizeMode != 0;
    }

    public boolean getShowHorizontalLines() {
        return this.showHorizontalLines;
    }

    public boolean getShowVerticalLines() {
        return this.showVerticalLines;
    }

    public boolean getSurrendersFocusOnKeystroke() {
        return this.surrendersFocusOnKeystroke;
    }

    public boolean isEditing() {
        return this.cellEditor != null;
    }

    public int[] getSelectedColumns() {
        return this.columnModel.getSelectedColumns();
    }

    public int[] getSelectedRows() {
        int n2 = this.selectionModel.getMinSelectionIndex();
        int n3 = this.selectionModel.getMaxSelectionIndex();
        if (n2 == -1 || n3 == -1) {
            return new int[0];
        }
        int[] nArray = new int[1 + (n3 - n2)];
        int n4 = 0;
        for (int i2 = n2; i2 <= n3; ++i2) {
            if (!this.selectionModel.isSelectedIndex(i2)) continue;
            nArray[n4++] = i2;
        }
        int[] nArray2 = new int[n4];
        System.arraycopy(nArray, 0, nArray2, 0, n4);
        return nArray2;
    }

    private int boundColumn(int n2) {
        if (n2 < 0 || n2 >= this.getColumnCount()) {
            throw new IllegalArgumentException("Column index out of range");
        }
        return n2;
    }

    private int boundRow(int n2) throws IllegalArgumentException {
        if (n2 < 0 || n2 >= this.getRowCount()) {
            throw new IllegalArgumentException("Row index out of range");
        }
        return n2;
    }

    public int convertColumnIndexToModel(int n2) {
        if (n2 < 0) {
            return n2;
        }
        return this.getColumnModel().getColumn(n2).getModelIndex();
    }

    public int convertColumnIndexToView(int n2) {
        if (n2 < 0) {
            return n2;
        }
        TableColumnModel tableColumnModel = this.getColumnModel();
        for (int i2 = 0; i2 < this.getColumnCount(); ++i2) {
            if (tableColumnModel.getColumn(i2).getModelIndex() != n2) continue;
            return i2;
        }
        return -1;
    }

    public int getRowHeight(int n2) {
        return this.rowModel == null ? this.getRowHeight() : this.rowModel.getSize(n2);
    }

    public void setAutoResizeMode(int n2) {
        if (n2 == 0 || n2 == 1 || n2 == 2 || n2 == 3 || n2 == 4) {
            int n3 = this.autoResizeMode;
            this.autoResizeMode = n2;
            this.resizeAndRepaint();
            if (this.tableHeader != null) {
                this.tableHeader.resizeAndRepaint();
            }
            this.firePropertyChange("autoResizeMode", n3, this.autoResizeMode);
        }
    }

    public void setEditingColumn(int n2) {
        this.editingColumn = n2;
    }

    public void setEditingRow(int n2) {
        this.editingRow = n2;
    }

    public void setRowHeight(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("New row height less than 1");
        }
        int n3 = this.rowHeight;
        this.rowHeight = n2;
        this.rowModel = null;
        this.resizeAndRepaint();
        this.firePropertyChange("rowHeight", n3, n2);
    }

    public void setRowMargin(int n2) {
        int n3 = this.rowMargin;
        this.rowMargin = n2;
        this.resizeAndRepaint();
        this.firePropertyChange("rowMargin", n3, n2);
    }

    public void setSelectionMode(int n2) {
        this.clearSelection();
        this.getSelectionModel().setSelectionMode(n2);
        this.getColumnModel().getSelectionModel().setSelectionMode(n2);
    }

    public void sizeColumnsToFit(int n2) {
        if (n2 == -1) {
            this.setWidthsFromPreferredWidths(false);
        } else if (this.autoResizeMode == 0) {
            TableColumn tableColumn = this.getColumnModel().getColumn(n2);
            tableColumn.setPreferredWidth(tableColumn.getWidth());
        } else {
            int n3 = this.getWidth() - this.getColumnModel().getTotalColumnWidth();
            this.accommodateDelta(n2, n3);
            this.setWidthsFromPreferredWidths(true);
        }
    }

    public boolean isColumnSelected(int n2) {
        return this.columnModel.getSelectionModel().isSelectedIndex(n2);
    }

    public boolean isRowSelected(int n2) {
        return this.selectionModel.isSelectedIndex(n2);
    }

    public JTable(int n2, int n3) {
        this(new DefaultTableModel(n2, n3));
    }

    private void accommodateDelta(int n2, int n3) {
        int n4 = this.getColumnCount();
        int n5 = n2;
        int n6 = n4;
        switch (this.autoResizeMode) {
            case 1: {
                n6 = Math.min(++n5 + 1, n4);
                break;
            }
            case 2: {
                ++n5;
                n6 = n4;
                break;
            }
            case 3: {
                n5 = n4 - 1;
                n6 = n5 + 1;
                break;
            }
            case 4: {
                n5 = 0;
                n6 = n4;
                break;
            }
            default: {
                return;
            }
        }
        int n7 = n5;
        int n8 = n6;
        TableColumnModel tableColumnModel = this.columnModel;
        Resizable3 resizable3 = new Resizable3(this, n8, n7, tableColumnModel){
            private final int val$end;
            private final int val$start;
            private final TableColumnModel val$cm;
            private final JTable this$0;

            public int getElementCount() {
                return this.val$end - this.val$start;
            }

            public int getLowerBoundAt(int n2) {
                return this.val$cm.getColumn(n2 + this.val$start).getMinWidth();
            }

            public int getMidPointAt(int n2) {
                return this.val$cm.getColumn(n2 + this.val$start).getWidth();
            }

            public int getUpperBoundAt(int n2) {
                return this.val$cm.getColumn(n2 + this.val$start).getMaxWidth();
            }

            public void setSizeAt(int n2, int n3) {
                this.val$cm.getColumn(n3 + this.val$start).setWidth(n2);
            }
            {
                this.this$0 = jTable;
                this.val$end = n2;
                this.val$start = n3;
                this.val$cm = tableColumnModel;
            }
        };
        int n9 = 0;
        for (int i2 = n5; i2 < n6; ++i2) {
            TableColumn tableColumn = this.columnModel.getColumn(i2);
            int n10 = tableColumn.getWidth();
            n9 += n10;
        }
        this.adjustSizes((long)(n9 + n3), resizable3, false);
    }

    public void addColumnSelectionInterval(int n2, int n3) {
        this.columnModel.getSelectionModel().addSelectionInterval(this.boundColumn(n2), this.boundColumn(n3));
    }

    public void addRowSelectionInterval(int n2, int n3) {
        this.selectionModel.addSelectionInterval(this.boundRow(n2), this.boundRow(n3));
    }

    public void moveColumn(int n2, int n3) {
        this.getColumnModel().moveColumn(n2, n3);
    }

    public void removeColumnSelectionInterval(int n2, int n3) {
        this.columnModel.getSelectionModel().removeSelectionInterval(this.boundColumn(n2), this.boundColumn(n3));
    }

    public void removeRowSelectionInterval(int n2, int n3) {
        this.selectionModel.removeSelectionInterval(this.boundRow(n2), this.boundRow(n3));
    }

    public void setColumnSelectionInterval(int n2, int n3) {
        this.columnModel.getSelectionModel().setSelectionInterval(this.boundColumn(n2), this.boundColumn(n3));
    }

    public void setRowHeight(int n2, int n3) {
        if (n3 <= 0) {
            throw new IllegalArgumentException("New row height less than 1");
        }
        this.getRowModel().setSize(n2, n3);
        this.resizeAndRepaint();
    }

    public void setRowSelectionInterval(int n2, int n3) {
        this.selectionModel.setSelectionInterval(this.boundRow(n2), this.boundRow(n3));
    }

    public boolean editCellAt(int n2, int n3) {
        return this.editCellAt(n2, n3, null);
    }

    public boolean isCellEditable(int n2, int n3) {
        return this.getModel().isCellEditable(n2, this.convertColumnIndexToModel(n3));
    }

    public boolean isCellSelected(int n2, int n3) {
        if (!this.getRowSelectionAllowed() && !this.getColumnSelectionAllowed()) {
            return false;
        }
        return !(this.getRowSelectionAllowed() && !this.isRowSelected(n2) || this.getColumnSelectionAllowed() && !this.isColumnSelected(n3));
    }

    private int limit(int n2, int n3, int n4) {
        return Math.min(n4, Math.max(n2, n3));
    }

    public void changeSelection(int n2, int n3, boolean bl2, boolean bl3) {
        Rectangle rectangle;
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        ListSelectionModel listSelectionModel2 = this.getColumnModel().getSelectionModel();
        boolean bl4 = this.isCellSelected(n2, n3);
        this.changeSelectionModel(listSelectionModel2, n3, bl2, bl3, bl4);
        this.changeSelectionModel(listSelectionModel, n2, bl2, bl3, bl4);
        if (this.getAutoscrolls() && (rectangle = this.getCellRect(n2, n3, false)) != null) {
            this.scrollRectToVisible(rectangle);
        }
    }

    public void setAutoCreateColumnsFromModel(boolean bl2) {
        if (this.autoCreateColumnsFromModel != bl2) {
            boolean bl3 = this.autoCreateColumnsFromModel;
            this.autoCreateColumnsFromModel = bl2;
            if (bl2) {
                this.createDefaultColumnsFromModel();
            }
            this.firePropertyChange("autoCreateColumnsFromModel", bl3, bl2);
        }
    }

    public void setCellSelectionEnabled(boolean bl2) {
        this.setRowSelectionAllowed(bl2);
        this.setColumnSelectionAllowed(bl2);
        boolean bl3 = this.cellSelectionEnabled;
        this.cellSelectionEnabled = bl2;
        this.firePropertyChange("cellSelectionEnabled", bl3, bl2);
    }

    public void setColumnSelectionAllowed(boolean bl2) {
        boolean bl3 = this.columnModel.getColumnSelectionAllowed();
        this.columnModel.setColumnSelectionAllowed(bl2);
        if (bl3 != bl2) {
            this.repaint();
        }
        this.firePropertyChange("columnSelectionAllowed", bl3, bl2);
    }

    public void setDragEnabled(boolean bl2) {
        if (bl2 && GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        this.dragEnabled = bl2;
    }

    public void setRowSelectionAllowed(boolean bl2) {
        boolean bl3 = this.rowSelectionAllowed;
        this.rowSelectionAllowed = bl2;
        if (bl3 != bl2) {
            this.repaint();
        }
        this.firePropertyChange("rowSelectionAllowed", bl3, bl2);
    }

    public void setShowGrid(boolean bl2) {
        this.setShowHorizontalLines(bl2);
        this.setShowVerticalLines(bl2);
        this.repaint();
    }

    public void setShowHorizontalLines(boolean bl2) {
        boolean bl3 = this.showHorizontalLines;
        this.showHorizontalLines = bl2;
        this.firePropertyChange("showHorizontalLines", bl3, bl2);
        this.repaint();
    }

    public void setShowVerticalLines(boolean bl2) {
        boolean bl3 = this.showVerticalLines;
        this.showVerticalLines = bl2;
        this.firePropertyChange("showVerticalLines", bl3, bl2);
        this.repaint();
    }

    public void setSurrendersFocusOnKeystroke(boolean bl2) {
        this.surrendersFocusOnKeystroke = bl2;
    }

    private void setWidthsFromPreferredWidths(boolean bl2) {
        int n2 = this.getWidth();
        int n3 = this.getPreferredSize().width;
        int n4 = !bl2 ? n2 : n3;
        TableColumnModel tableColumnModel = this.columnModel;
        Resizable3 resizable3 = new Resizable3(this, tableColumnModel, bl2){
            private final TableColumnModel val$cm;
            private final boolean val$inverse;
            private final JTable this$0;

            public int getElementCount() {
                return this.val$cm.getColumnCount();
            }

            public int getLowerBoundAt(int n2) {
                return this.val$cm.getColumn(n2).getMinWidth();
            }

            public int getMidPointAt(int n2) {
                if (!this.val$inverse) {
                    return this.val$cm.getColumn(n2).getPreferredWidth();
                }
                return this.val$cm.getColumn(n2).getWidth();
            }

            public int getUpperBoundAt(int n2) {
                return this.val$cm.getColumn(n2).getMaxWidth();
            }

            public void setSizeAt(int n2, int n3) {
                if (!this.val$inverse) {
                    this.val$cm.getColumn(n3).setWidth(n2);
                } else {
                    this.val$cm.getColumn(n3).setPreferredWidth(n2);
                }
            }
            {
                this.this$0 = jTable;
                this.val$cm = tableColumnModel;
                this.val$inverse = bl2;
            }
        };
        this.adjustSizes((long)n4, resizable3, bl2);
    }

    public void sizeColumnsToFit(boolean bl2) {
        int n2 = this.autoResizeMode;
        this.setAutoResizeMode(bl2 ? 3 : 4);
        this.sizeColumnsToFit(-1);
        this.setAutoResizeMode(n2);
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public Color getSelectionBackground() {
        return this.selectionBackground;
    }

    public Color getSelectionForeground() {
        return this.selectionForeground;
    }

    public void setGridColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("New color is null");
        }
        Color color2 = this.gridColor;
        this.gridColor = color;
        this.firePropertyChange("gridColor", color2, color);
        this.repaint();
    }

    public void setSelectionBackground(Color color) {
        Color color2 = this.selectionBackground;
        this.selectionBackground = color;
        this.firePropertyChange("selectionBackground", color2, color);
        if (!color.equals(color2)) {
            this.repaint();
        }
    }

    public void setSelectionForeground(Color color) {
        Color color2 = this.selectionForeground;
        this.selectionForeground = color;
        this.firePropertyChange("selectionForeground", color2, color);
        if (!color.equals(color2)) {
            this.repaint();
        }
    }

    public Component getEditorComponent() {
        return this.editorComp;
    }

    public Dimension getIntercellSpacing() {
        return new Dimension(this.getColumnModel().getColumnMargin(), this.rowMargin);
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.preferredViewportSize;
    }

    public void setIntercellSpacing(Dimension dimension) {
        this.setRowMargin(dimension.height);
        this.getColumnModel().setColumnMargin(dimension.width);
        this.resizeAndRepaint();
    }

    public void setPreferredScrollableViewportSize(Dimension dimension) {
        this.preferredViewportSize = dimension;
    }

    public int columnAtPoint(Point point) {
        int n2 = point.x;
        if (!this.getComponentOrientation().isLeftToRight()) {
            n2 = this.getWidth() - n2;
        }
        return this.getColumnModel().getColumnIndexAtX(n2);
    }

    public int rowAtPoint(Point point) {
        int n2;
        int n3 = point.y;
        int n4 = n2 = this.rowModel == null ? n3 / this.getRowHeight() : this.rowModel.getIndex(n3);
        if (n2 < 0) {
            return -1;
        }
        if (n2 >= this.getRowCount()) {
            return -1;
        }
        return n2;
    }

    public Rectangle getCellRect(int n2, int n3, boolean bl2) {
        int n4;
        Rectangle rectangle = new Rectangle();
        boolean bl3 = true;
        if (n2 < 0) {
            bl3 = false;
        } else if (n2 >= this.getRowCount()) {
            rectangle.y = this.getHeight();
            bl3 = false;
        } else {
            rectangle.height = this.getRowHeight(n2);
            int n5 = rectangle.y = this.rowModel == null ? n2 * rectangle.height : this.rowModel.getPosition(n2);
        }
        if (n3 < 0) {
            if (!this.getComponentOrientation().isLeftToRight()) {
                rectangle.x = this.getWidth();
            }
            bl3 = false;
        } else if (n3 >= this.getColumnCount()) {
            if (this.getComponentOrientation().isLeftToRight()) {
                rectangle.x = this.getWidth();
            }
            bl3 = false;
        } else {
            TableColumnModel tableColumnModel = this.getColumnModel();
            if (this.getComponentOrientation().isLeftToRight()) {
                for (n4 = 0; n4 < n3; ++n4) {
                    rectangle.x += tableColumnModel.getColumn(n4).getWidth();
                }
            } else {
                for (n4 = tableColumnModel.getColumnCount() - 1; n4 > n3; --n4) {
                    rectangle.x += tableColumnModel.getColumn(n4).getWidth();
                }
            }
            rectangle.width = tableColumnModel.getColumn(n3).getWidth();
        }
        if (bl3 && !bl2) {
            int n6 = this.getRowMargin();
            n4 = this.getColumnModel().getColumnMargin();
            rectangle.setBounds(rectangle.x + n4 / 2, rectangle.y + n6 / 2, rectangle.width - n4, rectangle.height - n6);
        }
        return rectangle;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n2, int n3) {
        if (n2 == 1) {
            int n4 = this.getRowHeight();
            return n4 > 0 ? Math.max(n4, rectangle.height / n4 * n4) : rectangle.height;
        }
        return rectangle.width;
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n2, int n3) {
        if (n2 == 0) {
            return 100;
        }
        return this.getRowHeight();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
        this.createDefaultRenderers();
        this.createDefaultEditors();
        if (this.getToolTipText() == null) {
            ToolTipManager.sharedInstance().registerComponent(this);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    public Class getColumnClass(int n2) {
        return this.getModel().getColumnClass(this.convertColumnIndexToModel(n2));
    }

    public Object getValueAt(int n2, int n3) {
        return this.getModel().getValueAt(n2, this.convertColumnIndexToModel(n3));
    }

    private void updateSubComponentUI(Object object) {
        if (object == null) {
            return;
        }
        Component component = null;
        if (object instanceof Component) {
            component = (Component)object;
        }
        if (object instanceof DefaultCellEditor) {
            component = ((DefaultCellEditor)object).getComponent();
        }
        if (component != null && component instanceof JComponent) {
            ((JComponent)component).updateUI();
        }
    }

    public void setValueAt(Object object, int n2, int n3) {
        this.getModel().setValueAt(object, n2, this.convertColumnIndexToModel(n3));
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected String paramString() {
        String string;
        String string2 = this.gridColor != null ? this.gridColor.toString() : "";
        String string3 = this.showHorizontalLines ? "true" : "false";
        String string4 = string = this.showVerticalLines ? "true" : "false";
        String string5 = this.autoResizeMode == 0 ? "AUTO_RESIZE_OFF" : (this.autoResizeMode == 1 ? "AUTO_RESIZE_NEXT_COLUMN" : (this.autoResizeMode == 2 ? "AUTO_RESIZE_SUBSEQUENT_COLUMNS" : (this.autoResizeMode == 3 ? "AUTO_RESIZE_LAST_COLUMN" : (this.autoResizeMode == 4 ? "AUTO_RESIZE_ALL_COLUMNS" : ""))));
        String string6 = this.autoCreateColumnsFromModel ? "true" : "false";
        String string7 = this.preferredViewportSize != null ? this.preferredViewportSize.toString() : "";
        String string8 = this.rowSelectionAllowed ? "true" : "false";
        String string9 = this.cellSelectionEnabled ? "true" : "false";
        String string10 = this.selectionForeground != null ? this.selectionForeground.toString() : "";
        String string11 = this.selectionBackground != null ? this.selectionBackground.toString() : "";
        return super.paramString() + ",autoCreateColumnsFromModel=" + string6 + ",autoResizeMode=" + string5 + ",cellSelectionEnabled=" + string9 + ",editingColumn=" + this.editingColumn + ",editingRow=" + this.editingRow + ",gridColor=" + string2 + ",preferredViewportSize=" + string7 + ",rowHeight=" + this.rowHeight + ",rowMargin=" + this.rowMargin + ",rowSelectionAllowed=" + string8 + ",selectionBackground=" + string11 + ",selectionForeground=" + string10 + ",showHorizontalLines=" + string3 + ",showVerticalLines=" + string;
    }

    public String getColumnName(int n2) {
        return this.getModel().getColumnName(this.convertColumnIndexToModel(n2));
    }

    public boolean editCellAt(int n2, int n3, EventObject eventObject) {
        Object object;
        if (this.cellEditor != null && !this.cellEditor.stopCellEditing()) {
            return false;
        }
        if (n2 < 0 || n2 >= this.getRowCount() || n3 < 0 || n3 >= this.getColumnCount()) {
            return false;
        }
        if (!this.isCellEditable(n2, n3)) {
            return false;
        }
        if (this.editorRemover == null) {
            object = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.editorRemover = new CellEditorRemover(this, (KeyboardFocusManager)object);
            ((KeyboardFocusManager)object).addPropertyChangeListener("permanentFocusOwner", this.editorRemover);
        }
        if ((object = this.getCellEditor(n2, n3)) != null && object.isCellEditable(eventObject)) {
            this.editorComp = this.prepareEditor((TableCellEditor)object, n2, n3);
            if (this.editorComp == null) {
                this.removeEditor();
                return false;
            }
            this.editorComp.setBounds(this.getCellRect(n2, n3, false));
            this.add(this.editorComp);
            this.editorComp.validate();
            this.setCellEditor((TableCellEditor)object);
            this.setEditingRow(n2);
            this.setEditingColumn(n3);
            object.addCellEditorListener(this);
            return true;
        }
        return false;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTable(this);
        }
        return this.accessibleContext;
    }

    private void adjustSizes(long l2, Resizable2 resizable2, boolean bl2) {
        int n2;
        long l3 = 0L;
        long l4 = 0L;
        for (n2 = 0; n2 < resizable2.getElementCount(); ++n2) {
            l3 += (long)resizable2.getLowerBoundAt(n2);
            l4 += (long)resizable2.getUpperBoundAt(n2);
        }
        if (bl2) {
            l2 = Math.min(Math.max(l3, l2), l4);
        }
        for (n2 = 0; n2 < resizable2.getElementCount(); ++n2) {
            int n3;
            int n4 = resizable2.getLowerBoundAt(n2);
            int n5 = resizable2.getUpperBoundAt(n2);
            if (l3 == l4) {
                n3 = n4;
            } else {
                double d2 = (double)(l2 - l3) / (double)(l4 - l3);
                n3 = (int)Math.round((double)n4 + d2 * (double)(n5 - n4));
            }
            resizable2.setSizeAt(n3, n2);
            l2 -= (long)n3;
            l3 -= (long)n4;
            l4 -= (long)n5;
        }
    }

    private void adjustSizes(long l2, Resizable3 resizable3, boolean bl2) {
        int n2 = resizable3.getElementCount();
        long l3 = 0L;
        for (int i2 = 0; i2 < n2; ++i2) {
            l3 += (long)resizable3.getMidPointAt(i2);
        }
        Resizable2 resizable2 = l2 < l3 == !bl2 ? new Resizable2(this, resizable3){
            private final Resizable3 val$r;
            private final JTable this$0;

            public int getElementCount() {
                return this.val$r.getElementCount();
            }

            public int getLowerBoundAt(int n2) {
                return this.val$r.getLowerBoundAt(n2);
            }

            public int getUpperBoundAt(int n2) {
                return this.val$r.getMidPointAt(n2);
            }

            public void setSizeAt(int n2, int n3) {
                this.val$r.setSizeAt(n2, n3);
            }
            {
                this.this$0 = jTable;
                this.val$r = resizable3;
            }
        } : new Resizable2(this, resizable3){
            private final Resizable3 val$r;
            private final JTable this$0;

            public int getElementCount() {
                return this.val$r.getElementCount();
            }

            public int getLowerBoundAt(int n2) {
                return this.val$r.getMidPointAt(n2);
            }

            public int getUpperBoundAt(int n2) {
                return this.val$r.getUpperBoundAt(n2);
            }

            public void setSizeAt(int n2, int n3) {
                this.val$r.setSizeAt(n2, n3);
            }
            {
                this.this$0 = jTable;
                this.val$r = resizable3;
            }
        };
        this.adjustSizes(l2, resizable2, !bl2);
    }

    protected ListSelectionModel createDefaultSelectionModel() {
        return new DefaultListSelectionModel();
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        if (listSelectionModel == null) {
            throw new IllegalArgumentException("Cannot set a null SelectionModel");
        }
        ListSelectionModel listSelectionModel2 = this.selectionModel;
        if (listSelectionModel != listSelectionModel2) {
            if (listSelectionModel2 != null) {
                listSelectionModel2.removeListSelectionListener(this);
            }
            this.selectionModel = listSelectionModel;
            if (listSelectionModel != null) {
                listSelectionModel.addListSelectionListener(this);
            }
            this.firePropertyChange("selectionModel", listSelectionModel2, listSelectionModel);
            this.repaint();
        }
    }

    private void changeSelectionModel(ListSelectionModel listSelectionModel, int n2, boolean bl2, boolean bl3, boolean bl4) {
        if (bl3) {
            if (bl2) {
                listSelectionModel.setAnchorSelectionIndex(n2);
            } else {
                listSelectionModel.setLeadSelectionIndex(n2);
            }
        } else if (bl2) {
            if (bl4) {
                listSelectionModel.removeSelectionInterval(n2, n2);
            } else {
                listSelectionModel.addSelectionInterval(n2, n2);
            }
        } else {
            listSelectionModel.setSelectionInterval(n2, n2);
        }
    }

    private SizeSequence getRowModel() {
        if (this.rowModel == null) {
            this.rowModel = new SizeSequence(this.getRowCount(), this.getRowHeight());
        }
        return this.rowModel;
    }

    public void columnMarginChanged(ChangeEvent changeEvent) {
        TableColumn tableColumn;
        if (this.isEditing()) {
            this.removeEditor();
        }
        if ((tableColumn = this.getResizingColumn()) != null && this.autoResizeMode == 0) {
            tableColumn.setPreferredWidth(tableColumn.getWidth());
        }
        this.resizeAndRepaint();
    }

    public void editingCanceled(ChangeEvent changeEvent) {
        this.removeEditor();
    }

    public void editingStopped(ChangeEvent changeEvent) {
        TableCellEditor tableCellEditor = this.getCellEditor();
        if (tableCellEditor != null) {
            Object object = tableCellEditor.getCellEditorValue();
            this.setValueAt(object, this.editingRow, this.editingColumn);
            this.removeEditor();
        }
    }

    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        boolean bl2 = listSelectionEvent.getValueIsAdjusting();
        if (this.columnSelectionAdjusting && !bl2) {
            this.columnSelectionAdjusting = false;
            return;
        }
        this.columnSelectionAdjusting = bl2;
        if (this.getRowCount() <= 0 || this.getColumnCount() <= 0) {
            return;
        }
        int n2 = this.limit(listSelectionEvent.getFirstIndex(), 0, this.getColumnCount() - 1);
        int n3 = this.limit(listSelectionEvent.getLastIndex(), 0, this.getColumnCount() - 1);
        int n4 = 0;
        int n5 = this.getRowCount() - 1;
        if (this.getRowSelectionAllowed()) {
            n4 = this.selectionModel.getMinSelectionIndex();
            n5 = this.selectionModel.getMaxSelectionIndex();
            if (n4 == -1 || n5 == -1) {
                return;
            }
        }
        Rectangle rectangle = this.getCellRect(n4, n2, false);
        Rectangle rectangle2 = this.getCellRect(n5, n3, false);
        Rectangle rectangle3 = rectangle.union(rectangle2);
        this.repaint(rectangle3);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        boolean bl2 = listSelectionEvent.getValueIsAdjusting();
        if (this.rowSelectionAdjusting && !bl2) {
            this.rowSelectionAdjusting = false;
            return;
        }
        this.rowSelectionAdjusting = bl2;
        if (this.getRowCount() <= 0 || this.getColumnCount() <= 0) {
            return;
        }
        int n2 = this.limit(listSelectionEvent.getFirstIndex(), 0, this.getRowCount() - 1);
        int n3 = this.limit(listSelectionEvent.getLastIndex(), 0, this.getRowCount() - 1);
        Rectangle rectangle = this.getCellRect(n2, 0, false);
        Rectangle rectangle2 = this.getCellRect(n3, this.getColumnCount() - 1, false);
        Rectangle rectangle3 = rectangle.union(rectangle2);
        this.repaint(rectangle3);
    }

    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        if (this.isEditing()) {
            this.removeEditor();
        }
        this.resizeAndRepaint();
    }

    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        if (this.isEditing()) {
            this.removeEditor();
        }
        this.repaint();
    }

    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        if (this.isEditing()) {
            this.removeEditor();
        }
        this.resizeAndRepaint();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        Rectangle rectangle;
        if (tableModelEvent == null || tableModelEvent.getFirstRow() == -1) {
            this.clearSelection();
            this.rowModel = null;
            if (this.getAutoCreateColumnsFromModel()) {
                this.createDefaultColumnsFromModel();
                return;
            }
            this.resizeAndRepaint();
            return;
        }
        if (this.rowModel != null) {
            this.repaint();
        }
        if (tableModelEvent.getType() == 1) {
            this.tableRowsInserted(tableModelEvent);
            return;
        }
        if (tableModelEvent.getType() == -1) {
            this.tableRowsDeleted(tableModelEvent);
            return;
        }
        int n2 = tableModelEvent.getColumn();
        int n3 = tableModelEvent.getFirstRow();
        int n4 = tableModelEvent.getLastRow();
        if (n2 == -1) {
            rectangle = new Rectangle(0, n3 * this.getRowHeight(), this.getColumnModel().getTotalColumnWidth(), 0);
        } else {
            int n5 = this.convertColumnIndexToView(n2);
            rectangle = this.getCellRect(n3, n5, false);
        }
        if (n4 != Integer.MAX_VALUE) {
            rectangle.height = (n4 - n3 + 1) * this.getRowHeight();
            this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            this.clearSelection();
            this.resizeAndRepaint();
            this.rowModel = null;
        }
    }

    private void tableRowsDeleted(TableModelEvent tableModelEvent) {
        int n2 = tableModelEvent.getFirstRow();
        int n3 = tableModelEvent.getLastRow();
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = this.getRowCount() - 1;
        }
        int n4 = n3 - n2 + 1;
        int n5 = this.getRowCount() + n4;
        this.selectionModel.removeIndexInterval(n2, n3);
        if (this.rowModel != null) {
            this.rowModel.removeEntries(n2, n4);
        }
        int n6 = this.getRowHeight();
        Rectangle rectangle = new Rectangle(0, n2 * n6, this.getColumnModel().getTotalColumnWidth(), (n5 - n2) * n6);
        this.revalidate();
        this.repaint(rectangle);
    }

    private void tableRowsInserted(TableModelEvent tableModelEvent) {
        int n2 = tableModelEvent.getFirstRow();
        int n3 = tableModelEvent.getLastRow();
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = this.getRowCount() - 1;
        }
        int n4 = n3 - n2 + 1;
        this.selectionModel.insertIndexInterval(n2, n4, true);
        if (this.rowModel != null) {
            this.rowModel.insertEntries(n2, n4, this.getRowHeight());
        }
        int n5 = this.getRowHeight();
        Rectangle rectangle = new Rectangle(0, n2 * n5, this.getColumnModel().getTotalColumnWidth(), (this.getRowCount() - n2) * n5);
        this.revalidate();
        this.repaint(rectangle);
    }

    public TableUI getUI() {
        return (TableUI)this.ui;
    }

    public void setUI(TableUI tableUI) {
        if (this.ui != tableUI) {
            super.setUI(tableUI);
            this.repaint();
        }
    }

    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel);
    }

    public JTableHeader getTableHeader() {
        return this.tableHeader;
    }

    public void setTableHeader(JTableHeader jTableHeader) {
        if (this.tableHeader != jTableHeader) {
            JTableHeader jTableHeader2 = this.tableHeader;
            if (jTableHeader2 != null) {
                jTableHeader2.setTable(null);
            }
            this.tableHeader = jTableHeader;
            if (jTableHeader != null) {
                jTableHeader.setTable(this);
            }
            this.firePropertyChange("tableHeader", jTableHeader2, jTableHeader);
        }
    }

    public TableCellEditor getCellEditor() {
        return this.cellEditor;
    }

    public TableCellEditor getCellEditor(int n2, int n3) {
        TableColumn tableColumn = this.getColumnModel().getColumn(n3);
        TableCellEditor tableCellEditor = tableColumn.getCellEditor();
        if (tableCellEditor == null) {
            tableCellEditor = this.getDefaultEditor(this.getColumnClass(n3));
        }
        return tableCellEditor;
    }

    public void setCellEditor(TableCellEditor tableCellEditor) {
        TableCellEditor tableCellEditor2 = this.cellEditor;
        this.cellEditor = tableCellEditor;
        this.firePropertyChange("tableCellEditor", tableCellEditor2, tableCellEditor);
    }

    public TableCellRenderer getCellRenderer(int n2, int n3) {
        TableColumn tableColumn = this.getColumnModel().getColumn(n3);
        TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.getDefaultRenderer(this.getColumnClass(n3));
        }
        return tableCellRenderer;
    }

    private TableColumn getResizingColumn() {
        return this.tableHeader == null ? null : this.tableHeader.getResizingColumn();
    }

    private int viewIndexForColumn(TableColumn tableColumn) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        for (int i2 = 0; i2 < tableColumnModel.getColumnCount(); ++i2) {
            if (tableColumnModel.getColumn(i2) != tableColumn) continue;
            return i2;
        }
        return -1;
    }

    public void addColumn(TableColumn tableColumn) {
        if (tableColumn.getHeaderValue() == null) {
            int n2 = tableColumn.getModelIndex();
            String string = this.getModel().getColumnName(n2);
            tableColumn.setHeaderValue(string);
        }
        this.getColumnModel().addColumn(tableColumn);
    }

    public void removeColumn(TableColumn tableColumn) {
        this.getColumnModel().removeColumn(tableColumn);
    }

    protected TableColumnModel createDefaultColumnModel() {
        return new DefaultTableColumnModel();
    }

    public TableColumnModel getColumnModel() {
        return this.columnModel;
    }

    public void setColumnModel(TableColumnModel tableColumnModel) {
        if (tableColumnModel == null) {
            throw new IllegalArgumentException("Cannot set a null ColumnModel");
        }
        TableColumnModel tableColumnModel2 = this.columnModel;
        if (tableColumnModel != tableColumnModel2) {
            if (tableColumnModel2 != null) {
                tableColumnModel2.removeColumnModelListener(this);
            }
            this.columnModel = tableColumnModel;
            tableColumnModel.addColumnModelListener(this);
            if (this.tableHeader != null) {
                this.tableHeader.setColumnModel(tableColumnModel);
            }
            this.firePropertyChange("columnModel", tableColumnModel2, tableColumnModel);
            this.resizeAndRepaint();
        }
    }

    protected TableModel createDefaultDataModel() {
        return new DefaultTableModel();
    }

    public TableModel getModel() {
        return this.dataModel;
    }

    public JTable(TableModel tableModel) {
        this(tableModel, null, null);
    }

    public void setModel(TableModel tableModel) {
        if (tableModel == null) {
            throw new IllegalArgumentException("Cannot set a null TableModel");
        }
        if (this.dataModel != tableModel) {
            TableModel tableModel2 = this.dataModel;
            if (tableModel2 != null) {
                tableModel2.removeTableModelListener(this);
            }
            this.dataModel = tableModel;
            tableModel.addTableModelListener(this);
            if (this.getColumnModel() != null) {
                this.tableChanged(new TableModelEvent(tableModel, -1));
            }
            this.firePropertyChange("model", tableModel2, tableModel);
        }
    }

    public Component prepareEditor(TableCellEditor tableCellEditor, int n2, int n3) {
        JComponent jComponent;
        boolean bl2;
        Object object = this.getValueAt(n2, n3);
        Component component = tableCellEditor.getTableCellEditorComponent(this, object, bl2 = this.isCellSelected(n2, n3), n2, n3);
        if (component instanceof JComponent && (jComponent = (JComponent)component).getNextFocusableComponent() == null) {
            jComponent.setNextFocusableComponent(this);
        }
        return component;
    }

    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n2, int n3) {
        Object object = this.getValueAt(n2, n3);
        boolean bl2 = this.isCellSelected(n2, n3);
        boolean bl3 = this.selectionModel.getAnchorSelectionIndex() == n2;
        boolean bl4 = this.columnModel.getSelectionModel().getAnchorSelectionIndex() == n3;
        boolean bl5 = bl3 && bl4 && this.isFocusOwner();
        return tableCellRenderer.getTableCellRendererComponent(this, object, bl2, bl5, n2, n3);
    }

    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n2, boolean bl2) {
        boolean bl3 = super.processKeyBinding(keyStroke, keyEvent, n2, bl2);
        if (!bl3 && n2 == 1 && this.isFocusOwner() && !Boolean.FALSE.equals((Boolean)this.getClientProperty("JTable.autoStartsEdit"))) {
            Component component = this.getEditorComponent();
            if (component == null) {
                if (keyEvent == null || keyEvent.getID() != 401) {
                    return false;
                }
                int n3 = keyEvent.getKeyCode();
                if (n3 == 16 || n3 == 17 || n3 == 18) {
                    return false;
                }
                int n4 = this.getSelectionModel().getAnchorSelectionIndex();
                int n5 = this.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
                if (n4 != -1 && n5 != -1 && !this.isEditing() && !this.editCellAt(n4, n5)) {
                    return false;
                }
                component = this.getEditorComponent();
                if (component == null) {
                    return false;
                }
            }
            if (component instanceof JComponent) {
                bl3 = ((JComponent)component).processKeyBinding(keyStroke, keyEvent, 0, bl2);
                if (this.getSurrendersFocusOnKeystroke()) {
                    component.requestFocus();
                }
            }
        }
        return bl3;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public JTable(Object[][] objectArray, Object[] objectArray2) {
        this(new AbstractTableModel(objectArray2, objectArray){
            private final Object[] val$columnNames;
            private final Object[][] val$rowData;

            public int getColumnCount() {
                return this.val$columnNames.length;
            }

            public int getRowCount() {
                return this.val$rowData.length;
            }

            public boolean isCellEditable(int n2, int n3) {
                return true;
            }

            public Object getValueAt(int n2, int n3) {
                return this.val$rowData[n2][n3];
            }

            public void setValueAt(Object object, int n2, int n3) {
                this.val$rowData[n2][n3] = object;
                this.fireTableCellUpdated(n2, n3);
            }

            public String getColumnName(int n2) {
                return this.val$columnNames[n2].toString();
            }
            {
                this.val$columnNames = objectArray;
                this.val$rowData = objectArray2;
            }
        });
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        TableCellRenderer tableCellRenderer;
        Component component;
        String string = null;
        Point point = mouseEvent.getPoint();
        int n2 = this.columnAtPoint(point);
        int n3 = this.rowAtPoint(point);
        if (n2 != -1 && n3 != -1 && (component = this.prepareRenderer(tableCellRenderer = this.getCellRenderer(n3, n2), n3, n2)) instanceof JComponent) {
            Rectangle rectangle = this.getCellRect(n3, n2, false);
            point.translate(-rectangle.x, -rectangle.y);
            MouseEvent mouseEvent2 = new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            string = ((JComponent)component).getToolTipText(mouseEvent2);
        }
        if (string == null) {
            string = this.getToolTipText();
        }
        return string;
    }

    private void setLazyEditor(Class clazz, String string) {
        this.setLazyValue(this.defaultEditorsByColumnClass, clazz, string);
    }

    private void setLazyRenderer(Class clazz, String string) {
        this.setLazyValue(this.defaultRenderersByColumnClass, clazz, string);
    }

    public JTable(Vector vector, Vector vector2) {
        this(new DefaultTableModel(vector, vector2));
    }

    public static JScrollPane createScrollPaneForTable(JTable jTable) {
        return new JScrollPane(jTable);
    }

    public TableCellEditor getDefaultEditor(Class clazz) {
        if (clazz == null) {
            return null;
        }
        Object object = this.defaultEditorsByColumnClass.get(clazz);
        if (object != null) {
            return (TableCellEditor)object;
        }
        return this.getDefaultEditor(clazz.getSuperclass());
    }

    public void setDefaultEditor(Class clazz, TableCellEditor tableCellEditor) {
        if (tableCellEditor != null) {
            this.defaultEditorsByColumnClass.put(clazz, tableCellEditor);
        } else {
            this.defaultEditorsByColumnClass.remove(clazz);
        }
    }

    public TableCellRenderer getDefaultRenderer(Class clazz) {
        if (clazz == null) {
            return null;
        }
        Object object = this.defaultRenderersByColumnClass.get(clazz);
        if (object != null) {
            return (TableCellRenderer)object;
        }
        return this.getDefaultRenderer(clazz.getSuperclass());
    }

    public void setDefaultRenderer(Class clazz, TableCellRenderer tableCellRenderer) {
        if (tableCellRenderer != null) {
            this.defaultRenderersByColumnClass.put(clazz, tableCellRenderer);
        } else {
            this.defaultRenderersByColumnClass.remove(clazz);
        }
    }

    public TableColumn getColumn(Object object) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n2 = tableColumnModel.getColumnIndex(object);
        return tableColumnModel.getColumn(n2);
    }

    public JTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        this(tableModel, tableColumnModel, null);
    }

    private void setLazyValue(Hashtable hashtable, Class clazz, String string) {
        hashtable.put(clazz, new UIDefaults.ProxyLazyValue(string));
    }

    public JTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        this.setLayout(null);
        this.setFocusTraversalKeys(0, JComponent.getManagingFocusForwardTraversalKeys());
        this.setFocusTraversalKeys(1, JComponent.getManagingFocusBackwardTraversalKeys());
        if (tableColumnModel == null) {
            tableColumnModel = this.createDefaultColumnModel();
            this.autoCreateColumnsFromModel = true;
        }
        this.setColumnModel(tableColumnModel);
        if (listSelectionModel == null) {
            listSelectionModel = this.createDefaultSelectionModel();
        }
        this.setSelectionModel(listSelectionModel);
        if (tableModel == null) {
            tableModel = this.createDefaultDataModel();
        }
        this.setModel(tableModel);
        this.initializeLocalVars();
        this.updateUI();
    }

    protected class AccessibleJTable
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    ListSelectionListener,
    TableModelListener,
    TableColumnModelListener,
    CellEditorListener,
    PropertyChangeListener,
    AccessibleExtendedTable {
        int lastSelectedRow;
        int lastSelectedCol;
        private Accessible caption;
        private Accessible summary;
        private Accessible[] rowDescription;
        private Accessible[] columnDescription;
        private final JTable this$0;

        public int getAccessibleChildrenCount() {
            return this.this$0.getColumnCount() * this.this$0.getRowCount();
        }

        public int getAccessibleColumnCount() {
            return this.this$0.getColumnCount();
        }

        public int getAccessibleRowCount() {
            return this.this$0.getRowCount();
        }

        public int getAccessibleSelectionCount() {
            int n2 = this.this$0.getSelectedRowCount();
            int n3 = this.this$0.getSelectedColumnCount();
            if (this.this$0.cellSelectionEnabled) {
                return n2 * n3;
            }
            if (this.this$0.getRowSelectionAllowed() && this.this$0.getColumnSelectionAllowed()) {
                return n2 * this.this$0.getColumnCount() + n3 * this.this$0.getRowCount() - n2 * n3;
            }
            if (this.this$0.getRowSelectionAllowed()) {
                return n2 * this.this$0.getColumnCount();
            }
            if (this.this$0.getColumnSelectionAllowed()) {
                return n3 * this.this$0.getRowCount();
            }
            return 0;
        }

        public void clearAccessibleSelection() {
            this.this$0.clearSelection();
        }

        public void selectAllAccessibleSelection() {
            if (this.this$0.cellSelectionEnabled) {
                this.this$0.selectAll();
            }
        }

        public int[] getSelectedAccessibleColumns() {
            return this.this$0.getSelectedColumns();
        }

        public int[] getSelectedAccessibleRows() {
            return this.this$0.getSelectedRows();
        }

        public int getAccessibleColumn(int n2) {
            return this.getAccessibleColumnAtIndex(n2);
        }

        public int getAccessibleColumnAtIndex(int n2) {
            int n3 = this.getAccessibleColumnCount();
            if (n3 == 0) {
                return -1;
            }
            return n2 % n3;
        }

        public int getAccessibleRow(int n2) {
            return this.getAccessibleRowAtIndex(n2);
        }

        public int getAccessibleRowAtIndex(int n2) {
            int n3 = this.getAccessibleColumnCount();
            if (n3 == 0) {
                return -1;
            }
            return n2 / n3;
        }

        public void addAccessibleSelection(int n2) {
            if (this.this$0.cellSelectionEnabled) {
                int n3 = this.getAccessibleColumnAtIndex(n2);
                int n4 = this.getAccessibleRowAtIndex(n2);
                this.this$0.addRowSelectionInterval(n4, n4);
                this.this$0.addColumnSelectionInterval(n3, n3);
            }
        }

        public void removeAccessibleSelection(int n2) {
            if (this.this$0.cellSelectionEnabled) {
                int n3 = this.getAccessibleColumnAtIndex(n2);
                int n4 = this.getAccessibleRowAtIndex(n2);
                this.this$0.removeRowSelectionInterval(n4, n4);
                this.this$0.removeColumnSelectionInterval(n3, n3);
            }
        }

        public boolean isAccessibleChildSelected(int n2) {
            int n3 = this.getAccessibleColumnAtIndex(n2);
            int n4 = this.getAccessibleRowAtIndex(n2);
            return this.this$0.isCellSelected(n4, n3);
        }

        public boolean isAccessibleColumnSelected(int n2) {
            return this.this$0.isColumnSelected(n2);
        }

        public boolean isAccessibleRowSelected(int n2) {
            return this.this$0.isRowSelected(n2);
        }

        public int getAccessibleColumnExtentAt(int n2, int n3) {
            return 1;
        }

        public int getAccessibleIndex(int n2, int n3) {
            return this.getAccessibleIndexAt(n2, n3);
        }

        public int getAccessibleIndexAt(int n2, int n3) {
            return n2 * this.getAccessibleColumnCount() + n3;
        }

        public int getAccessibleRowExtentAt(int n2, int n3) {
            return 1;
        }

        public boolean isAccessibleSelected(int n2, int n3) {
            return this.this$0.isCellSelected(n2, n3);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            if (string.compareTo("model") == 0) {
                if (object != null && object instanceof TableModel) {
                    ((TableModel)object).removeTableModelListener(this);
                }
                if (object2 != null && object2 instanceof TableModel) {
                    ((TableModel)object2).addTableModelListener(this);
                }
            } else if (string.compareTo("selectionModel") == 0) {
                Object object3 = propertyChangeEvent.getSource();
                if (object3 == this.this$0) {
                    if (object != null && object instanceof ListSelectionModel) {
                        ((ListSelectionModel)object).removeListSelectionListener(this);
                    }
                    if (object2 != null && object2 instanceof ListSelectionModel) {
                        ((ListSelectionModel)object2).addListSelectionListener(this);
                    }
                } else if (object3 == this.this$0.getColumnModel()) {
                    if (object != null && object instanceof ListSelectionModel) {
                        ((ListSelectionModel)object).removeListSelectionListener(this);
                    }
                    if (object2 != null && object2 instanceof ListSelectionModel) {
                        ((ListSelectionModel)object2).addListSelectionListener(this);
                    }
                }
            } else if (string.compareTo("columnModel") == 0) {
                TableColumnModel tableColumnModel;
                if (object != null && object instanceof TableColumnModel) {
                    tableColumnModel = (TableColumnModel)object;
                    tableColumnModel.removeColumnModelListener(this);
                    tableColumnModel.getSelectionModel().removeListSelectionListener(this);
                }
                if (object2 != null && object2 instanceof TableColumnModel) {
                    tableColumnModel = (TableColumnModel)object2;
                    tableColumnModel.addColumnModelListener(this);
                    tableColumnModel.getSelectionModel().addListSelectionListener(this);
                }
            } else if (string.compareTo("tableCellEditor") == 0) {
                if (object != null && object instanceof TableCellEditor) {
                    ((TableCellEditor)object).removeCellEditorListener(this);
                }
                if (object2 != null && object2 instanceof TableCellEditor) {
                    ((TableCellEditor)object2).addCellEditorListener(this);
                }
            }
        }

        public Accessible getAccessibleCaption() {
            return this.caption;
        }

        public Accessible getAccessibleSummary() {
            return this.summary;
        }

        public Accessible getAccessibleChild(int n2) {
            Serializable serializable;
            if (n2 < 0 || n2 >= this.getAccessibleChildrenCount()) {
                return null;
            }
            int n3 = this.getAccessibleColumnAtIndex(n2);
            int n4 = this.getAccessibleRowAtIndex(n2);
            TableColumn tableColumn = this.this$0.getColumnModel().getColumn(n3);
            TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
            if (tableCellRenderer == null) {
                serializable = this.this$0.getColumnClass(n3);
                tableCellRenderer = this.this$0.getDefaultRenderer((Class)serializable);
            }
            serializable = tableCellRenderer.getTableCellRendererComponent(this.this$0, null, false, false, n4, n3);
            return new AccessibleJTableCell(this, this.this$0, n4, n3, this.getAccessibleIndexAt(n4, n3));
        }

        public Accessible getAccessibleColumnDescription(int n2) {
            if (n2 < 0 || n2 >= this.getAccessibleColumnCount()) {
                throw new IllegalArgumentException(new Integer(n2).toString());
            }
            if (this.columnDescription == null) {
                return null;
            }
            return this.columnDescription[n2];
        }

        public Accessible getAccessibleRowDescription(int n2) {
            if (n2 < 0 || n2 >= this.getAccessibleRowCount()) {
                throw new IllegalArgumentException(new Integer(n2).toString());
            }
            if (this.rowDescription == null) {
                return null;
            }
            return this.rowDescription[n2];
        }

        public Accessible getAccessibleSelection(int n2) {
            if (n2 < 0 || n2 > this.getAccessibleSelectionCount()) {
                return null;
            }
            int n3 = this.this$0.getSelectedRowCount();
            int n4 = this.this$0.getSelectedColumnCount();
            int[] nArray = this.this$0.getSelectedRows();
            int[] nArray2 = this.this$0.getSelectedColumns();
            int n5 = this.this$0.getColumnCount();
            int n6 = this.this$0.getRowCount();
            if (this.this$0.cellSelectionEnabled) {
                int n7 = nArray[n2 / n4];
                int n8 = nArray2[n2 % n4];
                return this.getAccessibleChild(n7 * n5 + n8);
            }
            if (this.this$0.getRowSelectionAllowed() && this.this$0.getColumnSelectionAllowed()) {
                int n9 = n2;
                int n10 = nArray[0] == 0 ? 0 : 1;
                int n11 = 0;
                int n12 = -1;
                while (n11 < nArray.length) {
                    switch (n10) {
                        case 0: {
                            if (n9 < n5) {
                                int n13 = n9 % n5;
                                int n14 = nArray[n11];
                                return this.getAccessibleChild(n14 * n5 + n13);
                            }
                            n9 -= n5;
                            if (n11 + 1 == nArray.length || nArray[n11] != nArray[n11 + 1] - 1) {
                                n10 = 1;
                                n12 = nArray[n11];
                            }
                            ++n11;
                            break;
                        }
                        case 1: {
                            if (n9 < n4 * (nArray[n11] - (n12 == -1 ? 0 : n12 + 1))) {
                                int n15 = nArray2[n9 % n4];
                                int n16 = (n11 > 0 ? nArray[n11 - 1] + 1 : 0) + n9 / n4;
                                return this.getAccessibleChild(n16 * n5 + n15);
                            }
                            n9 -= n4 * (nArray[n11] - (n12 == -1 ? 0 : n12 + 1));
                            n10 = 0;
                        }
                    }
                }
                if (n9 < n4 * (n6 - (n12 == -1 ? 0 : n12 + 1))) {
                    int n17 = nArray2[n9 % n4];
                    int n18 = nArray[n11 - 1] + n9 / n4 + 1;
                    return this.getAccessibleChild(n18 * n5 + n17);
                }
            } else {
                if (this.this$0.getRowSelectionAllowed()) {
                    int n19 = n2 % n5;
                    int n20 = nArray[n2 / n5];
                    return this.getAccessibleChild(n20 * n5 + n19);
                }
                if (this.this$0.getColumnSelectionAllowed()) {
                    int n21 = nArray2[n2 % n4];
                    int n22 = n2 / n4;
                    return this.getAccessibleChild(n22 * n5 + n21);
                }
            }
            return null;
        }

        public Accessible getAccessibleAt(int n2, int n3) {
            return this.getAccessibleChild(n2 * this.getAccessibleColumnCount() + n3);
        }

        public void setAccessibleColumnDescription(int n2, Accessible accessible) {
            if (n2 < 0 || n2 >= this.getAccessibleColumnCount()) {
                throw new IllegalArgumentException(new Integer(n2).toString());
            }
            if (this.columnDescription == null) {
                int n3 = this.getAccessibleColumnCount();
                this.columnDescription = new Accessible[n3];
            }
            this.columnDescription[n2] = accessible;
        }

        public void setAccessibleRowDescription(int n2, Accessible accessible) {
            if (n2 < 0 || n2 >= this.getAccessibleRowCount()) {
                throw new IllegalArgumentException(new Integer(n2).toString());
            }
            if (this.rowDescription == null) {
                int n3 = this.getAccessibleRowCount();
                this.rowDescription = new Accessible[n3];
            }
            this.rowDescription[n2] = accessible;
        }

        public void setAccessibleCaption(Accessible accessible) {
            Accessible accessible2 = this.caption;
            this.caption = accessible;
            this.firePropertyChange("accessibleTableCaptionChanged", accessible2, this.caption);
        }

        public void setAccessibleSummary(Accessible accessible) {
            Accessible accessible2 = this.summary;
            this.summary = accessible;
            this.firePropertyChange("accessibleTableSummaryChanged", accessible2, this.summary);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TABLE;
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public AccessibleTable getAccessibleColumnHeader() {
            return new AccessibleTableHeader(this, this.this$0.getTableHeader());
        }

        public AccessibleTable getAccessibleRowHeader() {
            return null;
        }

        public AccessibleTable getAccessibleTable() {
            return this;
        }

        public void setAccessibleColumnHeader(AccessibleTable accessibleTable) {
        }

        public void setAccessibleRowHeader(AccessibleTable accessibleTable) {
        }

        AccessibleJTable(JTable jTable) {
            this.this$0 = jTable;
            super(jTable);
            jTable.addPropertyChangeListener(this);
            jTable.getSelectionModel().addListSelectionListener(this);
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            tableColumnModel.addColumnModelListener(this);
            tableColumnModel.getSelectionModel().addListSelectionListener(this);
            jTable.getModel().addTableModelListener(this);
            this.lastSelectedRow = jTable.getSelectedRow();
            this.lastSelectedCol = jTable.getSelectedColumn();
        }

        public void columnMarginChanged(ChangeEvent changeEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
        }

        public void editingCanceled(ChangeEvent changeEvent) {
        }

        public void editingStopped(ChangeEvent changeEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
        }

        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.firePropertyChange("AccessibleSelection", false, true);
            int n2 = this.this$0.getSelectedRow();
            int n3 = this.this$0.getSelectedColumn();
            if (n2 != this.lastSelectedRow || n3 != this.lastSelectedCol) {
                Accessible accessible = this.getAccessibleAt(this.lastSelectedRow, this.lastSelectedCol);
                Accessible accessible2 = this.getAccessibleAt(n2, n3);
                this.firePropertyChange("AccessibleActiveDescendant", accessible, accessible2);
                this.lastSelectedRow = n2;
                this.lastSelectedCol = n3;
            }
        }

        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
            int n2 = 1;
            AccessibleJTableModelChange accessibleJTableModelChange = new AccessibleJTableModelChange(this, n2, 0, 0, tableColumnModelEvent.getFromIndex(), tableColumnModelEvent.getToIndex());
            this.firePropertyChange("accessibleTableModelChanged", null, accessibleJTableModelChange);
        }

        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
            int n2 = -1;
            AccessibleJTableModelChange accessibleJTableModelChange = new AccessibleJTableModelChange(this, n2, 0, 0, tableColumnModelEvent.getFromIndex(), tableColumnModelEvent.getFromIndex());
            this.firePropertyChange("accessibleTableModelChanged", null, accessibleJTableModelChange);
            int n3 = 1;
            AccessibleJTableModelChange accessibleJTableModelChange2 = new AccessibleJTableModelChange(this, n3, 0, 0, tableColumnModelEvent.getToIndex(), tableColumnModelEvent.getToIndex());
            this.firePropertyChange("accessibleTableModelChanged", null, accessibleJTableModelChange2);
        }

        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
            int n2 = -1;
            AccessibleJTableModelChange accessibleJTableModelChange = new AccessibleJTableModelChange(this, n2, 0, 0, tableColumnModelEvent.getFromIndex(), tableColumnModelEvent.getToIndex());
            this.firePropertyChange("accessibleTableModelChanged", null, accessibleJTableModelChange);
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
            if (tableModelEvent != null) {
                int n2 = tableModelEvent.getColumn();
                int n3 = tableModelEvent.getColumn();
                if (n2 == -1) {
                    n2 = 0;
                    n3 = this.this$0.getColumnCount() - 1;
                }
                AccessibleJTableModelChange accessibleJTableModelChange = new AccessibleJTableModelChange(this, tableModelEvent.getType(), tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), n2, n3);
                this.firePropertyChange("accessibleTableModelChanged", null, accessibleJTableModelChange);
            }
        }

        public void tableRowsDeleted(TableModelEvent tableModelEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
            int n2 = tableModelEvent.getColumn();
            int n3 = tableModelEvent.getColumn();
            if (n2 == -1) {
                n2 = 0;
                n3 = this.this$0.getColumnCount() - 1;
            }
            AccessibleJTableModelChange accessibleJTableModelChange = new AccessibleJTableModelChange(this, tableModelEvent.getType(), tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), n2, n3);
            this.firePropertyChange("accessibleTableModelChanged", null, accessibleJTableModelChange);
        }

        public void tableRowsInserted(TableModelEvent tableModelEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
            int n2 = tableModelEvent.getColumn();
            int n3 = tableModelEvent.getColumn();
            if (n2 == -1) {
                n2 = 0;
                n3 = this.this$0.getColumnCount() - 1;
            }
            AccessibleJTableModelChange accessibleJTableModelChange = new AccessibleJTableModelChange(this, tableModelEvent.getType(), tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), n2, n3);
            this.firePropertyChange("accessibleTableModelChanged", null, accessibleJTableModelChange);
        }

        public Accessible getAccessibleAt(Point point) {
            int n2 = this.this$0.columnAtPoint(point);
            int n3 = this.this$0.rowAtPoint(point);
            if (n2 != -1 && n3 != -1) {
                Serializable serializable;
                TableColumn tableColumn = this.this$0.getColumnModel().getColumn(n2);
                TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
                if (tableCellRenderer == null) {
                    serializable = this.this$0.getColumnClass(n2);
                    tableCellRenderer = this.this$0.getDefaultRenderer((Class)serializable);
                }
                serializable = tableCellRenderer.getTableCellRendererComponent(this.this$0, null, false, false, n3, n2);
                return new AccessibleJTableCell(this, this.this$0, n3, n2, this.getAccessibleIndexAt(n3, n2));
            }
            return null;
        }

        static JTable access$000(AccessibleJTable accessibleJTable) {
            return accessibleJTable.this$0;
        }

        protected class AccessibleJTableCell
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent {
            private JTable parent;
            private int row;
            private int column;
            private int index;
            private final AccessibleJTable this$1;

            public int getAccessibleChildrenCount() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleChildrenCount();
                }
                return 0;
            }

            public int getAccessibleIndexInParent() {
                return this.index;
            }

            public void requestFocus() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).requestFocus();
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.requestFocus();
                    }
                }
            }

            public boolean isEnabled() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isEnabled();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isEnabled();
                }
                return false;
            }

            public boolean isFocusTraversable() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isFocusTraversable();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isFocusTraversable();
                }
                return false;
            }

            public boolean isShowing() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    if (accessibleContext.getAccessibleParent() != null) {
                        return ((AccessibleComponent)((Object)accessibleContext)).isShowing();
                    }
                    return this.isVisible();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isShowing();
                }
                return false;
            }

            public boolean isVisible() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isVisible();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isVisible();
                }
                return false;
            }

            public void setEnabled(boolean bl2) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setEnabled(bl2);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setEnabled(bl2);
                    }
                }
            }

            public void setVisible(boolean bl2) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setVisible(bl2);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setVisible(bl2);
                    }
                }
            }

            public Color getBackground() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getBackground();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getBackground();
                }
                return null;
            }

            public Color getForeground() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getForeground();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getForeground();
                }
                return null;
            }

            public void setBackground(Color color) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setBackground(color);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setBackground(color);
                    }
                }
            }

            public void setForeground(Color color) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setForeground(color);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setForeground(color);
                    }
                }
            }

            private Component getCurrentComponent() {
                TableColumn tableColumn = AccessibleJTable.access$000(this.this$1).getColumnModel().getColumn(this.column);
                TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
                if (tableCellRenderer == null) {
                    Class clazz = AccessibleJTable.access$000(this.this$1).getColumnClass(this.column);
                    tableCellRenderer = AccessibleJTable.access$000(this.this$1).getDefaultRenderer(clazz);
                }
                return tableCellRenderer.getTableCellRendererComponent(AccessibleJTable.access$000(this.this$1), null, false, false, this.row, this.column);
            }

            public Cursor getCursor() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getCursor();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getCursor();
                }
                Accessible accessible = this.getAccessibleParent();
                if (accessible instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessible)).getCursor();
                }
                return null;
            }

            public void setCursor(Cursor cursor) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setCursor(cursor);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setCursor(cursor);
                    }
                }
            }

            public Dimension getSize() {
                Rectangle rectangle;
                if (this.parent != null && (rectangle = this.parent.getCellRect(this.row, this.column, false)) != null) {
                    return rectangle.getSize();
                }
                return null;
            }

            public void setSize(Dimension dimension) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setSize(dimension);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setSize(dimension);
                    }
                }
            }

            public Font getFont() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getFont();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getFont();
                }
                return null;
            }

            public void setFont(Font font) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setFont(font);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setFont(font);
                    }
                }
            }

            public Point getLocation() {
                Rectangle rectangle;
                if (this.parent != null && (rectangle = this.parent.getCellRect(this.row, this.column, false)) != null) {
                    return rectangle.getLocation();
                }
                return null;
            }

            public Point getLocationOnScreen() {
                if (this.parent != null) {
                    Point point = this.parent.getLocationOnScreen();
                    Point point2 = this.getLocation();
                    point2.translate(point.x, point.y);
                    return point2;
                }
                return null;
            }

            public void setLocation(Point point) {
            }

            public boolean contains(Point point) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    Rectangle rectangle = ((AccessibleComponent)((Object)accessibleContext)).getBounds();
                    return rectangle.contains(point);
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    Rectangle rectangle = component.getBounds();
                    return rectangle.contains(point);
                }
                return this.getBounds().contains(point);
            }

            public Rectangle getBounds() {
                if (this.parent != null) {
                    return this.parent.getCellRect(this.row, this.column, false);
                }
                return null;
            }

            public void setBounds(Rectangle rectangle) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setBounds(rectangle);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setBounds(rectangle);
                    }
                }
            }

            public void addFocusListener(FocusListener focusListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).addFocusListener(focusListener);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.addFocusListener(focusListener);
                    }
                }
            }

            public void removeFocusListener(FocusListener focusListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).removeFocusListener(focusListener);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.removeFocusListener(focusListener);
                    }
                }
            }

            public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.addPropertyChangeListener(propertyChangeListener);
                } else {
                    super.addPropertyChangeListener(propertyChangeListener);
                }
            }

            public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.removePropertyChangeListener(propertyChangeListener);
                } else {
                    super.removePropertyChangeListener(propertyChangeListener);
                }
            }

            public String getAccessibleDescription() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleDescription();
                }
                return super.getAccessibleDescription();
            }

            public String getAccessibleName() {
                String string;
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null && (string = accessibleContext.getAccessibleName()) != null && string != "") {
                    return accessibleContext.getAccessibleName();
                }
                if (this.accessibleName != null && this.accessibleName != "") {
                    return this.accessibleName;
                }
                return null;
            }

            public void setAccessibleDescription(String string) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleDescription(string);
                } else {
                    super.setAccessibleDescription(string);
                }
            }

            public void setAccessibleName(String string) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleName(string);
                } else {
                    super.setAccessibleName(string);
                }
            }

            public Locale getLocale() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getLocale();
                }
                return null;
            }

            public Accessible getAccessibleParent() {
                return this.parent;
            }

            public Accessible getAccessibleChild(int n2) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    Accessible accessible = accessibleContext.getAccessibleChild(n2);
                    accessibleContext.setAccessibleParent(this);
                    return accessible;
                }
                return null;
            }

            public AccessibleAction getAccessibleAction() {
                return this.getCurrentAccessibleContext().getAccessibleAction();
            }

            public AccessibleComponent getAccessibleComponent() {
                return this;
            }

            public AccessibleContext getAccessibleContext() {
                return this;
            }

            private AccessibleContext getCurrentAccessibleContext() {
                Serializable serializable;
                TableColumn tableColumn = AccessibleJTable.access$000(this.this$1).getColumnModel().getColumn(this.column);
                TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
                if (tableCellRenderer == null) {
                    serializable = AccessibleJTable.access$000(this.this$1).getColumnClass(this.column);
                    tableCellRenderer = AccessibleJTable.access$000(this.this$1).getDefaultRenderer((Class)serializable);
                }
                if ((serializable = tableCellRenderer.getTableCellRendererComponent(AccessibleJTable.access$000(this.this$1), AccessibleJTable.access$000(this.this$1).getValueAt(this.row, this.column), false, false, this.row, this.column)) instanceof Accessible) {
                    return ((Accessible)((Object)serializable)).getAccessibleContext();
                }
                return null;
            }

            public AccessibleRole getAccessibleRole() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleRole();
                }
                return AccessibleRole.UNKNOWN;
            }

            public AccessibleSelection getAccessibleSelection() {
                return this.getCurrentAccessibleContext().getAccessibleSelection();
            }

            public AccessibleStateSet getAccessibleStateSet() {
                Rectangle rectangle;
                Rectangle rectangle2;
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                AccessibleStateSet accessibleStateSet = null;
                if (accessibleContext != null) {
                    accessibleStateSet = accessibleContext.getAccessibleStateSet();
                }
                if (accessibleStateSet == null) {
                    accessibleStateSet = new AccessibleStateSet();
                }
                if ((rectangle2 = AccessibleJTable.access$000(this.this$1).getVisibleRect()).intersects(rectangle = AccessibleJTable.access$000(this.this$1).getCellRect(this.row, this.column, false))) {
                    accessibleStateSet.add(AccessibleState.SHOWING);
                } else if (accessibleStateSet.contains(AccessibleState.SHOWING)) {
                    accessibleStateSet.remove(AccessibleState.SHOWING);
                }
                if (this.parent.isCellSelected(this.row, this.column)) {
                    accessibleStateSet.add(AccessibleState.SELECTED);
                } else if (accessibleStateSet.contains(AccessibleState.SELECTED)) {
                    accessibleStateSet.remove(AccessibleState.SELECTED);
                }
                if (this.row == AccessibleJTable.access$000(this.this$1).getSelectedRow() && this.column == AccessibleJTable.access$000(this.this$1).getSelectedColumn()) {
                    accessibleStateSet.add(AccessibleState.ACTIVE);
                }
                accessibleStateSet.add(AccessibleState.TRANSIENT);
                return accessibleStateSet;
            }

            public AccessibleText getAccessibleText() {
                return this.getCurrentAccessibleContext().getAccessibleText();
            }

            public AccessibleValue getAccessibleValue() {
                return this.getCurrentAccessibleContext().getAccessibleValue();
            }

            public FontMetrics getFontMetrics(Font font) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getFontMetrics(font);
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getFontMetrics(font);
                }
                return null;
            }

            public Accessible getAccessibleAt(Point point) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getAccessibleAt(point);
                }
                return null;
            }

            public AccessibleJTableCell(AccessibleJTable accessibleJTable, JTable jTable, int n2, int n3, int n4) {
                this.this$1 = accessibleJTable;
                this.parent = jTable;
                this.row = n2;
                this.column = n3;
                this.index = n4;
                this.setAccessibleParent(this.parent);
            }
        }

        protected class AccessibleJTableModelChange
        implements AccessibleTableModelChange {
            protected int type;
            protected int firstRow;
            protected int lastRow;
            protected int firstColumn;
            protected int lastColumn;
            private final AccessibleJTable this$1;

            public int getFirstColumn() {
                return this.firstColumn;
            }

            public int getFirstRow() {
                return this.firstRow;
            }

            public int getLastColumn() {
                return this.lastColumn;
            }

            public int getLastRow() {
                return this.lastRow;
            }

            public int getType() {
                return this.type;
            }

            protected AccessibleJTableModelChange(AccessibleJTable accessibleJTable, int n2, int n3, int n4, int n5, int n6) {
                this.this$1 = accessibleJTable;
                this.type = n2;
                this.firstRow = n3;
                this.lastRow = n4;
                this.firstColumn = n5;
                this.lastColumn = n6;
            }
        }

        private class AccessibleTableHeader
        implements AccessibleTable {
            private JTableHeader header;
            private TableColumnModel headerModel;
            private final AccessibleJTable this$1;

            public int getAccessibleColumnCount() {
                return this.headerModel.getColumnCount();
            }

            public int getAccessibleRowCount() {
                return 1;
            }

            public int[] getSelectedAccessibleColumns() {
                return new int[0];
            }

            public int[] getSelectedAccessibleRows() {
                return new int[0];
            }

            public boolean isAccessibleColumnSelected(int n2) {
                return false;
            }

            public boolean isAccessibleRowSelected(int n2) {
                return false;
            }

            public int getAccessibleColumnExtentAt(int n2, int n3) {
                return 1;
            }

            public int getAccessibleRowExtentAt(int n2, int n3) {
                return 1;
            }

            public boolean isAccessibleSelected(int n2, int n3) {
                return false;
            }

            public Accessible getAccessibleCaption() {
                return null;
            }

            public Accessible getAccessibleSummary() {
                return null;
            }

            public Accessible getAccessibleColumnDescription(int n2) {
                return null;
            }

            public Accessible getAccessibleRowDescription(int n2) {
                return null;
            }

            public Accessible getAccessibleAt(int n2, int n3) {
                Component component;
                TableColumn tableColumn = this.headerModel.getColumn(n3);
                TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
                if (tableCellRenderer == null) {
                    tableCellRenderer = this.header.getDefaultRenderer();
                }
                if ((component = tableCellRenderer.getTableCellRendererComponent(this.header.getTable(), tableColumn.getHeaderValue(), false, false, -1, n3)) instanceof Accessible) {
                    return (Accessible)((Object)component);
                }
                return null;
            }

            public void setAccessibleColumnDescription(int n2, Accessible accessible) {
            }

            public void setAccessibleRowDescription(int n2, Accessible accessible) {
            }

            public void setAccessibleCaption(Accessible accessible) {
            }

            public void setAccessibleSummary(Accessible accessible) {
            }

            public AccessibleTable getAccessibleColumnHeader() {
                return null;
            }

            public AccessibleTable getAccessibleRowHeader() {
                return null;
            }

            public void setAccessibleColumnHeader(AccessibleTable accessibleTable) {
            }

            public void setAccessibleRowHeader(AccessibleTable accessibleTable) {
            }

            AccessibleTableHeader(AccessibleJTable accessibleJTable, JTableHeader jTableHeader) {
                this.this$1 = accessibleJTable;
                this.header = jTableHeader;
                this.headerModel = jTableHeader.getColumnModel();
            }
        }
    }

    static class BooleanEditor
    extends DefaultCellEditor {
        public BooleanEditor() {
            super(new JCheckBox());
            JCheckBox jCheckBox = (JCheckBox)this.getComponent();
            jCheckBox.setHorizontalAlignment(0);
        }
    }

    static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public BooleanRenderer() {
            this.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
            if (bl2) {
                this.setForeground(jTable.getSelectionForeground());
                super.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            this.setSelected(object != null && (Boolean)object != false);
            return this;
        }
    }

    class CellEditorRemover
    implements PropertyChangeListener {
        KeyboardFocusManager focusManager;
        private final JTable this$0;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!this.this$0.isEditing() || this.this$0.getClientProperty("terminateEditOnFocusLost") != Boolean.TRUE) {
                return;
            }
            for (Component component = this.focusManager.getPermanentFocusOwner(); component != null; component = component.getParent()) {
                if (component == this.this$0) {
                    return;
                }
                if (!(component instanceof Window) && (!(component instanceof Applet) || component.getParent() != null)) continue;
                if (component != SwingUtilities.getRoot(this.this$0) || this.this$0.getCellEditor().stopCellEditing()) break;
                this.this$0.getCellEditor().cancelCellEditing();
                break;
            }
        }

        public CellEditorRemover(JTable jTable, KeyboardFocusManager keyboardFocusManager) {
            this.this$0 = jTable;
            this.focusManager = keyboardFocusManager;
        }
    }

    static class DateRenderer
    extends DefaultTableCellRenderer {
        DateFormat formatter;

        public void setValue(Object object) {
            if (this.formatter == null) {
                this.formatter = DateFormat.getDateInstance();
            }
            this.setText(object == null ? "" : this.formatter.format(object));
        }
    }

    static class DoubleRenderer
    extends NumberRenderer {
        NumberFormat formatter;

        public void setValue(Object object) {
            if (this.formatter == null) {
                this.formatter = NumberFormat.getInstance();
            }
            this.setText(object == null ? "" : this.formatter.format(object));
        }
    }

    static class GenericEditor
    extends DefaultCellEditor {
        Class[] argTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = JTable.class$("java.lang.String")) : class$java$lang$String};
        Constructor constructor;
        Object value;

        public GenericEditor() {
            super(new JTextField());
        }

        public boolean stopCellEditing() {
            String string = (String)super.getCellEditorValue();
            if ("".equals(string)) {
                if (this.constructor.getDeclaringClass() == (class$java$lang$String == null ? (class$java$lang$String = JTable.class$("java.lang.String")) : class$java$lang$String)) {
                    this.value = string;
                }
                super.stopCellEditing();
            }
            try {
                this.value = this.constructor.newInstance(new Object[]{string});
            }
            catch (Exception exception) {
                ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
                return false;
            }
            return super.stopCellEditing();
        }

        public Object getCellEditorValue() {
            return this.value;
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl2, int n2, int n3) {
            this.value = null;
            ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.black));
            try {
                Class clazz = jTable.getColumnClass(n3);
                if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = JTable.class$("java.lang.Object")) : class$java$lang$Object)) {
                    clazz = class$java$lang$String == null ? (class$java$lang$String = JTable.class$("java.lang.String")) : class$java$lang$String;
                }
                this.constructor = clazz.getConstructor(this.argTypes);
            }
            catch (Exception exception) {
                return null;
            }
            return super.getTableCellEditorComponent(jTable, object, bl2, n2, n3);
        }
    }

    static class IconRenderer
    extends DefaultTableCellRenderer {
        public IconRenderer() {
            this.setHorizontalAlignment(0);
        }

        public void setValue(Object object) {
            this.setIcon(object instanceof Icon ? (Icon)object : null);
        }
    }

    static class NumberEditor
    extends GenericEditor {
        public NumberEditor() {
            ((JTextField)this.getComponent()).setHorizontalAlignment(4);
        }
    }

    static class NumberRenderer
    extends DefaultTableCellRenderer {
        public NumberRenderer() {
            this.setHorizontalAlignment(4);
        }
    }

    private static interface Resizable2 {
        public int getElementCount();

        public int getLowerBoundAt(int var1);

        public int getUpperBoundAt(int var1);

        public void setSizeAt(int var1, int var2);
    }

    private static interface Resizable3
    extends Resizable2 {
        public int getMidPointAt(int var1);
    }
}

