/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth;

import com.sun.security.auth.PolicyFile;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.Security;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import javax.security.auth.AuthPermission;
import javax.security.auth.Policy;
import javax.security.auth.Subject;
import sun.security.util.Debug;

public class SubjectDomainCombiner
implements DomainCombiner {
    private Subject subject;
    private WeakKeyValueMap cachedPDs = new WeakKeyValueMap(null);
    private Set principalSet;
    private Principal[] principals;
    private static boolean checkedCacheProperty = false;
    private static boolean allowCaching = true;
    private static final Debug debug = Debug.getInstance("combiner", "\t[SubjectDomainCombiner]");

    static boolean access$200() {
        return allowCaching;
    }

    private boolean cachePolicy() {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(this){
            private final SubjectDomainCombiner this$0;

            public Object run() {
                return Security.getProperty("cache.auth.policy");
            }
            {
                this.this$0 = subjectDomainCombiner;
            }
        });
        if (string != null) {
            Boolean bl2 = new Boolean(string);
            return bl2;
        }
        return true;
    }

    public Subject getSubject() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("getSubjectFromDomainCombiner"));
        }
        return this.subject;
    }

    public SubjectDomainCombiner(Subject subject) {
        this.subject = subject;
        if (subject.isReadOnly()) {
            this.principalSet = subject.getPrincipals();
            this.principals = (Principal[])this.principalSet.toArray(new Principal[this.principalSet.size()]);
        }
        if (!checkedCacheProperty) {
            allowCaching = this.cachePolicy();
            checkedCacheProperty = true;
        }
    }

    static Debug access$100() {
        return debug;
    }

    private String printDomain(ProtectionDomain protectionDomain) {
        if (protectionDomain == null) {
            return "null";
        }
        return (String)AccessController.doPrivileged(new PrivilegedAction(this, protectionDomain){
            private final ProtectionDomain val$pd;
            private final SubjectDomainCombiner this$0;

            public Object run() {
                return this.val$pd.toString();
            }
            {
                this.this$0 = subjectDomainCombiner;
                this.val$pd = protectionDomain;
            }
        });
    }

    private void printInputDomains(ProtectionDomain[] protectionDomainArray, ProtectionDomain[] protectionDomainArray2) {
        int n2;
        if (protectionDomainArray == null || protectionDomainArray.length == 0) {
            debug.println("currentDomains null or 0 length");
        } else {
            for (n2 = 0; protectionDomainArray != null && n2 < protectionDomainArray.length; ++n2) {
                if (protectionDomainArray[n2] == null) {
                    debug.println("currentDomain " + n2 + ": SystemDomain");
                    continue;
                }
                debug.println("currentDomain " + n2 + ": " + this.printDomain(protectionDomainArray[n2]));
            }
        }
        if (protectionDomainArray2 == null || protectionDomainArray2.length == 0) {
            debug.println("assignedDomains null or 0 length");
        } else {
            debug.println("assignedDomains = ");
            for (n2 = 0; protectionDomainArray2 != null && n2 < protectionDomainArray2.length; ++n2) {
                if (protectionDomainArray2[n2] == null) {
                    debug.println("assignedDomain " + n2 + ": SystemDomain");
                    continue;
                }
                debug.println("assignedDomain " + n2 + ": " + this.printDomain(protectionDomainArray2[n2]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtectionDomain[] combine(ProtectionDomain[] protectionDomainArray, ProtectionDomain[] protectionDomainArray2) {
        Object object;
        if (protectionDomainArray == null || protectionDomainArray.length == 0) {
            return this.optimize(protectionDomainArray2, null);
        }
        if (debug != null) {
            if (this.subject == null) {
                debug.println("null subject");
            } else {
                object = this.subject;
                AccessController.doPrivileged(new PrivilegedAction(this, (Subject)object){
                    private final Subject val$s;
                    private final SubjectDomainCombiner this$0;

                    public Object run() {
                        SubjectDomainCombiner.access$100().println(this.val$s.toString());
                        return null;
                    }
                    {
                        this.this$0 = subjectDomainCombiner;
                        this.val$s = subject;
                    }
                });
            }
            this.printInputDomains(protectionDomainArray, protectionDomainArray2);
        }
        protectionDomainArray2 = this.optimize(protectionDomainArray2, null);
        protectionDomainArray = this.optimize(protectionDomainArray, protectionDomainArray2);
        if (debug != null) {
            debug.println("after optimize");
            this.printInputDomains(protectionDomainArray, protectionDomainArray2);
        }
        if (protectionDomainArray == null && protectionDomainArray2 == null) {
            return null;
        }
        object = (Policy)AccessController.doPrivileged(new PrivilegedAction(this){
            private final SubjectDomainCombiner this$0;

            public Object run() {
                return Policy.getPolicy();
            }
            {
                this.this$0 = subjectDomainCombiner;
            }
        });
        if (!(object instanceof PolicyFile)) {
            if (debug != null) {
                debug.println("Providing backwards compatibility for javax.security.auth.policy implementation: " + object.toString());
            }
            return this.combineJavaxPolicy(protectionDomainArray, protectionDomainArray2);
        }
        int n2 = protectionDomainArray == null ? 0 : protectionDomainArray.length;
        int n3 = protectionDomainArray2 == null ? 0 : protectionDomainArray2.length;
        ProtectionDomain[] protectionDomainArray3 = new ProtectionDomain[n2 + n3];
        WeakKeyValueMap weakKeyValueMap = this.cachedPDs;
        synchronized (weakKeyValueMap) {
            if (!this.subject.isReadOnly() && !((Object)this.subject.getPrincipals()).equals(this.principalSet)) {
                this.principalSet = new HashSet(this.subject.getPrincipals());
                this.principals = (Principal[])this.principalSet.toArray(new Principal[this.principalSet.size()]);
                this.cachedPDs.clear();
                if (debug != null) {
                    debug.println("Subject mutated - clearing cache");
                }
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                ProtectionDomain protectionDomain = protectionDomainArray[i2];
                ProtectionDomain protectionDomain2 = (ProtectionDomain)this.cachedPDs.getValue(protectionDomain);
                if (protectionDomain2 == null) {
                    protectionDomain2 = new ProtectionDomain(protectionDomain.getCodeSource(), protectionDomain.getPermissions(), protectionDomain.getClassLoader(), this.principals);
                    this.cachedPDs.putValue(protectionDomain, protectionDomain2);
                }
                protectionDomainArray3[i2] = protectionDomain2;
            }
        }
        if (debug != null) {
            debug.println("updated current: ");
            for (int i3 = 0; i3 < n2; ++i3) {
                debug.println("\tupdated[" + i3 + "] = " + this.printDomain(protectionDomainArray3[i3]));
            }
        }
        if (n3 > 0) {
            System.arraycopy(protectionDomainArray2, 0, protectionDomainArray3, n2, n3);
        }
        protectionDomainArray3 = this.optimize(protectionDomainArray3, null);
        if (debug != null) {
            if (protectionDomainArray3 == null || protectionDomainArray3.length == 0) {
                debug.println("returning null");
            } else {
                debug.println("combinedDomains: ");
                for (int i4 = 0; i4 < protectionDomainArray3.length; ++i4) {
                    debug.println("newDomain " + i4 + ": " + this.printDomain(protectionDomainArray3[i4]));
                }
            }
        }
        if (protectionDomainArray3 == null || protectionDomainArray3.length == 0) {
            return null;
        }
        return protectionDomainArray3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ProtectionDomain[] combineJavaxPolicy(ProtectionDomain[] protectionDomainArray, ProtectionDomain[] protectionDomainArray2) {
        AccessController.doPrivileged(new PrivilegedAction(this){
            private final SubjectDomainCombiner this$0;

            public Object run() {
                if (!SubjectDomainCombiner.access$200()) {
                    Policy.getPolicy().refresh();
                }
                return null;
            }
            {
                this.this$0 = subjectDomainCombiner;
            }
        });
        int n2 = protectionDomainArray == null ? 0 : protectionDomainArray.length;
        int n3 = protectionDomainArray2 == null ? 0 : protectionDomainArray2.length;
        ProtectionDomain[] protectionDomainArray3 = new ProtectionDomain[n2 + n3];
        boolean bl2 = false;
        WeakKeyValueMap weakKeyValueMap = this.cachedPDs;
        synchronized (weakKeyValueMap) {
            if (!this.subject.isReadOnly() && !((Object)this.subject.getPrincipals()).equals(this.principalSet)) {
                this.principalSet = new HashSet(this.subject.getPrincipals());
                this.principals = (Principal[])this.principalSet.toArray(new Principal[this.principalSet.size()]);
                this.cachedPDs.clear();
                if (debug != null) {
                    debug.println("Subject mutated - clearing cache");
                }
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                ProtectionDomain protectionDomain = protectionDomainArray[i2];
                ProtectionDomain protectionDomain2 = (ProtectionDomain)this.cachedPDs.getValue(protectionDomain);
                if (protectionDomain2 == null) {
                    Serializable serializable;
                    Enumeration enumeration;
                    PermissionCollection permissionCollection;
                    Permissions permissions = new Permissions();
                    PermissionCollection permissionCollection2 = protectionDomain.getPermissions();
                    if (permissionCollection2 != null) {
                        permissionCollection = permissionCollection2;
                        synchronized (permissionCollection) {
                            enumeration = permissionCollection2.elements();
                            while (enumeration.hasMoreElements()) {
                                serializable = (Permission)enumeration.nextElement();
                                permissions.add((Permission)serializable);
                            }
                        }
                    }
                    permissionCollection = null;
                    serializable = protectionDomainArray[i2].getCodeSource();
                    Subject subject = this.subject;
                    permissionCollection = (PermissionCollection)AccessController.doPrivileged(new PrivilegedAction(this, subject, (CodeSource)serializable){
                        private final Subject val$finalS;
                        private final CodeSource val$finalCs;
                        private final SubjectDomainCombiner this$0;

                        public Object run() {
                            return Policy.getPolicy().getPermissions(this.val$finalS, this.val$finalCs);
                        }
                        {
                            this.this$0 = subjectDomainCombiner;
                            this.val$finalS = subject;
                            this.val$finalCs = codeSource;
                        }
                    });
                    enumeration = permissionCollection.elements();
                    while (enumeration.hasMoreElements()) {
                        Permission permission = (Permission)enumeration.nextElement();
                        if (permissions.implies(permission)) continue;
                        permissions.add(permission);
                        if (debug == null) continue;
                        debug.println("Adding perm " + permission + "\n");
                    }
                    protectionDomain2 = new ProtectionDomain((CodeSource)serializable, permissions, protectionDomain.getClassLoader(), this.principals);
                    if (allowCaching) {
                        this.cachedPDs.putValue(protectionDomain, protectionDomain2);
                    }
                }
                protectionDomainArray3[i2] = protectionDomain2;
            }
        }
        if (debug != null) {
            debug.println("updated current: ");
            for (int i3 = 0; i3 < n2; ++i3) {
                debug.println("\tupdated[" + i3 + "] = " + protectionDomainArray3[i3]);
            }
        }
        if (n3 > 0) {
            System.arraycopy(protectionDomainArray2, 0, protectionDomainArray3, n2, n3);
        }
        if (debug != null) {
            if (protectionDomainArray3 == null || protectionDomainArray3.length == 0) {
                debug.println("returning null");
            } else {
                debug.println("combinedDomains: ");
                for (int i4 = 0; i4 < protectionDomainArray3.length; ++i4) {
                    debug.println("newDomain " + i4 + ": " + protectionDomainArray3[i4].toString());
                }
            }
        }
        if (protectionDomainArray3 == null || protectionDomainArray3.length == 0) {
            return null;
        }
        return protectionDomainArray3;
    }

    ProtectionDomain[] optimize(ProtectionDomain[] protectionDomainArray, ProtectionDomain[] protectionDomainArray2) {
        if (protectionDomainArray == null) {
            return null;
        }
        ProtectionDomain[] protectionDomainArray3 = new ProtectionDomain[protectionDomainArray.length];
        int n2 = 0;
        for (int i2 = 0; i2 < protectionDomainArray.length; ++i2) {
            int n3;
            if (protectionDomainArray[i2] == null) continue;
            boolean bl2 = false;
            for (n3 = 0; n3 < n2; ++n3) {
                if (protectionDomainArray3[n3] != protectionDomainArray[i2]) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            if (protectionDomainArray2 == null) {
                protectionDomainArray3[n2++] = protectionDomainArray[i2];
                continue;
            }
            n3 = 0;
            for (int i3 = 0; i3 < protectionDomainArray2.length; ++i3) {
                if (protectionDomainArray2[i3] != protectionDomainArray[i2]) continue;
                n3 = 1;
                break;
            }
            if (n3 != 0) continue;
            protectionDomainArray3[n2++] = protectionDomainArray[i2];
        }
        if (n2 < protectionDomainArray.length) {
            ProtectionDomain[] protectionDomainArray4 = new ProtectionDomain[n2];
            System.arraycopy(protectionDomainArray3, 0, protectionDomainArray4, 0, protectionDomainArray4.length);
            protectionDomainArray3 = protectionDomainArray4;
        }
        return protectionDomainArray3.length == 0 ? null : protectionDomainArray3;
    }

    private static class WeakKeyValueMap
    extends WeakHashMap {
        private WeakKeyValueMap() {
        }

        WeakKeyValueMap(1 var1_1) {
            this();
        }

        public Object getValue(Object object) {
            WeakReference weakReference = (WeakReference)super.get(object);
            if (weakReference != null) {
                return weakReference.get();
            }
            return null;
        }

        public Object putValue(Object object, Object object2) {
            WeakReference weakReference = (WeakReference)super.put(object, new WeakReference(object2));
            if (weakReference != null) {
                return weakReference.get();
            }
            return null;
        }
    }
}

