/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.GlyphMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class GlyphVector
implements Cloneable {
    public static final int FLAG_HAS_TRANSFORMS = 1;
    public static final int FLAG_HAS_POSITION_ADJUSTMENTS = 2;
    public static final int FLAG_RUN_RTL = 4;
    public static final int FLAG_COMPLEX_GLYPHS = 8;
    public static final int FLAG_MASK = 15;

    public int getLayoutFlags() {
        return 0;
    }

    public abstract int getNumGlyphs();

    public abstract void performDefaultLayout();

    public int getGlyphCharIndex(int n2) {
        return n2;
    }

    public abstract int getGlyphCode(int var1);

    public abstract float[] getGlyphPositions(int var1, int var2, float[] var3);

    public int[] getGlyphCharIndices(int n2, int n3, int[] nArray) {
        if (nArray == null) {
            nArray = new int[n3];
        }
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            nArray[n4] = this.getGlyphCharIndex(n5);
            ++n4;
            ++n5;
        }
        return nArray;
    }

    public abstract int[] getGlyphCodes(int var1, int var2, int[] var3);

    public abstract Font getFont();

    public abstract Shape getOutline();

    public abstract Shape getOutline(float var1, float var2);

    public abstract Shape getGlyphLogicalBounds(int var1);

    public abstract Shape getGlyphOutline(int var1);

    public abstract Shape getGlyphVisualBounds(int var1);

    public Shape getGlyphOutline(int n2, float f2, float f3) {
        Shape shape = this.getGlyphOutline(n2);
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(f2, f3);
        return affineTransform.createTransformedShape(shape);
    }

    public abstract FontRenderContext getFontRenderContext();

    public abstract GlyphJustificationInfo getGlyphJustificationInfo(int var1);

    public abstract GlyphMetrics getGlyphMetrics(int var1);

    public abstract boolean equals(GlyphVector var1);

    public abstract AffineTransform getGlyphTransform(int var1);

    public abstract void setGlyphTransform(int var1, AffineTransform var2);

    public abstract Point2D getGlyphPosition(int var1);

    public abstract void setGlyphPosition(int var1, Point2D var2);

    public abstract Rectangle2D getLogicalBounds();

    public abstract Rectangle2D getVisualBounds();

    public Rectangle getGlyphPixelBounds(int n2, FontRenderContext fontRenderContext, float f2, float f3) {
        Rectangle2D rectangle2D = this.getGlyphVisualBounds(n2).getBounds2D();
        int n3 = (int)Math.floor(rectangle2D.getX() + (double)f2);
        int n4 = (int)Math.floor(rectangle2D.getY() + (double)f3);
        int n5 = (int)Math.ceil(rectangle2D.getMaxX() + (double)f2);
        int n6 = (int)Math.ceil(rectangle2D.getMaxY() + (double)f3);
        return new Rectangle(n3, n4, n5 - n3, n6 - n4);
    }

    public Rectangle getPixelBounds(FontRenderContext fontRenderContext, float f2, float f3) {
        Rectangle2D rectangle2D = this.getVisualBounds();
        int n2 = (int)Math.floor(rectangle2D.getX() + (double)f2);
        int n3 = (int)Math.floor(rectangle2D.getY() + (double)f3);
        int n4 = (int)Math.ceil(rectangle2D.getMaxX() + (double)f2);
        int n5 = (int)Math.ceil(rectangle2D.getMaxY() + (double)f3);
        return new Rectangle(n2, n3, n4 - n2, n5 - n3);
    }
}

