/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.security.AccessController;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.ext.DelegatableDecoder;
import sun.nio.cs.ext.EUC_JP;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.ISO2022_JP;
import sun.nio.cs.ext.SJIS;
import sun.security.action.GetPropertyAction;

public class JISAutoDetect
extends Charset
implements HistoricallyNamedCharset {
    private static final int EUCJP_MASK = 1;
    private static final int SJIS2B_MASK = 2;
    private static final int SJIS1B_MASK = 4;
    private static final int EUCJP_KANA1_MASK = 8;
    private static final int EUCJP_KANA2_MASK = 16;

    public JISAutoDetect() {
        super("x-JISAutoDetect", ExtendedCharsets.aliasesFor("x-JISAutoDetect"));
    }

    public boolean canEncode() {
        return false;
    }

    public byte[] getByteMask1() {
        return Decoder.access$000();
    }

    public byte[] getByteMask2() {
        return Decoder.access$100();
    }

    public static final boolean canBeEUCJP(int n) {
        return (n & 1) != 0;
    }

    public static final boolean canBeSJIS1B(int n) {
        return (n & 4) != 0;
    }

    public static final boolean canBeEUCKana(int n, int n2) {
        return (n & 8) != 0 && (n2 & 0x10) != 0;
    }

    public String historicalName() {
        return "JISAutoDetect";
    }

    static boolean access$200(CharBuffer charBuffer) {
        return JISAutoDetect.looksLikeJapanese(charBuffer);
    }

    private static boolean looksLikeJapanese(CharBuffer charBuffer) {
        int n = 0;
        int n2 = 0;
        while (charBuffer.hasRemaining()) {
            char c = charBuffer.get();
            if ('\u3040' <= c && c <= '\u309f' && ++n > 1) {
                return true;
            }
            if ('\uff65' > c || c > '\uff9f' || ++n2 <= 1) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Charset charset) {
        return charset.name().equals("US-ASCII") || charset instanceof SJIS || charset instanceof EUC_JP || charset instanceof ISO2022_JP;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        throw new UnsupportedOperationException();
    }

    private static class Decoder
    extends CharsetDecoder {
        private static final String SJISName = Decoder.getSJISName();
        private static final String EUCJPName = Decoder.getEUCJPName();
        private DelegatableDecoder detectedDecoder = null;
        private static final byte[] maskTable1 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 5, 5, 5, 13, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 0};
        private static final byte[] maskTable2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 0};

        protected void implReset() {
            this.detectedDecoder = null;
        }

        public boolean isAutoDetecting() {
            return true;
        }

        public boolean isCharsetDetected() {
            return this.detectedDecoder != null;
        }

        static byte[] access$000() {
            return maskTable1;
        }

        static byte[] access$100() {
            return maskTable2;
        }

        private static boolean isPlainASCII(byte by) {
            return by >= 0 && by != 27;
        }

        private static String getEUCJPName() {
            GetPropertyAction getPropertyAction = new GetPropertyAction("os.name");
            String string = AccessController.doPrivileged(getPropertyAction);
            if (string.equals("Solaris") || string.equals("SunOS")) {
                return "x-eucjp-open";
            }
            return "EUC_JP";
        }

        private static String getSJISName() {
            GetPropertyAction getPropertyAction = new GetPropertyAction("os.name");
            String string = AccessController.doPrivileged(getPropertyAction);
            if (string.equals("Solaris") || string.equals("SunOS")) {
                return "PCK";
            }
            if (string.startsWith("Windows")) {
                return "windows-31J";
            }
            return "Shift_JIS";
        }

        public Charset detectedCharset() {
            if (this.detectedDecoder == null) {
                throw new IllegalStateException("charset not yet detected");
            }
            return ((CharsetDecoder)((Object)this.detectedDecoder)).charset();
        }

        public Decoder(Charset charset) {
            super(charset, 0.5f, 1.0f);
        }

        private static void copyLeadingASCII(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            byte by;
            int n;
            int n2 = byteBuffer.position();
            int n3 = n2 + Math.min(byteBuffer.remaining(), charBuffer.remaining());
            for (n = n2; n < n3 && Decoder.isPlainASCII(by = byteBuffer.get(n)); ++n) {
                charBuffer.put((char)(by & 0xFF));
            }
            byteBuffer.position(n);
        }

        protected CoderResult implFlush(CharBuffer charBuffer) {
            if (this.detectedDecoder != null) {
                return this.detectedDecoder.implFlush(charBuffer);
            }
            return super.implFlush(charBuffer);
        }

        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            if (this.detectedDecoder == null) {
                CharBuffer charBuffer2;
                ByteBuffer byteBuffer2;
                ByteBuffer byteBuffer3;
                Decoder.copyLeadingASCII(byteBuffer, charBuffer);
                if (!byteBuffer.hasRemaining()) {
                    return CoderResult.UNDERFLOW;
                }
                if (!charBuffer.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                int n = (int)((float)byteBuffer.limit() * this.maxCharsPerByte());
                CharBuffer charBuffer3 = CharBuffer.allocate(n);
                Charset charset = Charset.forName("ISO-2022-JP");
                CharsetDecoder charsetDecoder = charset.newDecoder();
                DelegatableDecoder delegatableDecoder = (DelegatableDecoder)((Object)charsetDecoder);
                CoderResult coderResult = delegatableDecoder.decodeLoop(byteBuffer3 = byteBuffer.asReadOnlyBuffer(), charBuffer3);
                if (!coderResult.isError()) {
                    return this.decodeLoop(charset, byteBuffer, charBuffer);
                }
                Charset charset2 = Charset.forName(EUCJPName);
                Charset charset3 = Charset.forName(SJISName);
                DelegatableDecoder delegatableDecoder2 = (DelegatableDecoder)((Object)charset2.newDecoder());
                ByteBuffer byteBuffer4 = byteBuffer.asReadOnlyBuffer();
                charBuffer3.clear();
                CoderResult coderResult2 = delegatableDecoder2.decodeLoop(byteBuffer4, charBuffer3);
                if (coderResult2.isError()) {
                    return this.decodeLoop(charset3, byteBuffer, charBuffer);
                }
                DelegatableDecoder delegatableDecoder3 = (DelegatableDecoder)((Object)charset3.newDecoder());
                CoderResult coderResult3 = delegatableDecoder3.decodeLoop(byteBuffer2 = byteBuffer.asReadOnlyBuffer(), charBuffer2 = CharBuffer.allocate(n));
                if (coderResult3.isError()) {
                    return this.decodeLoop(charset2, byteBuffer, charBuffer);
                }
                if (byteBuffer4.position() > byteBuffer2.position()) {
                    return this.decodeLoop(charset2, byteBuffer, charBuffer);
                }
                if (byteBuffer4.position() < byteBuffer2.position()) {
                    return this.decodeLoop(charset3, byteBuffer, charBuffer);
                }
                if (byteBuffer.position() == byteBuffer4.position()) {
                    return CoderResult.UNDERFLOW;
                }
                charBuffer3.flip();
                Charset charset4 = JISAutoDetect.access$200(charBuffer3) ? charset2 : charset3;
                return this.decodeLoop(charset4, byteBuffer, charBuffer);
            }
            return this.detectedDecoder.decodeLoop(byteBuffer, charBuffer);
        }

        private CoderResult decodeLoop(Charset charset, ByteBuffer byteBuffer, CharBuffer charBuffer) {
            this.detectedDecoder = (DelegatableDecoder)((Object)charset.newDecoder());
            return this.detectedDecoder.decodeLoop(byteBuffer, charBuffer);
        }
    }
}

